/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMetricDataRequest extends ConnectRequest implements
        ToCopyableBuilder<GetMetricDataRequest.Builder, GetMetricDataRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMetricDataRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetMetricDataRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetMetricDataRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Filters> FILTERS_FIELD = SdkField.<Filters> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetMetricDataRequest::filters)).setter(setter(Builder::filters)).constructor(Filters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<List<String>> GROUPINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetMetricDataRequest::groupingsAsStrings))
            .setter(setter(Builder::groupingsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groupings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<HistoricalMetric>> HISTORICAL_METRICS_FIELD = SdkField
            .<List<HistoricalMetric>> builder(MarshallingType.LIST)
            .getter(getter(GetMetricDataRequest::historicalMetrics))
            .setter(setter(Builder::historicalMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoricalMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HistoricalMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(HistoricalMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMetricDataRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetMetricDataRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, FILTERS_FIELD, GROUPINGS_FIELD, HISTORICAL_METRICS_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD));

    private final String instanceId;

    private final Instant startTime;

    private final Instant endTime;

    private final Filters filters;

    private final List<String> groupings;

    private final List<HistoricalMetric> historicalMetrics;

    private final String nextToken;

    private final Integer maxResults;

    private GetMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.filters = builder.filters;
        this.groupings = builder.groupings;
        this.historicalMetrics = builder.historicalMetrics;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The identifier for your Amazon Connect instance. To find the ID of your instance, open the AWS console and select
     * Amazon Connect. Select the alias of the instance in the Instance alias column. The instance ID is displayed in
     * the Overview section of your instance settings. For example, the instance ID is the set of characters at the end
     * of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
     * </p>
     * 
     * @return The identifier for your Amazon Connect instance. To find the ID of your instance, open the AWS console
     *         and select Amazon Connect. Select the alias of the instance in the Instance alias column. The instance ID
     *         is displayed in the Overview section of your instance settings. For example, the instance ID is the set
     *         of characters at the end of the instance ARN, after instance/, such as
     *         10a4c4eb-f57e-4d4c-b602-bf39176ced07.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of
     * historical metrics data. The time must be specified using a multiple of 5 minutes, such as 10:05, 10:10, 10:15.
     * </p>
     * <p>
     * <code>StartTime</code> cannot be earlier than 24 hours before the time of the request. Historical metrics are
     * available in Amazon Connect only for 24 hours.
     * </p>
     * 
     * @return The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of
     *         historical metrics data. The time must be specified using a multiple of 5 minutes, such as 10:05, 10:10,
     *         10:15.</p>
     *         <p>
     *         <code>StartTime</code> cannot be earlier than 24 hours before the time of the request. Historical metrics
     *         are available in Amazon Connect only for 24 hours.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical
     * metrics data. The time must be specified using an interval of 5 minutes, such as 11:00, 11:05, 11:10, and must be
     * later than the <code>StartTime</code> timestamp.
     * </p>
     * <p>
     * The time range between <code>StartTime</code> and <code>EndTime</code> must be less than 24 hours.
     * </p>
     * 
     * @return The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of
     *         historical metrics data. The time must be specified using an interval of 5 minutes, such as 11:00, 11:05,
     *         11:10, and must be later than the <code>StartTime</code> timestamp.</p>
     *         <p>
     *         The time range between <code>StartTime</code> and <code>EndTime</code> must be less than 24 hours.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * A <code>Filters</code> object that contains a list of queue IDs or queue ARNs, up to 100, or a list of Channels
     * to use to filter the metrics returned in the response. Metric data is retrieved only for the resources associated
     * with the IDs, ARNs, or Channels included in the filter. You can use both IDs and ARNs together in a request. Only
     * VOICE is supported for Channel.
     * </p>
     * <p>
     * To find the ARN for a queue, open the queue you want to use in the Amazon Connect Queue editor. The ARN for the
     * queue is displayed in the address bar as part of the URL. For example, the queue ARN is the set of characters at
     * the end of the URL, after 'id=' such as
     * <code>arn:aws:connect:us-east-1:270923740243:instance/78fb859d-1b7d-44b1-8aa3-12f0835c5855/queue/1d1a4575-9618-40ab-bbeb-81e45795fe61</code>
     * . The queue ID is also included in the URL, and is the string after 'queue/'.
     * </p>
     * 
     * @return A <code>Filters</code> object that contains a list of queue IDs or queue ARNs, up to 100, or a list of
     *         Channels to use to filter the metrics returned in the response. Metric data is retrieved only for the
     *         resources associated with the IDs, ARNs, or Channels included in the filter. You can use both IDs and
     *         ARNs together in a request. Only VOICE is supported for Channel.</p>
     *         <p>
     *         To find the ARN for a queue, open the queue you want to use in the Amazon Connect Queue editor. The ARN
     *         for the queue is displayed in the address bar as part of the URL. For example, the queue ARN is the set
     *         of characters at the end of the URL, after 'id=' such as
     *         <code>arn:aws:connect:us-east-1:270923740243:instance/78fb859d-1b7d-44b1-8aa3-12f0835c5855/queue/1d1a4575-9618-40ab-bbeb-81e45795fe61</code>
     *         . The queue ID is also included in the URL, and is the string after 'queue/'.
     */
    public Filters filters() {
        return filters;
    }

    /**
     * <p>
     * The grouping applied to the metrics returned. For example, when results are grouped by queueId, the metrics
     * returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated for
     * all queues.
     * </p>
     * <p>
     * The current version supports grouping by Queue
     * </p>
     * <p>
     * If no <code>Grouping</code> is included in the request, a summary of <code>HistoricalMetrics</code> for all
     * queues is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The grouping applied to the metrics returned. For example, when results are grouped by queueId, the
     *         metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather
     *         than aggregated for all queues.</p>
     *         <p>
     *         The current version supports grouping by Queue
     *         </p>
     *         <p>
     *         If no <code>Grouping</code> is included in the request, a summary of <code>HistoricalMetrics</code> for
     *         all queues is returned.
     */
    public List<Grouping> groupings() {
        return GroupingsCopier.copyStringToEnum(groupings);
    }

    /**
     * <p>
     * The grouping applied to the metrics returned. For example, when results are grouped by queueId, the metrics
     * returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated for
     * all queues.
     * </p>
     * <p>
     * The current version supports grouping by Queue
     * </p>
     * <p>
     * If no <code>Grouping</code> is included in the request, a summary of <code>HistoricalMetrics</code> for all
     * queues is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The grouping applied to the metrics returned. For example, when results are grouped by queueId, the
     *         metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather
     *         than aggregated for all queues.</p>
     *         <p>
     *         The current version supports grouping by Queue
     *         </p>
     *         <p>
     *         If no <code>Grouping</code> is included in the request, a summary of <code>HistoricalMetrics</code> for
     *         all queues is returned.
     */
    public List<String> groupingsAsStrings() {
        return groupings;
    }

    /**
     * <p>
     * A list of <code>HistoricalMetric</code> objects that contain the metrics to retrieve with the request.
     * </p>
     * <p>
     * A <code>HistoricalMetric</code> object contains: <code>HistoricalMetricName</code>, <code>Statistic</code>,
     * <code>Threshold</code>, and <code>Unit</code>.
     * </p>
     * <p>
     * You must list each metric to retrieve data for in the request. For each historical metric you include in the
     * request, you must include a <code>Unit</code> and a <code>Statistic</code>.
     * </p>
     * <p>
     * The following historical metrics are available:
     * </p>
     * <dl>
     * <dt>CONTACTS_QUEUED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistics: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_ABANDONED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistics: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_CONSULTED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistics: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistics: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_HANDLED_INCOMING</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistics: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_HANDLED_OUTBOUND</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistics: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_HOLD_ABANDONS</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistics: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_IN</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistics: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistics: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistics: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistics: SUM
     * </p>
     * </dd>
     * <dt>CALLBACK_CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistics: SUM
     * </p>
     * </dd>
     * <dt>CALLBACK_CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistics: SUM
     * </p>
     * </dd>
     * <dt>API_CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistics: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_MISSED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistics: SUM
     * </p>
     * </dd>
     * <dt>OCCUPANCY</dt>
     * <dd>
     * <p>
     * Unit: PERCENT
     * </p>
     * <p>
     * Statistics: AVG
     * </p>
     * </dd>
     * <dt>HANDLE_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistics: AVG
     * </p>
     * </dd>
     * <dt>AFTER_CONTACT_WORK_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistics: AVG
     * </p>
     * </dd>
     * <dt>QUEUED_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistics: MAX
     * </p>
     * </dd>
     * <dt>ABANDON_TIME</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistics: SUM
     * </p>
     * </dd>
     * <dt>QUEUE_ANSWER_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistics: AVG
     * </p>
     * </dd>
     * <dt>HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistics: AVG
     * </p>
     * </dd>
     * <dt>INTERACTION_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistics: AVG
     * </p>
     * </dd>
     * <dt>INTERACTION_AND_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistics: AVG
     * </p>
     * </dd>
     * <dt>SERVICE_LEVEL</dt>
     * <dd>
     * <p>
     * Unit: PERCENT
     * </p>
     * <p>
     * Statistics: AVG
     * </p>
     * <p>
     * Threshold: Only "Less than" comparisons are supported, with the following service level thresholds: 15, 20, 25,
     * 30, 45, 60, 90, 120, 180, 240, 300, 600
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>HistoricalMetric</code> objects that contain the metrics to retrieve with the
     *         request.</p>
     *         <p>
     *         A <code>HistoricalMetric</code> object contains: <code>HistoricalMetricName</code>,
     *         <code>Statistic</code>, <code>Threshold</code>, and <code>Unit</code>.
     *         </p>
     *         <p>
     *         You must list each metric to retrieve data for in the request. For each historical metric you include in
     *         the request, you must include a <code>Unit</code> and a <code>Statistic</code>.
     *         </p>
     *         <p>
     *         The following historical metrics are available:
     *         </p>
     *         <dl>
     *         <dt>CONTACTS_QUEUED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HANDLED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistics: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_ABANDONED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistics: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_CONSULTED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistics: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistics: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HANDLED_INCOMING</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistics: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HANDLED_OUTBOUND</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistics: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HOLD_ABANDONS</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistics: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_IN</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistics: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_OUT</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistics: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistics: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistics: SUM
     *         </p>
     *         </dd>
     *         <dt>CALLBACK_CONTACTS_HANDLED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistics: SUM
     *         </p>
     *         </dd>
     *         <dt>CALLBACK_CONTACTS_HANDLED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistics: SUM
     *         </p>
     *         </dd>
     *         <dt>API_CONTACTS_HANDLED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistics: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_MISSED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistics: SUM
     *         </p>
     *         </dd>
     *         <dt>OCCUPANCY</dt>
     *         <dd>
     *         <p>
     *         Unit: PERCENT
     *         </p>
     *         <p>
     *         Statistics: AVG
     *         </p>
     *         </dd>
     *         <dt>HANDLE_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistics: AVG
     *         </p>
     *         </dd>
     *         <dt>AFTER_CONTACT_WORK_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistics: AVG
     *         </p>
     *         </dd>
     *         <dt>QUEUED_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistics: MAX
     *         </p>
     *         </dd>
     *         <dt>ABANDON_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistics: SUM
     *         </p>
     *         </dd>
     *         <dt>QUEUE_ANSWER_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistics: AVG
     *         </p>
     *         </dd>
     *         <dt>HOLD_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistics: AVG
     *         </p>
     *         </dd>
     *         <dt>INTERACTION_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistics: AVG
     *         </p>
     *         </dd>
     *         <dt>INTERACTION_AND_HOLD_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistics: AVG
     *         </p>
     *         </dd>
     *         <dt>SERVICE_LEVEL</dt>
     *         <dd>
     *         <p>
     *         Unit: PERCENT
     *         </p>
     *         <p>
     *         Statistics: AVG
     *         </p>
     *         <p>
     *         Threshold: Only "Less than" comparisons are supported, with the following service level thresholds: 15,
     *         20, 25, 30, 45, 60, 90, 120, 180, 240, 300, 600
     *         </p>
     *         </dd>
     */
    public List<HistoricalMetric> historicalMetrics() {
        return historicalMetrics;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Indicates the maximum number of results to return per page in the response, between 1-100.
     * </p>
     * 
     * @return Indicates the maximum number of results to return per page in the response, between 1-100.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(groupingsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(historicalMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricDataRequest)) {
            return false;
        }
        GetMetricDataRequest other = (GetMetricDataRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(filters(), other.filters())
                && Objects.equals(groupingsAsStrings(), other.groupingsAsStrings())
                && Objects.equals(historicalMetrics(), other.historicalMetrics())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetMetricDataRequest").add("InstanceId", instanceId()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Filters", filters()).add("Groupings", groupingsAsStrings())
                .add("HistoricalMetrics", historicalMetrics()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Groupings":
            return Optional.ofNullable(clazz.cast(groupingsAsStrings()));
        case "HistoricalMetrics":
            return Optional.ofNullable(clazz.cast(historicalMetrics()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetricDataRequest, T> g) {
        return obj -> g.apply((GetMetricDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMetricDataRequest> {
        /**
         * <p>
         * The identifier for your Amazon Connect instance. To find the ID of your instance, open the AWS console and
         * select Amazon Connect. Select the alias of the instance in the Instance alias column. The instance ID is
         * displayed in the Overview section of your instance settings. For example, the instance ID is the set of
         * characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
         * </p>
         * 
         * @param instanceId
         *        The identifier for your Amazon Connect instance. To find the ID of your instance, open the AWS console
         *        and select Amazon Connect. Select the alias of the instance in the Instance alias column. The instance
         *        ID is displayed in the Overview section of your instance settings. For example, the instance ID is the
         *        set of characters at the end of the instance ARN, after instance/, such as
         *        10a4c4eb-f57e-4d4c-b602-bf39176ced07.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of
         * historical metrics data. The time must be specified using a multiple of 5 minutes, such as 10:05, 10:10,
         * 10:15.
         * </p>
         * <p>
         * <code>StartTime</code> cannot be earlier than 24 hours before the time of the request. Historical metrics are
         * available in Amazon Connect only for 24 hours.
         * </p>
         * 
         * @param startTime
         *        The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval
         *        of historical metrics data. The time must be specified using a multiple of 5 minutes, such as 10:05,
         *        10:10, 10:15.</p>
         *        <p>
         *        <code>StartTime</code> cannot be earlier than 24 hours before the time of the request. Historical
         *        metrics are available in Amazon Connect only for 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of
         * historical metrics data. The time must be specified using an interval of 5 minutes, such as 11:00, 11:05,
         * 11:10, and must be later than the <code>StartTime</code> timestamp.
         * </p>
         * <p>
         * The time range between <code>StartTime</code> and <code>EndTime</code> must be less than 24 hours.
         * </p>
         * 
         * @param endTime
         *        The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of
         *        historical metrics data. The time must be specified using an interval of 5 minutes, such as 11:00,
         *        11:05, 11:10, and must be later than the <code>StartTime</code> timestamp.</p>
         *        <p>
         *        The time range between <code>StartTime</code> and <code>EndTime</code> must be less than 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * A <code>Filters</code> object that contains a list of queue IDs or queue ARNs, up to 100, or a list of
         * Channels to use to filter the metrics returned in the response. Metric data is retrieved only for the
         * resources associated with the IDs, ARNs, or Channels included in the filter. You can use both IDs and ARNs
         * together in a request. Only VOICE is supported for Channel.
         * </p>
         * <p>
         * To find the ARN for a queue, open the queue you want to use in the Amazon Connect Queue editor. The ARN for
         * the queue is displayed in the address bar as part of the URL. For example, the queue ARN is the set of
         * characters at the end of the URL, after 'id=' such as
         * <code>arn:aws:connect:us-east-1:270923740243:instance/78fb859d-1b7d-44b1-8aa3-12f0835c5855/queue/1d1a4575-9618-40ab-bbeb-81e45795fe61</code>
         * . The queue ID is also included in the URL, and is the string after 'queue/'.
         * </p>
         * 
         * @param filters
         *        A <code>Filters</code> object that contains a list of queue IDs or queue ARNs, up to 100, or a list of
         *        Channels to use to filter the metrics returned in the response. Metric data is retrieved only for the
         *        resources associated with the IDs, ARNs, or Channels included in the filter. You can use both IDs and
         *        ARNs together in a request. Only VOICE is supported for Channel.</p>
         *        <p>
         *        To find the ARN for a queue, open the queue you want to use in the Amazon Connect Queue editor. The
         *        ARN for the queue is displayed in the address bar as part of the URL. For example, the queue ARN is
         *        the set of characters at the end of the URL, after 'id=' such as
         *        <code>arn:aws:connect:us-east-1:270923740243:instance/78fb859d-1b7d-44b1-8aa3-12f0835c5855/queue/1d1a4575-9618-40ab-bbeb-81e45795fe61</code>
         *        . The queue ID is also included in the URL, and is the string after 'queue/'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filters filters);

        /**
         * <p>
         * A <code>Filters</code> object that contains a list of queue IDs or queue ARNs, up to 100, or a list of
         * Channels to use to filter the metrics returned in the response. Metric data is retrieved only for the
         * resources associated with the IDs, ARNs, or Channels included in the filter. You can use both IDs and ARNs
         * together in a request. Only VOICE is supported for Channel.
         * </p>
         * <p>
         * To find the ARN for a queue, open the queue you want to use in the Amazon Connect Queue editor. The ARN for
         * the queue is displayed in the address bar as part of the URL. For example, the queue ARN is the set of
         * characters at the end of the URL, after 'id=' such as
         * <code>arn:aws:connect:us-east-1:270923740243:instance/78fb859d-1b7d-44b1-8aa3-12f0835c5855/queue/1d1a4575-9618-40ab-bbeb-81e45795fe61</code>
         * . The queue ID is also included in the URL, and is the string after 'queue/'.
         * </p>
         * This is a convenience that creates an instance of the {@link Filters.Builder} avoiding the need to create one
         * manually via {@link Filters#builder()}.
         *
         * When the {@link Consumer} completes, {@link Filters.Builder#build()} is called immediately and its result is
         * passed to {@link #filters(Filters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link Filters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(Filters)
         */
        default Builder filters(Consumer<Filters.Builder> filters) {
            return filters(Filters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The grouping applied to the metrics returned. For example, when results are grouped by queueId, the metrics
         * returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated
         * for all queues.
         * </p>
         * <p>
         * The current version supports grouping by Queue
         * </p>
         * <p>
         * If no <code>Grouping</code> is included in the request, a summary of <code>HistoricalMetrics</code> for all
         * queues is returned.
         * </p>
         * 
         * @param groupings
         *        The grouping applied to the metrics returned. For example, when results are grouped by queueId, the
         *        metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather
         *        than aggregated for all queues.</p>
         *        <p>
         *        The current version supports grouping by Queue
         *        </p>
         *        <p>
         *        If no <code>Grouping</code> is included in the request, a summary of <code>HistoricalMetrics</code>
         *        for all queues is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingsWithStrings(Collection<String> groupings);

        /**
         * <p>
         * The grouping applied to the metrics returned. For example, when results are grouped by queueId, the metrics
         * returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated
         * for all queues.
         * </p>
         * <p>
         * The current version supports grouping by Queue
         * </p>
         * <p>
         * If no <code>Grouping</code> is included in the request, a summary of <code>HistoricalMetrics</code> for all
         * queues is returned.
         * </p>
         * 
         * @param groupings
         *        The grouping applied to the metrics returned. For example, when results are grouped by queueId, the
         *        metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather
         *        than aggregated for all queues.</p>
         *        <p>
         *        The current version supports grouping by Queue
         *        </p>
         *        <p>
         *        If no <code>Grouping</code> is included in the request, a summary of <code>HistoricalMetrics</code>
         *        for all queues is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingsWithStrings(String... groupings);

        /**
         * <p>
         * The grouping applied to the metrics returned. For example, when results are grouped by queueId, the metrics
         * returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated
         * for all queues.
         * </p>
         * <p>
         * The current version supports grouping by Queue
         * </p>
         * <p>
         * If no <code>Grouping</code> is included in the request, a summary of <code>HistoricalMetrics</code> for all
         * queues is returned.
         * </p>
         * 
         * @param groupings
         *        The grouping applied to the metrics returned. For example, when results are grouped by queueId, the
         *        metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather
         *        than aggregated for all queues.</p>
         *        <p>
         *        The current version supports grouping by Queue
         *        </p>
         *        <p>
         *        If no <code>Grouping</code> is included in the request, a summary of <code>HistoricalMetrics</code>
         *        for all queues is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupings(Collection<Grouping> groupings);

        /**
         * <p>
         * The grouping applied to the metrics returned. For example, when results are grouped by queueId, the metrics
         * returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated
         * for all queues.
         * </p>
         * <p>
         * The current version supports grouping by Queue
         * </p>
         * <p>
         * If no <code>Grouping</code> is included in the request, a summary of <code>HistoricalMetrics</code> for all
         * queues is returned.
         * </p>
         * 
         * @param groupings
         *        The grouping applied to the metrics returned. For example, when results are grouped by queueId, the
         *        metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather
         *        than aggregated for all queues.</p>
         *        <p>
         *        The current version supports grouping by Queue
         *        </p>
         *        <p>
         *        If no <code>Grouping</code> is included in the request, a summary of <code>HistoricalMetrics</code>
         *        for all queues is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupings(Grouping... groupings);

        /**
         * <p>
         * A list of <code>HistoricalMetric</code> objects that contain the metrics to retrieve with the request.
         * </p>
         * <p>
         * A <code>HistoricalMetric</code> object contains: <code>HistoricalMetricName</code>, <code>Statistic</code>,
         * <code>Threshold</code>, and <code>Unit</code>.
         * </p>
         * <p>
         * You must list each metric to retrieve data for in the request. For each historical metric you include in the
         * request, you must include a <code>Unit</code> and a <code>Statistic</code>.
         * </p>
         * <p>
         * The following historical metrics are available:
         * </p>
         * <dl>
         * <dt>CONTACTS_QUEUED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_ABANDONED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_CONSULTED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED_INCOMING</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED_OUTBOUND</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HOLD_ABANDONS</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_IN</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CALLBACK_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CALLBACK_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>API_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_MISSED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>OCCUPANCY</dt>
         * <dd>
         * <p>
         * Unit: PERCENT
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>HANDLE_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>AFTER_CONTACT_WORK_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>QUEUED_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: MAX
         * </p>
         * </dd>
         * <dt>ABANDON_TIME</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>QUEUE_ANSWER_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>INTERACTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>INTERACTION_AND_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>SERVICE_LEVEL</dt>
         * <dd>
         * <p>
         * Unit: PERCENT
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * <p>
         * Threshold: Only "Less than" comparisons are supported, with the following service level thresholds: 15, 20,
         * 25, 30, 45, 60, 90, 120, 180, 240, 300, 600
         * </p>
         * </dd>
         * </dl>
         * 
         * @param historicalMetrics
         *        A list of <code>HistoricalMetric</code> objects that contain the metrics to retrieve with the
         *        request.</p>
         *        <p>
         *        A <code>HistoricalMetric</code> object contains: <code>HistoricalMetricName</code>,
         *        <code>Statistic</code>, <code>Threshold</code>, and <code>Unit</code>.
         *        </p>
         *        <p>
         *        You must list each metric to retrieve data for in the request. For each historical metric you include
         *        in the request, you must include a <code>Unit</code> and a <code>Statistic</code>.
         *        </p>
         *        <p>
         *        The following historical metrics are available:
         *        </p>
         *        <dl>
         *        <dt>CONTACTS_QUEUED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_ABANDONED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_CONSULTED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HANDLED_INCOMING</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HANDLED_OUTBOUND</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HOLD_ABANDONS</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_IN</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CALLBACK_CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CALLBACK_CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>API_CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_MISSED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>OCCUPANCY</dt>
         *        <dd>
         *        <p>
         *        Unit: PERCENT
         *        </p>
         *        <p>
         *        Statistics: AVG
         *        </p>
         *        </dd>
         *        <dt>HANDLE_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistics: AVG
         *        </p>
         *        </dd>
         *        <dt>AFTER_CONTACT_WORK_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistics: AVG
         *        </p>
         *        </dd>
         *        <dt>QUEUED_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistics: MAX
         *        </p>
         *        </dd>
         *        <dt>ABANDON_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>QUEUE_ANSWER_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistics: AVG
         *        </p>
         *        </dd>
         *        <dt>HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistics: AVG
         *        </p>
         *        </dd>
         *        <dt>INTERACTION_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistics: AVG
         *        </p>
         *        </dd>
         *        <dt>INTERACTION_AND_HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistics: AVG
         *        </p>
         *        </dd>
         *        <dt>SERVICE_LEVEL</dt>
         *        <dd>
         *        <p>
         *        Unit: PERCENT
         *        </p>
         *        <p>
         *        Statistics: AVG
         *        </p>
         *        <p>
         *        Threshold: Only "Less than" comparisons are supported, with the following service level thresholds:
         *        15, 20, 25, 30, 45, 60, 90, 120, 180, 240, 300, 600
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historicalMetrics(Collection<HistoricalMetric> historicalMetrics);

        /**
         * <p>
         * A list of <code>HistoricalMetric</code> objects that contain the metrics to retrieve with the request.
         * </p>
         * <p>
         * A <code>HistoricalMetric</code> object contains: <code>HistoricalMetricName</code>, <code>Statistic</code>,
         * <code>Threshold</code>, and <code>Unit</code>.
         * </p>
         * <p>
         * You must list each metric to retrieve data for in the request. For each historical metric you include in the
         * request, you must include a <code>Unit</code> and a <code>Statistic</code>.
         * </p>
         * <p>
         * The following historical metrics are available:
         * </p>
         * <dl>
         * <dt>CONTACTS_QUEUED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_ABANDONED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_CONSULTED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED_INCOMING</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED_OUTBOUND</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HOLD_ABANDONS</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_IN</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CALLBACK_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CALLBACK_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>API_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_MISSED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>OCCUPANCY</dt>
         * <dd>
         * <p>
         * Unit: PERCENT
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>HANDLE_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>AFTER_CONTACT_WORK_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>QUEUED_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: MAX
         * </p>
         * </dd>
         * <dt>ABANDON_TIME</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>QUEUE_ANSWER_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>INTERACTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>INTERACTION_AND_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>SERVICE_LEVEL</dt>
         * <dd>
         * <p>
         * Unit: PERCENT
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * <p>
         * Threshold: Only "Less than" comparisons are supported, with the following service level thresholds: 15, 20,
         * 25, 30, 45, 60, 90, 120, 180, 240, 300, 600
         * </p>
         * </dd>
         * </dl>
         * 
         * @param historicalMetrics
         *        A list of <code>HistoricalMetric</code> objects that contain the metrics to retrieve with the
         *        request.</p>
         *        <p>
         *        A <code>HistoricalMetric</code> object contains: <code>HistoricalMetricName</code>,
         *        <code>Statistic</code>, <code>Threshold</code>, and <code>Unit</code>.
         *        </p>
         *        <p>
         *        You must list each metric to retrieve data for in the request. For each historical metric you include
         *        in the request, you must include a <code>Unit</code> and a <code>Statistic</code>.
         *        </p>
         *        <p>
         *        The following historical metrics are available:
         *        </p>
         *        <dl>
         *        <dt>CONTACTS_QUEUED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_ABANDONED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_CONSULTED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HANDLED_INCOMING</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HANDLED_OUTBOUND</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HOLD_ABANDONS</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_IN</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CALLBACK_CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CALLBACK_CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>API_CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_MISSED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>OCCUPANCY</dt>
         *        <dd>
         *        <p>
         *        Unit: PERCENT
         *        </p>
         *        <p>
         *        Statistics: AVG
         *        </p>
         *        </dd>
         *        <dt>HANDLE_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistics: AVG
         *        </p>
         *        </dd>
         *        <dt>AFTER_CONTACT_WORK_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistics: AVG
         *        </p>
         *        </dd>
         *        <dt>QUEUED_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistics: MAX
         *        </p>
         *        </dd>
         *        <dt>ABANDON_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistics: SUM
         *        </p>
         *        </dd>
         *        <dt>QUEUE_ANSWER_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistics: AVG
         *        </p>
         *        </dd>
         *        <dt>HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistics: AVG
         *        </p>
         *        </dd>
         *        <dt>INTERACTION_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistics: AVG
         *        </p>
         *        </dd>
         *        <dt>INTERACTION_AND_HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistics: AVG
         *        </p>
         *        </dd>
         *        <dt>SERVICE_LEVEL</dt>
         *        <dd>
         *        <p>
         *        Unit: PERCENT
         *        </p>
         *        <p>
         *        Statistics: AVG
         *        </p>
         *        <p>
         *        Threshold: Only "Less than" comparisons are supported, with the following service level thresholds:
         *        15, 20, 25, 30, 45, 60, 90, 120, 180, 240, 300, 600
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historicalMetrics(HistoricalMetric... historicalMetrics);

        /**
         * <p>
         * A list of <code>HistoricalMetric</code> objects that contain the metrics to retrieve with the request.
         * </p>
         * <p>
         * A <code>HistoricalMetric</code> object contains: <code>HistoricalMetricName</code>, <code>Statistic</code>,
         * <code>Threshold</code>, and <code>Unit</code>.
         * </p>
         * <p>
         * You must list each metric to retrieve data for in the request. For each historical metric you include in the
         * request, you must include a <code>Unit</code> and a <code>Statistic</code>.
         * </p>
         * <p>
         * The following historical metrics are available:
         * </p>
         * <dl>
         * <dt>CONTACTS_QUEUED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_ABANDONED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_CONSULTED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED_INCOMING</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED_OUTBOUND</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HOLD_ABANDONS</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_IN</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CALLBACK_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CALLBACK_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>API_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_MISSED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>OCCUPANCY</dt>
         * <dd>
         * <p>
         * Unit: PERCENT
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>HANDLE_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>AFTER_CONTACT_WORK_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>QUEUED_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: MAX
         * </p>
         * </dd>
         * <dt>ABANDON_TIME</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistics: SUM
         * </p>
         * </dd>
         * <dt>QUEUE_ANSWER_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>INTERACTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>INTERACTION_AND_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * </dd>
         * <dt>SERVICE_LEVEL</dt>
         * <dd>
         * <p>
         * Unit: PERCENT
         * </p>
         * <p>
         * Statistics: AVG
         * </p>
         * <p>
         * Threshold: Only "Less than" comparisons are supported, with the following service level thresholds: 15, 20,
         * 25, 30, 45, 60, 90, 120, 180, 240, 300, 600
         * </p>
         * </dd>
         * </dl>
         * This is a convenience that creates an instance of the {@link List<HistoricalMetric>.Builder} avoiding the
         * need to create one manually via {@link List<HistoricalMetric>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HistoricalMetric>.Builder#build()} is called immediately and
         * its result is passed to {@link #historicalMetrics(List<HistoricalMetric>)}.
         * 
         * @param historicalMetrics
         *        a consumer that will call methods on {@link List<HistoricalMetric>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #historicalMetrics(List<HistoricalMetric>)
         */
        Builder historicalMetrics(Consumer<HistoricalMetric.Builder>... historicalMetrics);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Indicates the maximum number of results to return per page in the response, between 1-100.
         * </p>
         * 
         * @param maxResults
         *        Indicates the maximum number of results to return per page in the response, between 1-100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private Instant startTime;

        private Instant endTime;

        private Filters filters;

        private List<String> groupings = DefaultSdkAutoConstructList.getInstance();

        private List<HistoricalMetric> historicalMetrics = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricDataRequest model) {
            super(model);
            instanceId(model.instanceId);
            startTime(model.startTime);
            endTime(model.endTime);
            filters(model.filters);
            groupingsWithStrings(model.groupings);
            historicalMetrics(model.historicalMetrics);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Filters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        @Override
        public final Builder filters(Filters filters) {
            this.filters = filters;
            return this;
        }

        public final void setFilters(Filters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        public final Collection<String> getGroupingsAsStrings() {
            return groupings;
        }

        @Override
        public final Builder groupingsWithStrings(Collection<String> groupings) {
            this.groupings = GroupingsCopier.copy(groupings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingsWithStrings(String... groupings) {
            groupingsWithStrings(Arrays.asList(groupings));
            return this;
        }

        @Override
        public final Builder groupings(Collection<Grouping> groupings) {
            this.groupings = GroupingsCopier.copyEnumToString(groupings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupings(Grouping... groupings) {
            groupings(Arrays.asList(groupings));
            return this;
        }

        public final void setGroupingsWithStrings(Collection<String> groupings) {
            this.groupings = GroupingsCopier.copy(groupings);
        }

        public final Collection<HistoricalMetric.Builder> getHistoricalMetrics() {
            return historicalMetrics != null ? historicalMetrics.stream().map(HistoricalMetric::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder historicalMetrics(Collection<HistoricalMetric> historicalMetrics) {
            this.historicalMetrics = HistoricalMetricsCopier.copy(historicalMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historicalMetrics(HistoricalMetric... historicalMetrics) {
            historicalMetrics(Arrays.asList(historicalMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historicalMetrics(Consumer<HistoricalMetric.Builder>... historicalMetrics) {
            historicalMetrics(Stream.of(historicalMetrics).map(c -> HistoricalMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setHistoricalMetrics(Collection<HistoricalMetric.BuilderImpl> historicalMetrics) {
            this.historicalMetrics = HistoricalMetricsCopier.copyFromBuilder(historicalMetrics);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMetricDataRequest build() {
            return new GetMetricDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
