/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>HierarchyPath</code> object that contains information about the levels of the hierarchy group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HierarchyPath implements SdkPojo, Serializable, ToCopyableBuilder<HierarchyPath.Builder, HierarchyPath> {
    private static final SdkField<HierarchyGroupSummary> LEVEL_ONE_FIELD = SdkField
            .<HierarchyGroupSummary> builder(MarshallingType.SDK_POJO).getter(getter(HierarchyPath::levelOne))
            .setter(setter(Builder::levelOne)).constructor(HierarchyGroupSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelOne").build()).build();

    private static final SdkField<HierarchyGroupSummary> LEVEL_TWO_FIELD = SdkField
            .<HierarchyGroupSummary> builder(MarshallingType.SDK_POJO).getter(getter(HierarchyPath::levelTwo))
            .setter(setter(Builder::levelTwo)).constructor(HierarchyGroupSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelTwo").build()).build();

    private static final SdkField<HierarchyGroupSummary> LEVEL_THREE_FIELD = SdkField
            .<HierarchyGroupSummary> builder(MarshallingType.SDK_POJO).getter(getter(HierarchyPath::levelThree))
            .setter(setter(Builder::levelThree)).constructor(HierarchyGroupSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelThree").build()).build();

    private static final SdkField<HierarchyGroupSummary> LEVEL_FOUR_FIELD = SdkField
            .<HierarchyGroupSummary> builder(MarshallingType.SDK_POJO).getter(getter(HierarchyPath::levelFour))
            .setter(setter(Builder::levelFour)).constructor(HierarchyGroupSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelFour").build()).build();

    private static final SdkField<HierarchyGroupSummary> LEVEL_FIVE_FIELD = SdkField
            .<HierarchyGroupSummary> builder(MarshallingType.SDK_POJO).getter(getter(HierarchyPath::levelFive))
            .setter(setter(Builder::levelFive)).constructor(HierarchyGroupSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelFive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEVEL_ONE_FIELD,
            LEVEL_TWO_FIELD, LEVEL_THREE_FIELD, LEVEL_FOUR_FIELD, LEVEL_FIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final HierarchyGroupSummary levelOne;

    private final HierarchyGroupSummary levelTwo;

    private final HierarchyGroupSummary levelThree;

    private final HierarchyGroupSummary levelFour;

    private final HierarchyGroupSummary levelFive;

    private HierarchyPath(BuilderImpl builder) {
        this.levelOne = builder.levelOne;
        this.levelTwo = builder.levelTwo;
        this.levelThree = builder.levelThree;
        this.levelFour = builder.levelFour;
        this.levelFive = builder.levelFive;
    }

    /**
     * <p>
     * A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy group,
     * including ARN, Id, and Name.
     * </p>
     * 
     * @return A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy
     *         group, including ARN, Id, and Name.
     */
    public HierarchyGroupSummary levelOne() {
        return levelOne;
    }

    /**
     * <p>
     * A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy group,
     * including ARN, Id, and Name.
     * </p>
     * 
     * @return A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy
     *         group, including ARN, Id, and Name.
     */
    public HierarchyGroupSummary levelTwo() {
        return levelTwo;
    }

    /**
     * <p>
     * A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy group,
     * including ARN, Id, and Name.
     * </p>
     * 
     * @return A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy
     *         group, including ARN, Id, and Name.
     */
    public HierarchyGroupSummary levelThree() {
        return levelThree;
    }

    /**
     * <p>
     * A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy group,
     * including ARN, Id, and Name.
     * </p>
     * 
     * @return A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy
     *         group, including ARN, Id, and Name.
     */
    public HierarchyGroupSummary levelFour() {
        return levelFour;
    }

    /**
     * <p>
     * A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy group,
     * including ARN, Id, and Name.
     * </p>
     * 
     * @return A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy
     *         group, including ARN, Id, and Name.
     */
    public HierarchyGroupSummary levelFive() {
        return levelFive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(levelOne());
        hashCode = 31 * hashCode + Objects.hashCode(levelTwo());
        hashCode = 31 * hashCode + Objects.hashCode(levelThree());
        hashCode = 31 * hashCode + Objects.hashCode(levelFour());
        hashCode = 31 * hashCode + Objects.hashCode(levelFive());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HierarchyPath)) {
            return false;
        }
        HierarchyPath other = (HierarchyPath) obj;
        return Objects.equals(levelOne(), other.levelOne()) && Objects.equals(levelTwo(), other.levelTwo())
                && Objects.equals(levelThree(), other.levelThree()) && Objects.equals(levelFour(), other.levelFour())
                && Objects.equals(levelFive(), other.levelFive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HierarchyPath").add("LevelOne", levelOne()).add("LevelTwo", levelTwo())
                .add("LevelThree", levelThree()).add("LevelFour", levelFour()).add("LevelFive", levelFive()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LevelOne":
            return Optional.ofNullable(clazz.cast(levelOne()));
        case "LevelTwo":
            return Optional.ofNullable(clazz.cast(levelTwo()));
        case "LevelThree":
            return Optional.ofNullable(clazz.cast(levelThree()));
        case "LevelFour":
            return Optional.ofNullable(clazz.cast(levelFour()));
        case "LevelFive":
            return Optional.ofNullable(clazz.cast(levelFive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HierarchyPath, T> g) {
        return obj -> g.apply((HierarchyPath) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HierarchyPath> {
        /**
         * <p>
         * A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy group,
         * including ARN, Id, and Name.
         * </p>
         * 
         * @param levelOne
         *        A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy
         *        group, including ARN, Id, and Name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelOne(HierarchyGroupSummary levelOne);

        /**
         * <p>
         * A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy group,
         * including ARN, Id, and Name.
         * </p>
         * This is a convenience that creates an instance of the {@link HierarchyGroupSummary.Builder} avoiding the need
         * to create one manually via {@link HierarchyGroupSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link HierarchyGroupSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #levelOne(HierarchyGroupSummary)}.
         * 
         * @param levelOne
         *        a consumer that will call methods on {@link HierarchyGroupSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelOne(HierarchyGroupSummary)
         */
        default Builder levelOne(Consumer<HierarchyGroupSummary.Builder> levelOne) {
            return levelOne(HierarchyGroupSummary.builder().applyMutation(levelOne).build());
        }

        /**
         * <p>
         * A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy group,
         * including ARN, Id, and Name.
         * </p>
         * 
         * @param levelTwo
         *        A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy
         *        group, including ARN, Id, and Name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelTwo(HierarchyGroupSummary levelTwo);

        /**
         * <p>
         * A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy group,
         * including ARN, Id, and Name.
         * </p>
         * This is a convenience that creates an instance of the {@link HierarchyGroupSummary.Builder} avoiding the need
         * to create one manually via {@link HierarchyGroupSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link HierarchyGroupSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #levelTwo(HierarchyGroupSummary)}.
         * 
         * @param levelTwo
         *        a consumer that will call methods on {@link HierarchyGroupSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelTwo(HierarchyGroupSummary)
         */
        default Builder levelTwo(Consumer<HierarchyGroupSummary.Builder> levelTwo) {
            return levelTwo(HierarchyGroupSummary.builder().applyMutation(levelTwo).build());
        }

        /**
         * <p>
         * A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy group,
         * including ARN, Id, and Name.
         * </p>
         * 
         * @param levelThree
         *        A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy
         *        group, including ARN, Id, and Name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelThree(HierarchyGroupSummary levelThree);

        /**
         * <p>
         * A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy group,
         * including ARN, Id, and Name.
         * </p>
         * This is a convenience that creates an instance of the {@link HierarchyGroupSummary.Builder} avoiding the need
         * to create one manually via {@link HierarchyGroupSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link HierarchyGroupSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #levelThree(HierarchyGroupSummary)}.
         * 
         * @param levelThree
         *        a consumer that will call methods on {@link HierarchyGroupSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelThree(HierarchyGroupSummary)
         */
        default Builder levelThree(Consumer<HierarchyGroupSummary.Builder> levelThree) {
            return levelThree(HierarchyGroupSummary.builder().applyMutation(levelThree).build());
        }

        /**
         * <p>
         * A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy group,
         * including ARN, Id, and Name.
         * </p>
         * 
         * @param levelFour
         *        A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy
         *        group, including ARN, Id, and Name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelFour(HierarchyGroupSummary levelFour);

        /**
         * <p>
         * A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy group,
         * including ARN, Id, and Name.
         * </p>
         * This is a convenience that creates an instance of the {@link HierarchyGroupSummary.Builder} avoiding the need
         * to create one manually via {@link HierarchyGroupSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link HierarchyGroupSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #levelFour(HierarchyGroupSummary)}.
         * 
         * @param levelFour
         *        a consumer that will call methods on {@link HierarchyGroupSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelFour(HierarchyGroupSummary)
         */
        default Builder levelFour(Consumer<HierarchyGroupSummary.Builder> levelFour) {
            return levelFour(HierarchyGroupSummary.builder().applyMutation(levelFour).build());
        }

        /**
         * <p>
         * A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy group,
         * including ARN, Id, and Name.
         * </p>
         * 
         * @param levelFive
         *        A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy
         *        group, including ARN, Id, and Name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelFive(HierarchyGroupSummary levelFive);

        /**
         * <p>
         * A <code>HierarchyGroupSummary</code> object that contains information about the level of the hierarchy group,
         * including ARN, Id, and Name.
         * </p>
         * This is a convenience that creates an instance of the {@link HierarchyGroupSummary.Builder} avoiding the need
         * to create one manually via {@link HierarchyGroupSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link HierarchyGroupSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #levelFive(HierarchyGroupSummary)}.
         * 
         * @param levelFive
         *        a consumer that will call methods on {@link HierarchyGroupSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelFive(HierarchyGroupSummary)
         */
        default Builder levelFive(Consumer<HierarchyGroupSummary.Builder> levelFive) {
            return levelFive(HierarchyGroupSummary.builder().applyMutation(levelFive).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HierarchyGroupSummary levelOne;

        private HierarchyGroupSummary levelTwo;

        private HierarchyGroupSummary levelThree;

        private HierarchyGroupSummary levelFour;

        private HierarchyGroupSummary levelFive;

        private BuilderImpl() {
        }

        private BuilderImpl(HierarchyPath model) {
            levelOne(model.levelOne);
            levelTwo(model.levelTwo);
            levelThree(model.levelThree);
            levelFour(model.levelFour);
            levelFive(model.levelFive);
        }

        public final HierarchyGroupSummary.Builder getLevelOne() {
            return levelOne != null ? levelOne.toBuilder() : null;
        }

        @Override
        public final Builder levelOne(HierarchyGroupSummary levelOne) {
            this.levelOne = levelOne;
            return this;
        }

        public final void setLevelOne(HierarchyGroupSummary.BuilderImpl levelOne) {
            this.levelOne = levelOne != null ? levelOne.build() : null;
        }

        public final HierarchyGroupSummary.Builder getLevelTwo() {
            return levelTwo != null ? levelTwo.toBuilder() : null;
        }

        @Override
        public final Builder levelTwo(HierarchyGroupSummary levelTwo) {
            this.levelTwo = levelTwo;
            return this;
        }

        public final void setLevelTwo(HierarchyGroupSummary.BuilderImpl levelTwo) {
            this.levelTwo = levelTwo != null ? levelTwo.build() : null;
        }

        public final HierarchyGroupSummary.Builder getLevelThree() {
            return levelThree != null ? levelThree.toBuilder() : null;
        }

        @Override
        public final Builder levelThree(HierarchyGroupSummary levelThree) {
            this.levelThree = levelThree;
            return this;
        }

        public final void setLevelThree(HierarchyGroupSummary.BuilderImpl levelThree) {
            this.levelThree = levelThree != null ? levelThree.build() : null;
        }

        public final HierarchyGroupSummary.Builder getLevelFour() {
            return levelFour != null ? levelFour.toBuilder() : null;
        }

        @Override
        public final Builder levelFour(HierarchyGroupSummary levelFour) {
            this.levelFour = levelFour;
            return this;
        }

        public final void setLevelFour(HierarchyGroupSummary.BuilderImpl levelFour) {
            this.levelFour = levelFour != null ? levelFour.build() : null;
        }

        public final HierarchyGroupSummary.Builder getLevelFive() {
            return levelFive != null ? levelFive.toBuilder() : null;
        }

        @Override
        public final Builder levelFive(HierarchyGroupSummary levelFive) {
            this.levelFive = levelFive;
            return this;
        }

        public final void setLevelFive(HierarchyGroupSummary.BuilderImpl levelFive) {
            this.levelFive = levelFive != null ? levelFive.build() : null;
        }

        @Override
        public HierarchyPath build() {
            return new HierarchyPath(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
