/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContactAttributesRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateContactAttributesRequest.Builder, UpdateContactAttributesRequest> {
    private static final SdkField<String> INITIAL_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateContactAttributesRequest::initialContactId)).setter(setter(Builder::initialContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialContactId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateContactAttributesRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(UpdateContactAttributesRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_CONTACT_ID_FIELD,
            INSTANCE_ID_FIELD, ATTRIBUTES_FIELD));

    private final String initialContactId;

    private final String instanceId;

    private final Map<String, String> attributes;

    private UpdateContactAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.initialContactId = builder.initialContactId;
        this.instanceId = builder.instanceId;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The unique identifier of the contact for which to update attributes. This is the identifier for the contact
     * associated with the first interaction with the contact center.
     * </p>
     * 
     * @return The unique identifier of the contact for which to update attributes. This is the identifier for the
     *         contact associated with the first interaction with the contact center.
     */
    public String initialContactId() {
        return initialContactId;
    }

    /**
     * <p>
     * The identifier for your Amazon Connect instance. To find the ID of your instance, open the AWS console and select
     * Amazon Connect. Select the alias of the instance in the Instance alias column. The instance ID is displayed in
     * the Overview section of your instance settings. For example, the instance ID is the set of characters at the end
     * of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
     * </p>
     * 
     * @return The identifier for your Amazon Connect instance. To find the ID of your instance, open the AWS console
     *         and select Amazon Connect. Select the alias of the instance in the Instance alias column. The instance ID
     *         is displayed in the Overview section of your instance settings. For example, the instance ID is the set
     *         of characters at the end of the instance ARN, after instance/, such as
     *         10a4c4eb-f57e-4d4c-b602-bf39176ced07.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Specify a custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes,
     * and can be accessed in contact flows just like any other contact attributes.
     * </p>
     * <p>
     * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only
     * alphanumeric, dash, and underscore characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specify a custom key-value pair using an attribute map. The attributes are standard Amazon Connect
     *         attributes, and can be accessed in contact flows just like any other contact attributes.</p>
     *         <p>
     *         There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include
     *         only alphanumeric, dash, and underscore characters.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(initialContactId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactAttributesRequest)) {
            return false;
        }
        UpdateContactAttributesRequest other = (UpdateContactAttributesRequest) obj;
        return Objects.equals(initialContactId(), other.initialContactId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateContactAttributesRequest").add("InitialContactId", initialContactId())
                .add("InstanceId", instanceId()).add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InitialContactId":
            return Optional.ofNullable(clazz.cast(initialContactId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactAttributesRequest, T> g) {
        return obj -> g.apply((UpdateContactAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateContactAttributesRequest> {
        /**
         * <p>
         * The unique identifier of the contact for which to update attributes. This is the identifier for the contact
         * associated with the first interaction with the contact center.
         * </p>
         * 
         * @param initialContactId
         *        The unique identifier of the contact for which to update attributes. This is the identifier for the
         *        contact associated with the first interaction with the contact center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialContactId(String initialContactId);

        /**
         * <p>
         * The identifier for your Amazon Connect instance. To find the ID of your instance, open the AWS console and
         * select Amazon Connect. Select the alias of the instance in the Instance alias column. The instance ID is
         * displayed in the Overview section of your instance settings. For example, the instance ID is the set of
         * characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
         * </p>
         * 
         * @param instanceId
         *        The identifier for your Amazon Connect instance. To find the ID of your instance, open the AWS console
         *        and select Amazon Connect. Select the alias of the instance in the Instance alias column. The instance
         *        ID is displayed in the Overview section of your instance settings. For example, the instance ID is the
         *        set of characters at the end of the instance ARN, after instance/, such as
         *        10a4c4eb-f57e-4d4c-b602-bf39176ced07.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Specify a custom key-value pair using an attribute map. The attributes are standard Amazon Connect
         * attributes, and can be accessed in contact flows just like any other contact attributes.
         * </p>
         * <p>
         * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only
         * alphanumeric, dash, and underscore characters.
         * </p>
         * 
         * @param attributes
         *        Specify a custom key-value pair using an attribute map. The attributes are standard Amazon Connect
         *        attributes, and can be accessed in contact flows just like any other contact attributes.</p>
         *        <p>
         *        There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can
         *        include only alphanumeric, dash, and underscore characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String initialContactId;

        private String instanceId;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactAttributesRequest model) {
            super(model);
            initialContactId(model.initialContactId);
            instanceId(model.instanceId);
            attributes(model.attributes);
        }

        public final String getInitialContactId() {
            return initialContactId;
        }

        @Override
        public final Builder initialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
            return this;
        }

        public final void setInitialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContactAttributesRequest build() {
            return new UpdateContactAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
