/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserIdentityInfoRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateUserIdentityInfoRequest.Builder, UpdateUserIdentityInfoRequest> {
    private static final SdkField<UserIdentityInfo> IDENTITY_INFO_FIELD = SdkField
            .<UserIdentityInfo> builder(MarshallingType.SDK_POJO).getter(getter(UpdateUserIdentityInfoRequest::identityInfo))
            .setter(setter(Builder::identityInfo)).constructor(UserIdentityInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityInfo").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserIdentityInfoRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("UserId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserIdentityInfoRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_INFO_FIELD,
            USER_ID_FIELD, INSTANCE_ID_FIELD));

    private final UserIdentityInfo identityInfo;

    private final String userId;

    private final String instanceId;

    private UpdateUserIdentityInfoRequest(BuilderImpl builder) {
        super(builder);
        this.identityInfo = builder.identityInfo;
        this.userId = builder.userId;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * A <code>UserIdentityInfo</code> object.
     * </p>
     * 
     * @return A <code>UserIdentityInfo</code> object.
     */
    public UserIdentityInfo identityInfo() {
        return identityInfo;
    }

    /**
     * <p>
     * The identifier for the user account to update identity information for.
     * </p>
     * 
     * @return The identifier for the user account to update identity information for.
     */
    public String userId() {
        return userId;
    }

    /**
     * <p>
     * The identifier for your Amazon Connect instance. To find the ID of your instance, open the AWS console and select
     * Amazon Connect. Select the alias of the instance in the Instance alias column. The instance ID is displayed in
     * the Overview section of your instance settings. For example, the instance ID is the set of characters at the end
     * of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
     * </p>
     * 
     * @return The identifier for your Amazon Connect instance. To find the ID of your instance, open the AWS console
     *         and select Amazon Connect. Select the alias of the instance in the Instance alias column. The instance ID
     *         is displayed in the Overview section of your instance settings. For example, the instance ID is the set
     *         of characters at the end of the instance ARN, after instance/, such as
     *         10a4c4eb-f57e-4d4c-b602-bf39176ced07.
     */
    public String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityInfo());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserIdentityInfoRequest)) {
            return false;
        }
        UpdateUserIdentityInfoRequest other = (UpdateUserIdentityInfoRequest) obj;
        return Objects.equals(identityInfo(), other.identityInfo()) && Objects.equals(userId(), other.userId())
                && Objects.equals(instanceId(), other.instanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateUserIdentityInfoRequest").add("IdentityInfo", identityInfo()).add("UserId", userId())
                .add("InstanceId", instanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityInfo":
            return Optional.ofNullable(clazz.cast(identityInfo()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserIdentityInfoRequest, T> g) {
        return obj -> g.apply((UpdateUserIdentityInfoRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUserIdentityInfoRequest> {
        /**
         * <p>
         * A <code>UserIdentityInfo</code> object.
         * </p>
         * 
         * @param identityInfo
         *        A <code>UserIdentityInfo</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityInfo(UserIdentityInfo identityInfo);

        /**
         * <p>
         * A <code>UserIdentityInfo</code> object.
         * </p>
         * This is a convenience that creates an instance of the {@link UserIdentityInfo.Builder} avoiding the need to
         * create one manually via {@link UserIdentityInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserIdentityInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #identityInfo(UserIdentityInfo)}.
         * 
         * @param identityInfo
         *        a consumer that will call methods on {@link UserIdentityInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityInfo(UserIdentityInfo)
         */
        default Builder identityInfo(Consumer<UserIdentityInfo.Builder> identityInfo) {
            return identityInfo(UserIdentityInfo.builder().applyMutation(identityInfo).build());
        }

        /**
         * <p>
         * The identifier for the user account to update identity information for.
         * </p>
         * 
         * @param userId
         *        The identifier for the user account to update identity information for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The identifier for your Amazon Connect instance. To find the ID of your instance, open the AWS console and
         * select Amazon Connect. Select the alias of the instance in the Instance alias column. The instance ID is
         * displayed in the Overview section of your instance settings. For example, the instance ID is the set of
         * characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
         * </p>
         * 
         * @param instanceId
         *        The identifier for your Amazon Connect instance. To find the ID of your instance, open the AWS console
         *        and select Amazon Connect. Select the alias of the instance in the Instance alias column. The instance
         *        ID is displayed in the Overview section of your instance settings. For example, the instance ID is the
         *        set of characters at the end of the instance ARN, after instance/, such as
         *        10a4c4eb-f57e-4d4c-b602-bf39176ced07.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private UserIdentityInfo identityInfo;

        private String userId;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserIdentityInfoRequest model) {
            super(model);
            identityInfo(model.identityInfo);
            userId(model.userId);
            instanceId(model.instanceId);
        }

        public final UserIdentityInfo.Builder getIdentityInfo() {
            return identityInfo != null ? identityInfo.toBuilder() : null;
        }

        @Override
        public final Builder identityInfo(UserIdentityInfo identityInfo) {
            this.identityInfo = identityInfo;
            return this;
        }

        public final void setIdentityInfo(UserIdentityInfo.BuilderImpl identityInfo) {
            this.identityInfo = identityInfo != null ? identityInfo.build() : null;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserIdentityInfoRequest build() {
            return new UpdateUserIdentityInfoRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
