/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserRequest extends ConnectRequest implements
        ToCopyableBuilder<CreateUserRequest.Builder, CreateUserRequest> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUserRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUserRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<UserIdentityInfo> IDENTITY_INFO_FIELD = SdkField
            .<UserIdentityInfo> builder(MarshallingType.SDK_POJO).getter(getter(CreateUserRequest::identityInfo))
            .setter(setter(Builder::identityInfo)).constructor(UserIdentityInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityInfo").build()).build();

    private static final SdkField<UserPhoneConfig> PHONE_CONFIG_FIELD = SdkField
            .<UserPhoneConfig> builder(MarshallingType.SDK_POJO).getter(getter(CreateUserRequest::phoneConfig))
            .setter(setter(Builder::phoneConfig)).constructor(UserPhoneConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneConfig").build()).build();

    private static final SdkField<String> DIRECTORY_USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUserRequest::directoryUserId)).setter(setter(Builder::directoryUserId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryUserId").build()).build();

    private static final SdkField<List<String>> SECURITY_PROFILE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateUserRequest::securityProfileIds))
            .setter(setter(Builder::securityProfileIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfileIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUserRequest::routingProfileId)).setter(setter(Builder::routingProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileId").build()).build();

    private static final SdkField<String> HIERARCHY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUserRequest::hierarchyGroupId)).setter(setter(Builder::hierarchyGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyGroupId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUserRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD,
            PASSWORD_FIELD, IDENTITY_INFO_FIELD, PHONE_CONFIG_FIELD, DIRECTORY_USER_ID_FIELD, SECURITY_PROFILE_IDS_FIELD,
            ROUTING_PROFILE_ID_FIELD, HIERARCHY_GROUP_ID_FIELD, INSTANCE_ID_FIELD));

    private final String username;

    private final String password;

    private final UserIdentityInfo identityInfo;

    private final UserPhoneConfig phoneConfig;

    private final String directoryUserId;

    private final List<String> securityProfileIds;

    private final String routingProfileId;

    private final String hierarchyGroupId;

    private final String instanceId;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.username = builder.username;
        this.password = builder.password;
        this.identityInfo = builder.identityInfo;
        this.phoneConfig = builder.phoneConfig;
        this.directoryUserId = builder.directoryUserId;
        this.securityProfileIds = builder.securityProfileIds;
        this.routingProfileId = builder.routingProfileId;
        this.hierarchyGroupId = builder.hierarchyGroupId;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The user name for the account. For instances not using SAML for identity management, the user name can include up
     * to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters
     * from [a-zA-Z0-9_-.\@]+.
     * </p>
     * 
     * @return The user name for the account. For instances not using SAML for identity management, the user name can
     *         include up to 20 characters. If you are using SAML for identity management, the user name can include up
     *         to 64 characters from [a-zA-Z0-9_-.\@]+.
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * The password for the user account. A password is required if you are using Amazon Connect for identity
     * management. Otherwise, it is an error to include a password.
     * </p>
     * 
     * @return The password for the user account. A password is required if you are using Amazon Connect for identity
     *         management. Otherwise, it is an error to include a password.
     */
    public String password() {
        return password;
    }

    /**
     * <p>
     * The information about the identity of the user.
     * </p>
     * 
     * @return The information about the identity of the user.
     */
    public UserIdentityInfo identityInfo() {
        return identityInfo;
    }

    /**
     * <p>
     * The phone settings for the user.
     * </p>
     * 
     * @return The phone settings for the user.
     */
    public UserPhoneConfig phoneConfig() {
        return phoneConfig;
    }

    /**
     * <p>
     * The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access
     * the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume
     * that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate
     * users from your directory.
     * </p>
     * <p>
     * This parameter is required if you are using an existing directory for identity management in Amazon Connect when
     * Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management
     * and include this parameter, an error is returned.
     * </p>
     * 
     * @return The identifier of the user account in the directory used for identity management. If Amazon Connect
     *         cannot access the directory, you can specify this identifier to authenticate users. If you include the
     *         identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity
     *         information is used to authenticate users from your directory.</p>
     *         <p>
     *         This parameter is required if you are using an existing directory for identity management in Amazon
     *         Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for
     *         identity management and include this parameter, an error is returned.
     */
    public String directoryUserId() {
        return directoryUserId;
    }

    /**
     * <p>
     * The identifier of the security profile for the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The identifier of the security profile for the user.
     */
    public List<String> securityProfileIds() {
        return securityProfileIds;
    }

    /**
     * <p>
     * The identifier of the routing profile for the user.
     * </p>
     * 
     * @return The identifier of the routing profile for the user.
     */
    public String routingProfileId() {
        return routingProfileId;
    }

    /**
     * <p>
     * The identifier of the hierarchy group for the user.
     * </p>
     * 
     * @return The identifier of the hierarchy group for the user.
     */
    public String hierarchyGroupId() {
        return hierarchyGroupId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance.
     */
    public String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(identityInfo());
        hashCode = 31 * hashCode + Objects.hashCode(phoneConfig());
        hashCode = 31 * hashCode + Objects.hashCode(directoryUserId());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileIds());
        hashCode = 31 * hashCode + Objects.hashCode(routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest) obj;
        return Objects.equals(username(), other.username()) && Objects.equals(password(), other.password())
                && Objects.equals(identityInfo(), other.identityInfo()) && Objects.equals(phoneConfig(), other.phoneConfig())
                && Objects.equals(directoryUserId(), other.directoryUserId())
                && Objects.equals(securityProfileIds(), other.securityProfileIds())
                && Objects.equals(routingProfileId(), other.routingProfileId())
                && Objects.equals(hierarchyGroupId(), other.hierarchyGroupId())
                && Objects.equals(instanceId(), other.instanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateUserRequest").add("Username", username()).add("Password", password())
                .add("IdentityInfo", identityInfo()).add("PhoneConfig", phoneConfig()).add("DirectoryUserId", directoryUserId())
                .add("SecurityProfileIds", securityProfileIds()).add("RoutingProfileId", routingProfileId())
                .add("HierarchyGroupId", hierarchyGroupId()).add("InstanceId", instanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "IdentityInfo":
            return Optional.ofNullable(clazz.cast(identityInfo()));
        case "PhoneConfig":
            return Optional.ofNullable(clazz.cast(phoneConfig()));
        case "DirectoryUserId":
            return Optional.ofNullable(clazz.cast(directoryUserId()));
        case "SecurityProfileIds":
            return Optional.ofNullable(clazz.cast(securityProfileIds()));
        case "RoutingProfileId":
            return Optional.ofNullable(clazz.cast(routingProfileId()));
        case "HierarchyGroupId":
            return Optional.ofNullable(clazz.cast(hierarchyGroupId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserRequest, T> g) {
        return obj -> g.apply((CreateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserRequest> {
        /**
         * <p>
         * The user name for the account. For instances not using SAML for identity management, the user name can
         * include up to 20 characters. If you are using SAML for identity management, the user name can include up to
         * 64 characters from [a-zA-Z0-9_-.\@]+.
         * </p>
         * 
         * @param username
         *        The user name for the account. For instances not using SAML for identity management, the user name can
         *        include up to 20 characters. If you are using SAML for identity management, the user name can include
         *        up to 64 characters from [a-zA-Z0-9_-.\@]+.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The password for the user account. A password is required if you are using Amazon Connect for identity
         * management. Otherwise, it is an error to include a password.
         * </p>
         * 
         * @param password
         *        The password for the user account. A password is required if you are using Amazon Connect for identity
         *        management. Otherwise, it is an error to include a password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The information about the identity of the user.
         * </p>
         * 
         * @param identityInfo
         *        The information about the identity of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityInfo(UserIdentityInfo identityInfo);

        /**
         * <p>
         * The information about the identity of the user.
         * </p>
         * This is a convenience that creates an instance of the {@link UserIdentityInfo.Builder} avoiding the need to
         * create one manually via {@link UserIdentityInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserIdentityInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #identityInfo(UserIdentityInfo)}.
         * 
         * @param identityInfo
         *        a consumer that will call methods on {@link UserIdentityInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityInfo(UserIdentityInfo)
         */
        default Builder identityInfo(Consumer<UserIdentityInfo.Builder> identityInfo) {
            return identityInfo(UserIdentityInfo.builder().applyMutation(identityInfo).build());
        }

        /**
         * <p>
         * The phone settings for the user.
         * </p>
         * 
         * @param phoneConfig
         *        The phone settings for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneConfig(UserPhoneConfig phoneConfig);

        /**
         * <p>
         * The phone settings for the user.
         * </p>
         * This is a convenience that creates an instance of the {@link UserPhoneConfig.Builder} avoiding the need to
         * create one manually via {@link UserPhoneConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserPhoneConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #phoneConfig(UserPhoneConfig)}.
         * 
         * @param phoneConfig
         *        a consumer that will call methods on {@link UserPhoneConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneConfig(UserPhoneConfig)
         */
        default Builder phoneConfig(Consumer<UserPhoneConfig.Builder> phoneConfig) {
            return phoneConfig(UserPhoneConfig.builder().applyMutation(phoneConfig).build());
        }

        /**
         * <p>
         * The identifier of the user account in the directory used for identity management. If Amazon Connect cannot
         * access the directory, you can specify this identifier to authenticate users. If you include the identifier,
         * we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to
         * authenticate users from your directory.
         * </p>
         * <p>
         * This parameter is required if you are using an existing directory for identity management in Amazon Connect
         * when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity
         * management and include this parameter, an error is returned.
         * </p>
         * 
         * @param directoryUserId
         *        The identifier of the user account in the directory used for identity management. If Amazon Connect
         *        cannot access the directory, you can specify this identifier to authenticate users. If you include the
         *        identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity
         *        information is used to authenticate users from your directory.</p>
         *        <p>
         *        This parameter is required if you are using an existing directory for identity management in Amazon
         *        Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML
         *        for identity management and include this parameter, an error is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryUserId(String directoryUserId);

        /**
         * <p>
         * The identifier of the security profile for the user.
         * </p>
         * 
         * @param securityProfileIds
         *        The identifier of the security profile for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileIds(Collection<String> securityProfileIds);

        /**
         * <p>
         * The identifier of the security profile for the user.
         * </p>
         * 
         * @param securityProfileIds
         *        The identifier of the security profile for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileIds(String... securityProfileIds);

        /**
         * <p>
         * The identifier of the routing profile for the user.
         * </p>
         * 
         * @param routingProfileId
         *        The identifier of the routing profile for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfileId(String routingProfileId);

        /**
         * <p>
         * The identifier of the hierarchy group for the user.
         * </p>
         * 
         * @param hierarchyGroupId
         *        The identifier of the hierarchy group for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyGroupId(String hierarchyGroupId);

        /**
         * <p>
         * The identifier of the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String username;

        private String password;

        private UserIdentityInfo identityInfo;

        private UserPhoneConfig phoneConfig;

        private String directoryUserId;

        private List<String> securityProfileIds = DefaultSdkAutoConstructList.getInstance();

        private String routingProfileId;

        private String hierarchyGroupId;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            super(model);
            username(model.username);
            password(model.password);
            identityInfo(model.identityInfo);
            phoneConfig(model.phoneConfig);
            directoryUserId(model.directoryUserId);
            securityProfileIds(model.securityProfileIds);
            routingProfileId(model.routingProfileId);
            hierarchyGroupId(model.hierarchyGroupId);
            instanceId(model.instanceId);
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final UserIdentityInfo.Builder getIdentityInfo() {
            return identityInfo != null ? identityInfo.toBuilder() : null;
        }

        @Override
        public final Builder identityInfo(UserIdentityInfo identityInfo) {
            this.identityInfo = identityInfo;
            return this;
        }

        public final void setIdentityInfo(UserIdentityInfo.BuilderImpl identityInfo) {
            this.identityInfo = identityInfo != null ? identityInfo.build() : null;
        }

        public final UserPhoneConfig.Builder getPhoneConfig() {
            return phoneConfig != null ? phoneConfig.toBuilder() : null;
        }

        @Override
        public final Builder phoneConfig(UserPhoneConfig phoneConfig) {
            this.phoneConfig = phoneConfig;
            return this;
        }

        public final void setPhoneConfig(UserPhoneConfig.BuilderImpl phoneConfig) {
            this.phoneConfig = phoneConfig != null ? phoneConfig.build() : null;
        }

        public final String getDirectoryUserId() {
            return directoryUserId;
        }

        @Override
        public final Builder directoryUserId(String directoryUserId) {
            this.directoryUserId = directoryUserId;
            return this;
        }

        public final void setDirectoryUserId(String directoryUserId) {
            this.directoryUserId = directoryUserId;
        }

        public final Collection<String> getSecurityProfileIds() {
            return securityProfileIds;
        }

        @Override
        public final Builder securityProfileIds(Collection<String> securityProfileIds) {
            this.securityProfileIds = SecurityProfileIdsCopier.copy(securityProfileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileIds(String... securityProfileIds) {
            securityProfileIds(Arrays.asList(securityProfileIds));
            return this;
        }

        public final void setSecurityProfileIds(Collection<String> securityProfileIds) {
            this.securityProfileIds = SecurityProfileIdsCopier.copy(securityProfileIds);
        }

        public final String getRoutingProfileId() {
            return routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        public final String getHierarchyGroupId() {
            return hierarchyGroupId;
        }

        @Override
        public final Builder hierarchyGroupId(String hierarchyGroupId) {
            this.hierarchyGroupId = hierarchyGroupId;
            return this;
        }

        public final void setHierarchyGroupId(String hierarchyGroupId) {
            this.hierarchyGroupId = hierarchyGroupId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
