/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a set of real-time metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CurrentMetricResult implements SdkPojo, Serializable,
        ToCopyableBuilder<CurrentMetricResult.Builder, CurrentMetricResult> {
    private static final SdkField<Dimensions> DIMENSIONS_FIELD = SdkField.<Dimensions> builder(MarshallingType.SDK_POJO)
            .getter(getter(CurrentMetricResult::dimensions)).setter(setter(Builder::dimensions)).constructor(Dimensions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()).build();

    private static final SdkField<List<CurrentMetricData>> COLLECTIONS_FIELD = SdkField
            .<List<CurrentMetricData>> builder(MarshallingType.LIST)
            .getter(getter(CurrentMetricResult::collections))
            .setter(setter(Builder::collections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Collections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CurrentMetricData> builder(MarshallingType.SDK_POJO)
                                            .constructor(CurrentMetricData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD,
            COLLECTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Dimensions dimensions;

    private final List<CurrentMetricData> collections;

    private CurrentMetricResult(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.collections = builder.collections;
    }

    /**
     * <p>
     * The dimensions for the metrics.
     * </p>
     * 
     * @return The dimensions for the metrics.
     */
    public Dimensions dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The set of metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The set of metrics.
     */
    public List<CurrentMetricData> collections() {
        return collections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(collections());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CurrentMetricResult)) {
            return false;
        }
        CurrentMetricResult other = (CurrentMetricResult) obj;
        return Objects.equals(dimensions(), other.dimensions()) && Objects.equals(collections(), other.collections());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CurrentMetricResult").add("Dimensions", dimensions()).add("Collections", collections()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "Collections":
            return Optional.ofNullable(clazz.cast(collections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CurrentMetricResult, T> g) {
        return obj -> g.apply((CurrentMetricResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CurrentMetricResult> {
        /**
         * <p>
         * The dimensions for the metrics.
         * </p>
         * 
         * @param dimensions
         *        The dimensions for the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Dimensions dimensions);

        /**
         * <p>
         * The dimensions for the metrics.
         * </p>
         * This is a convenience that creates an instance of the {@link Dimensions.Builder} avoiding the need to create
         * one manually via {@link Dimensions#builder()}.
         *
         * When the {@link Consumer} completes, {@link Dimensions.Builder#build()} is called immediately and its result
         * is passed to {@link #dimensions(Dimensions)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link Dimensions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(Dimensions)
         */
        default Builder dimensions(Consumer<Dimensions.Builder> dimensions) {
            return dimensions(Dimensions.builder().applyMutation(dimensions).build());
        }

        /**
         * <p>
         * The set of metrics.
         * </p>
         * 
         * @param collections
         *        The set of metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collections(Collection<CurrentMetricData> collections);

        /**
         * <p>
         * The set of metrics.
         * </p>
         * 
         * @param collections
         *        The set of metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collections(CurrentMetricData... collections);

        /**
         * <p>
         * The set of metrics.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CurrentMetricData>.Builder} avoiding the
         * need to create one manually via {@link List<CurrentMetricData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CurrentMetricData>.Builder#build()} is called immediately
         * and its result is passed to {@link #collections(List<CurrentMetricData>)}.
         * 
         * @param collections
         *        a consumer that will call methods on {@link List<CurrentMetricData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collections(List<CurrentMetricData>)
         */
        Builder collections(Consumer<CurrentMetricData.Builder>... collections);
    }

    static final class BuilderImpl implements Builder {
        private Dimensions dimensions;

        private List<CurrentMetricData> collections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CurrentMetricResult model) {
            dimensions(model.dimensions);
            collections(model.collections);
        }

        public final Dimensions.Builder getDimensions() {
            return dimensions != null ? dimensions.toBuilder() : null;
        }

        @Override
        public final Builder dimensions(Dimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final void setDimensions(Dimensions.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        public final Collection<CurrentMetricData.Builder> getCollections() {
            return collections != null ? collections.stream().map(CurrentMetricData::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder collections(Collection<CurrentMetricData> collections) {
            this.collections = CurrentMetricDataCollectionsCopier.copy(collections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collections(CurrentMetricData... collections) {
            collections(Arrays.asList(collections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collections(Consumer<CurrentMetricData.Builder>... collections) {
            collections(Stream.of(collections).map(c -> CurrentMetricData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCollections(Collection<CurrentMetricData.BuilderImpl> collections) {
            this.collections = CurrentMetricDataCollectionsCopier.copyFromBuilder(collections);
        }

        @Override
        public CurrentMetricResult build() {
            return new CurrentMetricResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
