/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPhoneNumbersRequest extends ConnectRequest implements
        ToCopyableBuilder<ListPhoneNumbersRequest.Builder, ListPhoneNumbersRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPhoneNumbersRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<List<String>> PHONE_NUMBER_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListPhoneNumbersRequest::phoneNumberTypesAsStrings))
            .setter(setter(Builder::phoneNumberTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("phoneNumberTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PHONE_NUMBER_COUNTRY_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListPhoneNumbersRequest::phoneNumberCountryCodesAsStrings))
            .setter(setter(Builder::phoneNumberCountryCodesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("phoneNumberCountryCodes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPhoneNumbersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListPhoneNumbersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            PHONE_NUMBER_TYPES_FIELD, PHONE_NUMBER_COUNTRY_CODES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String instanceId;

    private final List<String> phoneNumberTypes;

    private final List<String> phoneNumberCountryCodes;

    private final String nextToken;

    private final Integer maxResults;

    private ListPhoneNumbersRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.phoneNumberTypes = builder.phoneNumberTypes;
        this.phoneNumberCountryCodes = builder.phoneNumberCountryCodes;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The type of phone number.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The type of phone number.
     */
    public List<PhoneNumberType> phoneNumberTypes() {
        return PhoneNumberTypesCopier.copyStringToEnum(phoneNumberTypes);
    }

    /**
     * <p>
     * The type of phone number.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The type of phone number.
     */
    public List<String> phoneNumberTypesAsStrings() {
        return phoneNumberTypes;
    }

    /**
     * <p>
     * The ISO country code.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The ISO country code.
     */
    public List<PhoneNumberCountryCode> phoneNumberCountryCodes() {
        return PhoneNumberCountryCodesCopier.copyStringToEnum(phoneNumberCountryCodes);
    }

    /**
     * <p>
     * The ISO country code.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The ISO country code.
     */
    public List<String> phoneNumberCountryCodesAsStrings() {
        return phoneNumberCountryCodes;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximimum number of results to return per page.
     * </p>
     * 
     * @return The maximimum number of results to return per page.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberCountryCodesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersRequest)) {
            return false;
        }
        ListPhoneNumbersRequest other = (ListPhoneNumbersRequest) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(phoneNumberTypesAsStrings(), other.phoneNumberTypesAsStrings())
                && Objects.equals(phoneNumberCountryCodesAsStrings(), other.phoneNumberCountryCodesAsStrings())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPhoneNumbersRequest").add("InstanceId", instanceId())
                .add("PhoneNumberTypes", phoneNumberTypesAsStrings())
                .add("PhoneNumberCountryCodes", phoneNumberCountryCodesAsStrings()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "PhoneNumberTypes":
            return Optional.ofNullable(clazz.cast(phoneNumberTypesAsStrings()));
        case "PhoneNumberCountryCodes":
            return Optional.ofNullable(clazz.cast(phoneNumberCountryCodesAsStrings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPhoneNumbersRequest, T> g) {
        return obj -> g.apply((ListPhoneNumbersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPhoneNumbersRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The type of phone number.
         * </p>
         * 
         * @param phoneNumberTypes
         *        The type of phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberTypesWithStrings(Collection<String> phoneNumberTypes);

        /**
         * <p>
         * The type of phone number.
         * </p>
         * 
         * @param phoneNumberTypes
         *        The type of phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberTypesWithStrings(String... phoneNumberTypes);

        /**
         * <p>
         * The type of phone number.
         * </p>
         * 
         * @param phoneNumberTypes
         *        The type of phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberTypes(Collection<PhoneNumberType> phoneNumberTypes);

        /**
         * <p>
         * The type of phone number.
         * </p>
         * 
         * @param phoneNumberTypes
         *        The type of phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberTypes(PhoneNumberType... phoneNumberTypes);

        /**
         * <p>
         * The ISO country code.
         * </p>
         * 
         * @param phoneNumberCountryCodes
         *        The ISO country code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberCountryCodesWithStrings(Collection<String> phoneNumberCountryCodes);

        /**
         * <p>
         * The ISO country code.
         * </p>
         * 
         * @param phoneNumberCountryCodes
         *        The ISO country code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberCountryCodesWithStrings(String... phoneNumberCountryCodes);

        /**
         * <p>
         * The ISO country code.
         * </p>
         * 
         * @param phoneNumberCountryCodes
         *        The ISO country code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberCountryCodes(Collection<PhoneNumberCountryCode> phoneNumberCountryCodes);

        /**
         * <p>
         * The ISO country code.
         * </p>
         * 
         * @param phoneNumberCountryCodes
         *        The ISO country code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberCountryCodes(PhoneNumberCountryCode... phoneNumberCountryCodes);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximimum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximimum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private List<String> phoneNumberTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> phoneNumberCountryCodes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumbersRequest model) {
            super(model);
            instanceId(model.instanceId);
            phoneNumberTypesWithStrings(model.phoneNumberTypes);
            phoneNumberCountryCodesWithStrings(model.phoneNumberCountryCodes);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<String> getPhoneNumberTypesAsStrings() {
            return phoneNumberTypes;
        }

        @Override
        public final Builder phoneNumberTypesWithStrings(Collection<String> phoneNumberTypes) {
            this.phoneNumberTypes = PhoneNumberTypesCopier.copy(phoneNumberTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberTypesWithStrings(String... phoneNumberTypes) {
            phoneNumberTypesWithStrings(Arrays.asList(phoneNumberTypes));
            return this;
        }

        @Override
        public final Builder phoneNumberTypes(Collection<PhoneNumberType> phoneNumberTypes) {
            this.phoneNumberTypes = PhoneNumberTypesCopier.copyEnumToString(phoneNumberTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberTypes(PhoneNumberType... phoneNumberTypes) {
            phoneNumberTypes(Arrays.asList(phoneNumberTypes));
            return this;
        }

        public final void setPhoneNumberTypesWithStrings(Collection<String> phoneNumberTypes) {
            this.phoneNumberTypes = PhoneNumberTypesCopier.copy(phoneNumberTypes);
        }

        public final Collection<String> getPhoneNumberCountryCodesAsStrings() {
            return phoneNumberCountryCodes;
        }

        @Override
        public final Builder phoneNumberCountryCodesWithStrings(Collection<String> phoneNumberCountryCodes) {
            this.phoneNumberCountryCodes = PhoneNumberCountryCodesCopier.copy(phoneNumberCountryCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberCountryCodesWithStrings(String... phoneNumberCountryCodes) {
            phoneNumberCountryCodesWithStrings(Arrays.asList(phoneNumberCountryCodes));
            return this;
        }

        @Override
        public final Builder phoneNumberCountryCodes(Collection<PhoneNumberCountryCode> phoneNumberCountryCodes) {
            this.phoneNumberCountryCodes = PhoneNumberCountryCodesCopier.copyEnumToString(phoneNumberCountryCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberCountryCodes(PhoneNumberCountryCode... phoneNumberCountryCodes) {
            phoneNumberCountryCodes(Arrays.asList(phoneNumberCountryCodes));
            return this;
        }

        public final void setPhoneNumberCountryCodesWithStrings(Collection<String> phoneNumberCountryCodes) {
            this.phoneNumberCountryCodes = PhoneNumberCountryCodesCopier.copy(phoneNumberCountryCodes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPhoneNumbersRequest build() {
            return new ListPhoneNumbersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
