/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSecurityProfilesResponse extends ConnectResponse implements
        ToCopyableBuilder<ListSecurityProfilesResponse.Builder, ListSecurityProfilesResponse> {
    private static final SdkField<List<SecurityProfileSummary>> SECURITY_PROFILE_SUMMARY_LIST_FIELD = SdkField
            .<List<SecurityProfileSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListSecurityProfilesResponse::securityProfileSummaryList))
            .setter(setter(Builder::securityProfileSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfileSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityProfileSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityProfileSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSecurityProfilesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SECURITY_PROFILE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<SecurityProfileSummary> securityProfileSummaryList;

    private final String nextToken;

    private ListSecurityProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfileSummaryList = builder.securityProfileSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the security profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the security profiles.
     */
    public List<SecurityProfileSummary> securityProfileSummaryList() {
        return securityProfileSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityProfilesResponse)) {
            return false;
        }
        ListSecurityProfilesResponse other = (ListSecurityProfilesResponse) obj;
        return Objects.equals(securityProfileSummaryList(), other.securityProfileSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListSecurityProfilesResponse").add("SecurityProfileSummaryList", securityProfileSummaryList())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityProfileSummaryList":
            return Optional.ofNullable(clazz.cast(securityProfileSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityProfilesResponse, T> g) {
        return obj -> g.apply((ListSecurityProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSecurityProfilesResponse> {
        /**
         * <p>
         * Information about the security profiles.
         * </p>
         * 
         * @param securityProfileSummaryList
         *        Information about the security profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileSummaryList(Collection<SecurityProfileSummary> securityProfileSummaryList);

        /**
         * <p>
         * Information about the security profiles.
         * </p>
         * 
         * @param securityProfileSummaryList
         *        Information about the security profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileSummaryList(SecurityProfileSummary... securityProfileSummaryList);

        /**
         * <p>
         * Information about the security profiles.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SecurityProfileSummary>.Builder} avoiding
         * the need to create one manually via {@link List<SecurityProfileSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SecurityProfileSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #securityProfileSummaryList(List<SecurityProfileSummary>)}.
         * 
         * @param securityProfileSummaryList
         *        a consumer that will call methods on {@link List<SecurityProfileSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityProfileSummaryList(List<SecurityProfileSummary>)
         */
        Builder securityProfileSummaryList(Consumer<SecurityProfileSummary.Builder>... securityProfileSummaryList);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<SecurityProfileSummary> securityProfileSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityProfilesResponse model) {
            super(model);
            securityProfileSummaryList(model.securityProfileSummaryList);
            nextToken(model.nextToken);
        }

        public final Collection<SecurityProfileSummary.Builder> getSecurityProfileSummaryList() {
            return securityProfileSummaryList != null ? securityProfileSummaryList.stream()
                    .map(SecurityProfileSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityProfileSummaryList(Collection<SecurityProfileSummary> securityProfileSummaryList) {
            this.securityProfileSummaryList = SecurityProfileSummaryListCopier.copy(securityProfileSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileSummaryList(SecurityProfileSummary... securityProfileSummaryList) {
            securityProfileSummaryList(Arrays.asList(securityProfileSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileSummaryList(Consumer<SecurityProfileSummary.Builder>... securityProfileSummaryList) {
            securityProfileSummaryList(Stream.of(securityProfileSummaryList)
                    .map(c -> SecurityProfileSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityProfileSummaryList(Collection<SecurityProfileSummary.BuilderImpl> securityProfileSummaryList) {
            this.securityProfileSummaryList = SecurityProfileSummaryListCopier.copyFromBuilder(securityProfileSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSecurityProfilesResponse build() {
            return new ListSecurityProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
