/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaigns.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The possible types of dialer config parameters
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DialerConfig implements SdkPojo, Serializable, ToCopyableBuilder<DialerConfig.Builder, DialerConfig> {
    private static final SdkField<PredictiveDialerConfig> PREDICTIVE_DIALER_CONFIG_FIELD = SdkField
            .<PredictiveDialerConfig> builder(MarshallingType.SDK_POJO).memberName("predictiveDialerConfig")
            .getter(getter(DialerConfig::predictiveDialerConfig)).setter(setter(Builder::predictiveDialerConfig))
            .constructor(PredictiveDialerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictiveDialerConfig").build())
            .build();

    private static final SdkField<ProgressiveDialerConfig> PROGRESSIVE_DIALER_CONFIG_FIELD = SdkField
            .<ProgressiveDialerConfig> builder(MarshallingType.SDK_POJO).memberName("progressiveDialerConfig")
            .getter(getter(DialerConfig::progressiveDialerConfig)).setter(setter(Builder::progressiveDialerConfig))
            .constructor(ProgressiveDialerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressiveDialerConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PREDICTIVE_DIALER_CONFIG_FIELD, PROGRESSIVE_DIALER_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final PredictiveDialerConfig predictiveDialerConfig;

    private final ProgressiveDialerConfig progressiveDialerConfig;

    private final Type type;

    private DialerConfig(BuilderImpl builder) {
        this.predictiveDialerConfig = builder.predictiveDialerConfig;
        this.progressiveDialerConfig = builder.progressiveDialerConfig;
        this.type = builder.type;
    }

    /**
     * Returns the value of the PredictiveDialerConfig property for this object.
     * 
     * @return The value of the PredictiveDialerConfig property for this object.
     */
    public final PredictiveDialerConfig predictiveDialerConfig() {
        return predictiveDialerConfig;
    }

    /**
     * Returns the value of the ProgressiveDialerConfig property for this object.
     * 
     * @return The value of the ProgressiveDialerConfig property for this object.
     */
    public final ProgressiveDialerConfig progressiveDialerConfig() {
        return progressiveDialerConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(predictiveDialerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(progressiveDialerConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DialerConfig)) {
            return false;
        }
        DialerConfig other = (DialerConfig) obj;
        return Objects.equals(predictiveDialerConfig(), other.predictiveDialerConfig())
                && Objects.equals(progressiveDialerConfig(), other.progressiveDialerConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DialerConfig").add("PredictiveDialerConfig", predictiveDialerConfig())
                .add("ProgressiveDialerConfig", progressiveDialerConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "predictiveDialerConfig":
            return Optional.ofNullable(clazz.cast(predictiveDialerConfig()));
        case "progressiveDialerConfig":
            return Optional.ofNullable(clazz.cast(progressiveDialerConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #predictiveDialerConfig()} initialized to the given value.
     *
     * Sets the value of the PredictiveDialerConfig property for this object.
     *
     * @param predictiveDialerConfig
     *        The new value for the PredictiveDialerConfig property for this object.
     */
    public static DialerConfig fromPredictiveDialerConfig(PredictiveDialerConfig predictiveDialerConfig) {
        return builder().predictiveDialerConfig(predictiveDialerConfig).build();
    }

    /**
     * Create an instance of this class with {@link #predictiveDialerConfig()} initialized to the given value.
     *
     * Sets the value of the PredictiveDialerConfig property for this object.
     *
     * @param predictiveDialerConfig
     *        The new value for the PredictiveDialerConfig property for this object.
     */
    public static DialerConfig fromPredictiveDialerConfig(Consumer<PredictiveDialerConfig.Builder> predictiveDialerConfig) {
        PredictiveDialerConfig.Builder builder = PredictiveDialerConfig.builder();
        predictiveDialerConfig.accept(builder);
        return fromPredictiveDialerConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #progressiveDialerConfig()} initialized to the given value.
     *
     * Sets the value of the ProgressiveDialerConfig property for this object.
     *
     * @param progressiveDialerConfig
     *        The new value for the ProgressiveDialerConfig property for this object.
     */
    public static DialerConfig fromProgressiveDialerConfig(ProgressiveDialerConfig progressiveDialerConfig) {
        return builder().progressiveDialerConfig(progressiveDialerConfig).build();
    }

    /**
     * Create an instance of this class with {@link #progressiveDialerConfig()} initialized to the given value.
     *
     * Sets the value of the ProgressiveDialerConfig property for this object.
     *
     * @param progressiveDialerConfig
     *        The new value for the ProgressiveDialerConfig property for this object.
     */
    public static DialerConfig fromProgressiveDialerConfig(Consumer<ProgressiveDialerConfig.Builder> progressiveDialerConfig) {
        ProgressiveDialerConfig.Builder builder = ProgressiveDialerConfig.builder();
        progressiveDialerConfig.accept(builder);
        return fromProgressiveDialerConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DialerConfig, T> g) {
        return obj -> g.apply((DialerConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DialerConfig> {
        /**
         * Sets the value of the PredictiveDialerConfig property for this object.
         *
         * @param predictiveDialerConfig
         *        The new value for the PredictiveDialerConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictiveDialerConfig(PredictiveDialerConfig predictiveDialerConfig);

        /**
         * Sets the value of the PredictiveDialerConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PredictiveDialerConfig.Builder} avoiding
         * the need to create one manually via {@link PredictiveDialerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredictiveDialerConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #predictiveDialerConfig(PredictiveDialerConfig)}.
         * 
         * @param predictiveDialerConfig
         *        a consumer that will call methods on {@link PredictiveDialerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predictiveDialerConfig(PredictiveDialerConfig)
         */
        default Builder predictiveDialerConfig(Consumer<PredictiveDialerConfig.Builder> predictiveDialerConfig) {
            return predictiveDialerConfig(PredictiveDialerConfig.builder().applyMutation(predictiveDialerConfig).build());
        }

        /**
         * Sets the value of the ProgressiveDialerConfig property for this object.
         *
         * @param progressiveDialerConfig
         *        The new value for the ProgressiveDialerConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressiveDialerConfig(ProgressiveDialerConfig progressiveDialerConfig);

        /**
         * Sets the value of the ProgressiveDialerConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ProgressiveDialerConfig.Builder} avoiding
         * the need to create one manually via {@link ProgressiveDialerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProgressiveDialerConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #progressiveDialerConfig(ProgressiveDialerConfig)}.
         * 
         * @param progressiveDialerConfig
         *        a consumer that will call methods on {@link ProgressiveDialerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #progressiveDialerConfig(ProgressiveDialerConfig)
         */
        default Builder progressiveDialerConfig(Consumer<ProgressiveDialerConfig.Builder> progressiveDialerConfig) {
            return progressiveDialerConfig(ProgressiveDialerConfig.builder().applyMutation(progressiveDialerConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PredictiveDialerConfig predictiveDialerConfig;

        private ProgressiveDialerConfig progressiveDialerConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DialerConfig model) {
            predictiveDialerConfig(model.predictiveDialerConfig);
            progressiveDialerConfig(model.progressiveDialerConfig);
        }

        public final PredictiveDialerConfig.Builder getPredictiveDialerConfig() {
            return predictiveDialerConfig != null ? predictiveDialerConfig.toBuilder() : null;
        }

        public final void setPredictiveDialerConfig(PredictiveDialerConfig.BuilderImpl predictiveDialerConfig) {
            Object oldValue = this.predictiveDialerConfig;
            this.predictiveDialerConfig = predictiveDialerConfig != null ? predictiveDialerConfig.build() : null;
            handleUnionValueChange(Type.PREDICTIVE_DIALER_CONFIG, oldValue, this.predictiveDialerConfig);
        }

        @Override
        public final Builder predictiveDialerConfig(PredictiveDialerConfig predictiveDialerConfig) {
            Object oldValue = this.predictiveDialerConfig;
            this.predictiveDialerConfig = predictiveDialerConfig;
            handleUnionValueChange(Type.PREDICTIVE_DIALER_CONFIG, oldValue, this.predictiveDialerConfig);
            return this;
        }

        public final ProgressiveDialerConfig.Builder getProgressiveDialerConfig() {
            return progressiveDialerConfig != null ? progressiveDialerConfig.toBuilder() : null;
        }

        public final void setProgressiveDialerConfig(ProgressiveDialerConfig.BuilderImpl progressiveDialerConfig) {
            Object oldValue = this.progressiveDialerConfig;
            this.progressiveDialerConfig = progressiveDialerConfig != null ? progressiveDialerConfig.build() : null;
            handleUnionValueChange(Type.PROGRESSIVE_DIALER_CONFIG, oldValue, this.progressiveDialerConfig);
        }

        @Override
        public final Builder progressiveDialerConfig(ProgressiveDialerConfig progressiveDialerConfig) {
            Object oldValue = this.progressiveDialerConfig;
            this.progressiveDialerConfig = progressiveDialerConfig;
            handleUnionValueChange(Type.PROGRESSIVE_DIALER_CONFIG, oldValue, this.progressiveDialerConfig);
            return this;
        }

        @Override
        public DialerConfig build() {
            return new DialerConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DialerConfig#type()
     */
    public enum Type {
        PREDICTIVE_DIALER_CONFIG,

        PROGRESSIVE_DIALER_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
