/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaigns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * PutDialRequestBatchRequest
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDialRequestBatchRequest extends ConnectCampaignsRequest implements
        ToCopyableBuilder<PutDialRequestBatchRequest.Builder, PutDialRequestBatchRequest> {
    private static final SdkField<List<DialRequest>> DIAL_REQUESTS_FIELD = SdkField
            .<List<DialRequest>> builder(MarshallingType.LIST)
            .memberName("dialRequests")
            .getter(getter(PutDialRequestBatchRequest::dialRequests))
            .setter(setter(Builder::dialRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DialRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(DialRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(PutDialRequestBatchRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DIAL_REQUESTS_FIELD, ID_FIELD));

    private final List<DialRequest> dialRequests;

    private final String id;

    private PutDialRequestBatchRequest(BuilderImpl builder) {
        super(builder);
        this.dialRequests = builder.dialRequests;
        this.id = builder.id;
    }

    /**
     * For responses, this returns true if the service returned a value for the DialRequests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDialRequests() {
        return dialRequests != null && !(dialRequests instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the DialRequests property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDialRequests} method.
     * </p>
     * 
     * @return The value of the DialRequests property for this object.
     */
    public final List<DialRequest> dialRequests() {
        return dialRequests;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDialRequests() ? dialRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDialRequestBatchRequest)) {
            return false;
        }
        PutDialRequestBatchRequest other = (PutDialRequestBatchRequest) obj;
        return hasDialRequests() == other.hasDialRequests() && Objects.equals(dialRequests(), other.dialRequests())
                && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDialRequestBatchRequest").add("DialRequests", hasDialRequests() ? dialRequests() : null)
                .add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dialRequests":
            return Optional.ofNullable(clazz.cast(dialRequests()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDialRequestBatchRequest, T> g) {
        return obj -> g.apply((PutDialRequestBatchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectCampaignsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutDialRequestBatchRequest> {
        /**
         * Sets the value of the DialRequests property for this object.
         *
         * @param dialRequests
         *        The new value for the DialRequests property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialRequests(Collection<DialRequest> dialRequests);

        /**
         * Sets the value of the DialRequests property for this object.
         *
         * @param dialRequests
         *        The new value for the DialRequests property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialRequests(DialRequest... dialRequests);

        /**
         * Sets the value of the DialRequests property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcampaigns.model.DialRequest.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.connectcampaigns.model.DialRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcampaigns.model.DialRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #dialRequests(List<DialRequest>)}.
         * 
         * @param dialRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcampaigns.model.DialRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dialRequests(java.util.Collection<DialRequest>)
         */
        Builder dialRequests(Consumer<DialRequest.Builder>... dialRequests);

        /**
         * Sets the value of the Id property for this object.
         *
         * @param id
         *        The new value for the Id property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCampaignsRequest.BuilderImpl implements Builder {
        private List<DialRequest> dialRequests = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDialRequestBatchRequest model) {
            super(model);
            dialRequests(model.dialRequests);
            id(model.id);
        }

        public final List<DialRequest.Builder> getDialRequests() {
            List<DialRequest.Builder> result = DialRequestListCopier.copyToBuilder(this.dialRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDialRequests(Collection<DialRequest.BuilderImpl> dialRequests) {
            this.dialRequests = DialRequestListCopier.copyFromBuilder(dialRequests);
        }

        @Override
        public final Builder dialRequests(Collection<DialRequest> dialRequests) {
            this.dialRequests = DialRequestListCopier.copy(dialRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dialRequests(DialRequest... dialRequests) {
            dialRequests(Arrays.asList(dialRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dialRequests(Consumer<DialRequest.Builder>... dialRequests) {
            dialRequests(Stream.of(dialRequests).map(c -> DialRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDialRequestBatchRequest build() {
            return new PutDialRequestBatchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
