/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaigns;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.connectcampaigns.model.AccessDeniedException;
import software.amazon.awssdk.services.connectcampaigns.model.ConflictException;
import software.amazon.awssdk.services.connectcampaigns.model.ConnectCampaignsException;
import software.amazon.awssdk.services.connectcampaigns.model.CreateCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.CreateCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.DeleteConnectInstanceConfigRequest;
import software.amazon.awssdk.services.connectcampaigns.model.DeleteConnectInstanceConfigResponse;
import software.amazon.awssdk.services.connectcampaigns.model.DeleteInstanceOnboardingJobRequest;
import software.amazon.awssdk.services.connectcampaigns.model.DeleteInstanceOnboardingJobResponse;
import software.amazon.awssdk.services.connectcampaigns.model.DescribeCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.DescribeCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.GetCampaignStateBatchRequest;
import software.amazon.awssdk.services.connectcampaigns.model.GetCampaignStateBatchResponse;
import software.amazon.awssdk.services.connectcampaigns.model.GetCampaignStateRequest;
import software.amazon.awssdk.services.connectcampaigns.model.GetCampaignStateResponse;
import software.amazon.awssdk.services.connectcampaigns.model.GetConnectInstanceConfigRequest;
import software.amazon.awssdk.services.connectcampaigns.model.GetConnectInstanceConfigResponse;
import software.amazon.awssdk.services.connectcampaigns.model.GetInstanceOnboardingJobStatusRequest;
import software.amazon.awssdk.services.connectcampaigns.model.GetInstanceOnboardingJobStatusResponse;
import software.amazon.awssdk.services.connectcampaigns.model.InternalServerException;
import software.amazon.awssdk.services.connectcampaigns.model.InvalidCampaignStateException;
import software.amazon.awssdk.services.connectcampaigns.model.InvalidStateException;
import software.amazon.awssdk.services.connectcampaigns.model.ListCampaignsRequest;
import software.amazon.awssdk.services.connectcampaigns.model.ListCampaignsResponse;
import software.amazon.awssdk.services.connectcampaigns.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.connectcampaigns.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.connectcampaigns.model.PauseCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.PauseCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.PutDialRequestBatchRequest;
import software.amazon.awssdk.services.connectcampaigns.model.PutDialRequestBatchResponse;
import software.amazon.awssdk.services.connectcampaigns.model.ResourceNotFoundException;
import software.amazon.awssdk.services.connectcampaigns.model.ResumeCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.ResumeCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.connectcampaigns.model.StartCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.StartCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.StartInstanceOnboardingJobRequest;
import software.amazon.awssdk.services.connectcampaigns.model.StartInstanceOnboardingJobResponse;
import software.amazon.awssdk.services.connectcampaigns.model.StopCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.StopCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.TagResourceRequest;
import software.amazon.awssdk.services.connectcampaigns.model.TagResourceResponse;
import software.amazon.awssdk.services.connectcampaigns.model.ThrottlingException;
import software.amazon.awssdk.services.connectcampaigns.model.UntagResourceRequest;
import software.amazon.awssdk.services.connectcampaigns.model.UntagResourceResponse;
import software.amazon.awssdk.services.connectcampaigns.model.UpdateCampaignDialerConfigRequest;
import software.amazon.awssdk.services.connectcampaigns.model.UpdateCampaignDialerConfigResponse;
import software.amazon.awssdk.services.connectcampaigns.model.UpdateCampaignNameRequest;
import software.amazon.awssdk.services.connectcampaigns.model.UpdateCampaignNameResponse;
import software.amazon.awssdk.services.connectcampaigns.model.UpdateCampaignOutboundCallConfigRequest;
import software.amazon.awssdk.services.connectcampaigns.model.UpdateCampaignOutboundCallConfigResponse;
import software.amazon.awssdk.services.connectcampaigns.model.ValidationException;
import software.amazon.awssdk.services.connectcampaigns.paginators.ListCampaignsIterable;

/**
 * Service client for accessing AmazonConnectCampaignService. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Provide APIs to create and manage Amazon Connect Campaigns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ConnectCampaignsClient extends SdkClient {
    String SERVICE_NAME = "connect-campaigns";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "connect-campaigns";

    /**
     * <p>
     * Creates a campaign for the specified Amazon Connect account. This API is idempotent.
     * </p>
     *
     * @param createCampaignRequest
     *        The request for Create Campaign API.
     * @return Result of the CreateCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/CreateCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCampaignResponse createCampaign(CreateCampaignRequest createCampaignRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a campaign for the specified Amazon Connect account. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCampaignRequest#builder()}
     * </p>
     *
     * @param createCampaignRequest
     *        A {@link Consumer} that will call methods on {@link CreateCampaignRequest.Builder} to create a request.
     *        The request for Create Campaign API.
     * @return Result of the CreateCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/CreateCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCampaignResponse createCampaign(Consumer<CreateCampaignRequest.Builder> createCampaignRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            AccessDeniedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsException {
        return createCampaign(CreateCampaignRequest.builder().applyMutation(createCampaignRequest).build());
    }

    /**
     * <p>
     * Deletes a campaign from the specified Amazon Connect account.
     * </p>
     *
     * @param deleteCampaignRequest
     *        DeleteCampaignRequest
     * @return Result of the DeleteCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DeleteCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCampaignResponse deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a campaign from the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteCampaignRequest#builder()}
     * </p>
     *
     * @param deleteCampaignRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCampaignRequest.Builder} to create a request.
     *        DeleteCampaignRequest
     * @return Result of the DeleteCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DeleteCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCampaignResponse deleteCampaign(Consumer<DeleteCampaignRequest.Builder> deleteCampaignRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ConnectCampaignsException {
        return deleteCampaign(DeleteCampaignRequest.builder().applyMutation(deleteCampaignRequest).build());
    }

    /**
     * <p>
     * Deletes a connect instance config from the specified AWS account.
     * </p>
     *
     * @param deleteConnectInstanceConfigRequest
     *        DeleteCampaignRequest
     * @return Result of the DeleteConnectInstanceConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidStateException
     *         The request could not be processed because of conflict in the current state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.DeleteConnectInstanceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DeleteConnectInstanceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectInstanceConfigResponse deleteConnectInstanceConfig(
            DeleteConnectInstanceConfigRequest deleteConnectInstanceConfigRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, InvalidStateException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a connect instance config from the specified AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectInstanceConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConnectInstanceConfigRequest#builder()}
     * </p>
     *
     * @param deleteConnectInstanceConfigRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConnectInstanceConfigRequest.Builder} to create
     *        a request. DeleteCampaignRequest
     * @return Result of the DeleteConnectInstanceConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidStateException
     *         The request could not be processed because of conflict in the current state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.DeleteConnectInstanceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DeleteConnectInstanceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectInstanceConfigResponse deleteConnectInstanceConfig(
            Consumer<DeleteConnectInstanceConfigRequest.Builder> deleteConnectInstanceConfigRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            InvalidStateException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        return deleteConnectInstanceConfig(DeleteConnectInstanceConfigRequest.builder()
                .applyMutation(deleteConnectInstanceConfigRequest).build());
    }

    /**
     * <p>
     * Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteInstanceOnboardingJobRequest
     *        The request for DeleteInstanceOnboardingJob API.
     * @return Result of the DeleteInstanceOnboardingJob operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidStateException
     *         The request could not be processed because of conflict in the current state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.DeleteInstanceOnboardingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DeleteInstanceOnboardingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInstanceOnboardingJobResponse deleteInstanceOnboardingJob(
            DeleteInstanceOnboardingJobRequest deleteInstanceOnboardingJobRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, InvalidStateException, AwsServiceException,
            SdkClientException, ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceOnboardingJobRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteInstanceOnboardingJobRequest#builder()}
     * </p>
     *
     * @param deleteInstanceOnboardingJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInstanceOnboardingJobRequest.Builder} to create
     *        a request. The request for DeleteInstanceOnboardingJob API.
     * @return Result of the DeleteInstanceOnboardingJob operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidStateException
     *         The request could not be processed because of conflict in the current state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.DeleteInstanceOnboardingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DeleteInstanceOnboardingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInstanceOnboardingJobResponse deleteInstanceOnboardingJob(
            Consumer<DeleteInstanceOnboardingJobRequest.Builder> deleteInstanceOnboardingJobRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            InvalidStateException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        return deleteInstanceOnboardingJob(DeleteInstanceOnboardingJobRequest.builder()
                .applyMutation(deleteInstanceOnboardingJobRequest).build());
    }

    /**
     * <p>
     * Describes the specific campaign.
     * </p>
     *
     * @param describeCampaignRequest
     *        DescribeCampaignRequests
     * @return Result of the DescribeCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.DescribeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DescribeCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCampaignResponse describeCampaign(DescribeCampaignRequest describeCampaignRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specific campaign.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCampaignRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeCampaignRequest#builder()}
     * </p>
     *
     * @param describeCampaignRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCampaignRequest.Builder} to create a request.
     *        DescribeCampaignRequests
     * @return Result of the DescribeCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.DescribeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DescribeCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCampaignResponse describeCampaign(Consumer<DescribeCampaignRequest.Builder> describeCampaignRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ConnectCampaignsException {
        return describeCampaign(DescribeCampaignRequest.builder().applyMutation(describeCampaignRequest).build());
    }

    /**
     * <p>
     * Get state of a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param getCampaignStateRequest
     *        GetCampaignStateRequest
     * @return Result of the GetCampaignState operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.GetCampaignState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetCampaignState"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCampaignStateResponse getCampaignState(GetCampaignStateRequest getCampaignStateRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get state of a campaign for the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignStateRequest.Builder} avoiding the need
     * to create one manually via {@link GetCampaignStateRequest#builder()}
     * </p>
     *
     * @param getCampaignStateRequest
     *        A {@link Consumer} that will call methods on {@link GetCampaignStateRequest.Builder} to create a request.
     *        GetCampaignStateRequest
     * @return Result of the GetCampaignState operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.GetCampaignState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetCampaignState"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCampaignStateResponse getCampaignState(Consumer<GetCampaignStateRequest.Builder> getCampaignStateRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        return getCampaignState(GetCampaignStateRequest.builder().applyMutation(getCampaignStateRequest).build());
    }

    /**
     * <p>
     * Get state of campaigns for the specified Amazon Connect account.
     * </p>
     *
     * @param getCampaignStateBatchRequest
     *        GetCampaignStateBatchRequest
     * @return Result of the GetCampaignStateBatch operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.GetCampaignStateBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetCampaignStateBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCampaignStateBatchResponse getCampaignStateBatch(GetCampaignStateBatchRequest getCampaignStateBatchRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get state of campaigns for the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignStateBatchRequest.Builder} avoiding the
     * need to create one manually via {@link GetCampaignStateBatchRequest#builder()}
     * </p>
     *
     * @param getCampaignStateBatchRequest
     *        A {@link Consumer} that will call methods on {@link GetCampaignStateBatchRequest.Builder} to create a
     *        request. GetCampaignStateBatchRequest
     * @return Result of the GetCampaignStateBatch operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.GetCampaignStateBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetCampaignStateBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCampaignStateBatchResponse getCampaignStateBatch(
            Consumer<GetCampaignStateBatchRequest.Builder> getCampaignStateBatchRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsException {
        return getCampaignStateBatch(GetCampaignStateBatchRequest.builder().applyMutation(getCampaignStateBatchRequest).build());
    }

    /**
     * <p>
     * Get the specific Connect instance config.
     * </p>
     *
     * @param getConnectInstanceConfigRequest
     *        GetConnectInstanceConfigRequest
     * @return Result of the GetConnectInstanceConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.GetConnectInstanceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetConnectInstanceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectInstanceConfigResponse getConnectInstanceConfig(
            GetConnectInstanceConfigRequest getConnectInstanceConfigRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the specific Connect instance config.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectInstanceConfigRequest.Builder} avoiding
     * the need to create one manually via {@link GetConnectInstanceConfigRequest#builder()}
     * </p>
     *
     * @param getConnectInstanceConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectInstanceConfigRequest.Builder} to create a
     *        request. GetConnectInstanceConfigRequest
     * @return Result of the GetConnectInstanceConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.GetConnectInstanceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetConnectInstanceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectInstanceConfigResponse getConnectInstanceConfig(
            Consumer<GetConnectInstanceConfigRequest.Builder> getConnectInstanceConfigRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsException {
        return getConnectInstanceConfig(GetConnectInstanceConfigRequest.builder().applyMutation(getConnectInstanceConfigRequest)
                .build());
    }

    /**
     * <p>
     * Get the specific instance onboarding job status.
     * </p>
     *
     * @param getInstanceOnboardingJobStatusRequest
     *        GetInstanceOnboardingJobStatusRequest
     * @return Result of the GetInstanceOnboardingJobStatus operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.GetInstanceOnboardingJobStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetInstanceOnboardingJobStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInstanceOnboardingJobStatusResponse getInstanceOnboardingJobStatus(
            GetInstanceOnboardingJobStatusRequest getInstanceOnboardingJobStatusRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the specific instance onboarding job status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceOnboardingJobStatusRequest.Builder}
     * avoiding the need to create one manually via {@link GetInstanceOnboardingJobStatusRequest#builder()}
     * </p>
     *
     * @param getInstanceOnboardingJobStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetInstanceOnboardingJobStatusRequest.Builder} to
     *        create a request. GetInstanceOnboardingJobStatusRequest
     * @return Result of the GetInstanceOnboardingJobStatus operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.GetInstanceOnboardingJobStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetInstanceOnboardingJobStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInstanceOnboardingJobStatusResponse getInstanceOnboardingJobStatus(
            Consumer<GetInstanceOnboardingJobStatusRequest.Builder> getInstanceOnboardingJobStatusRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ConnectCampaignsException {
        return getInstanceOnboardingJobStatus(GetInstanceOnboardingJobStatusRequest.builder()
                .applyMutation(getInstanceOnboardingJobStatusRequest).build());
    }

    /**
     * <p>
     * Provides summary information about the campaigns under the specified Amazon Connect account.
     * </p>
     *
     * @param listCampaignsRequest
     *        ListCampaignsRequest
     * @return Result of the ListCampaigns operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/ListCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCampaignsResponse listCampaigns(ListCampaignsRequest listCampaignsRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summary information about the campaigns under the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCampaignsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCampaignsRequest#builder()}
     * </p>
     *
     * @param listCampaignsRequest
     *        A {@link Consumer} that will call methods on {@link ListCampaignsRequest.Builder} to create a request.
     *        ListCampaignsRequest
     * @return Result of the ListCampaigns operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/ListCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCampaignsResponse listCampaigns(Consumer<ListCampaignsRequest.Builder> listCampaignsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsException {
        return listCampaigns(ListCampaignsRequest.builder().applyMutation(listCampaignsRequest).build());
    }

    /**
     * <p>
     * Provides summary information about the campaigns under the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCampaigns(software.amazon.awssdk.services.connectcampaigns.model.ListCampaignsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaigns.paginators.ListCampaignsIterable responses = client.listCampaignsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connectcampaigns.paginators.ListCampaignsIterable responses = client
     *             .listCampaignsPaginator(request);
     *     for (software.amazon.awssdk.services.connectcampaigns.model.ListCampaignsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaigns.paginators.ListCampaignsIterable responses = client.listCampaignsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCampaigns(software.amazon.awssdk.services.connectcampaigns.model.ListCampaignsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCampaignsRequest
     *        ListCampaignsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/ListCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCampaignsIterable listCampaignsPaginator(ListCampaignsRequest listCampaignsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summary information about the campaigns under the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCampaigns(software.amazon.awssdk.services.connectcampaigns.model.ListCampaignsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaigns.paginators.ListCampaignsIterable responses = client.listCampaignsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connectcampaigns.paginators.ListCampaignsIterable responses = client
     *             .listCampaignsPaginator(request);
     *     for (software.amazon.awssdk.services.connectcampaigns.model.ListCampaignsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaigns.paginators.ListCampaignsIterable responses = client.listCampaignsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCampaigns(software.amazon.awssdk.services.connectcampaigns.model.ListCampaignsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCampaignsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCampaignsRequest#builder()}
     * </p>
     *
     * @param listCampaignsRequest
     *        A {@link Consumer} that will call methods on {@link ListCampaignsRequest.Builder} to create a request.
     *        ListCampaignsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/ListCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCampaignsIterable listCampaignsPaginator(Consumer<ListCampaignsRequest.Builder> listCampaignsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsException {
        return listCampaignsPaginator(ListCampaignsRequest.builder().applyMutation(listCampaignsRequest).build());
    }

    /**
     * <p>
     * List tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        ListTagsForResource
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request. ListTagsForResource
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectCampaignsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Pauses a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param pauseCampaignRequest
     *        PauseCampaignRequest
     * @return Result of the PauseCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.PauseCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/PauseCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default PauseCampaignResponse pauseCampaign(PauseCampaignRequest pauseCampaignRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Pauses a campaign for the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PauseCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link PauseCampaignRequest#builder()}
     * </p>
     *
     * @param pauseCampaignRequest
     *        A {@link Consumer} that will call methods on {@link PauseCampaignRequest.Builder} to create a request.
     *        PauseCampaignRequest
     * @return Result of the PauseCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.PauseCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/PauseCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default PauseCampaignResponse pauseCampaign(Consumer<PauseCampaignRequest.Builder> pauseCampaignRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsException {
        return pauseCampaign(PauseCampaignRequest.builder().applyMutation(pauseCampaignRequest).build());
    }

    /**
     * <p>
     * Creates dials requests for the specified campaign Amazon Connect account. This API is idempotent.
     * </p>
     *
     * @param putDialRequestBatchRequest
     *        PutDialRequestBatchRequest
     * @return Result of the PutDialRequestBatch operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.PutDialRequestBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/PutDialRequestBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDialRequestBatchResponse putDialRequestBatch(PutDialRequestBatchRequest putDialRequestBatchRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates dials requests for the specified campaign Amazon Connect account. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDialRequestBatchRequest.Builder} avoiding the
     * need to create one manually via {@link PutDialRequestBatchRequest#builder()}
     * </p>
     *
     * @param putDialRequestBatchRequest
     *        A {@link Consumer} that will call methods on {@link PutDialRequestBatchRequest.Builder} to create a
     *        request. PutDialRequestBatchRequest
     * @return Result of the PutDialRequestBatch operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.PutDialRequestBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/PutDialRequestBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDialRequestBatchResponse putDialRequestBatch(
            Consumer<PutDialRequestBatchRequest.Builder> putDialRequestBatchRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        return putDialRequestBatch(PutDialRequestBatchRequest.builder().applyMutation(putDialRequestBatchRequest).build());
    }

    /**
     * <p>
     * Stops a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param resumeCampaignRequest
     *        ResumeCampaignRequest
     * @return Result of the ResumeCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.ResumeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/ResumeCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default ResumeCampaignResponse resumeCampaign(ResumeCampaignRequest resumeCampaignRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a campaign for the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResumeCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link ResumeCampaignRequest#builder()}
     * </p>
     *
     * @param resumeCampaignRequest
     *        A {@link Consumer} that will call methods on {@link ResumeCampaignRequest.Builder} to create a request.
     *        ResumeCampaignRequest
     * @return Result of the ResumeCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.ResumeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/ResumeCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default ResumeCampaignResponse resumeCampaign(Consumer<ResumeCampaignRequest.Builder> resumeCampaignRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsException {
        return resumeCampaign(ResumeCampaignRequest.builder().applyMutation(resumeCampaignRequest).build());
    }

    /**
     * <p>
     * Starts a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param startCampaignRequest
     *        StartCampaignRequest
     * @return Result of the StartCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.StartCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/StartCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default StartCampaignResponse startCampaign(StartCampaignRequest startCampaignRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a campaign for the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link StartCampaignRequest#builder()}
     * </p>
     *
     * @param startCampaignRequest
     *        A {@link Consumer} that will call methods on {@link StartCampaignRequest.Builder} to create a request.
     *        StartCampaignRequest
     * @return Result of the StartCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.StartCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/StartCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default StartCampaignResponse startCampaign(Consumer<StartCampaignRequest.Builder> startCampaignRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsException {
        return startCampaign(StartCampaignRequest.builder().applyMutation(startCampaignRequest).build());
    }

    /**
     * <p>
     * Onboard the specific Amazon Connect instance to Connect Campaigns.
     * </p>
     *
     * @param startInstanceOnboardingJobRequest
     *        The request for StartInstanceOnboardingJob API.
     * @return Result of the StartInstanceOnboardingJob operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.StartInstanceOnboardingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/StartInstanceOnboardingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartInstanceOnboardingJobResponse startInstanceOnboardingJob(
            StartInstanceOnboardingJobRequest startInstanceOnboardingJobRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Onboard the specific Amazon Connect instance to Connect Campaigns.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartInstanceOnboardingJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartInstanceOnboardingJobRequest#builder()}
     * </p>
     *
     * @param startInstanceOnboardingJobRequest
     *        A {@link Consumer} that will call methods on {@link StartInstanceOnboardingJobRequest.Builder} to create a
     *        request. The request for StartInstanceOnboardingJob API.
     * @return Result of the StartInstanceOnboardingJob operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.StartInstanceOnboardingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/StartInstanceOnboardingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartInstanceOnboardingJobResponse startInstanceOnboardingJob(
            Consumer<StartInstanceOnboardingJobRequest.Builder> startInstanceOnboardingJobRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        return startInstanceOnboardingJob(StartInstanceOnboardingJobRequest.builder()
                .applyMutation(startInstanceOnboardingJobRequest).build());
    }

    /**
     * <p>
     * Stops a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param stopCampaignRequest
     *        StopCampaignRequest
     * @return Result of the StopCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.StopCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/StopCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default StopCampaignResponse stopCampaign(StopCampaignRequest stopCampaignRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a campaign for the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link StopCampaignRequest#builder()}
     * </p>
     *
     * @param stopCampaignRequest
     *        A {@link Consumer} that will call methods on {@link StopCampaignRequest.Builder} to create a request.
     *        StopCampaignRequest
     * @return Result of the StopCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.StopCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/StopCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default StopCampaignResponse stopCampaign(Consumer<StopCampaignRequest.Builder> stopCampaignRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsException {
        return stopCampaign(StopCampaignRequest.builder().applyMutation(stopCampaignRequest).build());
    }

    /**
     * <p>
     * Tag a resource.
     * </p>
     *
     * @param tagResourceRequest
     *        TagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tag a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     *        TagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Untag a resource.
     * </p>
     *
     * @param untagResourceRequest
     *        UntagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untag a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     *        UntagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the dialer config of a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignDialerConfigRequest
     *        UpdateCampaignDialerConfigRequest
     * @return Result of the UpdateCampaignDialerConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.UpdateCampaignDialerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UpdateCampaignDialerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignDialerConfigResponse updateCampaignDialerConfig(
            UpdateCampaignDialerConfigRequest updateCampaignDialerConfigRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException, AwsServiceException,
            SdkClientException, ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the dialer config of a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignDialerConfigRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateCampaignDialerConfigRequest#builder()}
     * </p>
     *
     * @param updateCampaignDialerConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCampaignDialerConfigRequest.Builder} to create a
     *        request. UpdateCampaignDialerConfigRequest
     * @return Result of the UpdateCampaignDialerConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.UpdateCampaignDialerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UpdateCampaignDialerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignDialerConfigResponse updateCampaignDialerConfig(
            Consumer<UpdateCampaignDialerConfigRequest.Builder> updateCampaignDialerConfigRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        return updateCampaignDialerConfig(UpdateCampaignDialerConfigRequest.builder()
                .applyMutation(updateCampaignDialerConfigRequest).build());
    }

    /**
     * <p>
     * Updates the name of a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignNameRequest
     *        UpdateCampaignNameRequest
     * @return Result of the UpdateCampaignName operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.UpdateCampaignName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UpdateCampaignName"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignNameResponse updateCampaignName(UpdateCampaignNameRequest updateCampaignNameRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name of a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignNameRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateCampaignNameRequest#builder()}
     * </p>
     *
     * @param updateCampaignNameRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCampaignNameRequest.Builder} to create a
     *        request. UpdateCampaignNameRequest
     * @return Result of the UpdateCampaignName operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.UpdateCampaignName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UpdateCampaignName"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignNameResponse updateCampaignName(Consumer<UpdateCampaignNameRequest.Builder> updateCampaignNameRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        return updateCampaignName(UpdateCampaignNameRequest.builder().applyMutation(updateCampaignNameRequest).build());
    }

    /**
     * <p>
     * Updates the outbound call config of a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignOutboundCallConfigRequest
     *        UpdateCampaignOutboundCallConfigRequest
     * @return Result of the UpdateCampaignOutboundCallConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.UpdateCampaignOutboundCallConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UpdateCampaignOutboundCallConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignOutboundCallConfigResponse updateCampaignOutboundCallConfig(
            UpdateCampaignOutboundCallConfigRequest updateCampaignOutboundCallConfigRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectCampaignsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the outbound call config of a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignOutboundCallConfigRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCampaignOutboundCallConfigRequest#builder()}
     * </p>
     *
     * @param updateCampaignOutboundCallConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCampaignOutboundCallConfigRequest.Builder} to
     *        create a request. UpdateCampaignOutboundCallConfigRequest
     * @return Result of the UpdateCampaignOutboundCallConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsClient.UpdateCampaignOutboundCallConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UpdateCampaignOutboundCallConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignOutboundCallConfigResponse updateCampaignOutboundCallConfig(
            Consumer<UpdateCampaignOutboundCallConfigRequest.Builder> updateCampaignOutboundCallConfigRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        return updateCampaignOutboundCallConfig(UpdateCampaignOutboundCallConfigRequest.builder()
                .applyMutation(updateCampaignOutboundCallConfigRequest).build());
    }

    /**
     * Create a {@link ConnectCampaignsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ConnectCampaignsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ConnectCampaignsClient}.
     */
    static ConnectCampaignsClientBuilder builder() {
        return new DefaultConnectCampaignsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
