/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaigns.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectcampaigns.model.EncryptionConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceConfig> {
    private static final SdkField<String> CONNECT_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectInstanceId").getter(InstanceConfig.getter(InstanceConfig::connectInstanceId)).setter(InstanceConfig.setter(Builder::connectInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectInstanceId").build()}).build();
    private static final SdkField<EncryptionConfig> ENCRYPTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfig").getter(InstanceConfig.getter(InstanceConfig::encryptionConfig)).setter(InstanceConfig.setter(Builder::encryptionConfig)).constructor(EncryptionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfig").build()}).build();
    private static final SdkField<String> SERVICE_LINKED_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceLinkedRoleArn").getter(InstanceConfig.getter(InstanceConfig::serviceLinkedRoleArn)).setter(InstanceConfig.setter(Builder::serviceLinkedRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceLinkedRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECT_INSTANCE_ID_FIELD, ENCRYPTION_CONFIG_FIELD, SERVICE_LINKED_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String connectInstanceId;
    private final EncryptionConfig encryptionConfig;
    private final String serviceLinkedRoleArn;

    private InstanceConfig(BuilderImpl builder) {
        this.connectInstanceId = builder.connectInstanceId;
        this.encryptionConfig = builder.encryptionConfig;
        this.serviceLinkedRoleArn = builder.serviceLinkedRoleArn;
    }

    public final String connectInstanceId() {
        return this.connectInstanceId;
    }

    public final EncryptionConfig encryptionConfig() {
        return this.encryptionConfig;
    }

    public final String serviceLinkedRoleArn() {
        return this.serviceLinkedRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceLinkedRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceConfig)) {
            return false;
        }
        InstanceConfig other = (InstanceConfig)obj;
        return Objects.equals(this.connectInstanceId(), other.connectInstanceId()) && Objects.equals(this.encryptionConfig(), other.encryptionConfig()) && Objects.equals(this.serviceLinkedRoleArn(), other.serviceLinkedRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceConfig").add("ConnectInstanceId", (Object)this.connectInstanceId()).add("EncryptionConfig", (Object)this.encryptionConfig()).add("ServiceLinkedRoleArn", (Object)this.serviceLinkedRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectInstanceId": {
                return Optional.ofNullable(clazz.cast(this.connectInstanceId()));
            }
            case "encryptionConfig": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfig()));
            }
            case "serviceLinkedRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceLinkedRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceConfig, T> g) {
        return obj -> g.apply((InstanceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectInstanceId;
        private EncryptionConfig encryptionConfig;
        private String serviceLinkedRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceConfig model) {
            this.connectInstanceId(model.connectInstanceId);
            this.encryptionConfig(model.encryptionConfig);
            this.serviceLinkedRoleArn(model.serviceLinkedRoleArn);
        }

        public final String getConnectInstanceId() {
            return this.connectInstanceId;
        }

        public final void setConnectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
        }

        @Override
        public final Builder connectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
            return this;
        }

        public final EncryptionConfig.Builder getEncryptionConfig() {
            return this.encryptionConfig != null ? this.encryptionConfig.toBuilder() : null;
        }

        public final void setEncryptionConfig(EncryptionConfig.BuilderImpl encryptionConfig) {
            this.encryptionConfig = encryptionConfig != null ? encryptionConfig.build() : null;
        }

        @Override
        public final Builder encryptionConfig(EncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        public final String getServiceLinkedRoleArn() {
            return this.serviceLinkedRoleArn;
        }

        public final void setServiceLinkedRoleArn(String serviceLinkedRoleArn) {
            this.serviceLinkedRoleArn = serviceLinkedRoleArn;
        }

        @Override
        public final Builder serviceLinkedRoleArn(String serviceLinkedRoleArn) {
            this.serviceLinkedRoleArn = serviceLinkedRoleArn;
            return this;
        }

        public InstanceConfig build() {
            return new InstanceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceConfig> {
        public Builder connectInstanceId(String var1);

        public Builder encryptionConfig(EncryptionConfig var1);

        default public Builder encryptionConfig(Consumer<EncryptionConfig.Builder> encryptionConfig) {
            return this.encryptionConfig((EncryptionConfig)((EncryptionConfig.Builder)EncryptionConfig.builder().applyMutation(encryptionConfig)).build());
        }

        public Builder serviceLinkedRoleArn(String var1);
    }
}

