/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaigns.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Instance onboarding job status object
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceOnboardingJobStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceOnboardingJobStatus.Builder, InstanceOnboardingJobStatus> {
    private static final SdkField<String> CONNECT_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectInstanceId").getter(getter(InstanceOnboardingJobStatus::connectInstanceId))
            .setter(setter(Builder::connectInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectInstanceId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(InstanceOnboardingJobStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(InstanceOnboardingJobStatus::failureCodeAsString))
            .setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECT_INSTANCE_ID_FIELD,
            STATUS_FIELD, FAILURE_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectInstanceId;

    private final String status;

    private final String failureCode;

    private InstanceOnboardingJobStatus(BuilderImpl builder) {
        this.connectInstanceId = builder.connectInstanceId;
        this.status = builder.status;
        this.failureCode = builder.failureCode;
    }

    /**
     * Returns the value of the ConnectInstanceId property for this object.
     * 
     * @return The value of the ConnectInstanceId property for this object.
     */
    public final String connectInstanceId() {
        return connectInstanceId;
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InstanceOnboardingJobStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see InstanceOnboardingJobStatusCode
     */
    public final InstanceOnboardingJobStatusCode status() {
        return InstanceOnboardingJobStatusCode.fromValue(status);
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InstanceOnboardingJobStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see InstanceOnboardingJobStatusCode
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the FailureCode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link InstanceOnboardingJobFailureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The value of the FailureCode property for this object.
     * @see InstanceOnboardingJobFailureCode
     */
    public final InstanceOnboardingJobFailureCode failureCode() {
        return InstanceOnboardingJobFailureCode.fromValue(failureCode);
    }

    /**
     * Returns the value of the FailureCode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link InstanceOnboardingJobFailureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The value of the FailureCode property for this object.
     * @see InstanceOnboardingJobFailureCode
     */
    public final String failureCodeAsString() {
        return failureCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceOnboardingJobStatus)) {
            return false;
        }
        InstanceOnboardingJobStatus other = (InstanceOnboardingJobStatus) obj;
        return Objects.equals(connectInstanceId(), other.connectInstanceId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureCodeAsString(), other.failureCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceOnboardingJobStatus").add("ConnectInstanceId", connectInstanceId())
                .add("Status", statusAsString()).add("FailureCode", failureCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectInstanceId":
            return Optional.ofNullable(clazz.cast(connectInstanceId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceOnboardingJobStatus, T> g) {
        return obj -> g.apply((InstanceOnboardingJobStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceOnboardingJobStatus> {
        /**
         * Sets the value of the ConnectInstanceId property for this object.
         *
         * @param connectInstanceId
         *        The new value for the ConnectInstanceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectInstanceId(String connectInstanceId);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see InstanceOnboardingJobStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceOnboardingJobStatusCode
         */
        Builder status(String status);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see InstanceOnboardingJobStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceOnboardingJobStatusCode
         */
        Builder status(InstanceOnboardingJobStatusCode status);

        /**
         * Sets the value of the FailureCode property for this object.
         *
         * @param failureCode
         *        The new value for the FailureCode property for this object.
         * @see InstanceOnboardingJobFailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceOnboardingJobFailureCode
         */
        Builder failureCode(String failureCode);

        /**
         * Sets the value of the FailureCode property for this object.
         *
         * @param failureCode
         *        The new value for the FailureCode property for this object.
         * @see InstanceOnboardingJobFailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceOnboardingJobFailureCode
         */
        Builder failureCode(InstanceOnboardingJobFailureCode failureCode);
    }

    static final class BuilderImpl implements Builder {
        private String connectInstanceId;

        private String status;

        private String failureCode;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceOnboardingJobStatus model) {
            connectInstanceId(model.connectInstanceId);
            status(model.status);
            failureCode(model.failureCode);
        }

        public final String getConnectInstanceId() {
            return connectInstanceId;
        }

        public final void setConnectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
        }

        @Override
        public final Builder connectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InstanceOnboardingJobStatusCode status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(InstanceOnboardingJobFailureCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        @Override
        public InstanceOnboardingJobStatus build() {
            return new InstanceOnboardingJobStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
