/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaigns;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.connectcampaigns.internal.ConnectCampaignsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.connectcampaigns.model.AccessDeniedException;
import software.amazon.awssdk.services.connectcampaigns.model.ConflictException;
import software.amazon.awssdk.services.connectcampaigns.model.ConnectCampaignsException;
import software.amazon.awssdk.services.connectcampaigns.model.CreateCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.CreateCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.DeleteConnectInstanceConfigRequest;
import software.amazon.awssdk.services.connectcampaigns.model.DeleteConnectInstanceConfigResponse;
import software.amazon.awssdk.services.connectcampaigns.model.DeleteInstanceOnboardingJobRequest;
import software.amazon.awssdk.services.connectcampaigns.model.DeleteInstanceOnboardingJobResponse;
import software.amazon.awssdk.services.connectcampaigns.model.DescribeCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.DescribeCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.GetCampaignStateBatchRequest;
import software.amazon.awssdk.services.connectcampaigns.model.GetCampaignStateBatchResponse;
import software.amazon.awssdk.services.connectcampaigns.model.GetCampaignStateRequest;
import software.amazon.awssdk.services.connectcampaigns.model.GetCampaignStateResponse;
import software.amazon.awssdk.services.connectcampaigns.model.GetConnectInstanceConfigRequest;
import software.amazon.awssdk.services.connectcampaigns.model.GetConnectInstanceConfigResponse;
import software.amazon.awssdk.services.connectcampaigns.model.GetInstanceOnboardingJobStatusRequest;
import software.amazon.awssdk.services.connectcampaigns.model.GetInstanceOnboardingJobStatusResponse;
import software.amazon.awssdk.services.connectcampaigns.model.InternalServerException;
import software.amazon.awssdk.services.connectcampaigns.model.InvalidCampaignStateException;
import software.amazon.awssdk.services.connectcampaigns.model.InvalidStateException;
import software.amazon.awssdk.services.connectcampaigns.model.ListCampaignsRequest;
import software.amazon.awssdk.services.connectcampaigns.model.ListCampaignsResponse;
import software.amazon.awssdk.services.connectcampaigns.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.connectcampaigns.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.connectcampaigns.model.PauseCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.PauseCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.PutDialRequestBatchRequest;
import software.amazon.awssdk.services.connectcampaigns.model.PutDialRequestBatchResponse;
import software.amazon.awssdk.services.connectcampaigns.model.ResourceNotFoundException;
import software.amazon.awssdk.services.connectcampaigns.model.ResumeCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.ResumeCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.connectcampaigns.model.StartCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.StartCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.StartInstanceOnboardingJobRequest;
import software.amazon.awssdk.services.connectcampaigns.model.StartInstanceOnboardingJobResponse;
import software.amazon.awssdk.services.connectcampaigns.model.StopCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.StopCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.TagResourceRequest;
import software.amazon.awssdk.services.connectcampaigns.model.TagResourceResponse;
import software.amazon.awssdk.services.connectcampaigns.model.ThrottlingException;
import software.amazon.awssdk.services.connectcampaigns.model.UntagResourceRequest;
import software.amazon.awssdk.services.connectcampaigns.model.UntagResourceResponse;
import software.amazon.awssdk.services.connectcampaigns.model.UpdateCampaignDialerConfigRequest;
import software.amazon.awssdk.services.connectcampaigns.model.UpdateCampaignDialerConfigResponse;
import software.amazon.awssdk.services.connectcampaigns.model.UpdateCampaignNameRequest;
import software.amazon.awssdk.services.connectcampaigns.model.UpdateCampaignNameResponse;
import software.amazon.awssdk.services.connectcampaigns.model.UpdateCampaignOutboundCallConfigRequest;
import software.amazon.awssdk.services.connectcampaigns.model.UpdateCampaignOutboundCallConfigResponse;
import software.amazon.awssdk.services.connectcampaigns.model.ValidationException;
import software.amazon.awssdk.services.connectcampaigns.transform.CreateCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.DeleteCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.DeleteConnectInstanceConfigRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.DeleteInstanceOnboardingJobRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.DescribeCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.GetCampaignStateBatchRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.GetCampaignStateRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.GetConnectInstanceConfigRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.GetInstanceOnboardingJobStatusRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.ListCampaignsRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.PauseCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.PutDialRequestBatchRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.ResumeCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.StartCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.StartInstanceOnboardingJobRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.StopCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.UpdateCampaignDialerConfigRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.UpdateCampaignNameRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.UpdateCampaignOutboundCallConfigRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ConnectCampaignsAsyncClient}.
 *
 * @see ConnectCampaignsAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultConnectCampaignsAsyncClient implements ConnectCampaignsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultConnectCampaignsAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultConnectCampaignsAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates a campaign for the specified Amazon Connect account. This API is idempotent.
     * </p>
     *
     * @param createCampaignRequest
     *        The request for Create Campaign API.
     * @return A Java Future containing the result of the CreateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/CreateCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCampaignResponse> createCampaign(CreateCampaignRequest createCampaignRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCampaignResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCampaignRequest, CreateCampaignResponse>()
                            .withOperationName("CreateCampaign").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCampaignRequest));
            CompletableFuture<CreateCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a campaign from the specified Amazon Connect account.
     * </p>
     *
     * @param deleteCampaignRequest
     *        DeleteCampaignRequest
     * @return A Java Future containing the result of the DeleteCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DeleteCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCampaignResponse> deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCampaignResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCampaignRequest, DeleteCampaignResponse>()
                            .withOperationName("DeleteCampaign").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCampaignRequest));
            CompletableFuture<DeleteCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a connect instance config from the specified AWS account.
     * </p>
     *
     * @param deleteConnectInstanceConfigRequest
     *        DeleteCampaignRequest
     * @return A Java Future containing the result of the DeleteConnectInstanceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidStateException The request could not be processed because of conflict in the current state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.DeleteConnectInstanceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DeleteConnectInstanceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConnectInstanceConfigResponse> deleteConnectInstanceConfig(
            DeleteConnectInstanceConfigRequest deleteConnectInstanceConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConnectInstanceConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConnectInstanceConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConnectInstanceConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConnectInstanceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConnectInstanceConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConnectInstanceConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConnectInstanceConfigRequest, DeleteConnectInstanceConfigResponse>()
                            .withOperationName("DeleteConnectInstanceConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConnectInstanceConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConnectInstanceConfigRequest));
            CompletableFuture<DeleteConnectInstanceConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteInstanceOnboardingJobRequest
     *        The request for DeleteInstanceOnboardingJob API.
     * @return A Java Future containing the result of the DeleteInstanceOnboardingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidStateException The request could not be processed because of conflict in the current state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.DeleteInstanceOnboardingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DeleteInstanceOnboardingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInstanceOnboardingJobResponse> deleteInstanceOnboardingJob(
            DeleteInstanceOnboardingJobRequest deleteInstanceOnboardingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInstanceOnboardingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInstanceOnboardingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInstanceOnboardingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInstanceOnboardingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteInstanceOnboardingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInstanceOnboardingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInstanceOnboardingJobRequest, DeleteInstanceOnboardingJobResponse>()
                            .withOperationName("DeleteInstanceOnboardingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteInstanceOnboardingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteInstanceOnboardingJobRequest));
            CompletableFuture<DeleteInstanceOnboardingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specific campaign.
     * </p>
     *
     * @param describeCampaignRequest
     *        DescribeCampaignRequests
     * @return A Java Future containing the result of the DescribeCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.DescribeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DescribeCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCampaignResponse> describeCampaign(DescribeCampaignRequest describeCampaignRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCampaignRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCampaignResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCampaignRequest, DescribeCampaignResponse>()
                            .withOperationName("DescribeCampaign").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCampaignRequest));
            CompletableFuture<DescribeCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get state of a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param getCampaignStateRequest
     *        GetCampaignStateRequest
     * @return A Java Future containing the result of the GetCampaignState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.GetCampaignState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetCampaignState"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCampaignStateResponse> getCampaignState(GetCampaignStateRequest getCampaignStateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCampaignStateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignStateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaignState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCampaignStateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCampaignStateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCampaignStateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCampaignStateRequest, GetCampaignStateResponse>()
                            .withOperationName("GetCampaignState").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCampaignStateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCampaignStateRequest));
            CompletableFuture<GetCampaignStateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get state of campaigns for the specified Amazon Connect account.
     * </p>
     *
     * @param getCampaignStateBatchRequest
     *        GetCampaignStateBatchRequest
     * @return A Java Future containing the result of the GetCampaignStateBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.GetCampaignStateBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetCampaignStateBatch"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCampaignStateBatchResponse> getCampaignStateBatch(
            GetCampaignStateBatchRequest getCampaignStateBatchRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCampaignStateBatchRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignStateBatchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaignStateBatch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCampaignStateBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCampaignStateBatchResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCampaignStateBatchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCampaignStateBatchRequest, GetCampaignStateBatchResponse>()
                            .withOperationName("GetCampaignStateBatch").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCampaignStateBatchRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCampaignStateBatchRequest));
            CompletableFuture<GetCampaignStateBatchResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the specific Connect instance config.
     * </p>
     *
     * @param getConnectInstanceConfigRequest
     *        GetConnectInstanceConfigRequest
     * @return A Java Future containing the result of the GetConnectInstanceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.GetConnectInstanceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetConnectInstanceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConnectInstanceConfigResponse> getConnectInstanceConfig(
            GetConnectInstanceConfigRequest getConnectInstanceConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getConnectInstanceConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getConnectInstanceConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConnectInstanceConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConnectInstanceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetConnectInstanceConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConnectInstanceConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConnectInstanceConfigRequest, GetConnectInstanceConfigResponse>()
                            .withOperationName("GetConnectInstanceConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetConnectInstanceConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getConnectInstanceConfigRequest));
            CompletableFuture<GetConnectInstanceConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the specific instance onboarding job status.
     * </p>
     *
     * @param getInstanceOnboardingJobStatusRequest
     *        GetInstanceOnboardingJobStatusRequest
     * @return A Java Future containing the result of the GetInstanceOnboardingJobStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.GetInstanceOnboardingJobStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetInstanceOnboardingJobStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceOnboardingJobStatusResponse> getInstanceOnboardingJobStatus(
            GetInstanceOnboardingJobStatusRequest getInstanceOnboardingJobStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getInstanceOnboardingJobStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getInstanceOnboardingJobStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInstanceOnboardingJobStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInstanceOnboardingJobStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInstanceOnboardingJobStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInstanceOnboardingJobStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstanceOnboardingJobStatusRequest, GetInstanceOnboardingJobStatusResponse>()
                            .withOperationName("GetInstanceOnboardingJobStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetInstanceOnboardingJobStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getInstanceOnboardingJobStatusRequest));
            CompletableFuture<GetInstanceOnboardingJobStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides summary information about the campaigns under the specified Amazon Connect account.
     * </p>
     *
     * @param listCampaignsRequest
     *        ListCampaignsRequest
     * @return A Java Future containing the result of the ListCampaigns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/ListCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCampaignsResponse> listCampaigns(ListCampaignsRequest listCampaignsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCampaignsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCampaignsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCampaigns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCampaignsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListCampaignsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCampaignsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCampaignsRequest, ListCampaignsResponse>()
                            .withOperationName("ListCampaigns").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCampaignsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCampaignsRequest));
            CompletableFuture<ListCampaignsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        ListTagsForResource
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Pauses a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param pauseCampaignRequest
     *        PauseCampaignRequest
     * @return A Java Future containing the result of the PauseCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.PauseCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/PauseCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PauseCampaignResponse> pauseCampaign(PauseCampaignRequest pauseCampaignRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(pauseCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, pauseCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PauseCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PauseCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PauseCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PauseCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PauseCampaignRequest, PauseCampaignResponse>()
                            .withOperationName("PauseCampaign").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PauseCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(pauseCampaignRequest));
            CompletableFuture<PauseCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates dials requests for the specified campaign Amazon Connect account. This API is idempotent.
     * </p>
     *
     * @param putDialRequestBatchRequest
     *        PutDialRequestBatchRequest
     * @return A Java Future containing the result of the PutDialRequestBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.PutDialRequestBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/PutDialRequestBatch"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutDialRequestBatchResponse> putDialRequestBatch(
            PutDialRequestBatchRequest putDialRequestBatchRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putDialRequestBatchRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putDialRequestBatchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDialRequestBatch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutDialRequestBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutDialRequestBatchResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutDialRequestBatchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutDialRequestBatchRequest, PutDialRequestBatchResponse>()
                            .withOperationName("PutDialRequestBatch").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutDialRequestBatchRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putDialRequestBatchRequest));
            CompletableFuture<PutDialRequestBatchResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param resumeCampaignRequest
     *        ResumeCampaignRequest
     * @return A Java Future containing the result of the ResumeCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.ResumeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/ResumeCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ResumeCampaignResponse> resumeCampaign(ResumeCampaignRequest resumeCampaignRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resumeCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resumeCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResumeCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResumeCampaignResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ResumeCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ResumeCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResumeCampaignRequest, ResumeCampaignResponse>()
                            .withOperationName("ResumeCampaign").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ResumeCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(resumeCampaignRequest));
            CompletableFuture<ResumeCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param startCampaignRequest
     *        StartCampaignRequest
     * @return A Java Future containing the result of the StartCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.StartCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/StartCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartCampaignResponse> startCampaign(StartCampaignRequest startCampaignRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StartCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartCampaignRequest, StartCampaignResponse>()
                            .withOperationName("StartCampaign").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startCampaignRequest));
            CompletableFuture<StartCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Onboard the specific Amazon Connect instance to Connect Campaigns.
     * </p>
     *
     * @param startInstanceOnboardingJobRequest
     *        The request for StartInstanceOnboardingJob API.
     * @return A Java Future containing the result of the StartInstanceOnboardingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.StartInstanceOnboardingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/StartInstanceOnboardingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartInstanceOnboardingJobResponse> startInstanceOnboardingJob(
            StartInstanceOnboardingJobRequest startInstanceOnboardingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startInstanceOnboardingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startInstanceOnboardingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartInstanceOnboardingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartInstanceOnboardingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartInstanceOnboardingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartInstanceOnboardingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartInstanceOnboardingJobRequest, StartInstanceOnboardingJobResponse>()
                            .withOperationName("StartInstanceOnboardingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartInstanceOnboardingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startInstanceOnboardingJobRequest));
            CompletableFuture<StartInstanceOnboardingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param stopCampaignRequest
     *        StopCampaignRequest
     * @return A Java Future containing the result of the StopCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.StopCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/StopCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StopCampaignResponse> stopCampaign(StopCampaignRequest stopCampaignRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StopCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopCampaignRequest, StopCampaignResponse>()
                            .withOperationName("StopCampaign").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopCampaignRequest));
            CompletableFuture<StopCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Tag a resource.
     * </p>
     *
     * @param tagResourceRequest
     *        TagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Untag a resource.
     * </p>
     *
     * @param untagResourceRequest
     *        UntagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the dialer config of a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignDialerConfigRequest
     *        UpdateCampaignDialerConfigRequest
     * @return A Java Future containing the result of the UpdateCampaignDialerConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.UpdateCampaignDialerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UpdateCampaignDialerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCampaignDialerConfigResponse> updateCampaignDialerConfig(
            UpdateCampaignDialerConfigRequest updateCampaignDialerConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCampaignDialerConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCampaignDialerConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCampaignDialerConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCampaignDialerConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCampaignDialerConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCampaignDialerConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCampaignDialerConfigRequest, UpdateCampaignDialerConfigResponse>()
                            .withOperationName("UpdateCampaignDialerConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCampaignDialerConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCampaignDialerConfigRequest));
            CompletableFuture<UpdateCampaignDialerConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the name of a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignNameRequest
     *        UpdateCampaignNameRequest
     * @return A Java Future containing the result of the UpdateCampaignName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.UpdateCampaignName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UpdateCampaignName"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCampaignNameResponse> updateCampaignName(UpdateCampaignNameRequest updateCampaignNameRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCampaignNameRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCampaignNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCampaignName");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCampaignNameResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCampaignNameResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCampaignNameResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCampaignNameRequest, UpdateCampaignNameResponse>()
                            .withOperationName("UpdateCampaignName").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCampaignNameRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCampaignNameRequest));
            CompletableFuture<UpdateCampaignNameResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the outbound call config of a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignOutboundCallConfigRequest
     *        UpdateCampaignOutboundCallConfigRequest
     * @return A Java Future containing the result of the UpdateCampaignOutboundCallConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsAsyncClient.UpdateCampaignOutboundCallConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UpdateCampaignOutboundCallConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCampaignOutboundCallConfigResponse> updateCampaignOutboundCallConfig(
            UpdateCampaignOutboundCallConfigRequest updateCampaignOutboundCallConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCampaignOutboundCallConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCampaignOutboundCallConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCampaignOutboundCallConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCampaignOutboundCallConfigResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateCampaignOutboundCallConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCampaignOutboundCallConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCampaignOutboundCallConfigRequest, UpdateCampaignOutboundCallConfigResponse>()
                            .withOperationName("UpdateCampaignOutboundCallConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCampaignOutboundCallConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCampaignOutboundCallConfigRequest));
            CompletableFuture<UpdateCampaignOutboundCallConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final ConnectCampaignsServiceClientConfiguration serviceClientConfiguration() {
        return new ConnectCampaignsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ConnectCampaignsException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCampaignStateException")
                                .exceptionBuilderSupplier(InvalidCampaignStateException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidStateException")
                                .exceptionBuilderSupplier(InvalidStateException::builder).httpStatusCode(409).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        ConnectCampaignsServiceClientConfigurationBuilder serviceConfigBuilder = new ConnectCampaignsServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
