/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaigns.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectcampaigns.model.InstanceOnboardingJobFailureCode;
import software.amazon.awssdk.services.connectcampaigns.model.InstanceOnboardingJobStatusCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceOnboardingJobStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceOnboardingJobStatus> {
    private static final SdkField<String> CONNECT_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectInstanceId").getter(InstanceOnboardingJobStatus.getter(InstanceOnboardingJobStatus::connectInstanceId)).setter(InstanceOnboardingJobStatus.setter(Builder::connectInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectInstanceId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(InstanceOnboardingJobStatus.getter(InstanceOnboardingJobStatus::statusAsString)).setter(InstanceOnboardingJobStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureCode").getter(InstanceOnboardingJobStatus.getter(InstanceOnboardingJobStatus::failureCodeAsString)).setter(InstanceOnboardingJobStatus.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECT_INSTANCE_ID_FIELD, STATUS_FIELD, FAILURE_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceOnboardingJobStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String connectInstanceId;
    private final String status;
    private final String failureCode;

    private InstanceOnboardingJobStatus(BuilderImpl builder) {
        this.connectInstanceId = builder.connectInstanceId;
        this.status = builder.status;
        this.failureCode = builder.failureCode;
    }

    public final String connectInstanceId() {
        return this.connectInstanceId;
    }

    public final InstanceOnboardingJobStatusCode status() {
        return InstanceOnboardingJobStatusCode.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final InstanceOnboardingJobFailureCode failureCode() {
        return InstanceOnboardingJobFailureCode.fromValue(this.failureCode);
    }

    public final String failureCodeAsString() {
        return this.failureCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceOnboardingJobStatus)) {
            return false;
        }
        InstanceOnboardingJobStatus other = (InstanceOnboardingJobStatus)obj;
        return Objects.equals(this.connectInstanceId(), other.connectInstanceId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureCodeAsString(), other.failureCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceOnboardingJobStatus").add("ConnectInstanceId", (Object)this.connectInstanceId()).add("Status", (Object)this.statusAsString()).add("FailureCode", (Object)this.failureCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectInstanceId": {
                return Optional.ofNullable(clazz.cast(this.connectInstanceId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("connectInstanceId", CONNECT_INSTANCE_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("failureCode", FAILURE_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceOnboardingJobStatus, T> g) {
        return obj -> g.apply((InstanceOnboardingJobStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectInstanceId;
        private String status;
        private String failureCode;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceOnboardingJobStatus model) {
            this.connectInstanceId(model.connectInstanceId);
            this.status(model.status);
            this.failureCode(model.failureCode);
        }

        public final String getConnectInstanceId() {
            return this.connectInstanceId;
        }

        public final void setConnectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
        }

        @Override
        public final Builder connectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InstanceOnboardingJobStatusCode status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(InstanceOnboardingJobFailureCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public InstanceOnboardingJobStatus build() {
            return new InstanceOnboardingJobStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceOnboardingJobStatus> {
        public Builder connectInstanceId(String var1);

        public Builder status(String var1);

        public Builder status(InstanceOnboardingJobStatusCode var1);

        public Builder failureCode(String var1);

        public Builder failureCode(InstanceOnboardingJobFailureCode var1);
    }
}

