/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaigns.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon Connect campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Campaign implements SdkPojo, Serializable, ToCopyableBuilder<Campaign.Builder, Campaign> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Campaign::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Campaign::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Campaign::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CONNECT_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectInstanceId").getter(getter(Campaign::connectInstanceId))
            .setter(setter(Builder::connectInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectInstanceId").build()).build();

    private static final SdkField<DialerConfig> DIALER_CONFIG_FIELD = SdkField.<DialerConfig> builder(MarshallingType.SDK_POJO)
            .memberName("dialerConfig").getter(getter(Campaign::dialerConfig)).setter(setter(Builder::dialerConfig))
            .constructor(DialerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialerConfig").build()).build();

    private static final SdkField<OutboundCallConfig> OUTBOUND_CALL_CONFIG_FIELD = SdkField
            .<OutboundCallConfig> builder(MarshallingType.SDK_POJO).memberName("outboundCallConfig")
            .getter(getter(Campaign::outboundCallConfig)).setter(setter(Builder::outboundCallConfig))
            .constructor(OutboundCallConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outboundCallConfig").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Campaign::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, CONNECT_INSTANCE_ID_FIELD, DIALER_CONFIG_FIELD, OUTBOUND_CALL_CONFIG_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String connectInstanceId;

    private final DialerConfig dialerConfig;

    private final OutboundCallConfig outboundCallConfig;

    private final Map<String, String> tags;

    private Campaign(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.connectInstanceId = builder.connectInstanceId;
        this.dialerConfig = builder.dialerConfig;
        this.outboundCallConfig = builder.outboundCallConfig;
        this.tags = builder.tags;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the Arn property for this object.
     * 
     * @return The value of the Arn property for this object.
     */
    public final String arn() {
        return arn;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the ConnectInstanceId property for this object.
     * 
     * @return The value of the ConnectInstanceId property for this object.
     */
    public final String connectInstanceId() {
        return connectInstanceId;
    }

    /**
     * Returns the value of the DialerConfig property for this object.
     * 
     * @return The value of the DialerConfig property for this object.
     */
    public final DialerConfig dialerConfig() {
        return dialerConfig;
    }

    /**
     * Returns the value of the OutboundCallConfig property for this object.
     * 
     * @return The value of the OutboundCallConfig property for this object.
     */
    public final OutboundCallConfig outboundCallConfig() {
        return outboundCallConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(connectInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(dialerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outboundCallConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Campaign)) {
            return false;
        }
        Campaign other = (Campaign) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(connectInstanceId(), other.connectInstanceId())
                && Objects.equals(dialerConfig(), other.dialerConfig())
                && Objects.equals(outboundCallConfig(), other.outboundCallConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Campaign").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("ConnectInstanceId", connectInstanceId()).add("DialerConfig", dialerConfig())
                .add("OutboundCallConfig", outboundCallConfig()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "connectInstanceId":
            return Optional.ofNullable(clazz.cast(connectInstanceId()));
        case "dialerConfig":
            return Optional.ofNullable(clazz.cast(dialerConfig()));
        case "outboundCallConfig":
            return Optional.ofNullable(clazz.cast(outboundCallConfig()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("connectInstanceId", CONNECT_INSTANCE_ID_FIELD);
        map.put("dialerConfig", DIALER_CONFIG_FIELD);
        map.put("outboundCallConfig", OUTBOUND_CALL_CONFIG_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Campaign, T> g) {
        return obj -> g.apply((Campaign) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Campaign> {
        /**
         * Sets the value of the Id property for this object.
         *
         * @param id
         *        The new value for the Id property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the Arn property for this object.
         *
         * @param arn
         *        The new value for the Arn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the ConnectInstanceId property for this object.
         *
         * @param connectInstanceId
         *        The new value for the ConnectInstanceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectInstanceId(String connectInstanceId);

        /**
         * Sets the value of the DialerConfig property for this object.
         *
         * @param dialerConfig
         *        The new value for the DialerConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialerConfig(DialerConfig dialerConfig);

        /**
         * Sets the value of the DialerConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DialerConfig.Builder} avoiding the need
         * to create one manually via {@link DialerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DialerConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #dialerConfig(DialerConfig)}.
         * 
         * @param dialerConfig
         *        a consumer that will call methods on {@link DialerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dialerConfig(DialerConfig)
         */
        default Builder dialerConfig(Consumer<DialerConfig.Builder> dialerConfig) {
            return dialerConfig(DialerConfig.builder().applyMutation(dialerConfig).build());
        }

        /**
         * Sets the value of the OutboundCallConfig property for this object.
         *
         * @param outboundCallConfig
         *        The new value for the OutboundCallConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundCallConfig(OutboundCallConfig outboundCallConfig);

        /**
         * Sets the value of the OutboundCallConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OutboundCallConfig.Builder} avoiding the
         * need to create one manually via {@link OutboundCallConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutboundCallConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outboundCallConfig(OutboundCallConfig)}.
         * 
         * @param outboundCallConfig
         *        a consumer that will call methods on {@link OutboundCallConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outboundCallConfig(OutboundCallConfig)
         */
        default Builder outboundCallConfig(Consumer<OutboundCallConfig.Builder> outboundCallConfig) {
            return outboundCallConfig(OutboundCallConfig.builder().applyMutation(outboundCallConfig).build());
        }

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String connectInstanceId;

        private DialerConfig dialerConfig;

        private OutboundCallConfig outboundCallConfig;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Campaign model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            connectInstanceId(model.connectInstanceId);
            dialerConfig(model.dialerConfig);
            outboundCallConfig(model.outboundCallConfig);
            tags(model.tags);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getConnectInstanceId() {
            return connectInstanceId;
        }

        public final void setConnectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
        }

        @Override
        public final Builder connectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
            return this;
        }

        public final DialerConfig.Builder getDialerConfig() {
            return dialerConfig != null ? dialerConfig.toBuilder() : null;
        }

        public final void setDialerConfig(DialerConfig.BuilderImpl dialerConfig) {
            this.dialerConfig = dialerConfig != null ? dialerConfig.build() : null;
        }

        @Override
        public final Builder dialerConfig(DialerConfig dialerConfig) {
            this.dialerConfig = dialerConfig;
            return this;
        }

        public final OutboundCallConfig.Builder getOutboundCallConfig() {
            return outboundCallConfig != null ? outboundCallConfig.toBuilder() : null;
        }

        public final void setOutboundCallConfig(OutboundCallConfig.BuilderImpl outboundCallConfig) {
            this.outboundCallConfig = outboundCallConfig != null ? outboundCallConfig.build() : null;
        }

        @Override
        public final Builder outboundCallConfig(OutboundCallConfig outboundCallConfig) {
            this.outboundCallConfig = outboundCallConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Campaign build() {
            return new Campaign(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
