/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaigns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * PutDialRequestBatchResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDialRequestBatchResponse extends ConnectCampaignsResponse implements
        ToCopyableBuilder<PutDialRequestBatchResponse.Builder, PutDialRequestBatchResponse> {
    private static final SdkField<List<SuccessfulRequest>> SUCCESSFUL_REQUESTS_FIELD = SdkField
            .<List<SuccessfulRequest>> builder(MarshallingType.LIST)
            .memberName("successfulRequests")
            .getter(getter(PutDialRequestBatchResponse::successfulRequests))
            .setter(setter(Builder::successfulRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successfulRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SuccessfulRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(SuccessfulRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FailedRequest>> FAILED_REQUESTS_FIELD = SdkField
            .<List<FailedRequest>> builder(MarshallingType.LIST)
            .memberName("failedRequests")
            .getter(getter(PutDialRequestBatchResponse::failedRequests))
            .setter(setter(Builder::failedRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_REQUESTS_FIELD,
            FAILED_REQUESTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SuccessfulRequest> successfulRequests;

    private final List<FailedRequest> failedRequests;

    private PutDialRequestBatchResponse(BuilderImpl builder) {
        super(builder);
        this.successfulRequests = builder.successfulRequests;
        this.failedRequests = builder.failedRequests;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuccessfulRequests property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuccessfulRequests() {
        return successfulRequests != null && !(successfulRequests instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the SuccessfulRequests property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessfulRequests} method.
     * </p>
     * 
     * @return The value of the SuccessfulRequests property for this object.
     */
    public final List<SuccessfulRequest> successfulRequests() {
        return successfulRequests;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedRequests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedRequests() {
        return failedRequests != null && !(failedRequests instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the FailedRequests property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedRequests} method.
     * </p>
     * 
     * @return The value of the FailedRequests property for this object.
     */
    public final List<FailedRequest> failedRequests() {
        return failedRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessfulRequests() ? successfulRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedRequests() ? failedRequests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDialRequestBatchResponse)) {
            return false;
        }
        PutDialRequestBatchResponse other = (PutDialRequestBatchResponse) obj;
        return hasSuccessfulRequests() == other.hasSuccessfulRequests()
                && Objects.equals(successfulRequests(), other.successfulRequests())
                && hasFailedRequests() == other.hasFailedRequests() && Objects.equals(failedRequests(), other.failedRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDialRequestBatchResponse")
                .add("SuccessfulRequests", hasSuccessfulRequests() ? successfulRequests() : null)
                .add("FailedRequests", hasFailedRequests() ? failedRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "successfulRequests":
            return Optional.ofNullable(clazz.cast(successfulRequests()));
        case "failedRequests":
            return Optional.ofNullable(clazz.cast(failedRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("successfulRequests", SUCCESSFUL_REQUESTS_FIELD);
        map.put("failedRequests", FAILED_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutDialRequestBatchResponse, T> g) {
        return obj -> g.apply((PutDialRequestBatchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectCampaignsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutDialRequestBatchResponse> {
        /**
         * Sets the value of the SuccessfulRequests property for this object.
         *
         * @param successfulRequests
         *        The new value for the SuccessfulRequests property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulRequests(Collection<SuccessfulRequest> successfulRequests);

        /**
         * Sets the value of the SuccessfulRequests property for this object.
         *
         * @param successfulRequests
         *        The new value for the SuccessfulRequests property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulRequests(SuccessfulRequest... successfulRequests);

        /**
         * Sets the value of the SuccessfulRequests property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcampaigns.model.SuccessfulRequest.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connectcampaigns.model.SuccessfulRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcampaigns.model.SuccessfulRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #successfulRequests(List<SuccessfulRequest>)}.
         * 
         * @param successfulRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcampaigns.model.SuccessfulRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successfulRequests(java.util.Collection<SuccessfulRequest>)
         */
        Builder successfulRequests(Consumer<SuccessfulRequest.Builder>... successfulRequests);

        /**
         * Sets the value of the FailedRequests property for this object.
         *
         * @param failedRequests
         *        The new value for the FailedRequests property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRequests(Collection<FailedRequest> failedRequests);

        /**
         * Sets the value of the FailedRequests property for this object.
         *
         * @param failedRequests
         *        The new value for the FailedRequests property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRequests(FailedRequest... failedRequests);

        /**
         * Sets the value of the FailedRequests property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcampaigns.model.FailedRequest.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connectcampaigns.model.FailedRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcampaigns.model.FailedRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #failedRequests(List<FailedRequest>)}.
         * 
         * @param failedRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcampaigns.model.FailedRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedRequests(java.util.Collection<FailedRequest>)
         */
        Builder failedRequests(Consumer<FailedRequest.Builder>... failedRequests);
    }

    static final class BuilderImpl extends ConnectCampaignsResponse.BuilderImpl implements Builder {
        private List<SuccessfulRequest> successfulRequests = DefaultSdkAutoConstructList.getInstance();

        private List<FailedRequest> failedRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutDialRequestBatchResponse model) {
            super(model);
            successfulRequests(model.successfulRequests);
            failedRequests(model.failedRequests);
        }

        public final List<SuccessfulRequest.Builder> getSuccessfulRequests() {
            List<SuccessfulRequest.Builder> result = SuccessfulRequestListCopier.copyToBuilder(this.successfulRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulRequests(Collection<SuccessfulRequest.BuilderImpl> successfulRequests) {
            this.successfulRequests = SuccessfulRequestListCopier.copyFromBuilder(successfulRequests);
        }

        @Override
        public final Builder successfulRequests(Collection<SuccessfulRequest> successfulRequests) {
            this.successfulRequests = SuccessfulRequestListCopier.copy(successfulRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulRequests(SuccessfulRequest... successfulRequests) {
            successfulRequests(Arrays.asList(successfulRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulRequests(Consumer<SuccessfulRequest.Builder>... successfulRequests) {
            successfulRequests(Stream.of(successfulRequests).map(c -> SuccessfulRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FailedRequest.Builder> getFailedRequests() {
            List<FailedRequest.Builder> result = FailedRequestListCopier.copyToBuilder(this.failedRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedRequests(Collection<FailedRequest.BuilderImpl> failedRequests) {
            this.failedRequests = FailedRequestListCopier.copyFromBuilder(failedRequests);
        }

        @Override
        public final Builder failedRequests(Collection<FailedRequest> failedRequests) {
            this.failedRequests = FailedRequestListCopier.copy(failedRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequests(FailedRequest... failedRequests) {
            failedRequests(Arrays.asList(failedRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequests(Consumer<FailedRequest.Builder>... failedRequests) {
            failedRequests(Stream.of(failedRequests).map(c -> FailedRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutDialRequestBatchResponse build() {
            return new PutDialRequestBatchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
