/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcampaignsv2.model.AttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SmsChannelSubtypeParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SmsChannelSubtypeParameters> {
    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationPhoneNumber").getter(SmsChannelSubtypeParameters.getter(SmsChannelSubtypeParameters::destinationPhoneNumber)).setter(SmsChannelSubtypeParameters.setter(Builder::destinationPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPhoneNumber").build()}).build();
    private static final SdkField<String> CONNECT_SOURCE_PHONE_NUMBER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectSourcePhoneNumberArn").getter(SmsChannelSubtypeParameters.getter(SmsChannelSubtypeParameters::connectSourcePhoneNumberArn)).setter(SmsChannelSubtypeParameters.setter(Builder::connectSourcePhoneNumberArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectSourcePhoneNumberArn").build()}).build();
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateArn").getter(SmsChannelSubtypeParameters.getter(SmsChannelSubtypeParameters::templateArn)).setter(SmsChannelSubtypeParameters.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateArn").build()}).build();
    private static final SdkField<Map<String, String>> TEMPLATE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("templateParameters").getter(SmsChannelSubtypeParameters.getter(SmsChannelSubtypeParameters::templateParameters)).setter(SmsChannelSubtypeParameters.setter(Builder::templateParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_PHONE_NUMBER_FIELD, CONNECT_SOURCE_PHONE_NUMBER_ARN_FIELD, TEMPLATE_ARN_FIELD, TEMPLATE_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SmsChannelSubtypeParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String destinationPhoneNumber;
    private final String connectSourcePhoneNumberArn;
    private final String templateArn;
    private final Map<String, String> templateParameters;

    private SmsChannelSubtypeParameters(BuilderImpl builder) {
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.connectSourcePhoneNumberArn = builder.connectSourcePhoneNumberArn;
        this.templateArn = builder.templateArn;
        this.templateParameters = builder.templateParameters;
    }

    public final String destinationPhoneNumber() {
        return this.destinationPhoneNumber;
    }

    public final String connectSourcePhoneNumberArn() {
        return this.connectSourcePhoneNumberArn;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    public final boolean hasTemplateParameters() {
        return this.templateParameters != null && !(this.templateParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> templateParameters() {
        return this.templateParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectSourcePhoneNumberArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplateParameters() ? this.templateParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SmsChannelSubtypeParameters)) {
            return false;
        }
        SmsChannelSubtypeParameters other = (SmsChannelSubtypeParameters)obj;
        return Objects.equals(this.destinationPhoneNumber(), other.destinationPhoneNumber()) && Objects.equals(this.connectSourcePhoneNumberArn(), other.connectSourcePhoneNumberArn()) && Objects.equals(this.templateArn(), other.templateArn()) && this.hasTemplateParameters() == other.hasTemplateParameters() && Objects.equals(this.templateParameters(), other.templateParameters());
    }

    public final String toString() {
        return ToString.builder((String)"SmsChannelSubtypeParameters").add("DestinationPhoneNumber", (Object)(this.destinationPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("ConnectSourcePhoneNumberArn", (Object)this.connectSourcePhoneNumberArn()).add("TemplateArn", (Object)this.templateArn()).add("TemplateParameters", (Object)(this.templateParameters() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinationPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.destinationPhoneNumber()));
            }
            case "connectSourcePhoneNumberArn": {
                return Optional.ofNullable(clazz.cast(this.connectSourcePhoneNumberArn()));
            }
            case "templateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
            case "templateParameters": {
                return Optional.ofNullable(clazz.cast(this.templateParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destinationPhoneNumber", DESTINATION_PHONE_NUMBER_FIELD);
        map.put("connectSourcePhoneNumberArn", CONNECT_SOURCE_PHONE_NUMBER_ARN_FIELD);
        map.put("templateArn", TEMPLATE_ARN_FIELD);
        map.put("templateParameters", TEMPLATE_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SmsChannelSubtypeParameters, T> g) {
        return obj -> g.apply((SmsChannelSubtypeParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationPhoneNumber;
        private String connectSourcePhoneNumberArn;
        private String templateArn;
        private Map<String, String> templateParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SmsChannelSubtypeParameters model) {
            this.destinationPhoneNumber(model.destinationPhoneNumber);
            this.connectSourcePhoneNumberArn(model.connectSourcePhoneNumberArn);
            this.templateArn(model.templateArn);
            this.templateParameters(model.templateParameters);
        }

        public final String getDestinationPhoneNumber() {
            return this.destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final String getConnectSourcePhoneNumberArn() {
            return this.connectSourcePhoneNumberArn;
        }

        public final void setConnectSourcePhoneNumberArn(String connectSourcePhoneNumberArn) {
            this.connectSourcePhoneNumberArn = connectSourcePhoneNumberArn;
        }

        @Override
        public final Builder connectSourcePhoneNumberArn(String connectSourcePhoneNumberArn) {
            this.connectSourcePhoneNumberArn = connectSourcePhoneNumberArn;
            return this;
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final Map<String, String> getTemplateParameters() {
            if (this.templateParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.templateParameters;
        }

        public final void setTemplateParameters(Map<String, String> templateParameters) {
            this.templateParameters = AttributesCopier.copy(templateParameters);
        }

        @Override
        public final Builder templateParameters(Map<String, String> templateParameters) {
            this.templateParameters = AttributesCopier.copy(templateParameters);
            return this;
        }

        public SmsChannelSubtypeParameters build() {
            return new SmsChannelSubtypeParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SmsChannelSubtypeParameters> {
        public Builder destinationPhoneNumber(String var1);

        public Builder connectSourcePhoneNumberArn(String var1);

        public Builder templateArn(String var1);

        public Builder templateParameters(Map<String, String> var1);
    }
}

