/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.connectcampaignsv2.model.CreateCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.CreateCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignChannelSubtypeConfigRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignChannelSubtypeConfigResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignCommunicationLimitsRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignCommunicationLimitsResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignCommunicationTimeRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignCommunicationTimeResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteConnectInstanceConfigRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteConnectInstanceConfigResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteConnectInstanceIntegrationRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteConnectInstanceIntegrationResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteInstanceOnboardingJobRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteInstanceOnboardingJobResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DescribeCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DescribeCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetCampaignStateBatchRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetCampaignStateBatchResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetCampaignStateRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetCampaignStateResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetConnectInstanceConfigRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetConnectInstanceConfigResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetInstanceOnboardingJobStatusRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetInstanceOnboardingJobStatusResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.PauseCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.PauseCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.PutConnectInstanceIntegrationRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.PutConnectInstanceIntegrationResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.PutOutboundRequestBatchRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.PutOutboundRequestBatchResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.PutProfileOutboundRequestBatchRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.PutProfileOutboundRequestBatchResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.ResumeCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.ResumeCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.StartCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.StartCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.StartInstanceOnboardingJobRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.StartInstanceOnboardingJobResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.StopCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.StopCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.TagResourceRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.TagResourceResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignChannelSubtypeConfigRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignChannelSubtypeConfigResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignCommunicationLimitsRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignCommunicationLimitsResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignCommunicationTimeRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignCommunicationTimeResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignFlowAssociationRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignFlowAssociationResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignNameRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignNameResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignScheduleRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignScheduleResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignSourceRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignSourceResponse;
import software.amazon.awssdk.services.connectcampaignsv2.paginators.ListCampaignsPublisher;
import software.amazon.awssdk.services.connectcampaignsv2.paginators.ListConnectInstanceIntegrationsPublisher;

/**
 * Service client for accessing AmazonConnectCampaignServiceV2 asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Provide APIs to create and manage Amazon Connect Campaigns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ConnectCampaignsV2AsyncClient extends AwsClient {
    String SERVICE_NAME = "connect-campaigns";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "connect-campaigns";

    /**
     * <p>
     * Creates a campaign for the specified Amazon Connect account. This API is idempotent.
     * </p>
     *
     * @param createCampaignRequest
     *        The request for CreateCampaign API.
     * @return A Java Future containing the result of the CreateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/CreateCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCampaignResponse> createCampaign(CreateCampaignRequest createCampaignRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a campaign for the specified Amazon Connect account. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCampaignRequest#builder()}
     * </p>
     *
     * @param createCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.CreateCampaignRequest.Builder} to create a
     *        request. The request for CreateCampaign API.
     * @return A Java Future containing the result of the CreateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/CreateCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCampaignResponse> createCampaign(Consumer<CreateCampaignRequest.Builder> createCampaignRequest) {
        return createCampaign(CreateCampaignRequest.builder().applyMutation(createCampaignRequest).build());
    }

    /**
     * <p>
     * Deletes a campaign from the specified Amazon Connect account.
     * </p>
     *
     * @param deleteCampaignRequest
     *        The request for DeleteCampaign API.
     * @return A Java Future containing the result of the DeleteCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCampaignResponse> deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a campaign from the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteCampaignRequest#builder()}
     * </p>
     *
     * @param deleteCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignRequest.Builder} to create a
     *        request. The request for DeleteCampaign API.
     * @return A Java Future containing the result of the DeleteCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCampaignResponse> deleteCampaign(Consumer<DeleteCampaignRequest.Builder> deleteCampaignRequest) {
        return deleteCampaign(DeleteCampaignRequest.builder().applyMutation(deleteCampaignRequest).build());
    }

    /**
     * <p>
     * Deletes the channel subtype config of a campaign. This API is idempotent.
     * </p>
     *
     * @param deleteCampaignChannelSubtypeConfigRequest
     *        The request for DeleteCampaignChannelSubtypeConfig API.
     * @return A Java Future containing the result of the DeleteCampaignChannelSubtypeConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.DeleteCampaignChannelSubtypeConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaignChannelSubtypeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCampaignChannelSubtypeConfigResponse> deleteCampaignChannelSubtypeConfig(
            DeleteCampaignChannelSubtypeConfigRequest deleteCampaignChannelSubtypeConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the channel subtype config of a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCampaignChannelSubtypeConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCampaignChannelSubtypeConfigRequest#builder()}
     * </p>
     *
     * @param deleteCampaignChannelSubtypeConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignChannelSubtypeConfigRequest.Builder}
     *        to create a request. The request for DeleteCampaignChannelSubtypeConfig API.
     * @return A Java Future containing the result of the DeleteCampaignChannelSubtypeConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.DeleteCampaignChannelSubtypeConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaignChannelSubtypeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCampaignChannelSubtypeConfigResponse> deleteCampaignChannelSubtypeConfig(
            Consumer<DeleteCampaignChannelSubtypeConfigRequest.Builder> deleteCampaignChannelSubtypeConfigRequest) {
        return deleteCampaignChannelSubtypeConfig(DeleteCampaignChannelSubtypeConfigRequest.builder()
                .applyMutation(deleteCampaignChannelSubtypeConfigRequest).build());
    }

    /**
     * <p>
     * Deletes the communication limits config for a campaign. This API is idempotent.
     * </p>
     *
     * @param deleteCampaignCommunicationLimitsRequest
     *        The request for DeleteCampaignCommunicationLimits API.
     * @return A Java Future containing the result of the DeleteCampaignCommunicationLimits operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.DeleteCampaignCommunicationLimits
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaignCommunicationLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCampaignCommunicationLimitsResponse> deleteCampaignCommunicationLimits(
            DeleteCampaignCommunicationLimitsRequest deleteCampaignCommunicationLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the communication limits config for a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCampaignCommunicationLimitsRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCampaignCommunicationLimitsRequest#builder()}
     * </p>
     *
     * @param deleteCampaignCommunicationLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignCommunicationLimitsRequest.Builder}
     *        to create a request. The request for DeleteCampaignCommunicationLimits API.
     * @return A Java Future containing the result of the DeleteCampaignCommunicationLimits operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.DeleteCampaignCommunicationLimits
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaignCommunicationLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCampaignCommunicationLimitsResponse> deleteCampaignCommunicationLimits(
            Consumer<DeleteCampaignCommunicationLimitsRequest.Builder> deleteCampaignCommunicationLimitsRequest) {
        return deleteCampaignCommunicationLimits(DeleteCampaignCommunicationLimitsRequest.builder()
                .applyMutation(deleteCampaignCommunicationLimitsRequest).build());
    }

    /**
     * <p>
     * Deletes the communication time config for a campaign. This API is idempotent.
     * </p>
     *
     * @param deleteCampaignCommunicationTimeRequest
     *        The request for DeleteCampaignCommunicationTime API.
     * @return A Java Future containing the result of the DeleteCampaignCommunicationTime operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.DeleteCampaignCommunicationTime
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaignCommunicationTime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCampaignCommunicationTimeResponse> deleteCampaignCommunicationTime(
            DeleteCampaignCommunicationTimeRequest deleteCampaignCommunicationTimeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the communication time config for a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCampaignCommunicationTimeRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCampaignCommunicationTimeRequest#builder()}
     * </p>
     *
     * @param deleteCampaignCommunicationTimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignCommunicationTimeRequest.Builder}
     *        to create a request. The request for DeleteCampaignCommunicationTime API.
     * @return A Java Future containing the result of the DeleteCampaignCommunicationTime operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.DeleteCampaignCommunicationTime
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaignCommunicationTime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCampaignCommunicationTimeResponse> deleteCampaignCommunicationTime(
            Consumer<DeleteCampaignCommunicationTimeRequest.Builder> deleteCampaignCommunicationTimeRequest) {
        return deleteCampaignCommunicationTime(DeleteCampaignCommunicationTimeRequest.builder()
                .applyMutation(deleteCampaignCommunicationTimeRequest).build());
    }

    /**
     * <p>
     * Deletes a connect instance config from the specified AWS account.
     * </p>
     *
     * @param deleteConnectInstanceConfigRequest
     *        The request for DeleteConnectInstanceConfig API.
     * @return A Java Future containing the result of the DeleteConnectInstanceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidStateException The request could not be processed because of conflict in the current state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.DeleteConnectInstanceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteConnectInstanceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectInstanceConfigResponse> deleteConnectInstanceConfig(
            DeleteConnectInstanceConfigRequest deleteConnectInstanceConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a connect instance config from the specified AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectInstanceConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConnectInstanceConfigRequest#builder()}
     * </p>
     *
     * @param deleteConnectInstanceConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.DeleteConnectInstanceConfigRequest.Builder}
     *        to create a request. The request for DeleteConnectInstanceConfig API.
     * @return A Java Future containing the result of the DeleteConnectInstanceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidStateException The request could not be processed because of conflict in the current state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.DeleteConnectInstanceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteConnectInstanceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectInstanceConfigResponse> deleteConnectInstanceConfig(
            Consumer<DeleteConnectInstanceConfigRequest.Builder> deleteConnectInstanceConfigRequest) {
        return deleteConnectInstanceConfig(DeleteConnectInstanceConfigRequest.builder()
                .applyMutation(deleteConnectInstanceConfigRequest).build());
    }

    /**
     * <p>
     * Delete the integration for the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteConnectInstanceIntegrationRequest
     *        The request for DeleteConnectInstanceIntegration API.
     * @return A Java Future containing the result of the DeleteConnectInstanceIntegration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.DeleteConnectInstanceIntegration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteConnectInstanceIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectInstanceIntegrationResponse> deleteConnectInstanceIntegration(
            DeleteConnectInstanceIntegrationRequest deleteConnectInstanceIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the integration for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectInstanceIntegrationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConnectInstanceIntegrationRequest#builder()}
     * </p>
     *
     * @param deleteConnectInstanceIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.DeleteConnectInstanceIntegrationRequest.Builder}
     *        to create a request. The request for DeleteConnectInstanceIntegration API.
     * @return A Java Future containing the result of the DeleteConnectInstanceIntegration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.DeleteConnectInstanceIntegration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteConnectInstanceIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectInstanceIntegrationResponse> deleteConnectInstanceIntegration(
            Consumer<DeleteConnectInstanceIntegrationRequest.Builder> deleteConnectInstanceIntegrationRequest) {
        return deleteConnectInstanceIntegration(DeleteConnectInstanceIntegrationRequest.builder()
                .applyMutation(deleteConnectInstanceIntegrationRequest).build());
    }

    /**
     * <p>
     * Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteInstanceOnboardingJobRequest
     *        The request for DeleteInstanceOnboardingJob API.
     * @return A Java Future containing the result of the DeleteInstanceOnboardingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidStateException The request could not be processed because of conflict in the current state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.DeleteInstanceOnboardingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteInstanceOnboardingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInstanceOnboardingJobResponse> deleteInstanceOnboardingJob(
            DeleteInstanceOnboardingJobRequest deleteInstanceOnboardingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceOnboardingJobRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteInstanceOnboardingJobRequest#builder()}
     * </p>
     *
     * @param deleteInstanceOnboardingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.DeleteInstanceOnboardingJobRequest.Builder}
     *        to create a request. The request for DeleteInstanceOnboardingJob API.
     * @return A Java Future containing the result of the DeleteInstanceOnboardingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidStateException The request could not be processed because of conflict in the current state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.DeleteInstanceOnboardingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteInstanceOnboardingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInstanceOnboardingJobResponse> deleteInstanceOnboardingJob(
            Consumer<DeleteInstanceOnboardingJobRequest.Builder> deleteInstanceOnboardingJobRequest) {
        return deleteInstanceOnboardingJob(DeleteInstanceOnboardingJobRequest.builder()
                .applyMutation(deleteInstanceOnboardingJobRequest).build());
    }

    /**
     * <p>
     * Describes the specific campaign.
     * </p>
     *
     * @param describeCampaignRequest
     *        The request for DescribeCampaign API.
     * @return A Java Future containing the result of the DescribeCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.DescribeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DescribeCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCampaignResponse> describeCampaign(DescribeCampaignRequest describeCampaignRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specific campaign.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCampaignRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeCampaignRequest#builder()}
     * </p>
     *
     * @param describeCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.DescribeCampaignRequest.Builder} to create
     *        a request. The request for DescribeCampaign API.
     * @return A Java Future containing the result of the DescribeCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.DescribeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DescribeCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCampaignResponse> describeCampaign(
            Consumer<DescribeCampaignRequest.Builder> describeCampaignRequest) {
        return describeCampaign(DescribeCampaignRequest.builder().applyMutation(describeCampaignRequest).build());
    }

    /**
     * <p>
     * Get state of a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param getCampaignStateRequest
     *        The request for GetCampaignState API.
     * @return A Java Future containing the result of the GetCampaignState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.GetCampaignState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetCampaignState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCampaignStateResponse> getCampaignState(GetCampaignStateRequest getCampaignStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get state of a campaign for the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignStateRequest.Builder} avoiding the need
     * to create one manually via {@link GetCampaignStateRequest#builder()}
     * </p>
     *
     * @param getCampaignStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.GetCampaignStateRequest.Builder} to create
     *        a request. The request for GetCampaignState API.
     * @return A Java Future containing the result of the GetCampaignState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.GetCampaignState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetCampaignState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCampaignStateResponse> getCampaignState(
            Consumer<GetCampaignStateRequest.Builder> getCampaignStateRequest) {
        return getCampaignState(GetCampaignStateRequest.builder().applyMutation(getCampaignStateRequest).build());
    }

    /**
     * <p>
     * Get state of campaigns for the specified Amazon Connect account.
     * </p>
     *
     * @param getCampaignStateBatchRequest
     *        The request for GetCampaignStateBatch API.
     * @return A Java Future containing the result of the GetCampaignStateBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.GetCampaignStateBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetCampaignStateBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCampaignStateBatchResponse> getCampaignStateBatch(
            GetCampaignStateBatchRequest getCampaignStateBatchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get state of campaigns for the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignStateBatchRequest.Builder} avoiding the
     * need to create one manually via {@link GetCampaignStateBatchRequest#builder()}
     * </p>
     *
     * @param getCampaignStateBatchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.GetCampaignStateBatchRequest.Builder} to
     *        create a request. The request for GetCampaignStateBatch API.
     * @return A Java Future containing the result of the GetCampaignStateBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.GetCampaignStateBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetCampaignStateBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCampaignStateBatchResponse> getCampaignStateBatch(
            Consumer<GetCampaignStateBatchRequest.Builder> getCampaignStateBatchRequest) {
        return getCampaignStateBatch(GetCampaignStateBatchRequest.builder().applyMutation(getCampaignStateBatchRequest).build());
    }

    /**
     * <p>
     * Get the specific Connect instance config.
     * </p>
     *
     * @param getConnectInstanceConfigRequest
     *        The request for GetConnectInstanceConfig API.
     * @return A Java Future containing the result of the GetConnectInstanceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.GetConnectInstanceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetConnectInstanceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectInstanceConfigResponse> getConnectInstanceConfig(
            GetConnectInstanceConfigRequest getConnectInstanceConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the specific Connect instance config.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectInstanceConfigRequest.Builder} avoiding
     * the need to create one manually via {@link GetConnectInstanceConfigRequest#builder()}
     * </p>
     *
     * @param getConnectInstanceConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.GetConnectInstanceConfigRequest.Builder}
     *        to create a request. The request for GetConnectInstanceConfig API.
     * @return A Java Future containing the result of the GetConnectInstanceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.GetConnectInstanceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetConnectInstanceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectInstanceConfigResponse> getConnectInstanceConfig(
            Consumer<GetConnectInstanceConfigRequest.Builder> getConnectInstanceConfigRequest) {
        return getConnectInstanceConfig(GetConnectInstanceConfigRequest.builder().applyMutation(getConnectInstanceConfigRequest)
                .build());
    }

    /**
     * <p>
     * Get the specific instance onboarding job status.
     * </p>
     *
     * @param getInstanceOnboardingJobStatusRequest
     *        The request for GetInstanceOnboardingJobStatus API.
     * @return A Java Future containing the result of the GetInstanceOnboardingJobStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.GetInstanceOnboardingJobStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetInstanceOnboardingJobStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInstanceOnboardingJobStatusResponse> getInstanceOnboardingJobStatus(
            GetInstanceOnboardingJobStatusRequest getInstanceOnboardingJobStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the specific instance onboarding job status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceOnboardingJobStatusRequest.Builder}
     * avoiding the need to create one manually via {@link GetInstanceOnboardingJobStatusRequest#builder()}
     * </p>
     *
     * @param getInstanceOnboardingJobStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.GetInstanceOnboardingJobStatusRequest.Builder}
     *        to create a request. The request for GetInstanceOnboardingJobStatus API.
     * @return A Java Future containing the result of the GetInstanceOnboardingJobStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.GetInstanceOnboardingJobStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetInstanceOnboardingJobStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInstanceOnboardingJobStatusResponse> getInstanceOnboardingJobStatus(
            Consumer<GetInstanceOnboardingJobStatusRequest.Builder> getInstanceOnboardingJobStatusRequest) {
        return getInstanceOnboardingJobStatus(GetInstanceOnboardingJobStatusRequest.builder()
                .applyMutation(getInstanceOnboardingJobStatusRequest).build());
    }

    /**
     * <p>
     * Provides summary information about the campaigns under the specified Amazon Connect account.
     * </p>
     *
     * @param listCampaignsRequest
     *        The request for ListCampaigns API.
     * @return A Java Future containing the result of the ListCampaigns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCampaignsResponse> listCampaigns(ListCampaignsRequest listCampaignsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summary information about the campaigns under the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCampaignsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCampaignsRequest#builder()}
     * </p>
     *
     * @param listCampaignsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsRequest.Builder} to create a
     *        request. The request for ListCampaigns API.
     * @return A Java Future containing the result of the ListCampaigns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCampaignsResponse> listCampaigns(Consumer<ListCampaignsRequest.Builder> listCampaignsRequest) {
        return listCampaigns(ListCampaignsRequest.builder().applyMutation(listCampaignsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCampaigns(software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaignsv2.paginators.ListCampaignsPublisher publisher = client.listCampaignsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaignsv2.paginators.ListCampaignsPublisher publisher = client.listCampaignsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCampaigns(software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCampaignsRequest
     *        The request for ListCampaigns API.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCampaignsPublisher listCampaignsPaginator(ListCampaignsRequest listCampaignsRequest) {
        return new ListCampaignsPublisher(this, listCampaignsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCampaigns(software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaignsv2.paginators.ListCampaignsPublisher publisher = client.listCampaignsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaignsv2.paginators.ListCampaignsPublisher publisher = client.listCampaignsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCampaigns(software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCampaignsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCampaignsRequest#builder()}
     * </p>
     *
     * @param listCampaignsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsRequest.Builder} to create a
     *        request. The request for ListCampaigns API.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCampaignsPublisher listCampaignsPaginator(Consumer<ListCampaignsRequest.Builder> listCampaignsRequest) {
        return listCampaignsPaginator(ListCampaignsRequest.builder().applyMutation(listCampaignsRequest).build());
    }

    /**
     * <p>
     * Provides summary information about the integration under the specified Connect instance.
     * </p>
     *
     * @param listConnectInstanceIntegrationsRequest
     *        The request for ListConnectInstanceIntegrations API.
     * @return A Java Future containing the result of the ListConnectInstanceIntegrations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.ListConnectInstanceIntegrations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListConnectInstanceIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConnectInstanceIntegrationsResponse> listConnectInstanceIntegrations(
            ListConnectInstanceIntegrationsRequest listConnectInstanceIntegrationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summary information about the integration under the specified Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectInstanceIntegrationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConnectInstanceIntegrationsRequest#builder()}
     * </p>
     *
     * @param listConnectInstanceIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest.Builder}
     *        to create a request. The request for ListConnectInstanceIntegrations API.
     * @return A Java Future containing the result of the ListConnectInstanceIntegrations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.ListConnectInstanceIntegrations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListConnectInstanceIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConnectInstanceIntegrationsResponse> listConnectInstanceIntegrations(
            Consumer<ListConnectInstanceIntegrationsRequest.Builder> listConnectInstanceIntegrationsRequest) {
        return listConnectInstanceIntegrations(ListConnectInstanceIntegrationsRequest.builder()
                .applyMutation(listConnectInstanceIntegrationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnectInstanceIntegrations(software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaignsv2.paginators.ListConnectInstanceIntegrationsPublisher publisher = client.listConnectInstanceIntegrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaignsv2.paginators.ListConnectInstanceIntegrationsPublisher publisher = client.listConnectInstanceIntegrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectInstanceIntegrations(software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConnectInstanceIntegrationsRequest
     *        The request for ListConnectInstanceIntegrations API.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.ListConnectInstanceIntegrations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListConnectInstanceIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectInstanceIntegrationsPublisher listConnectInstanceIntegrationsPaginator(
            ListConnectInstanceIntegrationsRequest listConnectInstanceIntegrationsRequest) {
        return new ListConnectInstanceIntegrationsPublisher(this, listConnectInstanceIntegrationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnectInstanceIntegrations(software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaignsv2.paginators.ListConnectInstanceIntegrationsPublisher publisher = client.listConnectInstanceIntegrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaignsv2.paginators.ListConnectInstanceIntegrationsPublisher publisher = client.listConnectInstanceIntegrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectInstanceIntegrations(software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectInstanceIntegrationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConnectInstanceIntegrationsRequest#builder()}
     * </p>
     *
     * @param listConnectInstanceIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest.Builder}
     *        to create a request. The request for ListConnectInstanceIntegrations API.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.ListConnectInstanceIntegrations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListConnectInstanceIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectInstanceIntegrationsPublisher listConnectInstanceIntegrationsPaginator(
            Consumer<ListConnectInstanceIntegrationsRequest.Builder> listConnectInstanceIntegrationsRequest) {
        return listConnectInstanceIntegrationsPaginator(ListConnectInstanceIntegrationsRequest.builder()
                .applyMutation(listConnectInstanceIntegrationsRequest).build());
    }

    /**
     * <p>
     * List tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        The request for ListTagsForResource API.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.ListTagsForResourceRequest.Builder} to
     *        create a request. The request for ListTagsForResource API.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Pauses a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param pauseCampaignRequest
     *        The request for PauseCampaign API.
     * @return A Java Future containing the result of the PauseCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.PauseCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PauseCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PauseCampaignResponse> pauseCampaign(PauseCampaignRequest pauseCampaignRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Pauses a campaign for the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PauseCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link PauseCampaignRequest#builder()}
     * </p>
     *
     * @param pauseCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.PauseCampaignRequest.Builder} to create a
     *        request. The request for PauseCampaign API.
     * @return A Java Future containing the result of the PauseCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.PauseCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PauseCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PauseCampaignResponse> pauseCampaign(Consumer<PauseCampaignRequest.Builder> pauseCampaignRequest) {
        return pauseCampaign(PauseCampaignRequest.builder().applyMutation(pauseCampaignRequest).build());
    }

    /**
     * <p>
     * Put or update the integration for the specified Amazon Connect instance.
     * </p>
     *
     * @param putConnectInstanceIntegrationRequest
     *        The request for PutConnectInstanceIntegration API.
     * @return A Java Future containing the result of the PutConnectInstanceIntegration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.PutConnectInstanceIntegration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PutConnectInstanceIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConnectInstanceIntegrationResponse> putConnectInstanceIntegration(
            PutConnectInstanceIntegrationRequest putConnectInstanceIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Put or update the integration for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConnectInstanceIntegrationRequest.Builder}
     * avoiding the need to create one manually via {@link PutConnectInstanceIntegrationRequest#builder()}
     * </p>
     *
     * @param putConnectInstanceIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.PutConnectInstanceIntegrationRequest.Builder}
     *        to create a request. The request for PutConnectInstanceIntegration API.
     * @return A Java Future containing the result of the PutConnectInstanceIntegration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.PutConnectInstanceIntegration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PutConnectInstanceIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConnectInstanceIntegrationResponse> putConnectInstanceIntegration(
            Consumer<PutConnectInstanceIntegrationRequest.Builder> putConnectInstanceIntegrationRequest) {
        return putConnectInstanceIntegration(PutConnectInstanceIntegrationRequest.builder()
                .applyMutation(putConnectInstanceIntegrationRequest).build());
    }

    /**
     * <p>
     * Creates outbound requests for the specified campaign Amazon Connect account. This API is idempotent.
     * </p>
     *
     * @param putOutboundRequestBatchRequest
     *        The request for PutOutboundRequestBatch API.
     * @return A Java Future containing the result of the PutOutboundRequestBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.PutOutboundRequestBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PutOutboundRequestBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutOutboundRequestBatchResponse> putOutboundRequestBatch(
            PutOutboundRequestBatchRequest putOutboundRequestBatchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates outbound requests for the specified campaign Amazon Connect account. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutOutboundRequestBatchRequest.Builder} avoiding
     * the need to create one manually via {@link PutOutboundRequestBatchRequest#builder()}
     * </p>
     *
     * @param putOutboundRequestBatchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.PutOutboundRequestBatchRequest.Builder} to
     *        create a request. The request for PutOutboundRequestBatch API.
     * @return A Java Future containing the result of the PutOutboundRequestBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.PutOutboundRequestBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PutOutboundRequestBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutOutboundRequestBatchResponse> putOutboundRequestBatch(
            Consumer<PutOutboundRequestBatchRequest.Builder> putOutboundRequestBatchRequest) {
        return putOutboundRequestBatch(PutOutboundRequestBatchRequest.builder().applyMutation(putOutboundRequestBatchRequest)
                .build());
    }

    /**
     * <p>
     * Takes in a list of profile outbound requests to be placed as part of an outbound campaign. This API is
     * idempotent.
     * </p>
     *
     * @param putProfileOutboundRequestBatchRequest
     *        The request for PutProfileOutboundRequestBatch API
     * @return A Java Future containing the result of the PutProfileOutboundRequestBatch operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.PutProfileOutboundRequestBatch
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PutProfileOutboundRequestBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutProfileOutboundRequestBatchResponse> putProfileOutboundRequestBatch(
            PutProfileOutboundRequestBatchRequest putProfileOutboundRequestBatchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Takes in a list of profile outbound requests to be placed as part of an outbound campaign. This API is
     * idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutProfileOutboundRequestBatchRequest.Builder}
     * avoiding the need to create one manually via {@link PutProfileOutboundRequestBatchRequest#builder()}
     * </p>
     *
     * @param putProfileOutboundRequestBatchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.PutProfileOutboundRequestBatchRequest.Builder}
     *        to create a request. The request for PutProfileOutboundRequestBatch API
     * @return A Java Future containing the result of the PutProfileOutboundRequestBatch operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.PutProfileOutboundRequestBatch
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PutProfileOutboundRequestBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutProfileOutboundRequestBatchResponse> putProfileOutboundRequestBatch(
            Consumer<PutProfileOutboundRequestBatchRequest.Builder> putProfileOutboundRequestBatchRequest) {
        return putProfileOutboundRequestBatch(PutProfileOutboundRequestBatchRequest.builder()
                .applyMutation(putProfileOutboundRequestBatchRequest).build());
    }

    /**
     * <p>
     * Stops a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param resumeCampaignRequest
     *        The request for ResumeCampaign API.
     * @return A Java Future containing the result of the ResumeCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.ResumeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ResumeCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResumeCampaignResponse> resumeCampaign(ResumeCampaignRequest resumeCampaignRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a campaign for the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResumeCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link ResumeCampaignRequest#builder()}
     * </p>
     *
     * @param resumeCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.ResumeCampaignRequest.Builder} to create a
     *        request. The request for ResumeCampaign API.
     * @return A Java Future containing the result of the ResumeCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.ResumeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ResumeCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResumeCampaignResponse> resumeCampaign(Consumer<ResumeCampaignRequest.Builder> resumeCampaignRequest) {
        return resumeCampaign(ResumeCampaignRequest.builder().applyMutation(resumeCampaignRequest).build());
    }

    /**
     * <p>
     * Starts a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param startCampaignRequest
     *        The request for StartCampaign API.
     * @return A Java Future containing the result of the StartCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.StartCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/StartCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartCampaignResponse> startCampaign(StartCampaignRequest startCampaignRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a campaign for the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link StartCampaignRequest#builder()}
     * </p>
     *
     * @param startCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.StartCampaignRequest.Builder} to create a
     *        request. The request for StartCampaign API.
     * @return A Java Future containing the result of the StartCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.StartCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/StartCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartCampaignResponse> startCampaign(Consumer<StartCampaignRequest.Builder> startCampaignRequest) {
        return startCampaign(StartCampaignRequest.builder().applyMutation(startCampaignRequest).build());
    }

    /**
     * <p>
     * Onboard the specific Amazon Connect instance to Connect Campaigns.
     * </p>
     *
     * @param startInstanceOnboardingJobRequest
     *        The request for StartInstanceOnboardingJob API.
     * @return A Java Future containing the result of the StartInstanceOnboardingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.StartInstanceOnboardingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/StartInstanceOnboardingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartInstanceOnboardingJobResponse> startInstanceOnboardingJob(
            StartInstanceOnboardingJobRequest startInstanceOnboardingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Onboard the specific Amazon Connect instance to Connect Campaigns.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartInstanceOnboardingJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartInstanceOnboardingJobRequest#builder()}
     * </p>
     *
     * @param startInstanceOnboardingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.StartInstanceOnboardingJobRequest.Builder}
     *        to create a request. The request for StartInstanceOnboardingJob API.
     * @return A Java Future containing the result of the StartInstanceOnboardingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.StartInstanceOnboardingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/StartInstanceOnboardingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartInstanceOnboardingJobResponse> startInstanceOnboardingJob(
            Consumer<StartInstanceOnboardingJobRequest.Builder> startInstanceOnboardingJobRequest) {
        return startInstanceOnboardingJob(StartInstanceOnboardingJobRequest.builder()
                .applyMutation(startInstanceOnboardingJobRequest).build());
    }

    /**
     * <p>
     * Stops a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param stopCampaignRequest
     *        The request for StopCampaign API.
     * @return A Java Future containing the result of the StopCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.StopCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/StopCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopCampaignResponse> stopCampaign(StopCampaignRequest stopCampaignRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a campaign for the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link StopCampaignRequest#builder()}
     * </p>
     *
     * @param stopCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.StopCampaignRequest.Builder} to create a
     *        request. The request for StopCampaign API.
     * @return A Java Future containing the result of the StopCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.StopCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/StopCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopCampaignResponse> stopCampaign(Consumer<StopCampaignRequest.Builder> stopCampaignRequest) {
        return stopCampaign(StopCampaignRequest.builder().applyMutation(stopCampaignRequest).build());
    }

    /**
     * <p>
     * Tag a resource.
     * </p>
     *
     * @param tagResourceRequest
     *        The request for TagResource API.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tag a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.TagResourceRequest.Builder} to create a
     *        request. The request for TagResource API.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Untag a resource.
     * </p>
     *
     * @param untagResourceRequest
     *        The request for UntagResource API.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untag a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.UntagResourceRequest.Builder} to create a
     *        request. The request for UntagResource API.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the channel subtype config of a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignChannelSubtypeConfigRequest
     *        The request for UpdateCampaignChannelSubtypeConfig API.
     * @return A Java Future containing the result of the UpdateCampaignChannelSubtypeConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.UpdateCampaignChannelSubtypeConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignChannelSubtypeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCampaignChannelSubtypeConfigResponse> updateCampaignChannelSubtypeConfig(
            UpdateCampaignChannelSubtypeConfigRequest updateCampaignChannelSubtypeConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the channel subtype config of a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignChannelSubtypeConfigRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCampaignChannelSubtypeConfigRequest#builder()}
     * </p>
     *
     * @param updateCampaignChannelSubtypeConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignChannelSubtypeConfigRequest.Builder}
     *        to create a request. The request for UpdateCampaignChannelSubtypeConfig API.
     * @return A Java Future containing the result of the UpdateCampaignChannelSubtypeConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.UpdateCampaignChannelSubtypeConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignChannelSubtypeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCampaignChannelSubtypeConfigResponse> updateCampaignChannelSubtypeConfig(
            Consumer<UpdateCampaignChannelSubtypeConfigRequest.Builder> updateCampaignChannelSubtypeConfigRequest) {
        return updateCampaignChannelSubtypeConfig(UpdateCampaignChannelSubtypeConfigRequest.builder()
                .applyMutation(updateCampaignChannelSubtypeConfigRequest).build());
    }

    /**
     * <p>
     * Updates the communication limits config for a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignCommunicationLimitsRequest
     *        The request for UpdateCampaignCommunicationLimits API.
     * @return A Java Future containing the result of the UpdateCampaignCommunicationLimits operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.UpdateCampaignCommunicationLimits
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignCommunicationLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCampaignCommunicationLimitsResponse> updateCampaignCommunicationLimits(
            UpdateCampaignCommunicationLimitsRequest updateCampaignCommunicationLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the communication limits config for a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignCommunicationLimitsRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCampaignCommunicationLimitsRequest#builder()}
     * </p>
     *
     * @param updateCampaignCommunicationLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignCommunicationLimitsRequest.Builder}
     *        to create a request. The request for UpdateCampaignCommunicationLimits API.
     * @return A Java Future containing the result of the UpdateCampaignCommunicationLimits operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.UpdateCampaignCommunicationLimits
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignCommunicationLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCampaignCommunicationLimitsResponse> updateCampaignCommunicationLimits(
            Consumer<UpdateCampaignCommunicationLimitsRequest.Builder> updateCampaignCommunicationLimitsRequest) {
        return updateCampaignCommunicationLimits(UpdateCampaignCommunicationLimitsRequest.builder()
                .applyMutation(updateCampaignCommunicationLimitsRequest).build());
    }

    /**
     * <p>
     * Updates the communication time config for a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignCommunicationTimeRequest
     *        The request for UpdateCampaignCommunicationTime API.
     * @return A Java Future containing the result of the UpdateCampaignCommunicationTime operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.UpdateCampaignCommunicationTime
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignCommunicationTime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCampaignCommunicationTimeResponse> updateCampaignCommunicationTime(
            UpdateCampaignCommunicationTimeRequest updateCampaignCommunicationTimeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the communication time config for a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignCommunicationTimeRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCampaignCommunicationTimeRequest#builder()}
     * </p>
     *
     * @param updateCampaignCommunicationTimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignCommunicationTimeRequest.Builder}
     *        to create a request. The request for UpdateCampaignCommunicationTime API.
     * @return A Java Future containing the result of the UpdateCampaignCommunicationTime operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.UpdateCampaignCommunicationTime
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignCommunicationTime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCampaignCommunicationTimeResponse> updateCampaignCommunicationTime(
            Consumer<UpdateCampaignCommunicationTimeRequest.Builder> updateCampaignCommunicationTimeRequest) {
        return updateCampaignCommunicationTime(UpdateCampaignCommunicationTimeRequest.builder()
                .applyMutation(updateCampaignCommunicationTimeRequest).build());
    }

    /**
     * <p>
     * Updates the campaign flow associated with a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignFlowAssociationRequest
     *        The request for UpdateCampaignFlowAssociation API.
     * @return A Java Future containing the result of the UpdateCampaignFlowAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.UpdateCampaignFlowAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignFlowAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCampaignFlowAssociationResponse> updateCampaignFlowAssociation(
            UpdateCampaignFlowAssociationRequest updateCampaignFlowAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the campaign flow associated with a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignFlowAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCampaignFlowAssociationRequest#builder()}
     * </p>
     *
     * @param updateCampaignFlowAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignFlowAssociationRequest.Builder}
     *        to create a request. The request for UpdateCampaignFlowAssociation API.
     * @return A Java Future containing the result of the UpdateCampaignFlowAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.UpdateCampaignFlowAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignFlowAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCampaignFlowAssociationResponse> updateCampaignFlowAssociation(
            Consumer<UpdateCampaignFlowAssociationRequest.Builder> updateCampaignFlowAssociationRequest) {
        return updateCampaignFlowAssociation(UpdateCampaignFlowAssociationRequest.builder()
                .applyMutation(updateCampaignFlowAssociationRequest).build());
    }

    /**
     * <p>
     * Updates the name of a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignNameRequest
     *        The request for UpdateCampaignName API.
     * @return A Java Future containing the result of the UpdateCampaignName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.UpdateCampaignName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignName"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCampaignNameResponse> updateCampaignName(UpdateCampaignNameRequest updateCampaignNameRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name of a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignNameRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateCampaignNameRequest#builder()}
     * </p>
     *
     * @param updateCampaignNameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignNameRequest.Builder} to
     *        create a request. The request for UpdateCampaignName API.
     * @return A Java Future containing the result of the UpdateCampaignName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.UpdateCampaignName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignName"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCampaignNameResponse> updateCampaignName(
            Consumer<UpdateCampaignNameRequest.Builder> updateCampaignNameRequest) {
        return updateCampaignName(UpdateCampaignNameRequest.builder().applyMutation(updateCampaignNameRequest).build());
    }

    /**
     * <p>
     * Updates the schedule for a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignScheduleRequest
     *        The request for UpdateCampaignSchedule API.
     * @return A Java Future containing the result of the UpdateCampaignSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.UpdateCampaignSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCampaignScheduleResponse> updateCampaignSchedule(
            UpdateCampaignScheduleRequest updateCampaignScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the schedule for a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateCampaignScheduleRequest#builder()}
     * </p>
     *
     * @param updateCampaignScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignScheduleRequest.Builder} to
     *        create a request. The request for UpdateCampaignSchedule API.
     * @return A Java Future containing the result of the UpdateCampaignSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.UpdateCampaignSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCampaignScheduleResponse> updateCampaignSchedule(
            Consumer<UpdateCampaignScheduleRequest.Builder> updateCampaignScheduleRequest) {
        return updateCampaignSchedule(UpdateCampaignScheduleRequest.builder().applyMutation(updateCampaignScheduleRequest)
                .build());
    }

    /**
     * <p>
     * Updates the campaign source with a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignSourceRequest
     *        The request for UpdateCampaignSource API.
     * @return A Java Future containing the result of the UpdateCampaignSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.UpdateCampaignSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCampaignSourceResponse> updateCampaignSource(
            UpdateCampaignSourceRequest updateCampaignSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the campaign source with a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignSourceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateCampaignSourceRequest#builder()}
     * </p>
     *
     * @param updateCampaignSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignSourceRequest.Builder} to
     *        create a request. The request for UpdateCampaignSource API.
     * @return A Java Future containing the result of the UpdateCampaignSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidCampaignStateException The request could not be processed because of conflict in the current
     *         state of the campaign.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCampaignsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ConnectCampaignsV2AsyncClient.UpdateCampaignSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCampaignSourceResponse> updateCampaignSource(
            Consumer<UpdateCampaignSourceRequest.Builder> updateCampaignSourceRequest) {
        return updateCampaignSource(UpdateCampaignSourceRequest.builder().applyMutation(updateCampaignSourceRequest).build());
    }

    @Override
    default ConnectCampaignsV2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ConnectCampaignsV2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ConnectCampaignsV2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ConnectCampaignsV2AsyncClient}.
     */
    static ConnectCampaignsV2AsyncClientBuilder builder() {
        return new DefaultConnectCampaignsV2AsyncClientBuilder();
    }
}
