/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.connectcampaignsv2.model.AccessDeniedException;
import software.amazon.awssdk.services.connectcampaignsv2.model.ConflictException;
import software.amazon.awssdk.services.connectcampaignsv2.model.ConnectCampaignsV2Exception;
import software.amazon.awssdk.services.connectcampaignsv2.model.CreateCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.CreateCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignChannelSubtypeConfigRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignChannelSubtypeConfigResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignCommunicationLimitsRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignCommunicationLimitsResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignCommunicationTimeRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignCommunicationTimeResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteConnectInstanceConfigRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteConnectInstanceConfigResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteConnectInstanceIntegrationRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteConnectInstanceIntegrationResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteInstanceOnboardingJobRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteInstanceOnboardingJobResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DescribeCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DescribeCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetCampaignStateBatchRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetCampaignStateBatchResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetCampaignStateRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetCampaignStateResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetConnectInstanceConfigRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetConnectInstanceConfigResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetInstanceOnboardingJobStatusRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetInstanceOnboardingJobStatusResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.InternalServerException;
import software.amazon.awssdk.services.connectcampaignsv2.model.InvalidCampaignStateException;
import software.amazon.awssdk.services.connectcampaignsv2.model.InvalidStateException;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.PauseCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.PauseCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.PutConnectInstanceIntegrationRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.PutConnectInstanceIntegrationResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.PutOutboundRequestBatchRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.PutOutboundRequestBatchResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.PutProfileOutboundRequestBatchRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.PutProfileOutboundRequestBatchResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.connectcampaignsv2.model.ResumeCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.ResumeCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.connectcampaignsv2.model.StartCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.StartCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.StartInstanceOnboardingJobRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.StartInstanceOnboardingJobResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.StopCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.StopCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.TagResourceRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.TagResourceResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.ThrottlingException;
import software.amazon.awssdk.services.connectcampaignsv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignChannelSubtypeConfigRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignChannelSubtypeConfigResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignCommunicationLimitsRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignCommunicationLimitsResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignCommunicationTimeRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignCommunicationTimeResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignFlowAssociationRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignFlowAssociationResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignNameRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignNameResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignScheduleRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignScheduleResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignSourceRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignSourceResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.ValidationException;
import software.amazon.awssdk.services.connectcampaignsv2.paginators.ListCampaignsIterable;
import software.amazon.awssdk.services.connectcampaignsv2.paginators.ListConnectInstanceIntegrationsIterable;

/**
 * Service client for accessing AmazonConnectCampaignServiceV2. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Provide APIs to create and manage Amazon Connect Campaigns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ConnectCampaignsV2Client extends AwsClient {
    String SERVICE_NAME = "connect-campaigns";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "connect-campaigns";

    /**
     * <p>
     * Creates a campaign for the specified Amazon Connect account. This API is idempotent.
     * </p>
     *
     * @param createCampaignRequest
     *        The request for CreateCampaign API.
     * @return Result of the CreateCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/CreateCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCampaignResponse createCampaign(CreateCampaignRequest createCampaignRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a campaign for the specified Amazon Connect account. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCampaignRequest#builder()}
     * </p>
     *
     * @param createCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.CreateCampaignRequest.Builder} to create a
     *        request. The request for CreateCampaign API.
     * @return Result of the CreateCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/CreateCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCampaignResponse createCampaign(Consumer<CreateCampaignRequest.Builder> createCampaignRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            AccessDeniedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        return createCampaign(CreateCampaignRequest.builder().applyMutation(createCampaignRequest).build());
    }

    /**
     * <p>
     * Deletes a campaign from the specified Amazon Connect account.
     * </p>
     *
     * @param deleteCampaignRequest
     *        The request for DeleteCampaign API.
     * @return Result of the DeleteCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCampaignResponse deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a campaign from the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteCampaignRequest#builder()}
     * </p>
     *
     * @param deleteCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignRequest.Builder} to create a
     *        request. The request for DeleteCampaign API.
     * @return Result of the DeleteCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCampaignResponse deleteCampaign(Consumer<DeleteCampaignRequest.Builder> deleteCampaignRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return deleteCampaign(DeleteCampaignRequest.builder().applyMutation(deleteCampaignRequest).build());
    }

    /**
     * <p>
     * Deletes the channel subtype config of a campaign. This API is idempotent.
     * </p>
     *
     * @param deleteCampaignChannelSubtypeConfigRequest
     *        The request for DeleteCampaignChannelSubtypeConfig API.
     * @return Result of the DeleteCampaignChannelSubtypeConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteCampaignChannelSubtypeConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaignChannelSubtypeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCampaignChannelSubtypeConfigResponse deleteCampaignChannelSubtypeConfig(
            DeleteCampaignChannelSubtypeConfigRequest deleteCampaignChannelSubtypeConfigRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException, AwsServiceException,
            SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the channel subtype config of a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCampaignChannelSubtypeConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCampaignChannelSubtypeConfigRequest#builder()}
     * </p>
     *
     * @param deleteCampaignChannelSubtypeConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignChannelSubtypeConfigRequest.Builder}
     *        to create a request. The request for DeleteCampaignChannelSubtypeConfig API.
     * @return Result of the DeleteCampaignChannelSubtypeConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteCampaignChannelSubtypeConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaignChannelSubtypeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCampaignChannelSubtypeConfigResponse deleteCampaignChannelSubtypeConfig(
            Consumer<DeleteCampaignChannelSubtypeConfigRequest.Builder> deleteCampaignChannelSubtypeConfigRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return deleteCampaignChannelSubtypeConfig(DeleteCampaignChannelSubtypeConfigRequest.builder()
                .applyMutation(deleteCampaignChannelSubtypeConfigRequest).build());
    }

    /**
     * <p>
     * Deletes the communication limits config for a campaign. This API is idempotent.
     * </p>
     *
     * @param deleteCampaignCommunicationLimitsRequest
     *        The request for DeleteCampaignCommunicationLimits API.
     * @return Result of the DeleteCampaignCommunicationLimits operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteCampaignCommunicationLimits
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaignCommunicationLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCampaignCommunicationLimitsResponse deleteCampaignCommunicationLimits(
            DeleteCampaignCommunicationLimitsRequest deleteCampaignCommunicationLimitsRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the communication limits config for a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCampaignCommunicationLimitsRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCampaignCommunicationLimitsRequest#builder()}
     * </p>
     *
     * @param deleteCampaignCommunicationLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignCommunicationLimitsRequest.Builder}
     *        to create a request. The request for DeleteCampaignCommunicationLimits API.
     * @return Result of the DeleteCampaignCommunicationLimits operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteCampaignCommunicationLimits
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaignCommunicationLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCampaignCommunicationLimitsResponse deleteCampaignCommunicationLimits(
            Consumer<DeleteCampaignCommunicationLimitsRequest.Builder> deleteCampaignCommunicationLimitsRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        return deleteCampaignCommunicationLimits(DeleteCampaignCommunicationLimitsRequest.builder()
                .applyMutation(deleteCampaignCommunicationLimitsRequest).build());
    }

    /**
     * <p>
     * Deletes the communication time config for a campaign. This API is idempotent.
     * </p>
     *
     * @param deleteCampaignCommunicationTimeRequest
     *        The request for DeleteCampaignCommunicationTime API.
     * @return Result of the DeleteCampaignCommunicationTime operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteCampaignCommunicationTime
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaignCommunicationTime"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCampaignCommunicationTimeResponse deleteCampaignCommunicationTime(
            DeleteCampaignCommunicationTimeRequest deleteCampaignCommunicationTimeRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the communication time config for a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCampaignCommunicationTimeRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCampaignCommunicationTimeRequest#builder()}
     * </p>
     *
     * @param deleteCampaignCommunicationTimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignCommunicationTimeRequest.Builder}
     *        to create a request. The request for DeleteCampaignCommunicationTime API.
     * @return Result of the DeleteCampaignCommunicationTime operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteCampaignCommunicationTime
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaignCommunicationTime"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCampaignCommunicationTimeResponse deleteCampaignCommunicationTime(
            Consumer<DeleteCampaignCommunicationTimeRequest.Builder> deleteCampaignCommunicationTimeRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        return deleteCampaignCommunicationTime(DeleteCampaignCommunicationTimeRequest.builder()
                .applyMutation(deleteCampaignCommunicationTimeRequest).build());
    }

    /**
     * <p>
     * Deletes a connect instance config from the specified AWS account.
     * </p>
     *
     * @param deleteConnectInstanceConfigRequest
     *        The request for DeleteConnectInstanceConfig API.
     * @return Result of the DeleteConnectInstanceConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidStateException
     *         The request could not be processed because of conflict in the current state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteConnectInstanceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteConnectInstanceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectInstanceConfigResponse deleteConnectInstanceConfig(
            DeleteConnectInstanceConfigRequest deleteConnectInstanceConfigRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, InvalidStateException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a connect instance config from the specified AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectInstanceConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConnectInstanceConfigRequest#builder()}
     * </p>
     *
     * @param deleteConnectInstanceConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.DeleteConnectInstanceConfigRequest.Builder}
     *        to create a request. The request for DeleteConnectInstanceConfig API.
     * @return Result of the DeleteConnectInstanceConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidStateException
     *         The request could not be processed because of conflict in the current state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteConnectInstanceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteConnectInstanceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectInstanceConfigResponse deleteConnectInstanceConfig(
            Consumer<DeleteConnectInstanceConfigRequest.Builder> deleteConnectInstanceConfigRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            InvalidStateException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return deleteConnectInstanceConfig(DeleteConnectInstanceConfigRequest.builder()
                .applyMutation(deleteConnectInstanceConfigRequest).build());
    }

    /**
     * <p>
     * Delete the integration for the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteConnectInstanceIntegrationRequest
     *        The request for DeleteConnectInstanceIntegration API.
     * @return Result of the DeleteConnectInstanceIntegration operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteConnectInstanceIntegration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteConnectInstanceIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectInstanceIntegrationResponse deleteConnectInstanceIntegration(
            DeleteConnectInstanceIntegrationRequest deleteConnectInstanceIntegrationRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the integration for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectInstanceIntegrationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConnectInstanceIntegrationRequest#builder()}
     * </p>
     *
     * @param deleteConnectInstanceIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.DeleteConnectInstanceIntegrationRequest.Builder}
     *        to create a request. The request for DeleteConnectInstanceIntegration API.
     * @return Result of the DeleteConnectInstanceIntegration operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteConnectInstanceIntegration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteConnectInstanceIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectInstanceIntegrationResponse deleteConnectInstanceIntegration(
            Consumer<DeleteConnectInstanceIntegrationRequest.Builder> deleteConnectInstanceIntegrationRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return deleteConnectInstanceIntegration(DeleteConnectInstanceIntegrationRequest.builder()
                .applyMutation(deleteConnectInstanceIntegrationRequest).build());
    }

    /**
     * <p>
     * Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteInstanceOnboardingJobRequest
     *        The request for DeleteInstanceOnboardingJob API.
     * @return Result of the DeleteInstanceOnboardingJob operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidStateException
     *         The request could not be processed because of conflict in the current state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteInstanceOnboardingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteInstanceOnboardingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInstanceOnboardingJobResponse deleteInstanceOnboardingJob(
            DeleteInstanceOnboardingJobRequest deleteInstanceOnboardingJobRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, InvalidStateException, AwsServiceException,
            SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceOnboardingJobRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteInstanceOnboardingJobRequest#builder()}
     * </p>
     *
     * @param deleteInstanceOnboardingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.DeleteInstanceOnboardingJobRequest.Builder}
     *        to create a request. The request for DeleteInstanceOnboardingJob API.
     * @return Result of the DeleteInstanceOnboardingJob operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidStateException
     *         The request could not be processed because of conflict in the current state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteInstanceOnboardingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteInstanceOnboardingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInstanceOnboardingJobResponse deleteInstanceOnboardingJob(
            Consumer<DeleteInstanceOnboardingJobRequest.Builder> deleteInstanceOnboardingJobRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            InvalidStateException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return deleteInstanceOnboardingJob(DeleteInstanceOnboardingJobRequest.builder()
                .applyMutation(deleteInstanceOnboardingJobRequest).build());
    }

    /**
     * <p>
     * Describes the specific campaign.
     * </p>
     *
     * @param describeCampaignRequest
     *        The request for DescribeCampaign API.
     * @return Result of the DescribeCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DescribeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DescribeCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCampaignResponse describeCampaign(DescribeCampaignRequest describeCampaignRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specific campaign.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCampaignRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeCampaignRequest#builder()}
     * </p>
     *
     * @param describeCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.DescribeCampaignRequest.Builder} to create
     *        a request. The request for DescribeCampaign API.
     * @return Result of the DescribeCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DescribeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DescribeCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCampaignResponse describeCampaign(Consumer<DescribeCampaignRequest.Builder> describeCampaignRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return describeCampaign(DescribeCampaignRequest.builder().applyMutation(describeCampaignRequest).build());
    }

    /**
     * <p>
     * Get state of a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param getCampaignStateRequest
     *        The request for GetCampaignState API.
     * @return Result of the GetCampaignState operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.GetCampaignState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetCampaignState"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCampaignStateResponse getCampaignState(GetCampaignStateRequest getCampaignStateRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get state of a campaign for the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignStateRequest.Builder} avoiding the need
     * to create one manually via {@link GetCampaignStateRequest#builder()}
     * </p>
     *
     * @param getCampaignStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.GetCampaignStateRequest.Builder} to create
     *        a request. The request for GetCampaignState API.
     * @return Result of the GetCampaignState operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.GetCampaignState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetCampaignState"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCampaignStateResponse getCampaignState(Consumer<GetCampaignStateRequest.Builder> getCampaignStateRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return getCampaignState(GetCampaignStateRequest.builder().applyMutation(getCampaignStateRequest).build());
    }

    /**
     * <p>
     * Get state of campaigns for the specified Amazon Connect account.
     * </p>
     *
     * @param getCampaignStateBatchRequest
     *        The request for GetCampaignStateBatch API.
     * @return Result of the GetCampaignStateBatch operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.GetCampaignStateBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetCampaignStateBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCampaignStateBatchResponse getCampaignStateBatch(GetCampaignStateBatchRequest getCampaignStateBatchRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get state of campaigns for the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignStateBatchRequest.Builder} avoiding the
     * need to create one manually via {@link GetCampaignStateBatchRequest#builder()}
     * </p>
     *
     * @param getCampaignStateBatchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.GetCampaignStateBatchRequest.Builder} to
     *        create a request. The request for GetCampaignStateBatch API.
     * @return Result of the GetCampaignStateBatch operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.GetCampaignStateBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetCampaignStateBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCampaignStateBatchResponse getCampaignStateBatch(
            Consumer<GetCampaignStateBatchRequest.Builder> getCampaignStateBatchRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        return getCampaignStateBatch(GetCampaignStateBatchRequest.builder().applyMutation(getCampaignStateBatchRequest).build());
    }

    /**
     * <p>
     * Get the specific Connect instance config.
     * </p>
     *
     * @param getConnectInstanceConfigRequest
     *        The request for GetConnectInstanceConfig API.
     * @return Result of the GetConnectInstanceConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.GetConnectInstanceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetConnectInstanceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectInstanceConfigResponse getConnectInstanceConfig(
            GetConnectInstanceConfigRequest getConnectInstanceConfigRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the specific Connect instance config.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectInstanceConfigRequest.Builder} avoiding
     * the need to create one manually via {@link GetConnectInstanceConfigRequest#builder()}
     * </p>
     *
     * @param getConnectInstanceConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.GetConnectInstanceConfigRequest.Builder}
     *        to create a request. The request for GetConnectInstanceConfig API.
     * @return Result of the GetConnectInstanceConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.GetConnectInstanceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetConnectInstanceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectInstanceConfigResponse getConnectInstanceConfig(
            Consumer<GetConnectInstanceConfigRequest.Builder> getConnectInstanceConfigRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        return getConnectInstanceConfig(GetConnectInstanceConfigRequest.builder().applyMutation(getConnectInstanceConfigRequest)
                .build());
    }

    /**
     * <p>
     * Get the specific instance onboarding job status.
     * </p>
     *
     * @param getInstanceOnboardingJobStatusRequest
     *        The request for GetInstanceOnboardingJobStatus API.
     * @return Result of the GetInstanceOnboardingJobStatus operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.GetInstanceOnboardingJobStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetInstanceOnboardingJobStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInstanceOnboardingJobStatusResponse getInstanceOnboardingJobStatus(
            GetInstanceOnboardingJobStatusRequest getInstanceOnboardingJobStatusRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the specific instance onboarding job status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceOnboardingJobStatusRequest.Builder}
     * avoiding the need to create one manually via {@link GetInstanceOnboardingJobStatusRequest#builder()}
     * </p>
     *
     * @param getInstanceOnboardingJobStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.GetInstanceOnboardingJobStatusRequest.Builder}
     *        to create a request. The request for GetInstanceOnboardingJobStatus API.
     * @return Result of the GetInstanceOnboardingJobStatus operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.GetInstanceOnboardingJobStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetInstanceOnboardingJobStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInstanceOnboardingJobStatusResponse getInstanceOnboardingJobStatus(
            Consumer<GetInstanceOnboardingJobStatusRequest.Builder> getInstanceOnboardingJobStatusRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return getInstanceOnboardingJobStatus(GetInstanceOnboardingJobStatusRequest.builder()
                .applyMutation(getInstanceOnboardingJobStatusRequest).build());
    }

    /**
     * <p>
     * Provides summary information about the campaigns under the specified Amazon Connect account.
     * </p>
     *
     * @param listCampaignsRequest
     *        The request for ListCampaigns API.
     * @return Result of the ListCampaigns operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCampaignsResponse listCampaigns(ListCampaignsRequest listCampaignsRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summary information about the campaigns under the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCampaignsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCampaignsRequest#builder()}
     * </p>
     *
     * @param listCampaignsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsRequest.Builder} to create a
     *        request. The request for ListCampaigns API.
     * @return Result of the ListCampaigns operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCampaignsResponse listCampaigns(Consumer<ListCampaignsRequest.Builder> listCampaignsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        return listCampaigns(ListCampaignsRequest.builder().applyMutation(listCampaignsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCampaigns(software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaignsv2.paginators.ListCampaignsIterable responses = client.listCampaignsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connectcampaignsv2.paginators.ListCampaignsIterable responses = client
     *             .listCampaignsPaginator(request);
     *     for (software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaignsv2.paginators.ListCampaignsIterable responses = client.listCampaignsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCampaigns(software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCampaignsRequest
     *        The request for ListCampaigns API.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCampaignsIterable listCampaignsPaginator(ListCampaignsRequest listCampaignsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        return new ListCampaignsIterable(this, listCampaignsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCampaigns(software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaignsv2.paginators.ListCampaignsIterable responses = client.listCampaignsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connectcampaignsv2.paginators.ListCampaignsIterable responses = client
     *             .listCampaignsPaginator(request);
     *     for (software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaignsv2.paginators.ListCampaignsIterable responses = client.listCampaignsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCampaigns(software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCampaignsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCampaignsRequest#builder()}
     * </p>
     *
     * @param listCampaignsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsRequest.Builder} to create a
     *        request. The request for ListCampaigns API.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCampaignsIterable listCampaignsPaginator(Consumer<ListCampaignsRequest.Builder> listCampaignsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        return listCampaignsPaginator(ListCampaignsRequest.builder().applyMutation(listCampaignsRequest).build());
    }

    /**
     * <p>
     * Provides summary information about the integration under the specified Connect instance.
     * </p>
     *
     * @param listConnectInstanceIntegrationsRequest
     *        The request for ListConnectInstanceIntegrations API.
     * @return Result of the ListConnectInstanceIntegrations operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.ListConnectInstanceIntegrations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListConnectInstanceIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectInstanceIntegrationsResponse listConnectInstanceIntegrations(
            ListConnectInstanceIntegrationsRequest listConnectInstanceIntegrationsRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summary information about the integration under the specified Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectInstanceIntegrationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConnectInstanceIntegrationsRequest#builder()}
     * </p>
     *
     * @param listConnectInstanceIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest.Builder}
     *        to create a request. The request for ListConnectInstanceIntegrations API.
     * @return Result of the ListConnectInstanceIntegrations operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.ListConnectInstanceIntegrations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListConnectInstanceIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectInstanceIntegrationsResponse listConnectInstanceIntegrations(
            Consumer<ListConnectInstanceIntegrationsRequest.Builder> listConnectInstanceIntegrationsRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return listConnectInstanceIntegrations(ListConnectInstanceIntegrationsRequest.builder()
                .applyMutation(listConnectInstanceIntegrationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnectInstanceIntegrations(software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaignsv2.paginators.ListConnectInstanceIntegrationsIterable responses = client.listConnectInstanceIntegrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connectcampaignsv2.paginators.ListConnectInstanceIntegrationsIterable responses = client
     *             .listConnectInstanceIntegrationsPaginator(request);
     *     for (software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaignsv2.paginators.ListConnectInstanceIntegrationsIterable responses = client.listConnectInstanceIntegrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectInstanceIntegrations(software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConnectInstanceIntegrationsRequest
     *        The request for ListConnectInstanceIntegrations API.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.ListConnectInstanceIntegrations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListConnectInstanceIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectInstanceIntegrationsIterable listConnectInstanceIntegrationsPaginator(
            ListConnectInstanceIntegrationsRequest listConnectInstanceIntegrationsRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectCampaignsV2Exception {
        return new ListConnectInstanceIntegrationsIterable(this, listConnectInstanceIntegrationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnectInstanceIntegrations(software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaignsv2.paginators.ListConnectInstanceIntegrationsIterable responses = client.listConnectInstanceIntegrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connectcampaignsv2.paginators.ListConnectInstanceIntegrationsIterable responses = client
     *             .listConnectInstanceIntegrationsPaginator(request);
     *     for (software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcampaignsv2.paginators.ListConnectInstanceIntegrationsIterable responses = client.listConnectInstanceIntegrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectInstanceIntegrations(software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectInstanceIntegrationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConnectInstanceIntegrationsRequest#builder()}
     * </p>
     *
     * @param listConnectInstanceIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest.Builder}
     *        to create a request. The request for ListConnectInstanceIntegrations API.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.ListConnectInstanceIntegrations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListConnectInstanceIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectInstanceIntegrationsIterable listConnectInstanceIntegrationsPaginator(
            Consumer<ListConnectInstanceIntegrationsRequest.Builder> listConnectInstanceIntegrationsRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return listConnectInstanceIntegrationsPaginator(ListConnectInstanceIntegrationsRequest.builder()
                .applyMutation(listConnectInstanceIntegrationsRequest).build());
    }

    /**
     * <p>
     * List tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        The request for ListTagsForResource API.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.ListTagsForResourceRequest.Builder} to
     *        create a request. The request for ListTagsForResource API.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectCampaignsV2Exception {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Pauses a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param pauseCampaignRequest
     *        The request for PauseCampaign API.
     * @return Result of the PauseCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.PauseCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PauseCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default PauseCampaignResponse pauseCampaign(PauseCampaignRequest pauseCampaignRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Pauses a campaign for the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PauseCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link PauseCampaignRequest#builder()}
     * </p>
     *
     * @param pauseCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.PauseCampaignRequest.Builder} to create a
     *        request. The request for PauseCampaign API.
     * @return Result of the PauseCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.PauseCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PauseCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default PauseCampaignResponse pauseCampaign(Consumer<PauseCampaignRequest.Builder> pauseCampaignRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        return pauseCampaign(PauseCampaignRequest.builder().applyMutation(pauseCampaignRequest).build());
    }

    /**
     * <p>
     * Put or update the integration for the specified Amazon Connect instance.
     * </p>
     *
     * @param putConnectInstanceIntegrationRequest
     *        The request for PutConnectInstanceIntegration API.
     * @return Result of the PutConnectInstanceIntegration operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.PutConnectInstanceIntegration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PutConnectInstanceIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConnectInstanceIntegrationResponse putConnectInstanceIntegration(
            PutConnectInstanceIntegrationRequest putConnectInstanceIntegrationRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Put or update the integration for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConnectInstanceIntegrationRequest.Builder}
     * avoiding the need to create one manually via {@link PutConnectInstanceIntegrationRequest#builder()}
     * </p>
     *
     * @param putConnectInstanceIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.PutConnectInstanceIntegrationRequest.Builder}
     *        to create a request. The request for PutConnectInstanceIntegration API.
     * @return Result of the PutConnectInstanceIntegration operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.PutConnectInstanceIntegration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PutConnectInstanceIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConnectInstanceIntegrationResponse putConnectInstanceIntegration(
            Consumer<PutConnectInstanceIntegrationRequest.Builder> putConnectInstanceIntegrationRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return putConnectInstanceIntegration(PutConnectInstanceIntegrationRequest.builder()
                .applyMutation(putConnectInstanceIntegrationRequest).build());
    }

    /**
     * <p>
     * Creates outbound requests for the specified campaign Amazon Connect account. This API is idempotent.
     * </p>
     *
     * @param putOutboundRequestBatchRequest
     *        The request for PutOutboundRequestBatch API.
     * @return Result of the PutOutboundRequestBatch operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.PutOutboundRequestBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PutOutboundRequestBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default PutOutboundRequestBatchResponse putOutboundRequestBatch(PutOutboundRequestBatchRequest putOutboundRequestBatchRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates outbound requests for the specified campaign Amazon Connect account. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutOutboundRequestBatchRequest.Builder} avoiding
     * the need to create one manually via {@link PutOutboundRequestBatchRequest#builder()}
     * </p>
     *
     * @param putOutboundRequestBatchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.PutOutboundRequestBatchRequest.Builder} to
     *        create a request. The request for PutOutboundRequestBatch API.
     * @return Result of the PutOutboundRequestBatch operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.PutOutboundRequestBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PutOutboundRequestBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default PutOutboundRequestBatchResponse putOutboundRequestBatch(
            Consumer<PutOutboundRequestBatchRequest.Builder> putOutboundRequestBatchRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return putOutboundRequestBatch(PutOutboundRequestBatchRequest.builder().applyMutation(putOutboundRequestBatchRequest)
                .build());
    }

    /**
     * <p>
     * Takes in a list of profile outbound requests to be placed as part of an outbound campaign. This API is
     * idempotent.
     * </p>
     *
     * @param putProfileOutboundRequestBatchRequest
     *        The request for PutProfileOutboundRequestBatch API
     * @return Result of the PutProfileOutboundRequestBatch operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.PutProfileOutboundRequestBatch
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PutProfileOutboundRequestBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default PutProfileOutboundRequestBatchResponse putProfileOutboundRequestBatch(
            PutProfileOutboundRequestBatchRequest putProfileOutboundRequestBatchRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Takes in a list of profile outbound requests to be placed as part of an outbound campaign. This API is
     * idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutProfileOutboundRequestBatchRequest.Builder}
     * avoiding the need to create one manually via {@link PutProfileOutboundRequestBatchRequest#builder()}
     * </p>
     *
     * @param putProfileOutboundRequestBatchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.PutProfileOutboundRequestBatchRequest.Builder}
     *        to create a request. The request for PutProfileOutboundRequestBatch API
     * @return Result of the PutProfileOutboundRequestBatch operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.PutProfileOutboundRequestBatch
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PutProfileOutboundRequestBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default PutProfileOutboundRequestBatchResponse putProfileOutboundRequestBatch(
            Consumer<PutProfileOutboundRequestBatchRequest.Builder> putProfileOutboundRequestBatchRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        return putProfileOutboundRequestBatch(PutProfileOutboundRequestBatchRequest.builder()
                .applyMutation(putProfileOutboundRequestBatchRequest).build());
    }

    /**
     * <p>
     * Stops a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param resumeCampaignRequest
     *        The request for ResumeCampaign API.
     * @return Result of the ResumeCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.ResumeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ResumeCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default ResumeCampaignResponse resumeCampaign(ResumeCampaignRequest resumeCampaignRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a campaign for the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResumeCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link ResumeCampaignRequest#builder()}
     * </p>
     *
     * @param resumeCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.ResumeCampaignRequest.Builder} to create a
     *        request. The request for ResumeCampaign API.
     * @return Result of the ResumeCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.ResumeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ResumeCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default ResumeCampaignResponse resumeCampaign(Consumer<ResumeCampaignRequest.Builder> resumeCampaignRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        return resumeCampaign(ResumeCampaignRequest.builder().applyMutation(resumeCampaignRequest).build());
    }

    /**
     * <p>
     * Starts a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param startCampaignRequest
     *        The request for StartCampaign API.
     * @return Result of the StartCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.StartCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/StartCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default StartCampaignResponse startCampaign(StartCampaignRequest startCampaignRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a campaign for the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link StartCampaignRequest#builder()}
     * </p>
     *
     * @param startCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.StartCampaignRequest.Builder} to create a
     *        request. The request for StartCampaign API.
     * @return Result of the StartCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.StartCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/StartCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default StartCampaignResponse startCampaign(Consumer<StartCampaignRequest.Builder> startCampaignRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        return startCampaign(StartCampaignRequest.builder().applyMutation(startCampaignRequest).build());
    }

    /**
     * <p>
     * Onboard the specific Amazon Connect instance to Connect Campaigns.
     * </p>
     *
     * @param startInstanceOnboardingJobRequest
     *        The request for StartInstanceOnboardingJob API.
     * @return Result of the StartInstanceOnboardingJob operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.StartInstanceOnboardingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/StartInstanceOnboardingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartInstanceOnboardingJobResponse startInstanceOnboardingJob(
            StartInstanceOnboardingJobRequest startInstanceOnboardingJobRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Onboard the specific Amazon Connect instance to Connect Campaigns.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartInstanceOnboardingJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartInstanceOnboardingJobRequest#builder()}
     * </p>
     *
     * @param startInstanceOnboardingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.StartInstanceOnboardingJobRequest.Builder}
     *        to create a request. The request for StartInstanceOnboardingJob API.
     * @return Result of the StartInstanceOnboardingJob operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.StartInstanceOnboardingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/StartInstanceOnboardingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartInstanceOnboardingJobResponse startInstanceOnboardingJob(
            Consumer<StartInstanceOnboardingJobRequest.Builder> startInstanceOnboardingJobRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return startInstanceOnboardingJob(StartInstanceOnboardingJobRequest.builder()
                .applyMutation(startInstanceOnboardingJobRequest).build());
    }

    /**
     * <p>
     * Stops a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param stopCampaignRequest
     *        The request for StopCampaign API.
     * @return Result of the StopCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.StopCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/StopCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default StopCampaignResponse stopCampaign(StopCampaignRequest stopCampaignRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a campaign for the specified Amazon Connect account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link StopCampaignRequest#builder()}
     * </p>
     *
     * @param stopCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.StopCampaignRequest.Builder} to create a
     *        request. The request for StopCampaign API.
     * @return Result of the StopCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.StopCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/StopCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default StopCampaignResponse stopCampaign(Consumer<StopCampaignRequest.Builder> stopCampaignRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        return stopCampaign(StopCampaignRequest.builder().applyMutation(stopCampaignRequest).build());
    }

    /**
     * <p>
     * Tag a resource.
     * </p>
     *
     * @param tagResourceRequest
     *        The request for TagResource API.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tag a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.TagResourceRequest.Builder} to create a
     *        request. The request for TagResource API.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Untag a resource.
     * </p>
     *
     * @param untagResourceRequest
     *        The request for UntagResource API.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untag a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.UntagResourceRequest.Builder} to create a
     *        request. The request for UntagResource API.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the channel subtype config of a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignChannelSubtypeConfigRequest
     *        The request for UpdateCampaignChannelSubtypeConfig API.
     * @return Result of the UpdateCampaignChannelSubtypeConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignChannelSubtypeConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignChannelSubtypeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignChannelSubtypeConfigResponse updateCampaignChannelSubtypeConfig(
            UpdateCampaignChannelSubtypeConfigRequest updateCampaignChannelSubtypeConfigRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException, AwsServiceException,
            SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the channel subtype config of a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignChannelSubtypeConfigRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCampaignChannelSubtypeConfigRequest#builder()}
     * </p>
     *
     * @param updateCampaignChannelSubtypeConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignChannelSubtypeConfigRequest.Builder}
     *        to create a request. The request for UpdateCampaignChannelSubtypeConfig API.
     * @return Result of the UpdateCampaignChannelSubtypeConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignChannelSubtypeConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignChannelSubtypeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignChannelSubtypeConfigResponse updateCampaignChannelSubtypeConfig(
            Consumer<UpdateCampaignChannelSubtypeConfigRequest.Builder> updateCampaignChannelSubtypeConfigRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return updateCampaignChannelSubtypeConfig(UpdateCampaignChannelSubtypeConfigRequest.builder()
                .applyMutation(updateCampaignChannelSubtypeConfigRequest).build());
    }

    /**
     * <p>
     * Updates the communication limits config for a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignCommunicationLimitsRequest
     *        The request for UpdateCampaignCommunicationLimits API.
     * @return Result of the UpdateCampaignCommunicationLimits operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignCommunicationLimits
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignCommunicationLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignCommunicationLimitsResponse updateCampaignCommunicationLimits(
            UpdateCampaignCommunicationLimitsRequest updateCampaignCommunicationLimitsRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the communication limits config for a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignCommunicationLimitsRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCampaignCommunicationLimitsRequest#builder()}
     * </p>
     *
     * @param updateCampaignCommunicationLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignCommunicationLimitsRequest.Builder}
     *        to create a request. The request for UpdateCampaignCommunicationLimits API.
     * @return Result of the UpdateCampaignCommunicationLimits operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignCommunicationLimits
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignCommunicationLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignCommunicationLimitsResponse updateCampaignCommunicationLimits(
            Consumer<UpdateCampaignCommunicationLimitsRequest.Builder> updateCampaignCommunicationLimitsRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        return updateCampaignCommunicationLimits(UpdateCampaignCommunicationLimitsRequest.builder()
                .applyMutation(updateCampaignCommunicationLimitsRequest).build());
    }

    /**
     * <p>
     * Updates the communication time config for a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignCommunicationTimeRequest
     *        The request for UpdateCampaignCommunicationTime API.
     * @return Result of the UpdateCampaignCommunicationTime operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignCommunicationTime
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignCommunicationTime"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignCommunicationTimeResponse updateCampaignCommunicationTime(
            UpdateCampaignCommunicationTimeRequest updateCampaignCommunicationTimeRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the communication time config for a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignCommunicationTimeRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCampaignCommunicationTimeRequest#builder()}
     * </p>
     *
     * @param updateCampaignCommunicationTimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignCommunicationTimeRequest.Builder}
     *        to create a request. The request for UpdateCampaignCommunicationTime API.
     * @return Result of the UpdateCampaignCommunicationTime operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignCommunicationTime
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignCommunicationTime"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignCommunicationTimeResponse updateCampaignCommunicationTime(
            Consumer<UpdateCampaignCommunicationTimeRequest.Builder> updateCampaignCommunicationTimeRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        return updateCampaignCommunicationTime(UpdateCampaignCommunicationTimeRequest.builder()
                .applyMutation(updateCampaignCommunicationTimeRequest).build());
    }

    /**
     * <p>
     * Updates the campaign flow associated with a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignFlowAssociationRequest
     *        The request for UpdateCampaignFlowAssociation API.
     * @return Result of the UpdateCampaignFlowAssociation operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignFlowAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignFlowAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignFlowAssociationResponse updateCampaignFlowAssociation(
            UpdateCampaignFlowAssociationRequest updateCampaignFlowAssociationRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the campaign flow associated with a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignFlowAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCampaignFlowAssociationRequest#builder()}
     * </p>
     *
     * @param updateCampaignFlowAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignFlowAssociationRequest.Builder}
     *        to create a request. The request for UpdateCampaignFlowAssociation API.
     * @return Result of the UpdateCampaignFlowAssociation operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignFlowAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignFlowAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignFlowAssociationResponse updateCampaignFlowAssociation(
            Consumer<UpdateCampaignFlowAssociationRequest.Builder> updateCampaignFlowAssociationRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        return updateCampaignFlowAssociation(UpdateCampaignFlowAssociationRequest.builder()
                .applyMutation(updateCampaignFlowAssociationRequest).build());
    }

    /**
     * <p>
     * Updates the name of a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignNameRequest
     *        The request for UpdateCampaignName API.
     * @return Result of the UpdateCampaignName operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignName"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignNameResponse updateCampaignName(UpdateCampaignNameRequest updateCampaignNameRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name of a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignNameRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateCampaignNameRequest#builder()}
     * </p>
     *
     * @param updateCampaignNameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignNameRequest.Builder} to
     *        create a request. The request for UpdateCampaignName API.
     * @return Result of the UpdateCampaignName operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignName"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignNameResponse updateCampaignName(Consumer<UpdateCampaignNameRequest.Builder> updateCampaignNameRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return updateCampaignName(UpdateCampaignNameRequest.builder().applyMutation(updateCampaignNameRequest).build());
    }

    /**
     * <p>
     * Updates the schedule for a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignScheduleRequest
     *        The request for UpdateCampaignSchedule API.
     * @return Result of the UpdateCampaignSchedule operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignScheduleResponse updateCampaignSchedule(UpdateCampaignScheduleRequest updateCampaignScheduleRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the schedule for a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateCampaignScheduleRequest#builder()}
     * </p>
     *
     * @param updateCampaignScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignScheduleRequest.Builder} to
     *        create a request. The request for UpdateCampaignSchedule API.
     * @return Result of the UpdateCampaignSchedule operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignScheduleResponse updateCampaignSchedule(
            Consumer<UpdateCampaignScheduleRequest.Builder> updateCampaignScheduleRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return updateCampaignSchedule(UpdateCampaignScheduleRequest.builder().applyMutation(updateCampaignScheduleRequest)
                .build());
    }

    /**
     * <p>
     * Updates the campaign source with a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignSourceRequest
     *        The request for UpdateCampaignSource API.
     * @return Result of the UpdateCampaignSource operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignSource"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignSourceResponse updateCampaignSource(UpdateCampaignSourceRequest updateCampaignSourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the campaign source with a campaign. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignSourceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateCampaignSourceRequest#builder()}
     * </p>
     *
     * @param updateCampaignSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignSourceRequest.Builder} to
     *        create a request. The request for UpdateCampaignSource API.
     * @return Result of the UpdateCampaignSource operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignSource"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCampaignSourceResponse updateCampaignSource(
            Consumer<UpdateCampaignSourceRequest.Builder> updateCampaignSourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        return updateCampaignSource(UpdateCampaignSourceRequest.builder().applyMutation(updateCampaignSourceRequest).build());
    }

    /**
     * Create a {@link ConnectCampaignsV2Client} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ConnectCampaignsV2Client create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ConnectCampaignsV2Client}.
     */
    static ConnectCampaignsV2ClientBuilder builder() {
        return new DefaultConnectCampaignsV2ClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ConnectCampaignsV2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
