/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.connectcampaignsv2.internal.ConnectCampaignsV2ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.connectcampaignsv2.model.AccessDeniedException;
import software.amazon.awssdk.services.connectcampaignsv2.model.ConflictException;
import software.amazon.awssdk.services.connectcampaignsv2.model.ConnectCampaignsV2Exception;
import software.amazon.awssdk.services.connectcampaignsv2.model.CreateCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.CreateCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignChannelSubtypeConfigRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignChannelSubtypeConfigResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignCommunicationLimitsRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignCommunicationLimitsResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignCommunicationTimeRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignCommunicationTimeResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteConnectInstanceConfigRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteConnectInstanceConfigResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteConnectInstanceIntegrationRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteConnectInstanceIntegrationResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteInstanceOnboardingJobRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DeleteInstanceOnboardingJobResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.DescribeCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.DescribeCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetCampaignStateBatchRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetCampaignStateBatchResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetCampaignStateRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetCampaignStateResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetConnectInstanceConfigRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetConnectInstanceConfigResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetInstanceOnboardingJobStatusRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetInstanceOnboardingJobStatusResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.InternalServerException;
import software.amazon.awssdk.services.connectcampaignsv2.model.InvalidCampaignStateException;
import software.amazon.awssdk.services.connectcampaignsv2.model.InvalidStateException;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListCampaignsResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.PauseCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.PauseCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.PutConnectInstanceIntegrationRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.PutConnectInstanceIntegrationResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.PutOutboundRequestBatchRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.PutOutboundRequestBatchResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.PutProfileOutboundRequestBatchRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.PutProfileOutboundRequestBatchResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.connectcampaignsv2.model.ResumeCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.ResumeCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.connectcampaignsv2.model.StartCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.StartCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.StartInstanceOnboardingJobRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.StartInstanceOnboardingJobResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.StopCampaignRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.StopCampaignResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.TagResourceRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.TagResourceResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.ThrottlingException;
import software.amazon.awssdk.services.connectcampaignsv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignChannelSubtypeConfigRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignChannelSubtypeConfigResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignCommunicationLimitsRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignCommunicationLimitsResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignCommunicationTimeRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignCommunicationTimeResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignFlowAssociationRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignFlowAssociationResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignNameRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignNameResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignScheduleRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignScheduleResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignSourceRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.UpdateCampaignSourceResponse;
import software.amazon.awssdk.services.connectcampaignsv2.model.ValidationException;
import software.amazon.awssdk.services.connectcampaignsv2.transform.CreateCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.DeleteCampaignChannelSubtypeConfigRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.DeleteCampaignCommunicationLimitsRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.DeleteCampaignCommunicationTimeRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.DeleteCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.DeleteConnectInstanceConfigRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.DeleteConnectInstanceIntegrationRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.DeleteInstanceOnboardingJobRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.DescribeCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.GetCampaignStateBatchRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.GetCampaignStateRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.GetConnectInstanceConfigRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.GetInstanceOnboardingJobStatusRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.ListCampaignsRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.ListConnectInstanceIntegrationsRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.PauseCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.PutConnectInstanceIntegrationRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.PutOutboundRequestBatchRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.PutProfileOutboundRequestBatchRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.ResumeCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.StartCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.StartInstanceOnboardingJobRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.StopCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.UpdateCampaignChannelSubtypeConfigRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.UpdateCampaignCommunicationLimitsRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.UpdateCampaignCommunicationTimeRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.UpdateCampaignFlowAssociationRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.UpdateCampaignNameRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.UpdateCampaignScheduleRequestMarshaller;
import software.amazon.awssdk.services.connectcampaignsv2.transform.UpdateCampaignSourceRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link ConnectCampaignsV2Client}.
 *
 * @see ConnectCampaignsV2Client#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultConnectCampaignsV2Client implements ConnectCampaignsV2Client {
    private static final Logger log = Logger.loggerFor(DefaultConnectCampaignsV2Client.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultConnectCampaignsV2Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates a campaign for the specified Amazon Connect account. This API is idempotent.
     * </p>
     *
     * @param createCampaignRequest
     *        The request for CreateCampaign API.
     * @return Result of the CreateCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/CreateCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCampaignResponse createCampaign(CreateCampaignRequest createCampaignRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCampaign");

            return clientHandler.execute(new ClientExecutionParams<CreateCampaignRequest, CreateCampaignResponse>()
                    .withOperationName("CreateCampaign").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createCampaignRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCampaignRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a campaign from the specified Amazon Connect account.
     * </p>
     *
     * @param deleteCampaignRequest
     *        The request for DeleteCampaign API.
     * @return Result of the DeleteCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCampaignResponse deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCampaign");

            return clientHandler.execute(new ClientExecutionParams<DeleteCampaignRequest, DeleteCampaignResponse>()
                    .withOperationName("DeleteCampaign").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCampaignRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCampaignRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the channel subtype config of a campaign. This API is idempotent.
     * </p>
     *
     * @param deleteCampaignChannelSubtypeConfigRequest
     *        The request for DeleteCampaignChannelSubtypeConfig API.
     * @return Result of the DeleteCampaignChannelSubtypeConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteCampaignChannelSubtypeConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaignChannelSubtypeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCampaignChannelSubtypeConfigResponse deleteCampaignChannelSubtypeConfig(
            DeleteCampaignChannelSubtypeConfigRequest deleteCampaignChannelSubtypeConfigRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException, AwsServiceException,
            SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCampaignChannelSubtypeConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCampaignChannelSubtypeConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCampaignChannelSubtypeConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCampaignChannelSubtypeConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCampaignChannelSubtypeConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCampaignChannelSubtypeConfigRequest, DeleteCampaignChannelSubtypeConfigResponse>()
                            .withOperationName("DeleteCampaignChannelSubtypeConfig").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteCampaignChannelSubtypeConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCampaignChannelSubtypeConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the communication limits config for a campaign. This API is idempotent.
     * </p>
     *
     * @param deleteCampaignCommunicationLimitsRequest
     *        The request for DeleteCampaignCommunicationLimits API.
     * @return Result of the DeleteCampaignCommunicationLimits operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteCampaignCommunicationLimits
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaignCommunicationLimits"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCampaignCommunicationLimitsResponse deleteCampaignCommunicationLimits(
            DeleteCampaignCommunicationLimitsRequest deleteCampaignCommunicationLimitsRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCampaignCommunicationLimitsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCampaignCommunicationLimitsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCampaignCommunicationLimitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCampaignCommunicationLimitsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCampaignCommunicationLimits");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCampaignCommunicationLimitsRequest, DeleteCampaignCommunicationLimitsResponse>()
                            .withOperationName("DeleteCampaignCommunicationLimits").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteCampaignCommunicationLimitsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCampaignCommunicationLimitsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the communication time config for a campaign. This API is idempotent.
     * </p>
     *
     * @param deleteCampaignCommunicationTimeRequest
     *        The request for DeleteCampaignCommunicationTime API.
     * @return Result of the DeleteCampaignCommunicationTime operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteCampaignCommunicationTime
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteCampaignCommunicationTime"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCampaignCommunicationTimeResponse deleteCampaignCommunicationTime(
            DeleteCampaignCommunicationTimeRequest deleteCampaignCommunicationTimeRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCampaignCommunicationTimeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCampaignCommunicationTimeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCampaignCommunicationTimeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCampaignCommunicationTimeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCampaignCommunicationTime");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCampaignCommunicationTimeRequest, DeleteCampaignCommunicationTimeResponse>()
                            .withOperationName("DeleteCampaignCommunicationTime").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteCampaignCommunicationTimeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCampaignCommunicationTimeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a connect instance config from the specified AWS account.
     * </p>
     *
     * @param deleteConnectInstanceConfigRequest
     *        The request for DeleteConnectInstanceConfig API.
     * @return Result of the DeleteConnectInstanceConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidStateException
     *         The request could not be processed because of conflict in the current state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteConnectInstanceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteConnectInstanceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConnectInstanceConfigResponse deleteConnectInstanceConfig(
            DeleteConnectInstanceConfigRequest deleteConnectInstanceConfigRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, InvalidStateException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConnectInstanceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteConnectInstanceConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConnectInstanceConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConnectInstanceConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConnectInstanceConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteConnectInstanceConfigRequest, DeleteConnectInstanceConfigResponse>()
                            .withOperationName("DeleteConnectInstanceConfig").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteConnectInstanceConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteConnectInstanceConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete the integration for the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteConnectInstanceIntegrationRequest
     *        The request for DeleteConnectInstanceIntegration API.
     * @return Result of the DeleteConnectInstanceIntegration operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteConnectInstanceIntegration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteConnectInstanceIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConnectInstanceIntegrationResponse deleteConnectInstanceIntegration(
            DeleteConnectInstanceIntegrationRequest deleteConnectInstanceIntegrationRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConnectInstanceIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteConnectInstanceIntegrationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConnectInstanceIntegrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteConnectInstanceIntegrationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConnectInstanceIntegration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteConnectInstanceIntegrationRequest, DeleteConnectInstanceIntegrationResponse>()
                            .withOperationName("DeleteConnectInstanceIntegration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteConnectInstanceIntegrationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteConnectInstanceIntegrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteInstanceOnboardingJobRequest
     *        The request for DeleteInstanceOnboardingJob API.
     * @return Result of the DeleteInstanceOnboardingJob operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidStateException
     *         The request could not be processed because of conflict in the current state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DeleteInstanceOnboardingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DeleteInstanceOnboardingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteInstanceOnboardingJobResponse deleteInstanceOnboardingJob(
            DeleteInstanceOnboardingJobRequest deleteInstanceOnboardingJobRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, InvalidStateException, AwsServiceException,
            SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteInstanceOnboardingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteInstanceOnboardingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInstanceOnboardingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInstanceOnboardingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInstanceOnboardingJob");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteInstanceOnboardingJobRequest, DeleteInstanceOnboardingJobResponse>()
                            .withOperationName("DeleteInstanceOnboardingJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteInstanceOnboardingJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteInstanceOnboardingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specific campaign.
     * </p>
     *
     * @param describeCampaignRequest
     *        The request for DescribeCampaign API.
     * @return Result of the DescribeCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.DescribeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/DescribeCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeCampaignResponse describeCampaign(DescribeCampaignRequest describeCampaignRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCampaignRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCampaign");

            return clientHandler.execute(new ClientExecutionParams<DescribeCampaignRequest, DescribeCampaignResponse>()
                    .withOperationName("DescribeCampaign").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeCampaignRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeCampaignRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get state of a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param getCampaignStateRequest
     *        The request for GetCampaignState API.
     * @return Result of the GetCampaignState operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.GetCampaignState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetCampaignState"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCampaignStateResponse getCampaignState(GetCampaignStateRequest getCampaignStateRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCampaignStateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCampaignStateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCampaignStateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignStateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaignState");

            return clientHandler.execute(new ClientExecutionParams<GetCampaignStateRequest, GetCampaignStateResponse>()
                    .withOperationName("GetCampaignState").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getCampaignStateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCampaignStateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get state of campaigns for the specified Amazon Connect account.
     * </p>
     *
     * @param getCampaignStateBatchRequest
     *        The request for GetCampaignStateBatch API.
     * @return Result of the GetCampaignStateBatch operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.GetCampaignStateBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetCampaignStateBatch"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCampaignStateBatchResponse getCampaignStateBatch(GetCampaignStateBatchRequest getCampaignStateBatchRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCampaignStateBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCampaignStateBatchResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCampaignStateBatchRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignStateBatchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaignStateBatch");

            return clientHandler.execute(new ClientExecutionParams<GetCampaignStateBatchRequest, GetCampaignStateBatchResponse>()
                    .withOperationName("GetCampaignStateBatch").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getCampaignStateBatchRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCampaignStateBatchRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the specific Connect instance config.
     * </p>
     *
     * @param getConnectInstanceConfigRequest
     *        The request for GetConnectInstanceConfig API.
     * @return Result of the GetConnectInstanceConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.GetConnectInstanceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetConnectInstanceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetConnectInstanceConfigResponse getConnectInstanceConfig(
            GetConnectInstanceConfigRequest getConnectInstanceConfigRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetConnectInstanceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetConnectInstanceConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getConnectInstanceConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getConnectInstanceConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConnectInstanceConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<GetConnectInstanceConfigRequest, GetConnectInstanceConfigResponse>()
                            .withOperationName("GetConnectInstanceConfig").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getConnectInstanceConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetConnectInstanceConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the specific instance onboarding job status.
     * </p>
     *
     * @param getInstanceOnboardingJobStatusRequest
     *        The request for GetInstanceOnboardingJobStatus API.
     * @return Result of the GetInstanceOnboardingJobStatus operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.GetInstanceOnboardingJobStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/GetInstanceOnboardingJobStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetInstanceOnboardingJobStatusResponse getInstanceOnboardingJobStatus(
            GetInstanceOnboardingJobStatusRequest getInstanceOnboardingJobStatusRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetInstanceOnboardingJobStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetInstanceOnboardingJobStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getInstanceOnboardingJobStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getInstanceOnboardingJobStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInstanceOnboardingJobStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<GetInstanceOnboardingJobStatusRequest, GetInstanceOnboardingJobStatusResponse>()
                            .withOperationName("GetInstanceOnboardingJobStatus").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getInstanceOnboardingJobStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetInstanceOnboardingJobStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides summary information about the campaigns under the specified Amazon Connect account.
     * </p>
     *
     * @param listCampaignsRequest
     *        The request for ListCampaigns API.
     * @return Result of the ListCampaigns operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCampaignsResponse listCampaigns(ListCampaignsRequest listCampaignsRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCampaignsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListCampaignsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCampaignsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCampaignsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCampaigns");

            return clientHandler.execute(new ClientExecutionParams<ListCampaignsRequest, ListCampaignsResponse>()
                    .withOperationName("ListCampaigns").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listCampaignsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCampaignsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides summary information about the integration under the specified Connect instance.
     * </p>
     *
     * @param listConnectInstanceIntegrationsRequest
     *        The request for ListConnectInstanceIntegrations API.
     * @return Result of the ListConnectInstanceIntegrations operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.ListConnectInstanceIntegrations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListConnectInstanceIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListConnectInstanceIntegrationsResponse listConnectInstanceIntegrations(
            ListConnectInstanceIntegrationsRequest listConnectInstanceIntegrationsRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListConnectInstanceIntegrationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListConnectInstanceIntegrationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listConnectInstanceIntegrationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listConnectInstanceIntegrationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConnectInstanceIntegrations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListConnectInstanceIntegrationsRequest, ListConnectInstanceIntegrationsResponse>()
                            .withOperationName("ListConnectInstanceIntegrations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listConnectInstanceIntegrationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListConnectInstanceIntegrationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        The request for ListTagsForResource API.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Pauses a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param pauseCampaignRequest
     *        The request for PauseCampaign API.
     * @return Result of the PauseCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.PauseCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PauseCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PauseCampaignResponse pauseCampaign(PauseCampaignRequest pauseCampaignRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PauseCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PauseCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(pauseCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, pauseCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PauseCampaign");

            return clientHandler.execute(new ClientExecutionParams<PauseCampaignRequest, PauseCampaignResponse>()
                    .withOperationName("PauseCampaign").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(pauseCampaignRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PauseCampaignRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Put or update the integration for the specified Amazon Connect instance.
     * </p>
     *
     * @param putConnectInstanceIntegrationRequest
     *        The request for PutConnectInstanceIntegration API.
     * @return Result of the PutConnectInstanceIntegration operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.PutConnectInstanceIntegration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PutConnectInstanceIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutConnectInstanceIntegrationResponse putConnectInstanceIntegration(
            PutConnectInstanceIntegrationRequest putConnectInstanceIntegrationRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutConnectInstanceIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutConnectInstanceIntegrationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putConnectInstanceIntegrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putConnectInstanceIntegrationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutConnectInstanceIntegration");

            return clientHandler
                    .execute(new ClientExecutionParams<PutConnectInstanceIntegrationRequest, PutConnectInstanceIntegrationResponse>()
                            .withOperationName("PutConnectInstanceIntegration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putConnectInstanceIntegrationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutConnectInstanceIntegrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates outbound requests for the specified campaign Amazon Connect account. This API is idempotent.
     * </p>
     *
     * @param putOutboundRequestBatchRequest
     *        The request for PutOutboundRequestBatch API.
     * @return Result of the PutOutboundRequestBatch operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.PutOutboundRequestBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PutOutboundRequestBatch"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutOutboundRequestBatchResponse putOutboundRequestBatch(PutOutboundRequestBatchRequest putOutboundRequestBatchRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutOutboundRequestBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutOutboundRequestBatchResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putOutboundRequestBatchRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putOutboundRequestBatchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutOutboundRequestBatch");

            return clientHandler
                    .execute(new ClientExecutionParams<PutOutboundRequestBatchRequest, PutOutboundRequestBatchResponse>()
                            .withOperationName("PutOutboundRequestBatch").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putOutboundRequestBatchRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutOutboundRequestBatchRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Takes in a list of profile outbound requests to be placed as part of an outbound campaign. This API is
     * idempotent.
     * </p>
     *
     * @param putProfileOutboundRequestBatchRequest
     *        The request for PutProfileOutboundRequestBatch API
     * @return Result of the PutProfileOutboundRequestBatch operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.PutProfileOutboundRequestBatch
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PutProfileOutboundRequestBatch"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutProfileOutboundRequestBatchResponse putProfileOutboundRequestBatch(
            PutProfileOutboundRequestBatchRequest putProfileOutboundRequestBatchRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutProfileOutboundRequestBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutProfileOutboundRequestBatchResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putProfileOutboundRequestBatchRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putProfileOutboundRequestBatchRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutProfileOutboundRequestBatch");

            return clientHandler
                    .execute(new ClientExecutionParams<PutProfileOutboundRequestBatchRequest, PutProfileOutboundRequestBatchResponse>()
                            .withOperationName("PutProfileOutboundRequestBatch").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putProfileOutboundRequestBatchRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutProfileOutboundRequestBatchRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param resumeCampaignRequest
     *        The request for ResumeCampaign API.
     * @return Result of the ResumeCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.ResumeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/ResumeCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ResumeCampaignResponse resumeCampaign(ResumeCampaignRequest resumeCampaignRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ResumeCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ResumeCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resumeCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resumeCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResumeCampaign");

            return clientHandler.execute(new ClientExecutionParams<ResumeCampaignRequest, ResumeCampaignResponse>()
                    .withOperationName("ResumeCampaign").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(resumeCampaignRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ResumeCampaignRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param startCampaignRequest
     *        The request for StartCampaign API.
     * @return Result of the StartCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.StartCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/StartCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartCampaignResponse startCampaign(StartCampaignRequest startCampaignRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartCampaign");

            return clientHandler.execute(new ClientExecutionParams<StartCampaignRequest, StartCampaignResponse>()
                    .withOperationName("StartCampaign").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startCampaignRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartCampaignRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Onboard the specific Amazon Connect instance to Connect Campaigns.
     * </p>
     *
     * @param startInstanceOnboardingJobRequest
     *        The request for StartInstanceOnboardingJob API.
     * @return Result of the StartInstanceOnboardingJob operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.StartInstanceOnboardingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/StartInstanceOnboardingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartInstanceOnboardingJobResponse startInstanceOnboardingJob(
            StartInstanceOnboardingJobRequest startInstanceOnboardingJobRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartInstanceOnboardingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartInstanceOnboardingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startInstanceOnboardingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startInstanceOnboardingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartInstanceOnboardingJob");

            return clientHandler
                    .execute(new ClientExecutionParams<StartInstanceOnboardingJobRequest, StartInstanceOnboardingJobResponse>()
                            .withOperationName("StartInstanceOnboardingJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startInstanceOnboardingJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartInstanceOnboardingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops a campaign for the specified Amazon Connect account.
     * </p>
     *
     * @param stopCampaignRequest
     *        The request for StopCampaign API.
     * @return Result of the StopCampaign operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.StopCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/StopCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopCampaignResponse stopCampaign(StopCampaignRequest stopCampaignRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopCampaign");

            return clientHandler.execute(new ClientExecutionParams<StopCampaignRequest, StopCampaignResponse>()
                    .withOperationName("StopCampaign").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(stopCampaignRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopCampaignRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Tag a resource.
     * </p>
     *
     * @param tagResourceRequest
     *        The request for TagResource API.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Untag a resource.
     * </p>
     *
     * @param untagResourceRequest
     *        The request for UntagResource API.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the channel subtype config of a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignChannelSubtypeConfigRequest
     *        The request for UpdateCampaignChannelSubtypeConfig API.
     * @return Result of the UpdateCampaignChannelSubtypeConfig operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignChannelSubtypeConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignChannelSubtypeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCampaignChannelSubtypeConfigResponse updateCampaignChannelSubtypeConfig(
            UpdateCampaignChannelSubtypeConfigRequest updateCampaignChannelSubtypeConfigRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException, AwsServiceException,
            SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCampaignChannelSubtypeConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCampaignChannelSubtypeConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCampaignChannelSubtypeConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCampaignChannelSubtypeConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCampaignChannelSubtypeConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateCampaignChannelSubtypeConfigRequest, UpdateCampaignChannelSubtypeConfigResponse>()
                            .withOperationName("UpdateCampaignChannelSubtypeConfig").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateCampaignChannelSubtypeConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateCampaignChannelSubtypeConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the communication limits config for a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignCommunicationLimitsRequest
     *        The request for UpdateCampaignCommunicationLimits API.
     * @return Result of the UpdateCampaignCommunicationLimits operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignCommunicationLimits
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignCommunicationLimits"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCampaignCommunicationLimitsResponse updateCampaignCommunicationLimits(
            UpdateCampaignCommunicationLimitsRequest updateCampaignCommunicationLimitsRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCampaignCommunicationLimitsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCampaignCommunicationLimitsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCampaignCommunicationLimitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCampaignCommunicationLimitsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCampaignCommunicationLimits");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateCampaignCommunicationLimitsRequest, UpdateCampaignCommunicationLimitsResponse>()
                            .withOperationName("UpdateCampaignCommunicationLimits").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateCampaignCommunicationLimitsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateCampaignCommunicationLimitsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the communication time config for a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignCommunicationTimeRequest
     *        The request for UpdateCampaignCommunicationTime API.
     * @return Result of the UpdateCampaignCommunicationTime operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignCommunicationTime
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignCommunicationTime"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCampaignCommunicationTimeResponse updateCampaignCommunicationTime(
            UpdateCampaignCommunicationTimeRequest updateCampaignCommunicationTimeRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCampaignCommunicationTimeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCampaignCommunicationTimeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCampaignCommunicationTimeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCampaignCommunicationTimeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCampaignCommunicationTime");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateCampaignCommunicationTimeRequest, UpdateCampaignCommunicationTimeResponse>()
                            .withOperationName("UpdateCampaignCommunicationTime").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateCampaignCommunicationTimeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateCampaignCommunicationTimeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the campaign flow associated with a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignFlowAssociationRequest
     *        The request for UpdateCampaignFlowAssociation API.
     * @return Result of the UpdateCampaignFlowAssociation operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignFlowAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignFlowAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCampaignFlowAssociationResponse updateCampaignFlowAssociation(
            UpdateCampaignFlowAssociationRequest updateCampaignFlowAssociationRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCampaignFlowAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCampaignFlowAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCampaignFlowAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCampaignFlowAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCampaignFlowAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateCampaignFlowAssociationRequest, UpdateCampaignFlowAssociationResponse>()
                            .withOperationName("UpdateCampaignFlowAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateCampaignFlowAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateCampaignFlowAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the name of a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignNameRequest
     *        The request for UpdateCampaignName API.
     * @return Result of the UpdateCampaignName operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignName"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCampaignNameResponse updateCampaignName(UpdateCampaignNameRequest updateCampaignNameRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCampaignNameResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCampaignNameResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCampaignNameRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCampaignNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCampaignName");

            return clientHandler.execute(new ClientExecutionParams<UpdateCampaignNameRequest, UpdateCampaignNameResponse>()
                    .withOperationName("UpdateCampaignName").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateCampaignNameRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateCampaignNameRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the schedule for a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignScheduleRequest
     *        The request for UpdateCampaignSchedule API.
     * @return Result of the UpdateCampaignSchedule operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCampaignScheduleResponse updateCampaignSchedule(UpdateCampaignScheduleRequest updateCampaignScheduleRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCampaignScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCampaignScheduleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCampaignScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCampaignScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCampaignSchedule");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateCampaignScheduleRequest, UpdateCampaignScheduleResponse>()
                            .withOperationName("UpdateCampaignSchedule").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateCampaignScheduleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateCampaignScheduleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the campaign source with a campaign. This API is idempotent.
     * </p>
     *
     * @param updateCampaignSourceRequest
     *        The request for UpdateCampaignSource API.
     * @return Result of the UpdateCampaignSource operation returned by the service.
     * @throws InternalServerException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws InvalidCampaignStateException
     *         The request could not be processed because of conflict in the current state of the campaign.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectCampaignsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectCampaignsV2Client.UpdateCampaignSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignSource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCampaignSourceResponse updateCampaignSource(UpdateCampaignSourceRequest updateCampaignSourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException,
            InvalidCampaignStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectCampaignsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCampaignSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCampaignSourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCampaignSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCampaignSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ConnectCampaignsV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCampaignSource");

            return clientHandler.execute(new ClientExecutionParams<UpdateCampaignSourceRequest, UpdateCampaignSourceResponse>()
                    .withOperationName("UpdateCampaignSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateCampaignSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateCampaignSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        ConnectCampaignsV2ServiceClientConfigurationBuilder serviceConfigBuilder = new ConnectCampaignsV2ServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ConnectCampaignsV2Exception::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCampaignStateException")
                                .exceptionBuilderSupplier(InvalidCampaignStateException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidStateException")
                                .exceptionBuilderSupplier(InvalidStateException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build());
    }

    @Override
    public final ConnectCampaignsV2ServiceClientConfiguration serviceClientConfiguration() {
        return new ConnectCampaignsV2ServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
