/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Communication limits
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommunicationLimits implements SdkPojo, Serializable,
        ToCopyableBuilder<CommunicationLimits.Builder, CommunicationLimits> {
    private static final SdkField<List<CommunicationLimit>> COMMUNICATION_LIMITS_LIST_FIELD = SdkField
            .<List<CommunicationLimit>> builder(MarshallingType.LIST)
            .memberName("communicationLimitsList")
            .getter(getter(CommunicationLimits::communicationLimitsList))
            .setter(setter(Builder::communicationLimitsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("communicationLimitsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CommunicationLimit> builder(MarshallingType.SDK_POJO)
                                            .constructor(CommunicationLimit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COMMUNICATION_LIMITS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CommunicationLimit> communicationLimitsList;

    private final Type type;

    private CommunicationLimits(BuilderImpl builder) {
        this.communicationLimitsList = builder.communicationLimitsList;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the CommunicationLimitsList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCommunicationLimitsList() {
        return communicationLimitsList != null && !(communicationLimitsList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the CommunicationLimitsList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommunicationLimitsList} method.
     * </p>
     * 
     * @return The value of the CommunicationLimitsList property for this object.
     */
    public final List<CommunicationLimit> communicationLimitsList() {
        return communicationLimitsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCommunicationLimitsList() ? communicationLimitsList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommunicationLimits)) {
            return false;
        }
        CommunicationLimits other = (CommunicationLimits) obj;
        return hasCommunicationLimitsList() == other.hasCommunicationLimitsList()
                && Objects.equals(communicationLimitsList(), other.communicationLimitsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommunicationLimits")
                .add("CommunicationLimitsList", hasCommunicationLimitsList() ? communicationLimitsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "communicationLimitsList":
            return Optional.ofNullable(clazz.cast(communicationLimitsList()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #communicationLimitsList()} initialized to the given value.
     *
     * Sets the value of the CommunicationLimitsList property for this object.
     *
     * @param communicationLimitsList
     *        The new value for the CommunicationLimitsList property for this object.
     */
    public static CommunicationLimits fromCommunicationLimitsList(List<CommunicationLimit> communicationLimitsList) {
        return builder().communicationLimitsList(communicationLimitsList).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("communicationLimitsList", COMMUNICATION_LIMITS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommunicationLimits, T> g) {
        return obj -> g.apply((CommunicationLimits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommunicationLimits> {
        /**
         * Sets the value of the CommunicationLimitsList property for this object.
         *
         * @param communicationLimitsList
         *        The new value for the CommunicationLimitsList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communicationLimitsList(Collection<CommunicationLimit> communicationLimitsList);

        /**
         * Sets the value of the CommunicationLimitsList property for this object.
         *
         * @param communicationLimitsList
         *        The new value for the CommunicationLimitsList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communicationLimitsList(CommunicationLimit... communicationLimitsList);

        /**
         * Sets the value of the CommunicationLimitsList property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcampaignsv2.model.CommunicationLimit.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.connectcampaignsv2.model.CommunicationLimit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcampaignsv2.model.CommunicationLimit.Builder#build()} is called
         * immediately and its result is passed to {@link #communicationLimitsList(List<CommunicationLimit>)}.
         * 
         * @param communicationLimitsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.CommunicationLimit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #communicationLimitsList(java.util.Collection<CommunicationLimit>)
         */
        Builder communicationLimitsList(Consumer<CommunicationLimit.Builder>... communicationLimitsList);
    }

    static final class BuilderImpl implements Builder {
        private List<CommunicationLimit> communicationLimitsList = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CommunicationLimits model) {
            communicationLimitsList(model.communicationLimitsList);
        }

        public final List<CommunicationLimit.Builder> getCommunicationLimitsList() {
            List<CommunicationLimit.Builder> result = CommunicationLimitListCopier.copyToBuilder(this.communicationLimitsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommunicationLimitsList(Collection<CommunicationLimit.BuilderImpl> communicationLimitsList) {
            Object oldValue = this.communicationLimitsList;
            this.communicationLimitsList = CommunicationLimitListCopier.copyFromBuilder(communicationLimitsList);
            handleUnionValueChange(Type.COMMUNICATION_LIMITS_LIST, oldValue, this.communicationLimitsList);
        }

        @Override
        public final Builder communicationLimitsList(Collection<CommunicationLimit> communicationLimitsList) {
            Object oldValue = this.communicationLimitsList;
            this.communicationLimitsList = CommunicationLimitListCopier.copy(communicationLimitsList);
            handleUnionValueChange(Type.COMMUNICATION_LIMITS_LIST, oldValue, this.communicationLimitsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communicationLimitsList(CommunicationLimit... communicationLimitsList) {
            communicationLimitsList(Arrays.asList(communicationLimitsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communicationLimitsList(Consumer<CommunicationLimit.Builder>... communicationLimitsList) {
            communicationLimitsList(Stream.of(communicationLimitsList)
                    .map(c -> CommunicationLimit.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CommunicationLimits build() {
            return new CommunicationLimits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CommunicationLimits#type()
     */
    public enum Type {
        COMMUNICATION_LIMITS_LIST,

        UNKNOWN_TO_SDK_VERSION
    }
}
