/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Customer Profiles integration summary
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerProfilesIntegrationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomerProfilesIntegrationSummary.Builder, CustomerProfilesIntegrationSummary> {
    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainArn").getter(getter(CustomerProfilesIntegrationSummary::domainArn))
            .setter(setter(Builder::domainArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainArn").build()).build();

    private static final SdkField<Map<String, String>> OBJECT_TYPE_NAMES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("objectTypeNames")
            .getter(getter(CustomerProfilesIntegrationSummary::objectTypeNamesAsStrings))
            .setter(setter(Builder::objectTypeNamesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectTypeNames").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ARN_FIELD,
            OBJECT_TYPE_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainArn;

    private final Map<String, String> objectTypeNames;

    private CustomerProfilesIntegrationSummary(BuilderImpl builder) {
        this.domainArn = builder.domainArn;
        this.objectTypeNames = builder.objectTypeNames;
    }

    /**
     * Returns the value of the DomainArn property for this object.
     * 
     * @return The value of the DomainArn property for this object.
     */
    public final String domainArn() {
        return domainArn;
    }

    /**
     * Returns the value of the ObjectTypeNames property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasObjectTypeNames} method.
     * </p>
     * 
     * @return The value of the ObjectTypeNames property for this object.
     */
    public final Map<EventType, String> objectTypeNames() {
        return ObjectTypeNamesMapCopier.copyStringToEnum(objectTypeNames);
    }

    /**
     * For responses, this returns true if the service returned a value for the ObjectTypeNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasObjectTypeNames() {
        return objectTypeNames != null && !(objectTypeNames instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the ObjectTypeNames property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasObjectTypeNames} method.
     * </p>
     * 
     * @return The value of the ObjectTypeNames property for this object.
     */
    public final Map<String, String> objectTypeNamesAsStrings() {
        return objectTypeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasObjectTypeNames() ? objectTypeNamesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerProfilesIntegrationSummary)) {
            return false;
        }
        CustomerProfilesIntegrationSummary other = (CustomerProfilesIntegrationSummary) obj;
        return Objects.equals(domainArn(), other.domainArn()) && hasObjectTypeNames() == other.hasObjectTypeNames()
                && Objects.equals(objectTypeNamesAsStrings(), other.objectTypeNamesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomerProfilesIntegrationSummary").add("DomainArn", domainArn())
                .add("ObjectTypeNames", hasObjectTypeNames() ? objectTypeNamesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainArn":
            return Optional.ofNullable(clazz.cast(domainArn()));
        case "objectTypeNames":
            return Optional.ofNullable(clazz.cast(objectTypeNamesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainArn", DOMAIN_ARN_FIELD);
        map.put("objectTypeNames", OBJECT_TYPE_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomerProfilesIntegrationSummary, T> g) {
        return obj -> g.apply((CustomerProfilesIntegrationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerProfilesIntegrationSummary> {
        /**
         * Sets the value of the DomainArn property for this object.
         *
         * @param domainArn
         *        The new value for the DomainArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainArn(String domainArn);

        /**
         * Sets the value of the ObjectTypeNames property for this object.
         *
         * @param objectTypeNames
         *        The new value for the ObjectTypeNames property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectTypeNamesWithStrings(Map<String, String> objectTypeNames);

        /**
         * Sets the value of the ObjectTypeNames property for this object.
         *
         * @param objectTypeNames
         *        The new value for the ObjectTypeNames property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectTypeNames(Map<EventType, String> objectTypeNames);
    }

    static final class BuilderImpl implements Builder {
        private String domainArn;

        private Map<String, String> objectTypeNames = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerProfilesIntegrationSummary model) {
            domainArn(model.domainArn);
            objectTypeNamesWithStrings(model.objectTypeNames);
        }

        public final String getDomainArn() {
            return domainArn;
        }

        public final void setDomainArn(String domainArn) {
            this.domainArn = domainArn;
        }

        @Override
        public final Builder domainArn(String domainArn) {
            this.domainArn = domainArn;
            return this;
        }

        public final Map<String, String> getObjectTypeNames() {
            if (objectTypeNames instanceof SdkAutoConstructMap) {
                return null;
            }
            return objectTypeNames;
        }

        public final void setObjectTypeNames(Map<String, String> objectTypeNames) {
            this.objectTypeNames = ObjectTypeNamesMapCopier.copy(objectTypeNames);
        }

        @Override
        public final Builder objectTypeNamesWithStrings(Map<String, String> objectTypeNames) {
            this.objectTypeNames = ObjectTypeNamesMapCopier.copy(objectTypeNames);
            return this;
        }

        @Override
        public final Builder objectTypeNames(Map<EventType, String> objectTypeNames) {
            this.objectTypeNames = ObjectTypeNamesMapCopier.copyEnumToString(objectTypeNames);
            return this;
        }

        @Override
        public CustomerProfilesIntegrationSummary build() {
            return new CustomerProfilesIntegrationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
