/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters for the Email Channel Subtype
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailChannelSubtypeParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailChannelSubtypeParameters.Builder, EmailChannelSubtypeParameters> {
    private static final SdkField<String> DESTINATION_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationEmailAddress").getter(getter(EmailChannelSubtypeParameters::destinationEmailAddress))
            .setter(setter(Builder::destinationEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationEmailAddress").build())
            .build();

    private static final SdkField<String> CONNECT_SOURCE_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectSourceEmailAddress").getter(getter(EmailChannelSubtypeParameters::connectSourceEmailAddress))
            .setter(setter(Builder::connectSourceEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectSourceEmailAddress").build())
            .build();

    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateArn").getter(getter(EmailChannelSubtypeParameters::templateArn))
            .setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateArn").build()).build();

    private static final SdkField<Map<String, String>> TEMPLATE_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("templateParameters")
            .getter(getter(EmailChannelSubtypeParameters::templateParameters))
            .setter(setter(Builder::templateParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DESTINATION_EMAIL_ADDRESS_FIELD, CONNECT_SOURCE_EMAIL_ADDRESS_FIELD, TEMPLATE_ARN_FIELD, TEMPLATE_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationEmailAddress;

    private final String connectSourceEmailAddress;

    private final String templateArn;

    private final Map<String, String> templateParameters;

    private EmailChannelSubtypeParameters(BuilderImpl builder) {
        this.destinationEmailAddress = builder.destinationEmailAddress;
        this.connectSourceEmailAddress = builder.connectSourceEmailAddress;
        this.templateArn = builder.templateArn;
        this.templateParameters = builder.templateParameters;
    }

    /**
     * Returns the value of the DestinationEmailAddress property for this object.
     * 
     * @return The value of the DestinationEmailAddress property for this object.
     */
    public final String destinationEmailAddress() {
        return destinationEmailAddress;
    }

    /**
     * Returns the value of the ConnectSourceEmailAddress property for this object.
     * 
     * @return The value of the ConnectSourceEmailAddress property for this object.
     */
    public final String connectSourceEmailAddress() {
        return connectSourceEmailAddress;
    }

    /**
     * Returns the value of the TemplateArn property for this object.
     * 
     * @return The value of the TemplateArn property for this object.
     */
    public final String templateArn() {
        return templateArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TemplateParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTemplateParameters() {
        return templateParameters != null && !(templateParameters instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the TemplateParameters property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTemplateParameters} method.
     * </p>
     * 
     * @return The value of the TemplateParameters property for this object.
     */
    public final Map<String, String> templateParameters() {
        return templateParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(connectSourceEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTemplateParameters() ? templateParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailChannelSubtypeParameters)) {
            return false;
        }
        EmailChannelSubtypeParameters other = (EmailChannelSubtypeParameters) obj;
        return Objects.equals(destinationEmailAddress(), other.destinationEmailAddress())
                && Objects.equals(connectSourceEmailAddress(), other.connectSourceEmailAddress())
                && Objects.equals(templateArn(), other.templateArn()) && hasTemplateParameters() == other.hasTemplateParameters()
                && Objects.equals(templateParameters(), other.templateParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailChannelSubtypeParameters")
                .add("DestinationEmailAddress", destinationEmailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConnectSourceEmailAddress", connectSourceEmailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TemplateArn", templateArn())
                .add("TemplateParameters", templateParameters() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinationEmailAddress":
            return Optional.ofNullable(clazz.cast(destinationEmailAddress()));
        case "connectSourceEmailAddress":
            return Optional.ofNullable(clazz.cast(connectSourceEmailAddress()));
        case "templateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "templateParameters":
            return Optional.ofNullable(clazz.cast(templateParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destinationEmailAddress", DESTINATION_EMAIL_ADDRESS_FIELD);
        map.put("connectSourceEmailAddress", CONNECT_SOURCE_EMAIL_ADDRESS_FIELD);
        map.put("templateArn", TEMPLATE_ARN_FIELD);
        map.put("templateParameters", TEMPLATE_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailChannelSubtypeParameters, T> g) {
        return obj -> g.apply((EmailChannelSubtypeParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailChannelSubtypeParameters> {
        /**
         * Sets the value of the DestinationEmailAddress property for this object.
         *
         * @param destinationEmailAddress
         *        The new value for the DestinationEmailAddress property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationEmailAddress(String destinationEmailAddress);

        /**
         * Sets the value of the ConnectSourceEmailAddress property for this object.
         *
         * @param connectSourceEmailAddress
         *        The new value for the ConnectSourceEmailAddress property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectSourceEmailAddress(String connectSourceEmailAddress);

        /**
         * Sets the value of the TemplateArn property for this object.
         *
         * @param templateArn
         *        The new value for the TemplateArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * Sets the value of the TemplateParameters property for this object.
         *
         * @param templateParameters
         *        The new value for the TemplateParameters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateParameters(Map<String, String> templateParameters);
    }

    static final class BuilderImpl implements Builder {
        private String destinationEmailAddress;

        private String connectSourceEmailAddress;

        private String templateArn;

        private Map<String, String> templateParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EmailChannelSubtypeParameters model) {
            destinationEmailAddress(model.destinationEmailAddress);
            connectSourceEmailAddress(model.connectSourceEmailAddress);
            templateArn(model.templateArn);
            templateParameters(model.templateParameters);
        }

        public final String getDestinationEmailAddress() {
            return destinationEmailAddress;
        }

        public final void setDestinationEmailAddress(String destinationEmailAddress) {
            this.destinationEmailAddress = destinationEmailAddress;
        }

        @Override
        public final Builder destinationEmailAddress(String destinationEmailAddress) {
            this.destinationEmailAddress = destinationEmailAddress;
            return this;
        }

        public final String getConnectSourceEmailAddress() {
            return connectSourceEmailAddress;
        }

        public final void setConnectSourceEmailAddress(String connectSourceEmailAddress) {
            this.connectSourceEmailAddress = connectSourceEmailAddress;
        }

        @Override
        public final Builder connectSourceEmailAddress(String connectSourceEmailAddress) {
            this.connectSourceEmailAddress = connectSourceEmailAddress;
            return this;
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final Map<String, String> getTemplateParameters() {
            if (templateParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return templateParameters;
        }

        public final void setTemplateParameters(Map<String, String> templateParameters) {
            this.templateParameters = AttributesCopier.copy(templateParameters);
        }

        @Override
        public final Builder templateParameters(Map<String, String> templateParameters) {
            this.templateParameters = AttributesCopier.copy(templateParameters);
            return this;
        }

        @Override
        public EmailChannelSubtypeParameters build() {
            return new EmailChannelSubtypeParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
