/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Default Email Outbound config
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailOutboundConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailOutboundConfig.Builder, EmailOutboundConfig> {
    private static final SdkField<String> CONNECT_SOURCE_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectSourceEmailAddress").getter(getter(EmailOutboundConfig::connectSourceEmailAddress))
            .setter(setter(Builder::connectSourceEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectSourceEmailAddress").build())
            .build();

    private static final SdkField<String> SOURCE_EMAIL_ADDRESS_DISPLAY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("sourceEmailAddressDisplayName")
            .getter(getter(EmailOutboundConfig::sourceEmailAddressDisplayName))
            .setter(setter(Builder::sourceEmailAddressDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceEmailAddressDisplayName")
                    .build()).build();

    private static final SdkField<String> WISDOM_TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("wisdomTemplateArn").getter(getter(EmailOutboundConfig::wisdomTemplateArn))
            .setter(setter(Builder::wisdomTemplateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wisdomTemplateArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONNECT_SOURCE_EMAIL_ADDRESS_FIELD, SOURCE_EMAIL_ADDRESS_DISPLAY_NAME_FIELD, WISDOM_TEMPLATE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectSourceEmailAddress;

    private final String sourceEmailAddressDisplayName;

    private final String wisdomTemplateArn;

    private EmailOutboundConfig(BuilderImpl builder) {
        this.connectSourceEmailAddress = builder.connectSourceEmailAddress;
        this.sourceEmailAddressDisplayName = builder.sourceEmailAddressDisplayName;
        this.wisdomTemplateArn = builder.wisdomTemplateArn;
    }

    /**
     * Returns the value of the ConnectSourceEmailAddress property for this object.
     * 
     * @return The value of the ConnectSourceEmailAddress property for this object.
     */
    public final String connectSourceEmailAddress() {
        return connectSourceEmailAddress;
    }

    /**
     * Returns the value of the SourceEmailAddressDisplayName property for this object.
     * 
     * @return The value of the SourceEmailAddressDisplayName property for this object.
     */
    public final String sourceEmailAddressDisplayName() {
        return sourceEmailAddressDisplayName;
    }

    /**
     * Returns the value of the WisdomTemplateArn property for this object.
     * 
     * @return The value of the WisdomTemplateArn property for this object.
     */
    public final String wisdomTemplateArn() {
        return wisdomTemplateArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectSourceEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEmailAddressDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(wisdomTemplateArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailOutboundConfig)) {
            return false;
        }
        EmailOutboundConfig other = (EmailOutboundConfig) obj;
        return Objects.equals(connectSourceEmailAddress(), other.connectSourceEmailAddress())
                && Objects.equals(sourceEmailAddressDisplayName(), other.sourceEmailAddressDisplayName())
                && Objects.equals(wisdomTemplateArn(), other.wisdomTemplateArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("EmailOutboundConfig")
                .add("ConnectSourceEmailAddress", connectSourceEmailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SourceEmailAddressDisplayName",
                        sourceEmailAddressDisplayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WisdomTemplateArn", wisdomTemplateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectSourceEmailAddress":
            return Optional.ofNullable(clazz.cast(connectSourceEmailAddress()));
        case "sourceEmailAddressDisplayName":
            return Optional.ofNullable(clazz.cast(sourceEmailAddressDisplayName()));
        case "wisdomTemplateArn":
            return Optional.ofNullable(clazz.cast(wisdomTemplateArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectSourceEmailAddress", CONNECT_SOURCE_EMAIL_ADDRESS_FIELD);
        map.put("sourceEmailAddressDisplayName", SOURCE_EMAIL_ADDRESS_DISPLAY_NAME_FIELD);
        map.put("wisdomTemplateArn", WISDOM_TEMPLATE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailOutboundConfig, T> g) {
        return obj -> g.apply((EmailOutboundConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailOutboundConfig> {
        /**
         * Sets the value of the ConnectSourceEmailAddress property for this object.
         *
         * @param connectSourceEmailAddress
         *        The new value for the ConnectSourceEmailAddress property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectSourceEmailAddress(String connectSourceEmailAddress);

        /**
         * Sets the value of the SourceEmailAddressDisplayName property for this object.
         *
         * @param sourceEmailAddressDisplayName
         *        The new value for the SourceEmailAddressDisplayName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEmailAddressDisplayName(String sourceEmailAddressDisplayName);

        /**
         * Sets the value of the WisdomTemplateArn property for this object.
         *
         * @param wisdomTemplateArn
         *        The new value for the WisdomTemplateArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wisdomTemplateArn(String wisdomTemplateArn);
    }

    static final class BuilderImpl implements Builder {
        private String connectSourceEmailAddress;

        private String sourceEmailAddressDisplayName;

        private String wisdomTemplateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailOutboundConfig model) {
            connectSourceEmailAddress(model.connectSourceEmailAddress);
            sourceEmailAddressDisplayName(model.sourceEmailAddressDisplayName);
            wisdomTemplateArn(model.wisdomTemplateArn);
        }

        public final String getConnectSourceEmailAddress() {
            return connectSourceEmailAddress;
        }

        public final void setConnectSourceEmailAddress(String connectSourceEmailAddress) {
            this.connectSourceEmailAddress = connectSourceEmailAddress;
        }

        @Override
        public final Builder connectSourceEmailAddress(String connectSourceEmailAddress) {
            this.connectSourceEmailAddress = connectSourceEmailAddress;
            return this;
        }

        public final String getSourceEmailAddressDisplayName() {
            return sourceEmailAddressDisplayName;
        }

        public final void setSourceEmailAddressDisplayName(String sourceEmailAddressDisplayName) {
            this.sourceEmailAddressDisplayName = sourceEmailAddressDisplayName;
        }

        @Override
        public final Builder sourceEmailAddressDisplayName(String sourceEmailAddressDisplayName) {
            this.sourceEmailAddressDisplayName = sourceEmailAddressDisplayName;
            return this;
        }

        public final String getWisdomTemplateArn() {
            return wisdomTemplateArn;
        }

        public final void setWisdomTemplateArn(String wisdomTemplateArn) {
            this.wisdomTemplateArn = wisdomTemplateArn;
        }

        @Override
        public final Builder wisdomTemplateArn(String wisdomTemplateArn) {
            this.wisdomTemplateArn = wisdomTemplateArn;
            return this;
        }

        @Override
        public EmailOutboundConfig build() {
            return new EmailOutboundConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
