/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Email Outbound Mode
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailOutboundMode implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailOutboundMode.Builder, EmailOutboundMode> {
    private static final SdkField<AgentlessConfig> AGENTLESS_FIELD = SdkField.<AgentlessConfig> builder(MarshallingType.SDK_POJO)
            .memberName("agentless").getter(getter(EmailOutboundMode::agentless)).setter(setter(Builder::agentless))
            .constructor(AgentlessConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentless").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENTLESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AgentlessConfig agentless;

    private final Type type;

    private EmailOutboundMode(BuilderImpl builder) {
        this.agentless = builder.agentless;
        this.type = builder.type;
    }

    /**
     * Returns the value of the Agentless property for this object.
     * 
     * @return The value of the Agentless property for this object.
     */
    public final AgentlessConfig agentless() {
        return agentless;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentless());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailOutboundMode)) {
            return false;
        }
        EmailOutboundMode other = (EmailOutboundMode) obj;
        return Objects.equals(agentless(), other.agentless());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailOutboundMode").add("Agentless", agentless()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentless":
            return Optional.ofNullable(clazz.cast(agentless()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #agentless()} initialized to the given value.
     *
     * Sets the value of the Agentless property for this object.
     *
     * @param agentless
     *        The new value for the Agentless property for this object.
     */
    public static EmailOutboundMode fromAgentless(AgentlessConfig agentless) {
        return builder().agentless(agentless).build();
    }

    /**
     * Create an instance of this class with {@link #agentless()} initialized to the given value.
     *
     * Sets the value of the Agentless property for this object.
     *
     * @param agentless
     *        The new value for the Agentless property for this object.
     */
    public static EmailOutboundMode fromAgentless(Consumer<AgentlessConfig.Builder> agentless) {
        AgentlessConfig.Builder builder = AgentlessConfig.builder();
        agentless.accept(builder);
        return fromAgentless(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentless", AGENTLESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailOutboundMode, T> g) {
        return obj -> g.apply((EmailOutboundMode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailOutboundMode> {
        /**
         * Sets the value of the Agentless property for this object.
         *
         * @param agentless
         *        The new value for the Agentless property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentless(AgentlessConfig agentless);

        /**
         * Sets the value of the Agentless property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AgentlessConfig.Builder} avoiding the
         * need to create one manually via {@link AgentlessConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentlessConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #agentless(AgentlessConfig)}.
         * 
         * @param agentless
         *        a consumer that will call methods on {@link AgentlessConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentless(AgentlessConfig)
         */
        default Builder agentless(Consumer<AgentlessConfig.Builder> agentless) {
            return agentless(AgentlessConfig.builder().applyMutation(agentless).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AgentlessConfig agentless;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EmailOutboundMode model) {
            agentless(model.agentless);
        }

        public final AgentlessConfig.Builder getAgentless() {
            return agentless != null ? agentless.toBuilder() : null;
        }

        public final void setAgentless(AgentlessConfig.BuilderImpl agentless) {
            Object oldValue = this.agentless;
            this.agentless = agentless != null ? agentless.build() : null;
            handleUnionValueChange(Type.AGENTLESS, oldValue, this.agentless);
        }

        @Override
        public final Builder agentless(AgentlessConfig agentless) {
            Object oldValue = this.agentless;
            this.agentless = agentless;
            handleUnionValueChange(Type.AGENTLESS, oldValue, this.agentless);
            return this;
        }

        @Override
        public EmailOutboundMode build() {
            return new EmailOutboundMode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EmailOutboundMode#type()
     */
    public enum Type {
        AGENTLESS,

        UNKNOWN_TO_SDK_VERSION
    }
}
