/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A failed request identified by the unique client token.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedRequest implements SdkPojo, Serializable, ToCopyableBuilder<FailedRequest.Builder, FailedRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(FailedRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(FailedRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(FailedRequest::failureCodeAsString)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, ID_FIELD,
            FAILURE_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clientToken;

    private final String id;

    private final String failureCode;

    private FailedRequest(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.id = builder.id;
        this.failureCode = builder.failureCode;
    }

    /**
     * Returns the value of the ClientToken property for this object.
     * 
     * @return The value of the ClientToken property for this object.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the FailureCode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link FailureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The value of the FailureCode property for this object.
     * @see FailureCode
     */
    public final FailureCode failureCode() {
        return FailureCode.fromValue(failureCode);
    }

    /**
     * Returns the value of the FailureCode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link FailureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The value of the FailureCode property for this object.
     * @see FailureCode
     */
    public final String failureCodeAsString() {
        return failureCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedRequest)) {
            return false;
        }
        FailedRequest other = (FailedRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(id(), other.id())
                && Objects.equals(failureCodeAsString(), other.failureCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailedRequest").add("ClientToken", clientToken()).add("Id", id())
                .add("FailureCode", failureCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("id", ID_FIELD);
        map.put("failureCode", FAILURE_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailedRequest, T> g) {
        return obj -> g.apply((FailedRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedRequest> {
        /**
         * Sets the value of the ClientToken property for this object.
         *
         * @param clientToken
         *        The new value for the ClientToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * Sets the value of the Id property for this object.
         *
         * @param id
         *        The new value for the Id property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the FailureCode property for this object.
         *
         * @param failureCode
         *        The new value for the FailureCode property for this object.
         * @see FailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureCode
         */
        Builder failureCode(String failureCode);

        /**
         * Sets the value of the FailureCode property for this object.
         *
         * @param failureCode
         *        The new value for the FailureCode property for this object.
         * @see FailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureCode
         */
        Builder failureCode(FailureCode failureCode);
    }

    static final class BuilderImpl implements Builder {
        private String clientToken;

        private String id;

        private String failureCode;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedRequest model) {
            clientToken(model.clientToken);
            id(model.id);
            failureCode(model.failureCode);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(FailureCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        @Override
        public FailedRequest build() {
            return new FailedRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
