/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Integration summary for Connect instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntegrationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<IntegrationSummary.Builder, IntegrationSummary> {
    private static final SdkField<CustomerProfilesIntegrationSummary> CUSTOMER_PROFILES_FIELD = SdkField
            .<CustomerProfilesIntegrationSummary> builder(MarshallingType.SDK_POJO).memberName("customerProfiles")
            .getter(getter(IntegrationSummary::customerProfiles)).setter(setter(Builder::customerProfiles))
            .constructor(CustomerProfilesIntegrationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerProfiles").build()).build();

    private static final SdkField<QConnectIntegrationSummary> Q_CONNECT_FIELD = SdkField
            .<QConnectIntegrationSummary> builder(MarshallingType.SDK_POJO).memberName("qConnect")
            .getter(getter(IntegrationSummary::qConnect)).setter(setter(Builder::qConnect))
            .constructor(QConnectIntegrationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qConnect").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_PROFILES_FIELD,
            Q_CONNECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CustomerProfilesIntegrationSummary customerProfiles;

    private final QConnectIntegrationSummary qConnect;

    private final Type type;

    private IntegrationSummary(BuilderImpl builder) {
        this.customerProfiles = builder.customerProfiles;
        this.qConnect = builder.qConnect;
        this.type = builder.type;
    }

    /**
     * Returns the value of the CustomerProfiles property for this object.
     * 
     * @return The value of the CustomerProfiles property for this object.
     */
    public final CustomerProfilesIntegrationSummary customerProfiles() {
        return customerProfiles;
    }

    /**
     * Returns the value of the QConnect property for this object.
     * 
     * @return The value of the QConnect property for this object.
     */
    public final QConnectIntegrationSummary qConnect() {
        return qConnect;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerProfiles());
        hashCode = 31 * hashCode + Objects.hashCode(qConnect());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegrationSummary)) {
            return false;
        }
        IntegrationSummary other = (IntegrationSummary) obj;
        return Objects.equals(customerProfiles(), other.customerProfiles()) && Objects.equals(qConnect(), other.qConnect());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntegrationSummary").add("CustomerProfiles", customerProfiles()).add("QConnect", qConnect())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customerProfiles":
            return Optional.ofNullable(clazz.cast(customerProfiles()));
        case "qConnect":
            return Optional.ofNullable(clazz.cast(qConnect()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #customerProfiles()} initialized to the given value.
     *
     * Sets the value of the CustomerProfiles property for this object.
     *
     * @param customerProfiles
     *        The new value for the CustomerProfiles property for this object.
     */
    public static IntegrationSummary fromCustomerProfiles(CustomerProfilesIntegrationSummary customerProfiles) {
        return builder().customerProfiles(customerProfiles).build();
    }

    /**
     * Create an instance of this class with {@link #customerProfiles()} initialized to the given value.
     *
     * Sets the value of the CustomerProfiles property for this object.
     *
     * @param customerProfiles
     *        The new value for the CustomerProfiles property for this object.
     */
    public static IntegrationSummary fromCustomerProfiles(Consumer<CustomerProfilesIntegrationSummary.Builder> customerProfiles) {
        CustomerProfilesIntegrationSummary.Builder builder = CustomerProfilesIntegrationSummary.builder();
        customerProfiles.accept(builder);
        return fromCustomerProfiles(builder.build());
    }

    /**
     * Create an instance of this class with {@link #qConnect()} initialized to the given value.
     *
     * Sets the value of the QConnect property for this object.
     *
     * @param qConnect
     *        The new value for the QConnect property for this object.
     */
    public static IntegrationSummary fromQConnect(QConnectIntegrationSummary qConnect) {
        return builder().qConnect(qConnect).build();
    }

    /**
     * Create an instance of this class with {@link #qConnect()} initialized to the given value.
     *
     * Sets the value of the QConnect property for this object.
     *
     * @param qConnect
     *        The new value for the QConnect property for this object.
     */
    public static IntegrationSummary fromQConnect(Consumer<QConnectIntegrationSummary.Builder> qConnect) {
        QConnectIntegrationSummary.Builder builder = QConnectIntegrationSummary.builder();
        qConnect.accept(builder);
        return fromQConnect(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customerProfiles", CUSTOMER_PROFILES_FIELD);
        map.put("qConnect", Q_CONNECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntegrationSummary, T> g) {
        return obj -> g.apply((IntegrationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntegrationSummary> {
        /**
         * Sets the value of the CustomerProfiles property for this object.
         *
         * @param customerProfiles
         *        The new value for the CustomerProfiles property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerProfiles(CustomerProfilesIntegrationSummary customerProfiles);

        /**
         * Sets the value of the CustomerProfiles property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link CustomerProfilesIntegrationSummary.Builder} avoiding the need to create one manually via
         * {@link CustomerProfilesIntegrationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerProfilesIntegrationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #customerProfiles(CustomerProfilesIntegrationSummary)}.
         * 
         * @param customerProfiles
         *        a consumer that will call methods on {@link CustomerProfilesIntegrationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerProfiles(CustomerProfilesIntegrationSummary)
         */
        default Builder customerProfiles(Consumer<CustomerProfilesIntegrationSummary.Builder> customerProfiles) {
            return customerProfiles(CustomerProfilesIntegrationSummary.builder().applyMutation(customerProfiles).build());
        }

        /**
         * Sets the value of the QConnect property for this object.
         *
         * @param qConnect
         *        The new value for the QConnect property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qConnect(QConnectIntegrationSummary qConnect);

        /**
         * Sets the value of the QConnect property for this object.
         *
         * This is a convenience method that creates an instance of the {@link QConnectIntegrationSummary.Builder}
         * avoiding the need to create one manually via {@link QConnectIntegrationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QConnectIntegrationSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #qConnect(QConnectIntegrationSummary)}.
         * 
         * @param qConnect
         *        a consumer that will call methods on {@link QConnectIntegrationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qConnect(QConnectIntegrationSummary)
         */
        default Builder qConnect(Consumer<QConnectIntegrationSummary.Builder> qConnect) {
            return qConnect(QConnectIntegrationSummary.builder().applyMutation(qConnect).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CustomerProfilesIntegrationSummary customerProfiles;

        private QConnectIntegrationSummary qConnect;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IntegrationSummary model) {
            customerProfiles(model.customerProfiles);
            qConnect(model.qConnect);
        }

        public final CustomerProfilesIntegrationSummary.Builder getCustomerProfiles() {
            return customerProfiles != null ? customerProfiles.toBuilder() : null;
        }

        public final void setCustomerProfiles(CustomerProfilesIntegrationSummary.BuilderImpl customerProfiles) {
            Object oldValue = this.customerProfiles;
            this.customerProfiles = customerProfiles != null ? customerProfiles.build() : null;
            handleUnionValueChange(Type.CUSTOMER_PROFILES, oldValue, this.customerProfiles);
        }

        @Override
        public final Builder customerProfiles(CustomerProfilesIntegrationSummary customerProfiles) {
            Object oldValue = this.customerProfiles;
            this.customerProfiles = customerProfiles;
            handleUnionValueChange(Type.CUSTOMER_PROFILES, oldValue, this.customerProfiles);
            return this;
        }

        public final QConnectIntegrationSummary.Builder getQConnect() {
            return qConnect != null ? qConnect.toBuilder() : null;
        }

        public final void setQConnect(QConnectIntegrationSummary.BuilderImpl qConnect) {
            Object oldValue = this.qConnect;
            this.qConnect = qConnect != null ? qConnect.build() : null;
            handleUnionValueChange(Type.Q_CONNECT, oldValue, this.qConnect);
        }

        @Override
        public final Builder qConnect(QConnectIntegrationSummary qConnect) {
            Object oldValue = this.qConnect;
            this.qConnect = qConnect;
            handleUnionValueChange(Type.Q_CONNECT, oldValue, this.qConnect);
            return this;
        }

        @Override
        public IntegrationSummary build() {
            return new IntegrationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see IntegrationSummary#type()
     */
    public enum Type {
        CUSTOMER_PROFILES,

        Q_CONNECT,

        UNKNOWN_TO_SDK_VERSION
    }
}
