/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Open Hours config
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenHours implements SdkPojo, Serializable, ToCopyableBuilder<OpenHours.Builder, OpenHours> {
    private static final SdkField<Map<String, List<TimeRange>>> DAILY_HOURS_FIELD = SdkField
            .<Map<String, List<TimeRange>>> builder(MarshallingType.MAP)
            .memberName("dailyHours")
            .getter(getter(OpenHours::dailyHoursAsStrings))
            .setter(setter(Builder::dailyHoursWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dailyHours").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<TimeRange>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<TimeRange> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(TimeRange::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAILY_HOURS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, List<TimeRange>> dailyHours;

    private final Type type;

    private OpenHours(BuilderImpl builder) {
        this.dailyHours = builder.dailyHours;
        this.type = builder.type;
    }

    /**
     * Returns the value of the DailyHours property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDailyHours} method.
     * </p>
     * 
     * @return The value of the DailyHours property for this object.
     */
    public final Map<DayOfWeek, List<TimeRange>> dailyHours() {
        return DailyHoursCopier.copyStringToEnum(dailyHours);
    }

    /**
     * For responses, this returns true if the service returned a value for the DailyHours property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDailyHours() {
        return dailyHours != null && !(dailyHours instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the DailyHours property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDailyHours} method.
     * </p>
     * 
     * @return The value of the DailyHours property for this object.
     */
    public final Map<String, List<TimeRange>> dailyHoursAsStrings() {
        return dailyHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDailyHours() ? dailyHoursAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenHours)) {
            return false;
        }
        OpenHours other = (OpenHours) obj;
        return hasDailyHours() == other.hasDailyHours() && Objects.equals(dailyHoursAsStrings(), other.dailyHoursAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenHours").add("DailyHours", hasDailyHours() ? dailyHoursAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dailyHours":
            return Optional.ofNullable(clazz.cast(dailyHoursAsStrings()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #dailyHoursAsStrings()} initialized to the given value.
     *
     * Sets the value of the DailyHours property for this object.
     *
     * @param dailyHours
     *        The new value for the DailyHours property for this object.
     */
    public static OpenHours fromDailyHoursWithStrings(Map<String, List<TimeRange>> dailyHoursWithStrings) {
        return builder().dailyHoursWithStrings(dailyHoursWithStrings).build();
    }

    /**
     * Create an instance of this class with {@link #dailyHoursAsStrings()} initialized to the given value.
     *
     * Sets the value of the DailyHours property for this object.
     *
     * @param dailyHours
     *        The new value for the DailyHours property for this object.
     */
    public static OpenHours fromDailyHours(Map<DayOfWeek, List<TimeRange>> dailyHoursWithStrings) {
        return builder().dailyHours(dailyHoursWithStrings).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dailyHours", DAILY_HOURS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenHours, T> g) {
        return obj -> g.apply((OpenHours) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenHours> {
        /**
         * Sets the value of the DailyHours property for this object.
         *
         * @param dailyHours
         *        The new value for the DailyHours property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailyHoursWithStrings(Map<String, ? extends Collection<TimeRange>> dailyHours);

        /**
         * Sets the value of the DailyHours property for this object.
         *
         * @param dailyHours
         *        The new value for the DailyHours property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailyHours(Map<DayOfWeek, ? extends Collection<TimeRange>> dailyHours);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, List<TimeRange>> dailyHours = DefaultSdkAutoConstructMap.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OpenHours model) {
            dailyHoursWithStrings(model.dailyHours);
        }

        public final Map<String, List<TimeRange.Builder>> getDailyHours() {
            Map<String, List<TimeRange.Builder>> result = DailyHoursCopier.copyToBuilder(this.dailyHours);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setDailyHours(Map<String, ? extends Collection<TimeRange.BuilderImpl>> dailyHours) {
            Object oldValue = this.dailyHours;
            this.dailyHours = DailyHoursCopier.copyFromBuilder(dailyHours);
            handleUnionValueChange(Type.DAILY_HOURS, oldValue, this.dailyHours);
        }

        @Override
        public final Builder dailyHoursWithStrings(Map<String, ? extends Collection<TimeRange>> dailyHours) {
            Object oldValue = this.dailyHours;
            this.dailyHours = DailyHoursCopier.copy(dailyHours);
            handleUnionValueChange(Type.DAILY_HOURS, oldValue, this.dailyHours);
            return this;
        }

        @Override
        public final Builder dailyHours(Map<DayOfWeek, ? extends Collection<TimeRange>> dailyHours) {
            Object oldValue = this.dailyHours;
            this.dailyHours = DailyHoursCopier.copyEnumToString(dailyHours);
            handleUnionValueChange(Type.DAILY_HOURS, oldValue, this.dailyHours);
            return this;
        }

        @Override
        public OpenHours build() {
            return new OpenHours(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see OpenHours#type()
     */
    public enum Type {
        DAILY_HOURS,

        UNKNOWN_TO_SDK_VERSION
    }
}
