/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An outbound request for a campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutboundRequest implements SdkPojo, Serializable, ToCopyableBuilder<OutboundRequest.Builder, OutboundRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(OutboundRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("expirationTime")
            .getter(getter(OutboundRequest::expirationTime))
            .setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<ChannelSubtypeParameters> CHANNEL_SUBTYPE_PARAMETERS_FIELD = SdkField
            .<ChannelSubtypeParameters> builder(MarshallingType.SDK_POJO).memberName("channelSubtypeParameters")
            .getter(getter(OutboundRequest::channelSubtypeParameters)).setter(setter(Builder::channelSubtypeParameters))
            .constructor(ChannelSubtypeParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelSubtypeParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            EXPIRATION_TIME_FIELD, CHANNEL_SUBTYPE_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clientToken;

    private final Instant expirationTime;

    private final ChannelSubtypeParameters channelSubtypeParameters;

    private OutboundRequest(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.expirationTime = builder.expirationTime;
        this.channelSubtypeParameters = builder.channelSubtypeParameters;
    }

    /**
     * Returns the value of the ClientToken property for this object.
     * 
     * @return The value of the ClientToken property for this object.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns the value of the ExpirationTime property for this object.
     * 
     * @return The value of the ExpirationTime property for this object.
     */
    public final Instant expirationTime() {
        return expirationTime;
    }

    /**
     * Returns the value of the ChannelSubtypeParameters property for this object.
     * 
     * @return The value of the ChannelSubtypeParameters property for this object.
     */
    public final ChannelSubtypeParameters channelSubtypeParameters() {
        return channelSubtypeParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(channelSubtypeParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutboundRequest)) {
            return false;
        }
        OutboundRequest other = (OutboundRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(expirationTime(), other.expirationTime())
                && Objects.equals(channelSubtypeParameters(), other.channelSubtypeParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutboundRequest").add("ClientToken", clientToken()).add("ExpirationTime", expirationTime())
                .add("ChannelSubtypeParameters", channelSubtypeParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "expirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        case "channelSubtypeParameters":
            return Optional.ofNullable(clazz.cast(channelSubtypeParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("expirationTime", EXPIRATION_TIME_FIELD);
        map.put("channelSubtypeParameters", CHANNEL_SUBTYPE_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutboundRequest, T> g) {
        return obj -> g.apply((OutboundRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutboundRequest> {
        /**
         * Sets the value of the ClientToken property for this object.
         *
         * @param clientToken
         *        The new value for the ClientToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * Sets the value of the ExpirationTime property for this object.
         *
         * @param expirationTime
         *        The new value for the ExpirationTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Instant expirationTime);

        /**
         * Sets the value of the ChannelSubtypeParameters property for this object.
         *
         * @param channelSubtypeParameters
         *        The new value for the ChannelSubtypeParameters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelSubtypeParameters(ChannelSubtypeParameters channelSubtypeParameters);

        /**
         * Sets the value of the ChannelSubtypeParameters property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ChannelSubtypeParameters.Builder}
         * avoiding the need to create one manually via {@link ChannelSubtypeParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChannelSubtypeParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #channelSubtypeParameters(ChannelSubtypeParameters)}.
         * 
         * @param channelSubtypeParameters
         *        a consumer that will call methods on {@link ChannelSubtypeParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelSubtypeParameters(ChannelSubtypeParameters)
         */
        default Builder channelSubtypeParameters(Consumer<ChannelSubtypeParameters.Builder> channelSubtypeParameters) {
            return channelSubtypeParameters(ChannelSubtypeParameters.builder().applyMutation(channelSubtypeParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String clientToken;

        private Instant expirationTime;

        private ChannelSubtypeParameters channelSubtypeParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(OutboundRequest model) {
            clientToken(model.clientToken);
            expirationTime(model.expirationTime);
            channelSubtypeParameters(model.channelSubtypeParameters);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Instant getExpirationTime() {
            return expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final ChannelSubtypeParameters.Builder getChannelSubtypeParameters() {
            return channelSubtypeParameters != null ? channelSubtypeParameters.toBuilder() : null;
        }

        public final void setChannelSubtypeParameters(ChannelSubtypeParameters.BuilderImpl channelSubtypeParameters) {
            this.channelSubtypeParameters = channelSubtypeParameters != null ? channelSubtypeParameters.build() : null;
        }

        @Override
        public final Builder channelSubtypeParameters(ChannelSubtypeParameters channelSubtypeParameters) {
            this.channelSubtypeParameters = channelSubtypeParameters;
            return this;
        }

        @Override
        public OutboundRequest build() {
            return new OutboundRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
