/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Predictive config
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictiveConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<PredictiveConfig.Builder, PredictiveConfig> {
    private static final SdkField<Double> BANDWIDTH_ALLOCATION_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("bandwidthAllocation").getter(getter(PredictiveConfig::bandwidthAllocation))
            .setter(setter(Builder::bandwidthAllocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidthAllocation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BANDWIDTH_ALLOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double bandwidthAllocation;

    private PredictiveConfig(BuilderImpl builder) {
        this.bandwidthAllocation = builder.bandwidthAllocation;
    }

    /**
     * Returns the value of the BandwidthAllocation property for this object.
     * 
     * @return The value of the BandwidthAllocation property for this object.
     */
    public final Double bandwidthAllocation() {
        return bandwidthAllocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bandwidthAllocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictiveConfig)) {
            return false;
        }
        PredictiveConfig other = (PredictiveConfig) obj;
        return Objects.equals(bandwidthAllocation(), other.bandwidthAllocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredictiveConfig").add("BandwidthAllocation", bandwidthAllocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bandwidthAllocation":
            return Optional.ofNullable(clazz.cast(bandwidthAllocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bandwidthAllocation", BANDWIDTH_ALLOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredictiveConfig, T> g) {
        return obj -> g.apply((PredictiveConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredictiveConfig> {
        /**
         * Sets the value of the BandwidthAllocation property for this object.
         *
         * @param bandwidthAllocation
         *        The new value for the BandwidthAllocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandwidthAllocation(Double bandwidthAllocation);
    }

    static final class BuilderImpl implements Builder {
        private Double bandwidthAllocation;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictiveConfig model) {
            bandwidthAllocation(model.bandwidthAllocation);
        }

        public final Double getBandwidthAllocation() {
            return bandwidthAllocation;
        }

        public final void setBandwidthAllocation(Double bandwidthAllocation) {
            this.bandwidthAllocation = bandwidthAllocation;
        }

        @Override
        public final Builder bandwidthAllocation(Double bandwidthAllocation) {
            this.bandwidthAllocation = bandwidthAllocation;
            return this;
        }

        @Override
        public PredictiveConfig build() {
            return new PredictiveConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
