/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request for PutConnectInstanceIntegration API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutConnectInstanceIntegrationRequest extends ConnectCampaignsV2Request implements
        ToCopyableBuilder<PutConnectInstanceIntegrationRequest.Builder, PutConnectInstanceIntegrationRequest> {
    private static final SdkField<String> CONNECT_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectInstanceId").getter(getter(PutConnectInstanceIntegrationRequest::connectInstanceId))
            .setter(setter(Builder::connectInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("connectInstanceId").build()).build();

    private static final SdkField<IntegrationConfig> INTEGRATION_CONFIG_FIELD = SdkField
            .<IntegrationConfig> builder(MarshallingType.SDK_POJO).memberName("integrationConfig")
            .getter(getter(PutConnectInstanceIntegrationRequest::integrationConfig)).setter(setter(Builder::integrationConfig))
            .constructor(IntegrationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECT_INSTANCE_ID_FIELD,
            INTEGRATION_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectInstanceId;

    private final IntegrationConfig integrationConfig;

    private PutConnectInstanceIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.connectInstanceId = builder.connectInstanceId;
        this.integrationConfig = builder.integrationConfig;
    }

    /**
     * Returns the value of the ConnectInstanceId property for this object.
     * 
     * @return The value of the ConnectInstanceId property for this object.
     */
    public final String connectInstanceId() {
        return connectInstanceId;
    }

    /**
     * Returns the value of the IntegrationConfig property for this object.
     * 
     * @return The value of the IntegrationConfig property for this object.
     */
    public final IntegrationConfig integrationConfig() {
        return integrationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(integrationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConnectInstanceIntegrationRequest)) {
            return false;
        }
        PutConnectInstanceIntegrationRequest other = (PutConnectInstanceIntegrationRequest) obj;
        return Objects.equals(connectInstanceId(), other.connectInstanceId())
                && Objects.equals(integrationConfig(), other.integrationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutConnectInstanceIntegrationRequest").add("ConnectInstanceId", connectInstanceId())
                .add("IntegrationConfig", integrationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectInstanceId":
            return Optional.ofNullable(clazz.cast(connectInstanceId()));
        case "integrationConfig":
            return Optional.ofNullable(clazz.cast(integrationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectInstanceId", CONNECT_INSTANCE_ID_FIELD);
        map.put("integrationConfig", INTEGRATION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutConnectInstanceIntegrationRequest, T> g) {
        return obj -> g.apply((PutConnectInstanceIntegrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectCampaignsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PutConnectInstanceIntegrationRequest> {
        /**
         * Sets the value of the ConnectInstanceId property for this object.
         *
         * @param connectInstanceId
         *        The new value for the ConnectInstanceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectInstanceId(String connectInstanceId);

        /**
         * Sets the value of the IntegrationConfig property for this object.
         *
         * @param integrationConfig
         *        The new value for the IntegrationConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationConfig(IntegrationConfig integrationConfig);

        /**
         * Sets the value of the IntegrationConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link IntegrationConfig.Builder} avoiding the
         * need to create one manually via {@link IntegrationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntegrationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #integrationConfig(IntegrationConfig)}.
         * 
         * @param integrationConfig
         *        a consumer that will call methods on {@link IntegrationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integrationConfig(IntegrationConfig)
         */
        default Builder integrationConfig(Consumer<IntegrationConfig.Builder> integrationConfig) {
            return integrationConfig(IntegrationConfig.builder().applyMutation(integrationConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCampaignsV2Request.BuilderImpl implements Builder {
        private String connectInstanceId;

        private IntegrationConfig integrationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConnectInstanceIntegrationRequest model) {
            super(model);
            connectInstanceId(model.connectInstanceId);
            integrationConfig(model.integrationConfig);
        }

        public final String getConnectInstanceId() {
            return connectInstanceId;
        }

        public final void setConnectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
        }

        @Override
        public final Builder connectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
            return this;
        }

        public final IntegrationConfig.Builder getIntegrationConfig() {
            return integrationConfig != null ? integrationConfig.toBuilder() : null;
        }

        public final void setIntegrationConfig(IntegrationConfig.BuilderImpl integrationConfig) {
            this.integrationConfig = integrationConfig != null ? integrationConfig.build() : null;
        }

        @Override
        public final Builder integrationConfig(IntegrationConfig integrationConfig) {
            this.integrationConfig = integrationConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConnectInstanceIntegrationRequest build() {
            return new PutConnectInstanceIntegrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
