/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request for PutOutboundRequestBatch API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutOutboundRequestBatchRequest extends ConnectCampaignsV2Request implements
        ToCopyableBuilder<PutOutboundRequestBatchRequest.Builder, PutOutboundRequestBatchRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(PutOutboundRequestBatchRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<List<OutboundRequest>> OUTBOUND_REQUESTS_FIELD = SdkField
            .<List<OutboundRequest>> builder(MarshallingType.LIST)
            .memberName("outboundRequests")
            .getter(getter(PutOutboundRequestBatchRequest::outboundRequests))
            .setter(setter(Builder::outboundRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outboundRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutboundRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutboundRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            OUTBOUND_REQUESTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final List<OutboundRequest> outboundRequests;

    private PutOutboundRequestBatchRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.outboundRequests = builder.outboundRequests;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutboundRequests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutboundRequests() {
        return outboundRequests != null && !(outboundRequests instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the OutboundRequests property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutboundRequests} method.
     * </p>
     * 
     * @return The value of the OutboundRequests property for this object.
     */
    public final List<OutboundRequest> outboundRequests() {
        return outboundRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutboundRequests() ? outboundRequests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutOutboundRequestBatchRequest)) {
            return false;
        }
        PutOutboundRequestBatchRequest other = (PutOutboundRequestBatchRequest) obj;
        return Objects.equals(id(), other.id()) && hasOutboundRequests() == other.hasOutboundRequests()
                && Objects.equals(outboundRequests(), other.outboundRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutOutboundRequestBatchRequest").add("Id", id())
                .add("OutboundRequests", hasOutboundRequests() ? outboundRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "outboundRequests":
            return Optional.ofNullable(clazz.cast(outboundRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("outboundRequests", OUTBOUND_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutOutboundRequestBatchRequest, T> g) {
        return obj -> g.apply((PutOutboundRequestBatchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectCampaignsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PutOutboundRequestBatchRequest> {
        /**
         * Sets the value of the Id property for this object.
         *
         * @param id
         *        The new value for the Id property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the OutboundRequests property for this object.
         *
         * @param outboundRequests
         *        The new value for the OutboundRequests property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundRequests(Collection<OutboundRequest> outboundRequests);

        /**
         * Sets the value of the OutboundRequests property for this object.
         *
         * @param outboundRequests
         *        The new value for the OutboundRequests property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundRequests(OutboundRequest... outboundRequests);

        /**
         * Sets the value of the OutboundRequests property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcampaignsv2.model.OutboundRequest.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connectcampaignsv2.model.OutboundRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcampaignsv2.model.OutboundRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #outboundRequests(List<OutboundRequest>)}.
         * 
         * @param outboundRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.OutboundRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outboundRequests(java.util.Collection<OutboundRequest>)
         */
        Builder outboundRequests(Consumer<OutboundRequest.Builder>... outboundRequests);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCampaignsV2Request.BuilderImpl implements Builder {
        private String id;

        private List<OutboundRequest> outboundRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutOutboundRequestBatchRequest model) {
            super(model);
            id(model.id);
            outboundRequests(model.outboundRequests);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<OutboundRequest.Builder> getOutboundRequests() {
            List<OutboundRequest.Builder> result = OutboundRequestListCopier.copyToBuilder(this.outboundRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutboundRequests(Collection<OutboundRequest.BuilderImpl> outboundRequests) {
            this.outboundRequests = OutboundRequestListCopier.copyFromBuilder(outboundRequests);
        }

        @Override
        public final Builder outboundRequests(Collection<OutboundRequest> outboundRequests) {
            this.outboundRequests = OutboundRequestListCopier.copy(outboundRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outboundRequests(OutboundRequest... outboundRequests) {
            outboundRequests(Arrays.asList(outboundRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outboundRequests(Consumer<OutboundRequest.Builder>... outboundRequests) {
            outboundRequests(Stream.of(outboundRequests).map(c -> OutboundRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutOutboundRequestBatchRequest build() {
            return new PutOutboundRequestBatchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
