/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Restricted period
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestrictedPeriod implements SdkPojo, Serializable,
        ToCopyableBuilder<RestrictedPeriod.Builder, RestrictedPeriod> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RestrictedPeriod::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> START_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startDate").getter(getter(RestrictedPeriod::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build()).build();

    private static final SdkField<String> END_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endDate").getter(getter(RestrictedPeriod::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, START_DATE_FIELD,
            END_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String startDate;

    private final String endDate;

    private RestrictedPeriod(BuilderImpl builder) {
        this.name = builder.name;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the StartDate property for this object.
     * 
     * @return The value of the StartDate property for this object.
     */
    public final String startDate() {
        return startDate;
    }

    /**
     * Returns the value of the EndDate property for this object.
     * 
     * @return The value of the EndDate property for this object.
     */
    public final String endDate() {
        return endDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestrictedPeriod)) {
            return false;
        }
        RestrictedPeriod other = (RestrictedPeriod) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(endDate(), other.endDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestrictedPeriod").add("Name", name()).add("StartDate", startDate()).add("EndDate", endDate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "startDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "endDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("startDate", START_DATE_FIELD);
        map.put("endDate", END_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestrictedPeriod, T> g) {
        return obj -> g.apply((RestrictedPeriod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RestrictedPeriod> {
        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the StartDate property for this object.
         *
         * @param startDate
         *        The new value for the StartDate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(String startDate);

        /**
         * Sets the value of the EndDate property for this object.
         *
         * @param endDate
         *        The new value for the EndDate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(String endDate);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String startDate;

        private String endDate;

        private BuilderImpl() {
        }

        private BuilderImpl(RestrictedPeriod model) {
            name(model.name);
            startDate(model.startDate);
            endDate(model.endDate);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStartDate() {
            return startDate;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getEndDate() {
            return endDate;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        @Override
        public RestrictedPeriod build() {
            return new RestrictedPeriod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
