/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * SMS Channel Subtype config
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SmsChannelSubtypeConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SmsChannelSubtypeConfig.Builder, SmsChannelSubtypeConfig> {
    private static final SdkField<Double> CAPACITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("capacity").getter(getter(SmsChannelSubtypeConfig::capacity)).setter(setter(Builder::capacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacity").build()).build();

    private static final SdkField<SmsOutboundMode> OUTBOUND_MODE_FIELD = SdkField
            .<SmsOutboundMode> builder(MarshallingType.SDK_POJO).memberName("outboundMode")
            .getter(getter(SmsChannelSubtypeConfig::outboundMode)).setter(setter(Builder::outboundMode))
            .constructor(SmsOutboundMode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outboundMode").build()).build();

    private static final SdkField<SmsOutboundConfig> DEFAULT_OUTBOUND_CONFIG_FIELD = SdkField
            .<SmsOutboundConfig> builder(MarshallingType.SDK_POJO).memberName("defaultOutboundConfig")
            .getter(getter(SmsChannelSubtypeConfig::defaultOutboundConfig)).setter(setter(Builder::defaultOutboundConfig))
            .constructor(SmsOutboundConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultOutboundConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_FIELD,
            OUTBOUND_MODE_FIELD, DEFAULT_OUTBOUND_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double capacity;

    private final SmsOutboundMode outboundMode;

    private final SmsOutboundConfig defaultOutboundConfig;

    private SmsChannelSubtypeConfig(BuilderImpl builder) {
        this.capacity = builder.capacity;
        this.outboundMode = builder.outboundMode;
        this.defaultOutboundConfig = builder.defaultOutboundConfig;
    }

    /**
     * Returns the value of the Capacity property for this object.
     * 
     * @return The value of the Capacity property for this object.
     */
    public final Double capacity() {
        return capacity;
    }

    /**
     * Returns the value of the OutboundMode property for this object.
     * 
     * @return The value of the OutboundMode property for this object.
     */
    public final SmsOutboundMode outboundMode() {
        return outboundMode;
    }

    /**
     * Returns the value of the DefaultOutboundConfig property for this object.
     * 
     * @return The value of the DefaultOutboundConfig property for this object.
     */
    public final SmsOutboundConfig defaultOutboundConfig() {
        return defaultOutboundConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        hashCode = 31 * hashCode + Objects.hashCode(outboundMode());
        hashCode = 31 * hashCode + Objects.hashCode(defaultOutboundConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SmsChannelSubtypeConfig)) {
            return false;
        }
        SmsChannelSubtypeConfig other = (SmsChannelSubtypeConfig) obj;
        return Objects.equals(capacity(), other.capacity()) && Objects.equals(outboundMode(), other.outboundMode())
                && Objects.equals(defaultOutboundConfig(), other.defaultOutboundConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SmsChannelSubtypeConfig").add("Capacity", capacity()).add("OutboundMode", outboundMode())
                .add("DefaultOutboundConfig", defaultOutboundConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        case "outboundMode":
            return Optional.ofNullable(clazz.cast(outboundMode()));
        case "defaultOutboundConfig":
            return Optional.ofNullable(clazz.cast(defaultOutboundConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("capacity", CAPACITY_FIELD);
        map.put("outboundMode", OUTBOUND_MODE_FIELD);
        map.put("defaultOutboundConfig", DEFAULT_OUTBOUND_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SmsChannelSubtypeConfig, T> g) {
        return obj -> g.apply((SmsChannelSubtypeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SmsChannelSubtypeConfig> {
        /**
         * Sets the value of the Capacity property for this object.
         *
         * @param capacity
         *        The new value for the Capacity property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(Double capacity);

        /**
         * Sets the value of the OutboundMode property for this object.
         *
         * @param outboundMode
         *        The new value for the OutboundMode property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundMode(SmsOutboundMode outboundMode);

        /**
         * Sets the value of the OutboundMode property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SmsOutboundMode.Builder} avoiding the
         * need to create one manually via {@link SmsOutboundMode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SmsOutboundMode.Builder#build()} is called immediately and its
         * result is passed to {@link #outboundMode(SmsOutboundMode)}.
         * 
         * @param outboundMode
         *        a consumer that will call methods on {@link SmsOutboundMode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outboundMode(SmsOutboundMode)
         */
        default Builder outboundMode(Consumer<SmsOutboundMode.Builder> outboundMode) {
            return outboundMode(SmsOutboundMode.builder().applyMutation(outboundMode).build());
        }

        /**
         * Sets the value of the DefaultOutboundConfig property for this object.
         *
         * @param defaultOutboundConfig
         *        The new value for the DefaultOutboundConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOutboundConfig(SmsOutboundConfig defaultOutboundConfig);

        /**
         * Sets the value of the DefaultOutboundConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SmsOutboundConfig.Builder} avoiding the
         * need to create one manually via {@link SmsOutboundConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SmsOutboundConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultOutboundConfig(SmsOutboundConfig)}.
         * 
         * @param defaultOutboundConfig
         *        a consumer that will call methods on {@link SmsOutboundConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultOutboundConfig(SmsOutboundConfig)
         */
        default Builder defaultOutboundConfig(Consumer<SmsOutboundConfig.Builder> defaultOutboundConfig) {
            return defaultOutboundConfig(SmsOutboundConfig.builder().applyMutation(defaultOutboundConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Double capacity;

        private SmsOutboundMode outboundMode;

        private SmsOutboundConfig defaultOutboundConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SmsChannelSubtypeConfig model) {
            capacity(model.capacity);
            outboundMode(model.outboundMode);
            defaultOutboundConfig(model.defaultOutboundConfig);
        }

        public final Double getCapacity() {
            return capacity;
        }

        public final void setCapacity(Double capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Double capacity) {
            this.capacity = capacity;
            return this;
        }

        public final SmsOutboundMode.Builder getOutboundMode() {
            return outboundMode != null ? outboundMode.toBuilder() : null;
        }

        public final void setOutboundMode(SmsOutboundMode.BuilderImpl outboundMode) {
            this.outboundMode = outboundMode != null ? outboundMode.build() : null;
        }

        @Override
        public final Builder outboundMode(SmsOutboundMode outboundMode) {
            this.outboundMode = outboundMode;
            return this;
        }

        public final SmsOutboundConfig.Builder getDefaultOutboundConfig() {
            return defaultOutboundConfig != null ? defaultOutboundConfig.toBuilder() : null;
        }

        public final void setDefaultOutboundConfig(SmsOutboundConfig.BuilderImpl defaultOutboundConfig) {
            this.defaultOutboundConfig = defaultOutboundConfig != null ? defaultOutboundConfig.build() : null;
        }

        @Override
        public final Builder defaultOutboundConfig(SmsOutboundConfig defaultOutboundConfig) {
            this.defaultOutboundConfig = defaultOutboundConfig;
            return this;
        }

        @Override
        public SmsChannelSubtypeConfig build() {
            return new SmsChannelSubtypeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
