/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters for the Telephony Channel Subtype
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TelephonyChannelSubtypeParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<TelephonyChannelSubtypeParameters.Builder, TelephonyChannelSubtypeParameters> {
    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationPhoneNumber").getter(getter(TelephonyChannelSubtypeParameters::destinationPhoneNumber))
            .setter(setter(Builder::destinationPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPhoneNumber").build())
            .build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("attributes")
            .getter(getter(TelephonyChannelSubtypeParameters::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CONNECT_SOURCE_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectSourcePhoneNumber").getter(getter(TelephonyChannelSubtypeParameters::connectSourcePhoneNumber))
            .setter(setter(Builder::connectSourcePhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectSourcePhoneNumber").build())
            .build();

    private static final SdkField<AnswerMachineDetectionConfig> ANSWER_MACHINE_DETECTION_CONFIG_FIELD = SdkField
            .<AnswerMachineDetectionConfig> builder(MarshallingType.SDK_POJO)
            .memberName("answerMachineDetectionConfig")
            .getter(getter(TelephonyChannelSubtypeParameters::answerMachineDetectionConfig))
            .setter(setter(Builder::answerMachineDetectionConfig))
            .constructor(AnswerMachineDetectionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("answerMachineDetectionConfig")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DESTINATION_PHONE_NUMBER_FIELD, ATTRIBUTES_FIELD, CONNECT_SOURCE_PHONE_NUMBER_FIELD,
            ANSWER_MACHINE_DETECTION_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationPhoneNumber;

    private final Map<String, String> attributes;

    private final String connectSourcePhoneNumber;

    private final AnswerMachineDetectionConfig answerMachineDetectionConfig;

    private TelephonyChannelSubtypeParameters(BuilderImpl builder) {
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.attributes = builder.attributes;
        this.connectSourcePhoneNumber = builder.connectSourcePhoneNumber;
        this.answerMachineDetectionConfig = builder.answerMachineDetectionConfig;
    }

    /**
     * Returns the value of the DestinationPhoneNumber property for this object.
     * 
     * @return The value of the DestinationPhoneNumber property for this object.
     */
    public final String destinationPhoneNumber() {
        return destinationPhoneNumber;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Attributes property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The value of the Attributes property for this object.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * Returns the value of the ConnectSourcePhoneNumber property for this object.
     * 
     * @return The value of the ConnectSourcePhoneNumber property for this object.
     */
    public final String connectSourcePhoneNumber() {
        return connectSourcePhoneNumber;
    }

    /**
     * Returns the value of the AnswerMachineDetectionConfig property for this object.
     * 
     * @return The value of the AnswerMachineDetectionConfig property for this object.
     */
    public final AnswerMachineDetectionConfig answerMachineDetectionConfig() {
        return answerMachineDetectionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectSourcePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(answerMachineDetectionConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelephonyChannelSubtypeParameters)) {
            return false;
        }
        TelephonyChannelSubtypeParameters other = (TelephonyChannelSubtypeParameters) obj;
        return Objects.equals(destinationPhoneNumber(), other.destinationPhoneNumber())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && Objects.equals(connectSourcePhoneNumber(), other.connectSourcePhoneNumber())
                && Objects.equals(answerMachineDetectionConfig(), other.answerMachineDetectionConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TelephonyChannelSubtypeParameters")
                .add("DestinationPhoneNumber", destinationPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Attributes", attributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConnectSourcePhoneNumber", connectSourcePhoneNumber())
                .add("AnswerMachineDetectionConfig", answerMachineDetectionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinationPhoneNumber":
            return Optional.ofNullable(clazz.cast(destinationPhoneNumber()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "connectSourcePhoneNumber":
            return Optional.ofNullable(clazz.cast(connectSourcePhoneNumber()));
        case "answerMachineDetectionConfig":
            return Optional.ofNullable(clazz.cast(answerMachineDetectionConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destinationPhoneNumber", DESTINATION_PHONE_NUMBER_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("connectSourcePhoneNumber", CONNECT_SOURCE_PHONE_NUMBER_FIELD);
        map.put("answerMachineDetectionConfig", ANSWER_MACHINE_DETECTION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TelephonyChannelSubtypeParameters, T> g) {
        return obj -> g.apply((TelephonyChannelSubtypeParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TelephonyChannelSubtypeParameters> {
        /**
         * Sets the value of the DestinationPhoneNumber property for this object.
         *
         * @param destinationPhoneNumber
         *        The new value for the DestinationPhoneNumber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPhoneNumber(String destinationPhoneNumber);

        /**
         * Sets the value of the Attributes property for this object.
         *
         * @param attributes
         *        The new value for the Attributes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * Sets the value of the ConnectSourcePhoneNumber property for this object.
         *
         * @param connectSourcePhoneNumber
         *        The new value for the ConnectSourcePhoneNumber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectSourcePhoneNumber(String connectSourcePhoneNumber);

        /**
         * Sets the value of the AnswerMachineDetectionConfig property for this object.
         *
         * @param answerMachineDetectionConfig
         *        The new value for the AnswerMachineDetectionConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerMachineDetectionConfig(AnswerMachineDetectionConfig answerMachineDetectionConfig);

        /**
         * Sets the value of the AnswerMachineDetectionConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AnswerMachineDetectionConfig.Builder}
         * avoiding the need to create one manually via {@link AnswerMachineDetectionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnswerMachineDetectionConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #answerMachineDetectionConfig(AnswerMachineDetectionConfig)}.
         * 
         * @param answerMachineDetectionConfig
         *        a consumer that will call methods on {@link AnswerMachineDetectionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #answerMachineDetectionConfig(AnswerMachineDetectionConfig)
         */
        default Builder answerMachineDetectionConfig(Consumer<AnswerMachineDetectionConfig.Builder> answerMachineDetectionConfig) {
            return answerMachineDetectionConfig(AnswerMachineDetectionConfig.builder()
                    .applyMutation(answerMachineDetectionConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String destinationPhoneNumber;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String connectSourcePhoneNumber;

        private AnswerMachineDetectionConfig answerMachineDetectionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(TelephonyChannelSubtypeParameters model) {
            destinationPhoneNumber(model.destinationPhoneNumber);
            attributes(model.attributes);
            connectSourcePhoneNumber(model.connectSourcePhoneNumber);
            answerMachineDetectionConfig(model.answerMachineDetectionConfig);
        }

        public final String getDestinationPhoneNumber() {
            return destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final String getConnectSourcePhoneNumber() {
            return connectSourcePhoneNumber;
        }

        public final void setConnectSourcePhoneNumber(String connectSourcePhoneNumber) {
            this.connectSourcePhoneNumber = connectSourcePhoneNumber;
        }

        @Override
        public final Builder connectSourcePhoneNumber(String connectSourcePhoneNumber) {
            this.connectSourcePhoneNumber = connectSourcePhoneNumber;
            return this;
        }

        public final AnswerMachineDetectionConfig.Builder getAnswerMachineDetectionConfig() {
            return answerMachineDetectionConfig != null ? answerMachineDetectionConfig.toBuilder() : null;
        }

        public final void setAnswerMachineDetectionConfig(AnswerMachineDetectionConfig.BuilderImpl answerMachineDetectionConfig) {
            this.answerMachineDetectionConfig = answerMachineDetectionConfig != null ? answerMachineDetectionConfig.build()
                    : null;
        }

        @Override
        public final Builder answerMachineDetectionConfig(AnswerMachineDetectionConfig answerMachineDetectionConfig) {
            this.answerMachineDetectionConfig = answerMachineDetectionConfig;
            return this;
        }

        @Override
        public TelephonyChannelSubtypeParameters build() {
            return new TelephonyChannelSubtypeParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
