/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Time window config
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeWindow implements SdkPojo, Serializable, ToCopyableBuilder<TimeWindow.Builder, TimeWindow> {
    private static final SdkField<OpenHours> OPEN_HOURS_FIELD = SdkField.<OpenHours> builder(MarshallingType.SDK_POJO)
            .memberName("openHours").getter(getter(TimeWindow::openHours)).setter(setter(Builder::openHours))
            .constructor(OpenHours::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openHours").build()).build();

    private static final SdkField<RestrictedPeriods> RESTRICTED_PERIODS_FIELD = SdkField
            .<RestrictedPeriods> builder(MarshallingType.SDK_POJO).memberName("restrictedPeriods")
            .getter(getter(TimeWindow::restrictedPeriods)).setter(setter(Builder::restrictedPeriods))
            .constructor(RestrictedPeriods::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restrictedPeriods").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_HOURS_FIELD,
            RESTRICTED_PERIODS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OpenHours openHours;

    private final RestrictedPeriods restrictedPeriods;

    private TimeWindow(BuilderImpl builder) {
        this.openHours = builder.openHours;
        this.restrictedPeriods = builder.restrictedPeriods;
    }

    /**
     * Returns the value of the OpenHours property for this object.
     * 
     * @return The value of the OpenHours property for this object.
     */
    public final OpenHours openHours() {
        return openHours;
    }

    /**
     * Returns the value of the RestrictedPeriods property for this object.
     * 
     * @return The value of the RestrictedPeriods property for this object.
     */
    public final RestrictedPeriods restrictedPeriods() {
        return restrictedPeriods;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(openHours());
        hashCode = 31 * hashCode + Objects.hashCode(restrictedPeriods());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeWindow)) {
            return false;
        }
        TimeWindow other = (TimeWindow) obj;
        return Objects.equals(openHours(), other.openHours()) && Objects.equals(restrictedPeriods(), other.restrictedPeriods());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeWindow").add("OpenHours", openHours()).add("RestrictedPeriods", restrictedPeriods()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "openHours":
            return Optional.ofNullable(clazz.cast(openHours()));
        case "restrictedPeriods":
            return Optional.ofNullable(clazz.cast(restrictedPeriods()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("openHours", OPEN_HOURS_FIELD);
        map.put("restrictedPeriods", RESTRICTED_PERIODS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeWindow, T> g) {
        return obj -> g.apply((TimeWindow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeWindow> {
        /**
         * Sets the value of the OpenHours property for this object.
         *
         * @param openHours
         *        The new value for the OpenHours property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openHours(OpenHours openHours);

        /**
         * Sets the value of the OpenHours property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OpenHours.Builder} avoiding the need to
         * create one manually via {@link OpenHours#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenHours.Builder#build()} is called immediately and its result
         * is passed to {@link #openHours(OpenHours)}.
         * 
         * @param openHours
         *        a consumer that will call methods on {@link OpenHours.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openHours(OpenHours)
         */
        default Builder openHours(Consumer<OpenHours.Builder> openHours) {
            return openHours(OpenHours.builder().applyMutation(openHours).build());
        }

        /**
         * Sets the value of the RestrictedPeriods property for this object.
         *
         * @param restrictedPeriods
         *        The new value for the RestrictedPeriods property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictedPeriods(RestrictedPeriods restrictedPeriods);

        /**
         * Sets the value of the RestrictedPeriods property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RestrictedPeriods.Builder} avoiding the
         * need to create one manually via {@link RestrictedPeriods#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RestrictedPeriods.Builder#build()} is called immediately and its
         * result is passed to {@link #restrictedPeriods(RestrictedPeriods)}.
         * 
         * @param restrictedPeriods
         *        a consumer that will call methods on {@link RestrictedPeriods.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restrictedPeriods(RestrictedPeriods)
         */
        default Builder restrictedPeriods(Consumer<RestrictedPeriods.Builder> restrictedPeriods) {
            return restrictedPeriods(RestrictedPeriods.builder().applyMutation(restrictedPeriods).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OpenHours openHours;

        private RestrictedPeriods restrictedPeriods;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeWindow model) {
            openHours(model.openHours);
            restrictedPeriods(model.restrictedPeriods);
        }

        public final OpenHours.Builder getOpenHours() {
            return openHours != null ? openHours.toBuilder() : null;
        }

        public final void setOpenHours(OpenHours.BuilderImpl openHours) {
            this.openHours = openHours != null ? openHours.build() : null;
        }

        @Override
        public final Builder openHours(OpenHours openHours) {
            this.openHours = openHours;
            return this;
        }

        public final RestrictedPeriods.Builder getRestrictedPeriods() {
            return restrictedPeriods != null ? restrictedPeriods.toBuilder() : null;
        }

        public final void setRestrictedPeriods(RestrictedPeriods.BuilderImpl restrictedPeriods) {
            this.restrictedPeriods = restrictedPeriods != null ? restrictedPeriods.build() : null;
        }

        @Override
        public final Builder restrictedPeriods(RestrictedPeriods restrictedPeriods) {
            this.restrictedPeriods = restrictedPeriods;
            return this;
        }

        @Override
        public TimeWindow build() {
            return new TimeWindow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
