/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request for UpdateCampaignChannelSubtypeConfig API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCampaignChannelSubtypeConfigRequest extends ConnectCampaignsV2Request implements
        ToCopyableBuilder<UpdateCampaignChannelSubtypeConfigRequest.Builder, UpdateCampaignChannelSubtypeConfigRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateCampaignChannelSubtypeConfigRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<ChannelSubtypeConfig> CHANNEL_SUBTYPE_CONFIG_FIELD = SdkField
            .<ChannelSubtypeConfig> builder(MarshallingType.SDK_POJO).memberName("channelSubtypeConfig")
            .getter(getter(UpdateCampaignChannelSubtypeConfigRequest::channelSubtypeConfig))
            .setter(setter(Builder::channelSubtypeConfig)).constructor(ChannelSubtypeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelSubtypeConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            CHANNEL_SUBTYPE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final ChannelSubtypeConfig channelSubtypeConfig;

    private UpdateCampaignChannelSubtypeConfigRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.channelSubtypeConfig = builder.channelSubtypeConfig;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the ChannelSubtypeConfig property for this object.
     * 
     * @return The value of the ChannelSubtypeConfig property for this object.
     */
    public final ChannelSubtypeConfig channelSubtypeConfig() {
        return channelSubtypeConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(channelSubtypeConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCampaignChannelSubtypeConfigRequest)) {
            return false;
        }
        UpdateCampaignChannelSubtypeConfigRequest other = (UpdateCampaignChannelSubtypeConfigRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(channelSubtypeConfig(), other.channelSubtypeConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCampaignChannelSubtypeConfigRequest").add("Id", id())
                .add("ChannelSubtypeConfig", channelSubtypeConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "channelSubtypeConfig":
            return Optional.ofNullable(clazz.cast(channelSubtypeConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("channelSubtypeConfig", CHANNEL_SUBTYPE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCampaignChannelSubtypeConfigRequest, T> g) {
        return obj -> g.apply((UpdateCampaignChannelSubtypeConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectCampaignsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateCampaignChannelSubtypeConfigRequest> {
        /**
         * Sets the value of the Id property for this object.
         *
         * @param id
         *        The new value for the Id property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the ChannelSubtypeConfig property for this object.
         *
         * @param channelSubtypeConfig
         *        The new value for the ChannelSubtypeConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelSubtypeConfig(ChannelSubtypeConfig channelSubtypeConfig);

        /**
         * Sets the value of the ChannelSubtypeConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ChannelSubtypeConfig.Builder} avoiding
         * the need to create one manually via {@link ChannelSubtypeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChannelSubtypeConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #channelSubtypeConfig(ChannelSubtypeConfig)}.
         * 
         * @param channelSubtypeConfig
         *        a consumer that will call methods on {@link ChannelSubtypeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelSubtypeConfig(ChannelSubtypeConfig)
         */
        default Builder channelSubtypeConfig(Consumer<ChannelSubtypeConfig.Builder> channelSubtypeConfig) {
            return channelSubtypeConfig(ChannelSubtypeConfig.builder().applyMutation(channelSubtypeConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCampaignsV2Request.BuilderImpl implements Builder {
        private String id;

        private ChannelSubtypeConfig channelSubtypeConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCampaignChannelSubtypeConfigRequest model) {
            super(model);
            id(model.id);
            channelSubtypeConfig(model.channelSubtypeConfig);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ChannelSubtypeConfig.Builder getChannelSubtypeConfig() {
            return channelSubtypeConfig != null ? channelSubtypeConfig.toBuilder() : null;
        }

        public final void setChannelSubtypeConfig(ChannelSubtypeConfig.BuilderImpl channelSubtypeConfig) {
            this.channelSubtypeConfig = channelSubtypeConfig != null ? channelSubtypeConfig.build() : null;
        }

        @Override
        public final Builder channelSubtypeConfig(ChannelSubtypeConfig channelSubtypeConfig) {
            this.channelSubtypeConfig = channelSubtypeConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCampaignChannelSubtypeConfigRequest build() {
            return new UpdateCampaignChannelSubtypeConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
