/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filter model by type
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CampaignFilters implements SdkPojo, Serializable, ToCopyableBuilder<CampaignFilters.Builder, CampaignFilters> {
    private static final SdkField<InstanceIdFilter> INSTANCE_ID_FILTER_FIELD = SdkField
            .<InstanceIdFilter> builder(MarshallingType.SDK_POJO).memberName("instanceIdFilter")
            .getter(getter(CampaignFilters::instanceIdFilter)).setter(setter(Builder::instanceIdFilter))
            .constructor(InstanceIdFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceIdFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InstanceIdFilter instanceIdFilter;

    private CampaignFilters(BuilderImpl builder) {
        this.instanceIdFilter = builder.instanceIdFilter;
    }

    /**
     * Returns the value of the InstanceIdFilter property for this object.
     * 
     * @return The value of the InstanceIdFilter property for this object.
     */
    public final InstanceIdFilter instanceIdFilter() {
        return instanceIdFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceIdFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignFilters)) {
            return false;
        }
        CampaignFilters other = (CampaignFilters) obj;
        return Objects.equals(instanceIdFilter(), other.instanceIdFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CampaignFilters").add("InstanceIdFilter", instanceIdFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceIdFilter":
            return Optional.ofNullable(clazz.cast(instanceIdFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instanceIdFilter", INSTANCE_ID_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CampaignFilters, T> g) {
        return obj -> g.apply((CampaignFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CampaignFilters> {
        /**
         * Sets the value of the InstanceIdFilter property for this object.
         *
         * @param instanceIdFilter
         *        The new value for the InstanceIdFilter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIdFilter(InstanceIdFilter instanceIdFilter);

        /**
         * Sets the value of the InstanceIdFilter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InstanceIdFilter.Builder} avoiding the
         * need to create one manually via {@link InstanceIdFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceIdFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceIdFilter(InstanceIdFilter)}.
         * 
         * @param instanceIdFilter
         *        a consumer that will call methods on {@link InstanceIdFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceIdFilter(InstanceIdFilter)
         */
        default Builder instanceIdFilter(Consumer<InstanceIdFilter.Builder> instanceIdFilter) {
            return instanceIdFilter(InstanceIdFilter.builder().applyMutation(instanceIdFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InstanceIdFilter instanceIdFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignFilters model) {
            instanceIdFilter(model.instanceIdFilter);
        }

        public final InstanceIdFilter.Builder getInstanceIdFilter() {
            return instanceIdFilter != null ? instanceIdFilter.toBuilder() : null;
        }

        public final void setInstanceIdFilter(InstanceIdFilter.BuilderImpl instanceIdFilter) {
            this.instanceIdFilter = instanceIdFilter != null ? instanceIdFilter.build() : null;
        }

        @Override
        public final Builder instanceIdFilter(InstanceIdFilter instanceIdFilter) {
            this.instanceIdFilter = instanceIdFilter;
            return this;
        }

        @Override
        public CampaignFilters build() {
            return new CampaignFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
