/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon Connect campaign summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CampaignSummary implements SdkPojo, Serializable, ToCopyableBuilder<CampaignSummary.Builder, CampaignSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CampaignSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CampaignSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CampaignSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CONNECT_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectInstanceId").getter(getter(CampaignSummary::connectInstanceId))
            .setter(setter(Builder::connectInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectInstanceId").build()).build();

    private static final SdkField<List<String>> CHANNEL_SUBTYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("channelSubtypes")
            .getter(getter(CampaignSummary::channelSubtypesAsStrings))
            .setter(setter(Builder::channelSubtypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelSubtypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .memberName("schedule").getter(getter(CampaignSummary::schedule)).setter(setter(Builder::schedule))
            .constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<String> CONNECT_CAMPAIGN_FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectCampaignFlowArn").getter(getter(CampaignSummary::connectCampaignFlowArn))
            .setter(setter(Builder::connectCampaignFlowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectCampaignFlowArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, CONNECT_INSTANCE_ID_FIELD, CHANNEL_SUBTYPES_FIELD, SCHEDULE_FIELD, CONNECT_CAMPAIGN_FLOW_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String connectInstanceId;

    private final List<String> channelSubtypes;

    private final Schedule schedule;

    private final String connectCampaignFlowArn;

    private CampaignSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.connectInstanceId = builder.connectInstanceId;
        this.channelSubtypes = builder.channelSubtypes;
        this.schedule = builder.schedule;
        this.connectCampaignFlowArn = builder.connectCampaignFlowArn;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the Arn property for this object.
     * 
     * @return The value of the Arn property for this object.
     */
    public final String arn() {
        return arn;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the ConnectInstanceId property for this object.
     * 
     * @return The value of the ConnectInstanceId property for this object.
     */
    public final String connectInstanceId() {
        return connectInstanceId;
    }

    /**
     * Returns the value of the ChannelSubtypes property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelSubtypes} method.
     * </p>
     * 
     * @return The value of the ChannelSubtypes property for this object.
     */
    public final List<ChannelSubtype> channelSubtypes() {
        return ChannelSubtypeListCopier.copyStringToEnum(channelSubtypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelSubtypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChannelSubtypes() {
        return channelSubtypes != null && !(channelSubtypes instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the ChannelSubtypes property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelSubtypes} method.
     * </p>
     * 
     * @return The value of the ChannelSubtypes property for this object.
     */
    public final List<String> channelSubtypesAsStrings() {
        return channelSubtypes;
    }

    /**
     * Returns the value of the Schedule property for this object.
     * 
     * @return The value of the Schedule property for this object.
     */
    public final Schedule schedule() {
        return schedule;
    }

    /**
     * Returns the value of the ConnectCampaignFlowArn property for this object.
     * 
     * @return The value of the ConnectCampaignFlowArn property for this object.
     */
    public final String connectCampaignFlowArn() {
        return connectCampaignFlowArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(connectInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelSubtypes() ? channelSubtypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(connectCampaignFlowArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignSummary)) {
            return false;
        }
        CampaignSummary other = (CampaignSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(connectInstanceId(), other.connectInstanceId())
                && hasChannelSubtypes() == other.hasChannelSubtypes()
                && Objects.equals(channelSubtypesAsStrings(), other.channelSubtypesAsStrings())
                && Objects.equals(schedule(), other.schedule())
                && Objects.equals(connectCampaignFlowArn(), other.connectCampaignFlowArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CampaignSummary").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("ConnectInstanceId", connectInstanceId())
                .add("ChannelSubtypes", hasChannelSubtypes() ? channelSubtypesAsStrings() : null).add("Schedule", schedule())
                .add("ConnectCampaignFlowArn", connectCampaignFlowArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "connectInstanceId":
            return Optional.ofNullable(clazz.cast(connectInstanceId()));
        case "channelSubtypes":
            return Optional.ofNullable(clazz.cast(channelSubtypesAsStrings()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "connectCampaignFlowArn":
            return Optional.ofNullable(clazz.cast(connectCampaignFlowArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("connectInstanceId", CONNECT_INSTANCE_ID_FIELD);
        map.put("channelSubtypes", CHANNEL_SUBTYPES_FIELD);
        map.put("schedule", SCHEDULE_FIELD);
        map.put("connectCampaignFlowArn", CONNECT_CAMPAIGN_FLOW_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CampaignSummary, T> g) {
        return obj -> g.apply((CampaignSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CampaignSummary> {
        /**
         * Sets the value of the Id property for this object.
         *
         * @param id
         *        The new value for the Id property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the Arn property for this object.
         *
         * @param arn
         *        The new value for the Arn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the ConnectInstanceId property for this object.
         *
         * @param connectInstanceId
         *        The new value for the ConnectInstanceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectInstanceId(String connectInstanceId);

        /**
         * Sets the value of the ChannelSubtypes property for this object.
         *
         * @param channelSubtypes
         *        The new value for the ChannelSubtypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelSubtypesWithStrings(Collection<String> channelSubtypes);

        /**
         * Sets the value of the ChannelSubtypes property for this object.
         *
         * @param channelSubtypes
         *        The new value for the ChannelSubtypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelSubtypesWithStrings(String... channelSubtypes);

        /**
         * Sets the value of the ChannelSubtypes property for this object.
         *
         * @param channelSubtypes
         *        The new value for the ChannelSubtypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelSubtypes(Collection<ChannelSubtype> channelSubtypes);

        /**
         * Sets the value of the ChannelSubtypes property for this object.
         *
         * @param channelSubtypes
         *        The new value for the ChannelSubtypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelSubtypes(ChannelSubtype... channelSubtypes);

        /**
         * Sets the value of the Schedule property for this object.
         *
         * @param schedule
         *        The new value for the Schedule property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * Sets the value of the Schedule property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Schedule.Builder} avoiding the need to
         * create one manually via {@link Schedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * Sets the value of the ConnectCampaignFlowArn property for this object.
         *
         * @param connectCampaignFlowArn
         *        The new value for the ConnectCampaignFlowArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectCampaignFlowArn(String connectCampaignFlowArn);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String connectInstanceId;

        private List<String> channelSubtypes = DefaultSdkAutoConstructList.getInstance();

        private Schedule schedule;

        private String connectCampaignFlowArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignSummary model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            connectInstanceId(model.connectInstanceId);
            channelSubtypesWithStrings(model.channelSubtypes);
            schedule(model.schedule);
            connectCampaignFlowArn(model.connectCampaignFlowArn);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getConnectInstanceId() {
            return connectInstanceId;
        }

        public final void setConnectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
        }

        @Override
        public final Builder connectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
            return this;
        }

        public final Collection<String> getChannelSubtypes() {
            if (channelSubtypes instanceof SdkAutoConstructList) {
                return null;
            }
            return channelSubtypes;
        }

        public final void setChannelSubtypes(Collection<String> channelSubtypes) {
            this.channelSubtypes = ChannelSubtypeListCopier.copy(channelSubtypes);
        }

        @Override
        public final Builder channelSubtypesWithStrings(Collection<String> channelSubtypes) {
            this.channelSubtypes = ChannelSubtypeListCopier.copy(channelSubtypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelSubtypesWithStrings(String... channelSubtypes) {
            channelSubtypesWithStrings(Arrays.asList(channelSubtypes));
            return this;
        }

        @Override
        public final Builder channelSubtypes(Collection<ChannelSubtype> channelSubtypes) {
            this.channelSubtypes = ChannelSubtypeListCopier.copyEnumToString(channelSubtypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelSubtypes(ChannelSubtype... channelSubtypes) {
            channelSubtypes(Arrays.asList(channelSubtypes));
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getConnectCampaignFlowArn() {
            return connectCampaignFlowArn;
        }

        public final void setConnectCampaignFlowArn(String connectCampaignFlowArn) {
            this.connectCampaignFlowArn = connectCampaignFlowArn;
        }

        @Override
        public final Builder connectCampaignFlowArn(String connectCampaignFlowArn) {
            this.connectCampaignFlowArn = connectCampaignFlowArn;
            return this;
        }

        @Override
        public CampaignSummary build() {
            return new CampaignSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
