/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ChannelSubtypeParameters for an outbound request
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelSubtypeParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelSubtypeParameters.Builder, ChannelSubtypeParameters> {
    private static final SdkField<TelephonyChannelSubtypeParameters> TELEPHONY_FIELD = SdkField
            .<TelephonyChannelSubtypeParameters> builder(MarshallingType.SDK_POJO).memberName("telephony")
            .getter(getter(ChannelSubtypeParameters::telephony)).setter(setter(Builder::telephony))
            .constructor(TelephonyChannelSubtypeParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telephony").build()).build();

    private static final SdkField<SmsChannelSubtypeParameters> SMS_FIELD = SdkField
            .<SmsChannelSubtypeParameters> builder(MarshallingType.SDK_POJO).memberName("sms")
            .getter(getter(ChannelSubtypeParameters::sms)).setter(setter(Builder::sms))
            .constructor(SmsChannelSubtypeParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sms").build()).build();

    private static final SdkField<EmailChannelSubtypeParameters> EMAIL_FIELD = SdkField
            .<EmailChannelSubtypeParameters> builder(MarshallingType.SDK_POJO).memberName("email")
            .getter(getter(ChannelSubtypeParameters::email)).setter(setter(Builder::email))
            .constructor(EmailChannelSubtypeParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TELEPHONY_FIELD, SMS_FIELD,
            EMAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TelephonyChannelSubtypeParameters telephony;

    private final SmsChannelSubtypeParameters sms;

    private final EmailChannelSubtypeParameters email;

    private final Type type;

    private ChannelSubtypeParameters(BuilderImpl builder) {
        this.telephony = builder.telephony;
        this.sms = builder.sms;
        this.email = builder.email;
        this.type = builder.type;
    }

    /**
     * Returns the value of the Telephony property for this object.
     * 
     * @return The value of the Telephony property for this object.
     */
    public final TelephonyChannelSubtypeParameters telephony() {
        return telephony;
    }

    /**
     * Returns the value of the Sms property for this object.
     * 
     * @return The value of the Sms property for this object.
     */
    public final SmsChannelSubtypeParameters sms() {
        return sms;
    }

    /**
     * Returns the value of the Email property for this object.
     * 
     * @return The value of the Email property for this object.
     */
    public final EmailChannelSubtypeParameters email() {
        return email;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(telephony());
        hashCode = 31 * hashCode + Objects.hashCode(sms());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelSubtypeParameters)) {
            return false;
        }
        ChannelSubtypeParameters other = (ChannelSubtypeParameters) obj;
        return Objects.equals(telephony(), other.telephony()) && Objects.equals(sms(), other.sms())
                && Objects.equals(email(), other.email());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelSubtypeParameters").add("Telephony", telephony()).add("Sms", sms()).add("Email", email())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "telephony":
            return Optional.ofNullable(clazz.cast(telephony()));
        case "sms":
            return Optional.ofNullable(clazz.cast(sms()));
        case "email":
            return Optional.ofNullable(clazz.cast(email()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #telephony()} initialized to the given value.
     *
     * Sets the value of the Telephony property for this object.
     *
     * @param telephony
     *        The new value for the Telephony property for this object.
     */
    public static ChannelSubtypeParameters fromTelephony(TelephonyChannelSubtypeParameters telephony) {
        return builder().telephony(telephony).build();
    }

    /**
     * Create an instance of this class with {@link #telephony()} initialized to the given value.
     *
     * Sets the value of the Telephony property for this object.
     *
     * @param telephony
     *        The new value for the Telephony property for this object.
     */
    public static ChannelSubtypeParameters fromTelephony(Consumer<TelephonyChannelSubtypeParameters.Builder> telephony) {
        TelephonyChannelSubtypeParameters.Builder builder = TelephonyChannelSubtypeParameters.builder();
        telephony.accept(builder);
        return fromTelephony(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sms()} initialized to the given value.
     *
     * Sets the value of the Sms property for this object.
     *
     * @param sms
     *        The new value for the Sms property for this object.
     */
    public static ChannelSubtypeParameters fromSms(SmsChannelSubtypeParameters sms) {
        return builder().sms(sms).build();
    }

    /**
     * Create an instance of this class with {@link #sms()} initialized to the given value.
     *
     * Sets the value of the Sms property for this object.
     *
     * @param sms
     *        The new value for the Sms property for this object.
     */
    public static ChannelSubtypeParameters fromSms(Consumer<SmsChannelSubtypeParameters.Builder> sms) {
        SmsChannelSubtypeParameters.Builder builder = SmsChannelSubtypeParameters.builder();
        sms.accept(builder);
        return fromSms(builder.build());
    }

    /**
     * Create an instance of this class with {@link #email()} initialized to the given value.
     *
     * Sets the value of the Email property for this object.
     *
     * @param email
     *        The new value for the Email property for this object.
     */
    public static ChannelSubtypeParameters fromEmail(EmailChannelSubtypeParameters email) {
        return builder().email(email).build();
    }

    /**
     * Create an instance of this class with {@link #email()} initialized to the given value.
     *
     * Sets the value of the Email property for this object.
     *
     * @param email
     *        The new value for the Email property for this object.
     */
    public static ChannelSubtypeParameters fromEmail(Consumer<EmailChannelSubtypeParameters.Builder> email) {
        EmailChannelSubtypeParameters.Builder builder = EmailChannelSubtypeParameters.builder();
        email.accept(builder);
        return fromEmail(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("telephony", TELEPHONY_FIELD);
        map.put("sms", SMS_FIELD);
        map.put("email", EMAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChannelSubtypeParameters, T> g) {
        return obj -> g.apply((ChannelSubtypeParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelSubtypeParameters> {
        /**
         * Sets the value of the Telephony property for this object.
         *
         * @param telephony
         *        The new value for the Telephony property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telephony(TelephonyChannelSubtypeParameters telephony);

        /**
         * Sets the value of the Telephony property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link TelephonyChannelSubtypeParameters.Builder} avoiding the need to create one manually via
         * {@link TelephonyChannelSubtypeParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TelephonyChannelSubtypeParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #telephony(TelephonyChannelSubtypeParameters)}.
         * 
         * @param telephony
         *        a consumer that will call methods on {@link TelephonyChannelSubtypeParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #telephony(TelephonyChannelSubtypeParameters)
         */
        default Builder telephony(Consumer<TelephonyChannelSubtypeParameters.Builder> telephony) {
            return telephony(TelephonyChannelSubtypeParameters.builder().applyMutation(telephony).build());
        }

        /**
         * Sets the value of the Sms property for this object.
         *
         * @param sms
         *        The new value for the Sms property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sms(SmsChannelSubtypeParameters sms);

        /**
         * Sets the value of the Sms property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SmsChannelSubtypeParameters.Builder}
         * avoiding the need to create one manually via {@link SmsChannelSubtypeParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SmsChannelSubtypeParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #sms(SmsChannelSubtypeParameters)}.
         * 
         * @param sms
         *        a consumer that will call methods on {@link SmsChannelSubtypeParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sms(SmsChannelSubtypeParameters)
         */
        default Builder sms(Consumer<SmsChannelSubtypeParameters.Builder> sms) {
            return sms(SmsChannelSubtypeParameters.builder().applyMutation(sms).build());
        }

        /**
         * Sets the value of the Email property for this object.
         *
         * @param email
         *        The new value for the Email property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(EmailChannelSubtypeParameters email);

        /**
         * Sets the value of the Email property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EmailChannelSubtypeParameters.Builder}
         * avoiding the need to create one manually via {@link EmailChannelSubtypeParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailChannelSubtypeParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #email(EmailChannelSubtypeParameters)}.
         * 
         * @param email
         *        a consumer that will call methods on {@link EmailChannelSubtypeParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #email(EmailChannelSubtypeParameters)
         */
        default Builder email(Consumer<EmailChannelSubtypeParameters.Builder> email) {
            return email(EmailChannelSubtypeParameters.builder().applyMutation(email).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TelephonyChannelSubtypeParameters telephony;

        private SmsChannelSubtypeParameters sms;

        private EmailChannelSubtypeParameters email;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelSubtypeParameters model) {
            telephony(model.telephony);
            sms(model.sms);
            email(model.email);
        }

        public final TelephonyChannelSubtypeParameters.Builder getTelephony() {
            return telephony != null ? telephony.toBuilder() : null;
        }

        public final void setTelephony(TelephonyChannelSubtypeParameters.BuilderImpl telephony) {
            Object oldValue = this.telephony;
            this.telephony = telephony != null ? telephony.build() : null;
            handleUnionValueChange(Type.TELEPHONY, oldValue, this.telephony);
        }

        @Override
        public final Builder telephony(TelephonyChannelSubtypeParameters telephony) {
            Object oldValue = this.telephony;
            this.telephony = telephony;
            handleUnionValueChange(Type.TELEPHONY, oldValue, this.telephony);
            return this;
        }

        public final SmsChannelSubtypeParameters.Builder getSms() {
            return sms != null ? sms.toBuilder() : null;
        }

        public final void setSms(SmsChannelSubtypeParameters.BuilderImpl sms) {
            Object oldValue = this.sms;
            this.sms = sms != null ? sms.build() : null;
            handleUnionValueChange(Type.SMS, oldValue, this.sms);
        }

        @Override
        public final Builder sms(SmsChannelSubtypeParameters sms) {
            Object oldValue = this.sms;
            this.sms = sms;
            handleUnionValueChange(Type.SMS, oldValue, this.sms);
            return this;
        }

        public final EmailChannelSubtypeParameters.Builder getEmail() {
            return email != null ? email.toBuilder() : null;
        }

        public final void setEmail(EmailChannelSubtypeParameters.BuilderImpl email) {
            Object oldValue = this.email;
            this.email = email != null ? email.build() : null;
            handleUnionValueChange(Type.EMAIL, oldValue, this.email);
        }

        @Override
        public final Builder email(EmailChannelSubtypeParameters email) {
            Object oldValue = this.email;
            this.email = email;
            handleUnionValueChange(Type.EMAIL, oldValue, this.email);
            return this;
        }

        @Override
        public ChannelSubtypeParameters build() {
            return new ChannelSubtypeParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ChannelSubtypeParameters#type()
     */
    public enum Type {
        TELEPHONY,

        SMS,

        EMAIL,

        UNKNOWN_TO_SDK_VERSION
    }
}
