/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Communication Limit
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommunicationLimit implements SdkPojo, Serializable,
        ToCopyableBuilder<CommunicationLimit.Builder, CommunicationLimit> {
    private static final SdkField<Integer> MAX_COUNT_PER_RECIPIENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxCountPerRecipient").getter(getter(CommunicationLimit::maxCountPerRecipient))
            .setter(setter(Builder::maxCountPerRecipient))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCountPerRecipient").build())
            .build();

    private static final SdkField<Integer> FREQUENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("frequency").getter(getter(CommunicationLimit::frequency)).setter(setter(Builder::frequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(CommunicationLimit::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_COUNT_PER_RECIPIENT_FIELD,
            FREQUENCY_FIELD, UNIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maxCountPerRecipient;

    private final Integer frequency;

    private final String unit;

    private CommunicationLimit(BuilderImpl builder) {
        this.maxCountPerRecipient = builder.maxCountPerRecipient;
        this.frequency = builder.frequency;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * Maximum number of contacts allowed for a given target within the given frequency.
     * </p>
     * 
     * @return Maximum number of contacts allowed for a given target within the given frequency.
     */
    public final Integer maxCountPerRecipient() {
        return maxCountPerRecipient;
    }

    /**
     * <p>
     * The number of days to consider with regards to this limit.
     * </p>
     * 
     * @return The number of days to consider with regards to this limit.
     */
    public final Integer frequency() {
        return frequency;
    }

    /**
     * Returns the value of the Unit property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link CommunicationLimitTimeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #unitAsString}.
     * </p>
     * 
     * @return The value of the Unit property for this object.
     * @see CommunicationLimitTimeUnit
     */
    public final CommunicationLimitTimeUnit unit() {
        return CommunicationLimitTimeUnit.fromValue(unit);
    }

    /**
     * Returns the value of the Unit property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link CommunicationLimitTimeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #unitAsString}.
     * </p>
     * 
     * @return The value of the Unit property for this object.
     * @see CommunicationLimitTimeUnit
     */
    public final String unitAsString() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxCountPerRecipient());
        hashCode = 31 * hashCode + Objects.hashCode(frequency());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommunicationLimit)) {
            return false;
        }
        CommunicationLimit other = (CommunicationLimit) obj;
        return Objects.equals(maxCountPerRecipient(), other.maxCountPerRecipient())
                && Objects.equals(frequency(), other.frequency()) && Objects.equals(unitAsString(), other.unitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommunicationLimit").add("MaxCountPerRecipient", maxCountPerRecipient())
                .add("Frequency", frequency()).add("Unit", unitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxCountPerRecipient":
            return Optional.ofNullable(clazz.cast(maxCountPerRecipient()));
        case "frequency":
            return Optional.ofNullable(clazz.cast(frequency()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxCountPerRecipient", MAX_COUNT_PER_RECIPIENT_FIELD);
        map.put("frequency", FREQUENCY_FIELD);
        map.put("unit", UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommunicationLimit, T> g) {
        return obj -> g.apply((CommunicationLimit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommunicationLimit> {
        /**
         * <p>
         * Maximum number of contacts allowed for a given target within the given frequency.
         * </p>
         * 
         * @param maxCountPerRecipient
         *        Maximum number of contacts allowed for a given target within the given frequency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCountPerRecipient(Integer maxCountPerRecipient);

        /**
         * <p>
         * The number of days to consider with regards to this limit.
         * </p>
         * 
         * @param frequency
         *        The number of days to consider with regards to this limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frequency(Integer frequency);

        /**
         * Sets the value of the Unit property for this object.
         *
         * @param unit
         *        The new value for the Unit property for this object.
         * @see CommunicationLimitTimeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommunicationLimitTimeUnit
         */
        Builder unit(String unit);

        /**
         * Sets the value of the Unit property for this object.
         *
         * @param unit
         *        The new value for the Unit property for this object.
         * @see CommunicationLimitTimeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommunicationLimitTimeUnit
         */
        Builder unit(CommunicationLimitTimeUnit unit);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxCountPerRecipient;

        private Integer frequency;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(CommunicationLimit model) {
            maxCountPerRecipient(model.maxCountPerRecipient);
            frequency(model.frequency);
            unit(model.unit);
        }

        public final Integer getMaxCountPerRecipient() {
            return maxCountPerRecipient;
        }

        public final void setMaxCountPerRecipient(Integer maxCountPerRecipient) {
            this.maxCountPerRecipient = maxCountPerRecipient;
        }

        @Override
        public final Builder maxCountPerRecipient(Integer maxCountPerRecipient) {
            this.maxCountPerRecipient = maxCountPerRecipient;
            return this;
        }

        public final Integer getFrequency() {
            return frequency;
        }

        public final void setFrequency(Integer frequency) {
            this.frequency = frequency;
        }

        @Override
        public final Builder frequency(Integer frequency) {
            this.frequency = frequency;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(CommunicationLimitTimeUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        @Override
        public CommunicationLimit build() {
            return new CommunicationLimit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
