/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request for CreateCampaign API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCampaignRequest extends ConnectCampaignsV2Request implements
        ToCopyableBuilder<CreateCampaignRequest.Builder, CreateCampaignRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateCampaignRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CONNECT_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectInstanceId").getter(getter(CreateCampaignRequest::connectInstanceId))
            .setter(setter(Builder::connectInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectInstanceId").build()).build();

    private static final SdkField<ChannelSubtypeConfig> CHANNEL_SUBTYPE_CONFIG_FIELD = SdkField
            .<ChannelSubtypeConfig> builder(MarshallingType.SDK_POJO).memberName("channelSubtypeConfig")
            .getter(getter(CreateCampaignRequest::channelSubtypeConfig)).setter(setter(Builder::channelSubtypeConfig))
            .constructor(ChannelSubtypeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelSubtypeConfig").build())
            .build();

    private static final SdkField<Source> SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO).memberName("source")
            .getter(getter(CreateCampaignRequest::source)).setter(setter(Builder::source)).constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> CONNECT_CAMPAIGN_FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectCampaignFlowArn").getter(getter(CreateCampaignRequest::connectCampaignFlowArn))
            .setter(setter(Builder::connectCampaignFlowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectCampaignFlowArn").build())
            .build();

    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .memberName("schedule").getter(getter(CreateCampaignRequest::schedule)).setter(setter(Builder::schedule))
            .constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<CommunicationTimeConfig> COMMUNICATION_TIME_CONFIG_FIELD = SdkField
            .<CommunicationTimeConfig> builder(MarshallingType.SDK_POJO).memberName("communicationTimeConfig")
            .getter(getter(CreateCampaignRequest::communicationTimeConfig)).setter(setter(Builder::communicationTimeConfig))
            .constructor(CommunicationTimeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("communicationTimeConfig").build())
            .build();

    private static final SdkField<CommunicationLimitsConfig> COMMUNICATION_LIMITS_OVERRIDE_FIELD = SdkField
            .<CommunicationLimitsConfig> builder(MarshallingType.SDK_POJO)
            .memberName("communicationLimitsOverride")
            .getter(getter(CreateCampaignRequest::communicationLimitsOverride))
            .setter(setter(Builder::communicationLimitsOverride))
            .constructor(CommunicationLimitsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("communicationLimitsOverride")
                    .build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateCampaignRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CONNECT_INSTANCE_ID_FIELD, CHANNEL_SUBTYPE_CONFIG_FIELD, SOURCE_FIELD, CONNECT_CAMPAIGN_FLOW_ARN_FIELD,
            SCHEDULE_FIELD, COMMUNICATION_TIME_CONFIG_FIELD, COMMUNICATION_LIMITS_OVERRIDE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String connectInstanceId;

    private final ChannelSubtypeConfig channelSubtypeConfig;

    private final Source source;

    private final String connectCampaignFlowArn;

    private final Schedule schedule;

    private final CommunicationTimeConfig communicationTimeConfig;

    private final CommunicationLimitsConfig communicationLimitsOverride;

    private final Map<String, String> tags;

    private CreateCampaignRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.connectInstanceId = builder.connectInstanceId;
        this.channelSubtypeConfig = builder.channelSubtypeConfig;
        this.source = builder.source;
        this.connectCampaignFlowArn = builder.connectCampaignFlowArn;
        this.schedule = builder.schedule;
        this.communicationTimeConfig = builder.communicationTimeConfig;
        this.communicationLimitsOverride = builder.communicationLimitsOverride;
        this.tags = builder.tags;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the ConnectInstanceId property for this object.
     * 
     * @return The value of the ConnectInstanceId property for this object.
     */
    public final String connectInstanceId() {
        return connectInstanceId;
    }

    /**
     * Returns the value of the ChannelSubtypeConfig property for this object.
     * 
     * @return The value of the ChannelSubtypeConfig property for this object.
     */
    public final ChannelSubtypeConfig channelSubtypeConfig() {
        return channelSubtypeConfig;
    }

    /**
     * Returns the value of the Source property for this object.
     * 
     * @return The value of the Source property for this object.
     */
    public final Source source() {
        return source;
    }

    /**
     * Returns the value of the ConnectCampaignFlowArn property for this object.
     * 
     * @return The value of the ConnectCampaignFlowArn property for this object.
     */
    public final String connectCampaignFlowArn() {
        return connectCampaignFlowArn;
    }

    /**
     * Returns the value of the Schedule property for this object.
     * 
     * @return The value of the Schedule property for this object.
     */
    public final Schedule schedule() {
        return schedule;
    }

    /**
     * Returns the value of the CommunicationTimeConfig property for this object.
     * 
     * @return The value of the CommunicationTimeConfig property for this object.
     */
    public final CommunicationTimeConfig communicationTimeConfig() {
        return communicationTimeConfig;
    }

    /**
     * Returns the value of the CommunicationLimitsOverride property for this object.
     * 
     * @return The value of the CommunicationLimitsOverride property for this object.
     */
    public final CommunicationLimitsConfig communicationLimitsOverride() {
        return communicationLimitsOverride;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(connectInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(channelSubtypeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(connectCampaignFlowArn());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(communicationTimeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(communicationLimitsOverride());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCampaignRequest)) {
            return false;
        }
        CreateCampaignRequest other = (CreateCampaignRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(connectInstanceId(), other.connectInstanceId())
                && Objects.equals(channelSubtypeConfig(), other.channelSubtypeConfig())
                && Objects.equals(source(), other.source())
                && Objects.equals(connectCampaignFlowArn(), other.connectCampaignFlowArn())
                && Objects.equals(schedule(), other.schedule())
                && Objects.equals(communicationTimeConfig(), other.communicationTimeConfig())
                && Objects.equals(communicationLimitsOverride(), other.communicationLimitsOverride())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCampaignRequest").add("Name", name()).add("ConnectInstanceId", connectInstanceId())
                .add("ChannelSubtypeConfig", channelSubtypeConfig()).add("Source", source())
                .add("ConnectCampaignFlowArn", connectCampaignFlowArn()).add("Schedule", schedule())
                .add("CommunicationTimeConfig", communicationTimeConfig())
                .add("CommunicationLimitsOverride", communicationLimitsOverride()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "connectInstanceId":
            return Optional.ofNullable(clazz.cast(connectInstanceId()));
        case "channelSubtypeConfig":
            return Optional.ofNullable(clazz.cast(channelSubtypeConfig()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "connectCampaignFlowArn":
            return Optional.ofNullable(clazz.cast(connectCampaignFlowArn()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "communicationTimeConfig":
            return Optional.ofNullable(clazz.cast(communicationTimeConfig()));
        case "communicationLimitsOverride":
            return Optional.ofNullable(clazz.cast(communicationLimitsOverride()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("connectInstanceId", CONNECT_INSTANCE_ID_FIELD);
        map.put("channelSubtypeConfig", CHANNEL_SUBTYPE_CONFIG_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("connectCampaignFlowArn", CONNECT_CAMPAIGN_FLOW_ARN_FIELD);
        map.put("schedule", SCHEDULE_FIELD);
        map.put("communicationTimeConfig", COMMUNICATION_TIME_CONFIG_FIELD);
        map.put("communicationLimitsOverride", COMMUNICATION_LIMITS_OVERRIDE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCampaignRequest, T> g) {
        return obj -> g.apply((CreateCampaignRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectCampaignsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateCampaignRequest> {
        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the ConnectInstanceId property for this object.
         *
         * @param connectInstanceId
         *        The new value for the ConnectInstanceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectInstanceId(String connectInstanceId);

        /**
         * Sets the value of the ChannelSubtypeConfig property for this object.
         *
         * @param channelSubtypeConfig
         *        The new value for the ChannelSubtypeConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelSubtypeConfig(ChannelSubtypeConfig channelSubtypeConfig);

        /**
         * Sets the value of the ChannelSubtypeConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ChannelSubtypeConfig.Builder} avoiding
         * the need to create one manually via {@link ChannelSubtypeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChannelSubtypeConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #channelSubtypeConfig(ChannelSubtypeConfig)}.
         * 
         * @param channelSubtypeConfig
         *        a consumer that will call methods on {@link ChannelSubtypeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelSubtypeConfig(ChannelSubtypeConfig)
         */
        default Builder channelSubtypeConfig(Consumer<ChannelSubtypeConfig.Builder> channelSubtypeConfig) {
            return channelSubtypeConfig(ChannelSubtypeConfig.builder().applyMutation(channelSubtypeConfig).build());
        }

        /**
         * Sets the value of the Source property for this object.
         *
         * @param source
         *        The new value for the Source property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Source source);

        /**
         * Sets the value of the Source property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Source.Builder} avoiding the need to
         * create one manually via {@link Source#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #source(Source)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(Source)
         */
        default Builder source(Consumer<Source.Builder> source) {
            return source(Source.builder().applyMutation(source).build());
        }

        /**
         * Sets the value of the ConnectCampaignFlowArn property for this object.
         *
         * @param connectCampaignFlowArn
         *        The new value for the ConnectCampaignFlowArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectCampaignFlowArn(String connectCampaignFlowArn);

        /**
         * Sets the value of the Schedule property for this object.
         *
         * @param schedule
         *        The new value for the Schedule property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * Sets the value of the Schedule property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Schedule.Builder} avoiding the need to
         * create one manually via {@link Schedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * Sets the value of the CommunicationTimeConfig property for this object.
         *
         * @param communicationTimeConfig
         *        The new value for the CommunicationTimeConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communicationTimeConfig(CommunicationTimeConfig communicationTimeConfig);

        /**
         * Sets the value of the CommunicationTimeConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CommunicationTimeConfig.Builder} avoiding
         * the need to create one manually via {@link CommunicationTimeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommunicationTimeConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #communicationTimeConfig(CommunicationTimeConfig)}.
         * 
         * @param communicationTimeConfig
         *        a consumer that will call methods on {@link CommunicationTimeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #communicationTimeConfig(CommunicationTimeConfig)
         */
        default Builder communicationTimeConfig(Consumer<CommunicationTimeConfig.Builder> communicationTimeConfig) {
            return communicationTimeConfig(CommunicationTimeConfig.builder().applyMutation(communicationTimeConfig).build());
        }

        /**
         * Sets the value of the CommunicationLimitsOverride property for this object.
         *
         * @param communicationLimitsOverride
         *        The new value for the CommunicationLimitsOverride property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communicationLimitsOverride(CommunicationLimitsConfig communicationLimitsOverride);

        /**
         * Sets the value of the CommunicationLimitsOverride property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CommunicationLimitsConfig.Builder}
         * avoiding the need to create one manually via {@link CommunicationLimitsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommunicationLimitsConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #communicationLimitsOverride(CommunicationLimitsConfig)}.
         * 
         * @param communicationLimitsOverride
         *        a consumer that will call methods on {@link CommunicationLimitsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #communicationLimitsOverride(CommunicationLimitsConfig)
         */
        default Builder communicationLimitsOverride(Consumer<CommunicationLimitsConfig.Builder> communicationLimitsOverride) {
            return communicationLimitsOverride(CommunicationLimitsConfig.builder().applyMutation(communicationLimitsOverride)
                    .build());
        }

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCampaignsV2Request.BuilderImpl implements Builder {
        private String name;

        private String connectInstanceId;

        private ChannelSubtypeConfig channelSubtypeConfig;

        private Source source;

        private String connectCampaignFlowArn;

        private Schedule schedule;

        private CommunicationTimeConfig communicationTimeConfig;

        private CommunicationLimitsConfig communicationLimitsOverride;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCampaignRequest model) {
            super(model);
            name(model.name);
            connectInstanceId(model.connectInstanceId);
            channelSubtypeConfig(model.channelSubtypeConfig);
            source(model.source);
            connectCampaignFlowArn(model.connectCampaignFlowArn);
            schedule(model.schedule);
            communicationTimeConfig(model.communicationTimeConfig);
            communicationLimitsOverride(model.communicationLimitsOverride);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getConnectInstanceId() {
            return connectInstanceId;
        }

        public final void setConnectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
        }

        @Override
        public final Builder connectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
            return this;
        }

        public final ChannelSubtypeConfig.Builder getChannelSubtypeConfig() {
            return channelSubtypeConfig != null ? channelSubtypeConfig.toBuilder() : null;
        }

        public final void setChannelSubtypeConfig(ChannelSubtypeConfig.BuilderImpl channelSubtypeConfig) {
            this.channelSubtypeConfig = channelSubtypeConfig != null ? channelSubtypeConfig.build() : null;
        }

        @Override
        public final Builder channelSubtypeConfig(ChannelSubtypeConfig channelSubtypeConfig) {
            this.channelSubtypeConfig = channelSubtypeConfig;
            return this;
        }

        public final Source.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final String getConnectCampaignFlowArn() {
            return connectCampaignFlowArn;
        }

        public final void setConnectCampaignFlowArn(String connectCampaignFlowArn) {
            this.connectCampaignFlowArn = connectCampaignFlowArn;
        }

        @Override
        public final Builder connectCampaignFlowArn(String connectCampaignFlowArn) {
            this.connectCampaignFlowArn = connectCampaignFlowArn;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final CommunicationTimeConfig.Builder getCommunicationTimeConfig() {
            return communicationTimeConfig != null ? communicationTimeConfig.toBuilder() : null;
        }

        public final void setCommunicationTimeConfig(CommunicationTimeConfig.BuilderImpl communicationTimeConfig) {
            this.communicationTimeConfig = communicationTimeConfig != null ? communicationTimeConfig.build() : null;
        }

        @Override
        public final Builder communicationTimeConfig(CommunicationTimeConfig communicationTimeConfig) {
            this.communicationTimeConfig = communicationTimeConfig;
            return this;
        }

        public final CommunicationLimitsConfig.Builder getCommunicationLimitsOverride() {
            return communicationLimitsOverride != null ? communicationLimitsOverride.toBuilder() : null;
        }

        public final void setCommunicationLimitsOverride(CommunicationLimitsConfig.BuilderImpl communicationLimitsOverride) {
            this.communicationLimitsOverride = communicationLimitsOverride != null ? communicationLimitsOverride.build() : null;
        }

        @Override
        public final Builder communicationLimitsOverride(CommunicationLimitsConfig communicationLimitsOverride) {
            this.communicationLimitsOverride = communicationLimitsOverride;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCampaignRequest build() {
            return new CreateCampaignRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
