/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request for DeleteCampaignCommunicationLimits API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCampaignCommunicationLimitsRequest extends ConnectCampaignsV2Request implements
        ToCopyableBuilder<DeleteCampaignCommunicationLimitsRequest.Builder, DeleteCampaignCommunicationLimitsRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(DeleteCampaignCommunicationLimitsRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> CONFIG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("config")
            .getter(getter(DeleteCampaignCommunicationLimitsRequest::configAsString)).setter(setter(Builder::config))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("config").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String config;

    private DeleteCampaignCommunicationLimitsRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.config = builder.config;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the Config property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #config} will
     * return {@link CommunicationLimitsConfigType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #configAsString}.
     * </p>
     * 
     * @return The value of the Config property for this object.
     * @see CommunicationLimitsConfigType
     */
    public final CommunicationLimitsConfigType config() {
        return CommunicationLimitsConfigType.fromValue(config);
    }

    /**
     * Returns the value of the Config property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #config} will
     * return {@link CommunicationLimitsConfigType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #configAsString}.
     * </p>
     * 
     * @return The value of the Config property for this object.
     * @see CommunicationLimitsConfigType
     */
    public final String configAsString() {
        return config;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(configAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCampaignCommunicationLimitsRequest)) {
            return false;
        }
        DeleteCampaignCommunicationLimitsRequest other = (DeleteCampaignCommunicationLimitsRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(configAsString(), other.configAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteCampaignCommunicationLimitsRequest").add("Id", id()).add("Config", configAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "config":
            return Optional.ofNullable(clazz.cast(configAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("config", CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteCampaignCommunicationLimitsRequest, T> g) {
        return obj -> g.apply((DeleteCampaignCommunicationLimitsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectCampaignsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteCampaignCommunicationLimitsRequest> {
        /**
         * Sets the value of the Id property for this object.
         *
         * @param id
         *        The new value for the Id property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the Config property for this object.
         *
         * @param config
         *        The new value for the Config property for this object.
         * @see CommunicationLimitsConfigType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommunicationLimitsConfigType
         */
        Builder config(String config);

        /**
         * Sets the value of the Config property for this object.
         *
         * @param config
         *        The new value for the Config property for this object.
         * @see CommunicationLimitsConfigType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommunicationLimitsConfigType
         */
        Builder config(CommunicationLimitsConfigType config);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCampaignsV2Request.BuilderImpl implements Builder {
        private String id;

        private String config;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCampaignCommunicationLimitsRequest model) {
            super(model);
            id(model.id);
            config(model.config);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getConfig() {
            return config;
        }

        public final void setConfig(String config) {
            this.config = config;
        }

        @Override
        public final Builder config(String config) {
            this.config = config;
            return this;
        }

        @Override
        public final Builder config(CommunicationLimitsConfigType config) {
            this.config(config == null ? null : config.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCampaignCommunicationLimitsRequest build() {
            return new DeleteCampaignCommunicationLimitsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
