/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Instance Communication limits config
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceCommunicationLimitsConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceCommunicationLimitsConfig.Builder, InstanceCommunicationLimitsConfig> {
    private static final SdkField<CommunicationLimits> ALL_CHANNEL_SUBTYPES_FIELD = SdkField
            .<CommunicationLimits> builder(MarshallingType.SDK_POJO).memberName("allChannelSubtypes")
            .getter(getter(InstanceCommunicationLimitsConfig::allChannelSubtypes)).setter(setter(Builder::allChannelSubtypes))
            .constructor(CommunicationLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allChannelSubtypes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_CHANNEL_SUBTYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CommunicationLimits allChannelSubtypes;

    private InstanceCommunicationLimitsConfig(BuilderImpl builder) {
        this.allChannelSubtypes = builder.allChannelSubtypes;
    }

    /**
     * Returns the value of the AllChannelSubtypes property for this object.
     * 
     * @return The value of the AllChannelSubtypes property for this object.
     */
    public final CommunicationLimits allChannelSubtypes() {
        return allChannelSubtypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allChannelSubtypes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCommunicationLimitsConfig)) {
            return false;
        }
        InstanceCommunicationLimitsConfig other = (InstanceCommunicationLimitsConfig) obj;
        return Objects.equals(allChannelSubtypes(), other.allChannelSubtypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceCommunicationLimitsConfig").add("AllChannelSubtypes", allChannelSubtypes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allChannelSubtypes":
            return Optional.ofNullable(clazz.cast(allChannelSubtypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allChannelSubtypes", ALL_CHANNEL_SUBTYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceCommunicationLimitsConfig, T> g) {
        return obj -> g.apply((InstanceCommunicationLimitsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceCommunicationLimitsConfig> {
        /**
         * Sets the value of the AllChannelSubtypes property for this object.
         *
         * @param allChannelSubtypes
         *        The new value for the AllChannelSubtypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allChannelSubtypes(CommunicationLimits allChannelSubtypes);

        /**
         * Sets the value of the AllChannelSubtypes property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CommunicationLimits.Builder} avoiding the
         * need to create one manually via {@link CommunicationLimits#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommunicationLimits.Builder#build()} is called immediately and
         * its result is passed to {@link #allChannelSubtypes(CommunicationLimits)}.
         * 
         * @param allChannelSubtypes
         *        a consumer that will call methods on {@link CommunicationLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allChannelSubtypes(CommunicationLimits)
         */
        default Builder allChannelSubtypes(Consumer<CommunicationLimits.Builder> allChannelSubtypes) {
            return allChannelSubtypes(CommunicationLimits.builder().applyMutation(allChannelSubtypes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CommunicationLimits allChannelSubtypes;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCommunicationLimitsConfig model) {
            allChannelSubtypes(model.allChannelSubtypes);
        }

        public final CommunicationLimits.Builder getAllChannelSubtypes() {
            return allChannelSubtypes != null ? allChannelSubtypes.toBuilder() : null;
        }

        public final void setAllChannelSubtypes(CommunicationLimits.BuilderImpl allChannelSubtypes) {
            this.allChannelSubtypes = allChannelSubtypes != null ? allChannelSubtypes.build() : null;
        }

        @Override
        public final Builder allChannelSubtypes(CommunicationLimits allChannelSubtypes) {
            this.allChannelSubtypes = allChannelSubtypes;
            return this;
        }

        @Override
        public InstanceCommunicationLimitsConfig build() {
            return new InstanceCommunicationLimitsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
