/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Integration config for Connect Instance
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntegrationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<IntegrationConfig.Builder, IntegrationConfig> {
    private static final SdkField<CustomerProfilesIntegrationConfig> CUSTOMER_PROFILES_FIELD = SdkField
            .<CustomerProfilesIntegrationConfig> builder(MarshallingType.SDK_POJO).memberName("customerProfiles")
            .getter(getter(IntegrationConfig::customerProfiles)).setter(setter(Builder::customerProfiles))
            .constructor(CustomerProfilesIntegrationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerProfiles").build()).build();

    private static final SdkField<QConnectIntegrationConfig> Q_CONNECT_FIELD = SdkField
            .<QConnectIntegrationConfig> builder(MarshallingType.SDK_POJO).memberName("qConnect")
            .getter(getter(IntegrationConfig::qConnect)).setter(setter(Builder::qConnect))
            .constructor(QConnectIntegrationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qConnect").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_PROFILES_FIELD,
            Q_CONNECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CustomerProfilesIntegrationConfig customerProfiles;

    private final QConnectIntegrationConfig qConnect;

    private final Type type;

    private IntegrationConfig(BuilderImpl builder) {
        this.customerProfiles = builder.customerProfiles;
        this.qConnect = builder.qConnect;
        this.type = builder.type;
    }

    /**
     * Returns the value of the CustomerProfiles property for this object.
     * 
     * @return The value of the CustomerProfiles property for this object.
     */
    public final CustomerProfilesIntegrationConfig customerProfiles() {
        return customerProfiles;
    }

    /**
     * Returns the value of the QConnect property for this object.
     * 
     * @return The value of the QConnect property for this object.
     */
    public final QConnectIntegrationConfig qConnect() {
        return qConnect;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerProfiles());
        hashCode = 31 * hashCode + Objects.hashCode(qConnect());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegrationConfig)) {
            return false;
        }
        IntegrationConfig other = (IntegrationConfig) obj;
        return Objects.equals(customerProfiles(), other.customerProfiles()) && Objects.equals(qConnect(), other.qConnect());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntegrationConfig").add("CustomerProfiles", customerProfiles()).add("QConnect", qConnect())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customerProfiles":
            return Optional.ofNullable(clazz.cast(customerProfiles()));
        case "qConnect":
            return Optional.ofNullable(clazz.cast(qConnect()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #customerProfiles()} initialized to the given value.
     *
     * Sets the value of the CustomerProfiles property for this object.
     *
     * @param customerProfiles
     *        The new value for the CustomerProfiles property for this object.
     */
    public static IntegrationConfig fromCustomerProfiles(CustomerProfilesIntegrationConfig customerProfiles) {
        return builder().customerProfiles(customerProfiles).build();
    }

    /**
     * Create an instance of this class with {@link #customerProfiles()} initialized to the given value.
     *
     * Sets the value of the CustomerProfiles property for this object.
     *
     * @param customerProfiles
     *        The new value for the CustomerProfiles property for this object.
     */
    public static IntegrationConfig fromCustomerProfiles(Consumer<CustomerProfilesIntegrationConfig.Builder> customerProfiles) {
        CustomerProfilesIntegrationConfig.Builder builder = CustomerProfilesIntegrationConfig.builder();
        customerProfiles.accept(builder);
        return fromCustomerProfiles(builder.build());
    }

    /**
     * Create an instance of this class with {@link #qConnect()} initialized to the given value.
     *
     * Sets the value of the QConnect property for this object.
     *
     * @param qConnect
     *        The new value for the QConnect property for this object.
     */
    public static IntegrationConfig fromQConnect(QConnectIntegrationConfig qConnect) {
        return builder().qConnect(qConnect).build();
    }

    /**
     * Create an instance of this class with {@link #qConnect()} initialized to the given value.
     *
     * Sets the value of the QConnect property for this object.
     *
     * @param qConnect
     *        The new value for the QConnect property for this object.
     */
    public static IntegrationConfig fromQConnect(Consumer<QConnectIntegrationConfig.Builder> qConnect) {
        QConnectIntegrationConfig.Builder builder = QConnectIntegrationConfig.builder();
        qConnect.accept(builder);
        return fromQConnect(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customerProfiles", CUSTOMER_PROFILES_FIELD);
        map.put("qConnect", Q_CONNECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntegrationConfig, T> g) {
        return obj -> g.apply((IntegrationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntegrationConfig> {
        /**
         * Sets the value of the CustomerProfiles property for this object.
         *
         * @param customerProfiles
         *        The new value for the CustomerProfiles property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerProfiles(CustomerProfilesIntegrationConfig customerProfiles);

        /**
         * Sets the value of the CustomerProfiles property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link CustomerProfilesIntegrationConfig.Builder} avoiding the need to create one manually via
         * {@link CustomerProfilesIntegrationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerProfilesIntegrationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #customerProfiles(CustomerProfilesIntegrationConfig)}.
         * 
         * @param customerProfiles
         *        a consumer that will call methods on {@link CustomerProfilesIntegrationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerProfiles(CustomerProfilesIntegrationConfig)
         */
        default Builder customerProfiles(Consumer<CustomerProfilesIntegrationConfig.Builder> customerProfiles) {
            return customerProfiles(CustomerProfilesIntegrationConfig.builder().applyMutation(customerProfiles).build());
        }

        /**
         * Sets the value of the QConnect property for this object.
         *
         * @param qConnect
         *        The new value for the QConnect property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qConnect(QConnectIntegrationConfig qConnect);

        /**
         * Sets the value of the QConnect property for this object.
         *
         * This is a convenience method that creates an instance of the {@link QConnectIntegrationConfig.Builder}
         * avoiding the need to create one manually via {@link QConnectIntegrationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QConnectIntegrationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #qConnect(QConnectIntegrationConfig)}.
         * 
         * @param qConnect
         *        a consumer that will call methods on {@link QConnectIntegrationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qConnect(QConnectIntegrationConfig)
         */
        default Builder qConnect(Consumer<QConnectIntegrationConfig.Builder> qConnect) {
            return qConnect(QConnectIntegrationConfig.builder().applyMutation(qConnect).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CustomerProfilesIntegrationConfig customerProfiles;

        private QConnectIntegrationConfig qConnect;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IntegrationConfig model) {
            customerProfiles(model.customerProfiles);
            qConnect(model.qConnect);
        }

        public final CustomerProfilesIntegrationConfig.Builder getCustomerProfiles() {
            return customerProfiles != null ? customerProfiles.toBuilder() : null;
        }

        public final void setCustomerProfiles(CustomerProfilesIntegrationConfig.BuilderImpl customerProfiles) {
            Object oldValue = this.customerProfiles;
            this.customerProfiles = customerProfiles != null ? customerProfiles.build() : null;
            handleUnionValueChange(Type.CUSTOMER_PROFILES, oldValue, this.customerProfiles);
        }

        @Override
        public final Builder customerProfiles(CustomerProfilesIntegrationConfig customerProfiles) {
            Object oldValue = this.customerProfiles;
            this.customerProfiles = customerProfiles;
            handleUnionValueChange(Type.CUSTOMER_PROFILES, oldValue, this.customerProfiles);
            return this;
        }

        public final QConnectIntegrationConfig.Builder getQConnect() {
            return qConnect != null ? qConnect.toBuilder() : null;
        }

        public final void setQConnect(QConnectIntegrationConfig.BuilderImpl qConnect) {
            Object oldValue = this.qConnect;
            this.qConnect = qConnect != null ? qConnect.build() : null;
            handleUnionValueChange(Type.Q_CONNECT, oldValue, this.qConnect);
        }

        @Override
        public final Builder qConnect(QConnectIntegrationConfig qConnect) {
            Object oldValue = this.qConnect;
            this.qConnect = qConnect;
            handleUnionValueChange(Type.Q_CONNECT, oldValue, this.qConnect);
            return this;
        }

        @Override
        public IntegrationConfig build() {
            return new IntegrationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see IntegrationConfig#type()
     */
    public enum Type {
        CUSTOMER_PROFILES,

        Q_CONNECT,

        UNKNOWN_TO_SDK_VERSION
    }
}
