/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request for ListCampaigns API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCampaignsRequest extends ConnectCampaignsV2Request implements
        ToCopyableBuilder<ListCampaignsRequest.Builder, ListCampaignsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListCampaignsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCampaignsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<CampaignFilters> FILTERS_FIELD = SdkField.<CampaignFilters> builder(MarshallingType.SDK_POJO)
            .memberName("filters").getter(getter(ListCampaignsRequest::filters)).setter(setter(Builder::filters))
            .constructor(CampaignFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final CampaignFilters filters;

    private ListCampaignsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns the value of the Filters property for this object.
     * 
     * @return The value of the Filters property for this object.
     */
    public final CampaignFilters filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCampaignsRequest)) {
            return false;
        }
        ListCampaignsRequest other = (ListCampaignsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCampaignsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("Filters", filters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCampaignsRequest, T> g) {
        return obj -> g.apply((ListCampaignsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectCampaignsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListCampaignsRequest> {
        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the Filters property for this object.
         *
         * @param filters
         *        The new value for the Filters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(CampaignFilters filters);

        /**
         * Sets the value of the Filters property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CampaignFilters.Builder} avoiding the
         * need to create one manually via {@link CampaignFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CampaignFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(CampaignFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link CampaignFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(CampaignFilters)
         */
        default Builder filters(Consumer<CampaignFilters.Builder> filters) {
            return filters(CampaignFilters.builder().applyMutation(filters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCampaignsV2Request.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private CampaignFilters filters;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCampaignsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            filters(model.filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final CampaignFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(CampaignFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(CampaignFilters filters) {
            this.filters = filters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCampaignsRequest build() {
            return new ListCampaignsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
