/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request for PutProfileOutboundRequestBatch API
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutProfileOutboundRequestBatchRequest extends ConnectCampaignsV2Request implements
        ToCopyableBuilder<PutProfileOutboundRequestBatchRequest.Builder, PutProfileOutboundRequestBatchRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(PutProfileOutboundRequestBatchRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<List<ProfileOutboundRequest>> PROFILE_OUTBOUND_REQUESTS_FIELD = SdkField
            .<List<ProfileOutboundRequest>> builder(MarshallingType.LIST)
            .memberName("profileOutboundRequests")
            .getter(getter(PutProfileOutboundRequestBatchRequest::profileOutboundRequests))
            .setter(setter(Builder::profileOutboundRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileOutboundRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProfileOutboundRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProfileOutboundRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            PROFILE_OUTBOUND_REQUESTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final List<ProfileOutboundRequest> profileOutboundRequests;

    private PutProfileOutboundRequestBatchRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.profileOutboundRequests = builder.profileOutboundRequests;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProfileOutboundRequests property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProfileOutboundRequests() {
        return profileOutboundRequests != null && !(profileOutboundRequests instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the ProfileOutboundRequests property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfileOutboundRequests} method.
     * </p>
     * 
     * @return The value of the ProfileOutboundRequests property for this object.
     */
    public final List<ProfileOutboundRequest> profileOutboundRequests() {
        return profileOutboundRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasProfileOutboundRequests() ? profileOutboundRequests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutProfileOutboundRequestBatchRequest)) {
            return false;
        }
        PutProfileOutboundRequestBatchRequest other = (PutProfileOutboundRequestBatchRequest) obj;
        return Objects.equals(id(), other.id()) && hasProfileOutboundRequests() == other.hasProfileOutboundRequests()
                && Objects.equals(profileOutboundRequests(), other.profileOutboundRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutProfileOutboundRequestBatchRequest").add("Id", id())
                .add("ProfileOutboundRequests", hasProfileOutboundRequests() ? profileOutboundRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "profileOutboundRequests":
            return Optional.ofNullable(clazz.cast(profileOutboundRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("profileOutboundRequests", PROFILE_OUTBOUND_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutProfileOutboundRequestBatchRequest, T> g) {
        return obj -> g.apply((PutProfileOutboundRequestBatchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectCampaignsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PutProfileOutboundRequestBatchRequest> {
        /**
         * Sets the value of the Id property for this object.
         *
         * @param id
         *        The new value for the Id property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the ProfileOutboundRequests property for this object.
         *
         * @param profileOutboundRequests
         *        The new value for the ProfileOutboundRequests property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileOutboundRequests(Collection<ProfileOutboundRequest> profileOutboundRequests);

        /**
         * Sets the value of the ProfileOutboundRequests property for this object.
         *
         * @param profileOutboundRequests
         *        The new value for the ProfileOutboundRequests property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileOutboundRequests(ProfileOutboundRequest... profileOutboundRequests);

        /**
         * Sets the value of the ProfileOutboundRequests property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcampaignsv2.model.ProfileOutboundRequest.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.connectcampaignsv2.model.ProfileOutboundRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcampaignsv2.model.ProfileOutboundRequest.Builder#build()} is
         * called immediately and its result is passed to {@link #profileOutboundRequests(List<ProfileOutboundRequest>)}.
         * 
         * @param profileOutboundRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcampaignsv2.model.ProfileOutboundRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profileOutboundRequests(java.util.Collection<ProfileOutboundRequest>)
         */
        Builder profileOutboundRequests(Consumer<ProfileOutboundRequest.Builder>... profileOutboundRequests);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCampaignsV2Request.BuilderImpl implements Builder {
        private String id;

        private List<ProfileOutboundRequest> profileOutboundRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutProfileOutboundRequestBatchRequest model) {
            super(model);
            id(model.id);
            profileOutboundRequests(model.profileOutboundRequests);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<ProfileOutboundRequest.Builder> getProfileOutboundRequests() {
            List<ProfileOutboundRequest.Builder> result = ProfileOutboundRequestListCopier
                    .copyToBuilder(this.profileOutboundRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfileOutboundRequests(Collection<ProfileOutboundRequest.BuilderImpl> profileOutboundRequests) {
            this.profileOutboundRequests = ProfileOutboundRequestListCopier.copyFromBuilder(profileOutboundRequests);
        }

        @Override
        public final Builder profileOutboundRequests(Collection<ProfileOutboundRequest> profileOutboundRequests) {
            this.profileOutboundRequests = ProfileOutboundRequestListCopier.copy(profileOutboundRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileOutboundRequests(ProfileOutboundRequest... profileOutboundRequests) {
            profileOutboundRequests(Arrays.asList(profileOutboundRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileOutboundRequests(Consumer<ProfileOutboundRequest.Builder>... profileOutboundRequests) {
            profileOutboundRequests(Stream.of(profileOutboundRequests)
                    .map(c -> ProfileOutboundRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutProfileOutboundRequestBatchRequest build() {
            return new PutProfileOutboundRequestBatchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
