/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters for the SMS Channel Subtype
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SmsChannelSubtypeParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<SmsChannelSubtypeParameters.Builder, SmsChannelSubtypeParameters> {
    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationPhoneNumber").getter(getter(SmsChannelSubtypeParameters::destinationPhoneNumber))
            .setter(setter(Builder::destinationPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPhoneNumber").build())
            .build();

    private static final SdkField<String> CONNECT_SOURCE_PHONE_NUMBER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("connectSourcePhoneNumberArn")
            .getter(getter(SmsChannelSubtypeParameters::connectSourcePhoneNumberArn))
            .setter(setter(Builder::connectSourcePhoneNumberArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectSourcePhoneNumberArn")
                    .build()).build();

    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateArn").getter(getter(SmsChannelSubtypeParameters::templateArn))
            .setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateArn").build()).build();

    private static final SdkField<Map<String, String>> TEMPLATE_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("templateParameters")
            .getter(getter(SmsChannelSubtypeParameters::templateParameters))
            .setter(setter(Builder::templateParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DESTINATION_PHONE_NUMBER_FIELD, CONNECT_SOURCE_PHONE_NUMBER_ARN_FIELD,
                    TEMPLATE_ARN_FIELD, TEMPLATE_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationPhoneNumber;

    private final String connectSourcePhoneNumberArn;

    private final String templateArn;

    private final Map<String, String> templateParameters;

    private SmsChannelSubtypeParameters(BuilderImpl builder) {
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.connectSourcePhoneNumberArn = builder.connectSourcePhoneNumberArn;
        this.templateArn = builder.templateArn;
        this.templateParameters = builder.templateParameters;
    }

    /**
     * Returns the value of the DestinationPhoneNumber property for this object.
     * 
     * @return The value of the DestinationPhoneNumber property for this object.
     */
    public final String destinationPhoneNumber() {
        return destinationPhoneNumber;
    }

    /**
     * Returns the value of the ConnectSourcePhoneNumberArn property for this object.
     * 
     * @return The value of the ConnectSourcePhoneNumberArn property for this object.
     */
    public final String connectSourcePhoneNumberArn() {
        return connectSourcePhoneNumberArn;
    }

    /**
     * Returns the value of the TemplateArn property for this object.
     * 
     * @return The value of the TemplateArn property for this object.
     */
    public final String templateArn() {
        return templateArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TemplateParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTemplateParameters() {
        return templateParameters != null && !(templateParameters instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the TemplateParameters property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTemplateParameters} method.
     * </p>
     * 
     * @return The value of the TemplateParameters property for this object.
     */
    public final Map<String, String> templateParameters() {
        return templateParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(connectSourcePhoneNumberArn());
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTemplateParameters() ? templateParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SmsChannelSubtypeParameters)) {
            return false;
        }
        SmsChannelSubtypeParameters other = (SmsChannelSubtypeParameters) obj;
        return Objects.equals(destinationPhoneNumber(), other.destinationPhoneNumber())
                && Objects.equals(connectSourcePhoneNumberArn(), other.connectSourcePhoneNumberArn())
                && Objects.equals(templateArn(), other.templateArn()) && hasTemplateParameters() == other.hasTemplateParameters()
                && Objects.equals(templateParameters(), other.templateParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SmsChannelSubtypeParameters")
                .add("DestinationPhoneNumber", destinationPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConnectSourcePhoneNumberArn", connectSourcePhoneNumberArn()).add("TemplateArn", templateArn())
                .add("TemplateParameters", templateParameters() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinationPhoneNumber":
            return Optional.ofNullable(clazz.cast(destinationPhoneNumber()));
        case "connectSourcePhoneNumberArn":
            return Optional.ofNullable(clazz.cast(connectSourcePhoneNumberArn()));
        case "templateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "templateParameters":
            return Optional.ofNullable(clazz.cast(templateParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destinationPhoneNumber", DESTINATION_PHONE_NUMBER_FIELD);
        map.put("connectSourcePhoneNumberArn", CONNECT_SOURCE_PHONE_NUMBER_ARN_FIELD);
        map.put("templateArn", TEMPLATE_ARN_FIELD);
        map.put("templateParameters", TEMPLATE_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SmsChannelSubtypeParameters, T> g) {
        return obj -> g.apply((SmsChannelSubtypeParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SmsChannelSubtypeParameters> {
        /**
         * Sets the value of the DestinationPhoneNumber property for this object.
         *
         * @param destinationPhoneNumber
         *        The new value for the DestinationPhoneNumber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPhoneNumber(String destinationPhoneNumber);

        /**
         * Sets the value of the ConnectSourcePhoneNumberArn property for this object.
         *
         * @param connectSourcePhoneNumberArn
         *        The new value for the ConnectSourcePhoneNumberArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectSourcePhoneNumberArn(String connectSourcePhoneNumberArn);

        /**
         * Sets the value of the TemplateArn property for this object.
         *
         * @param templateArn
         *        The new value for the TemplateArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * Sets the value of the TemplateParameters property for this object.
         *
         * @param templateParameters
         *        The new value for the TemplateParameters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateParameters(Map<String, String> templateParameters);
    }

    static final class BuilderImpl implements Builder {
        private String destinationPhoneNumber;

        private String connectSourcePhoneNumberArn;

        private String templateArn;

        private Map<String, String> templateParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SmsChannelSubtypeParameters model) {
            destinationPhoneNumber(model.destinationPhoneNumber);
            connectSourcePhoneNumberArn(model.connectSourcePhoneNumberArn);
            templateArn(model.templateArn);
            templateParameters(model.templateParameters);
        }

        public final String getDestinationPhoneNumber() {
            return destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final String getConnectSourcePhoneNumberArn() {
            return connectSourcePhoneNumberArn;
        }

        public final void setConnectSourcePhoneNumberArn(String connectSourcePhoneNumberArn) {
            this.connectSourcePhoneNumberArn = connectSourcePhoneNumberArn;
        }

        @Override
        public final Builder connectSourcePhoneNumberArn(String connectSourcePhoneNumberArn) {
            this.connectSourcePhoneNumberArn = connectSourcePhoneNumberArn;
            return this;
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final Map<String, String> getTemplateParameters() {
            if (templateParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return templateParameters;
        }

        public final void setTemplateParameters(Map<String, String> templateParameters) {
            this.templateParameters = AttributesCopier.copy(templateParameters);
        }

        @Override
        public final Builder templateParameters(Map<String, String> templateParameters) {
            this.templateParameters = AttributesCopier.copy(templateParameters);
            return this;
        }

        @Override
        public SmsChannelSubtypeParameters build() {
            return new SmsChannelSubtypeParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
