/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Default SMS Outbound config
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SmsOutboundConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SmsOutboundConfig.Builder, SmsOutboundConfig> {
    private static final SdkField<String> CONNECT_SOURCE_PHONE_NUMBER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("connectSourcePhoneNumberArn")
            .getter(getter(SmsOutboundConfig::connectSourcePhoneNumberArn))
            .setter(setter(Builder::connectSourcePhoneNumberArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectSourcePhoneNumberArn")
                    .build()).build();

    private static final SdkField<String> WISDOM_TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("wisdomTemplateArn").getter(getter(SmsOutboundConfig::wisdomTemplateArn))
            .setter(setter(Builder::wisdomTemplateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wisdomTemplateArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONNECT_SOURCE_PHONE_NUMBER_ARN_FIELD, WISDOM_TEMPLATE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectSourcePhoneNumberArn;

    private final String wisdomTemplateArn;

    private SmsOutboundConfig(BuilderImpl builder) {
        this.connectSourcePhoneNumberArn = builder.connectSourcePhoneNumberArn;
        this.wisdomTemplateArn = builder.wisdomTemplateArn;
    }

    /**
     * Returns the value of the ConnectSourcePhoneNumberArn property for this object.
     * 
     * @return The value of the ConnectSourcePhoneNumberArn property for this object.
     */
    public final String connectSourcePhoneNumberArn() {
        return connectSourcePhoneNumberArn;
    }

    /**
     * Returns the value of the WisdomTemplateArn property for this object.
     * 
     * @return The value of the WisdomTemplateArn property for this object.
     */
    public final String wisdomTemplateArn() {
        return wisdomTemplateArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectSourcePhoneNumberArn());
        hashCode = 31 * hashCode + Objects.hashCode(wisdomTemplateArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SmsOutboundConfig)) {
            return false;
        }
        SmsOutboundConfig other = (SmsOutboundConfig) obj;
        return Objects.equals(connectSourcePhoneNumberArn(), other.connectSourcePhoneNumberArn())
                && Objects.equals(wisdomTemplateArn(), other.wisdomTemplateArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SmsOutboundConfig").add("ConnectSourcePhoneNumberArn", connectSourcePhoneNumberArn())
                .add("WisdomTemplateArn", wisdomTemplateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectSourcePhoneNumberArn":
            return Optional.ofNullable(clazz.cast(connectSourcePhoneNumberArn()));
        case "wisdomTemplateArn":
            return Optional.ofNullable(clazz.cast(wisdomTemplateArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectSourcePhoneNumberArn", CONNECT_SOURCE_PHONE_NUMBER_ARN_FIELD);
        map.put("wisdomTemplateArn", WISDOM_TEMPLATE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SmsOutboundConfig, T> g) {
        return obj -> g.apply((SmsOutboundConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SmsOutboundConfig> {
        /**
         * Sets the value of the ConnectSourcePhoneNumberArn property for this object.
         *
         * @param connectSourcePhoneNumberArn
         *        The new value for the ConnectSourcePhoneNumberArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectSourcePhoneNumberArn(String connectSourcePhoneNumberArn);

        /**
         * Sets the value of the WisdomTemplateArn property for this object.
         *
         * @param wisdomTemplateArn
         *        The new value for the WisdomTemplateArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wisdomTemplateArn(String wisdomTemplateArn);
    }

    static final class BuilderImpl implements Builder {
        private String connectSourcePhoneNumberArn;

        private String wisdomTemplateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SmsOutboundConfig model) {
            connectSourcePhoneNumberArn(model.connectSourcePhoneNumberArn);
            wisdomTemplateArn(model.wisdomTemplateArn);
        }

        public final String getConnectSourcePhoneNumberArn() {
            return connectSourcePhoneNumberArn;
        }

        public final void setConnectSourcePhoneNumberArn(String connectSourcePhoneNumberArn) {
            this.connectSourcePhoneNumberArn = connectSourcePhoneNumberArn;
        }

        @Override
        public final Builder connectSourcePhoneNumberArn(String connectSourcePhoneNumberArn) {
            this.connectSourcePhoneNumberArn = connectSourcePhoneNumberArn;
            return this;
        }

        public final String getWisdomTemplateArn() {
            return wisdomTemplateArn;
        }

        public final void setWisdomTemplateArn(String wisdomTemplateArn) {
            this.wisdomTemplateArn = wisdomTemplateArn;
        }

        @Override
        public final Builder wisdomTemplateArn(String wisdomTemplateArn) {
            this.wisdomTemplateArn = wisdomTemplateArn;
            return this;
        }

        @Override
        public SmsOutboundConfig build() {
            return new SmsOutboundConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
